/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.jdktools.versioning;

import eu.hansolo.jdktools.ReleaseStatus;
import eu.hansolo.jdktools.util.Comparison;
import eu.hansolo.jdktools.util.Helper;
import eu.hansolo.jdktools.util.OutputFormat;
import eu.hansolo.jdktools.versioning.SemverParser;
import eu.hansolo.jdktools.versioning.SemverParsingResult;
import eu.hansolo.jdktools.versioning.SimpleMajorVersion;
import eu.hansolo.jdktools.versioning.VersionNumber;
import java.util.List;
import java.util.Objects;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Semver
implements Comparable<Semver> {
    public static final Pattern EA_PATTERN = Pattern.compile("(ea|EA)(([.+\\-])([0-9]+))?");
    public static final Pattern BUILD_NUMBER_PATTERN = Pattern.compile("\\+?([bB])([0-9]+)");
    private VersionNumber versionNumber;
    private ReleaseStatus releaseStatus;
    private String pre;
    private String preBuild;
    private String metadata;
    private String build;
    private String opt;
    private Comparison comparison;

    public Semver(VersionNumber versionNumber) {
        this(versionNumber, versionNumber.getReleaseStatus() != null && versionNumber.getReleaseStatus().isPresent() ? versionNumber.getReleaseStatus().get() : ReleaseStatus.GA, versionNumber.getReleaseStatus().isPresent() ? (ReleaseStatus.EA == versionNumber.getReleaseStatus().get() ? "-ea" : "") : "", versionNumber.getBuild() != null && versionNumber.getBuild().isPresent() && versionNumber.getBuild().getAsInt() > 0 ? "+" + versionNumber.getBuild().getAsInt() : "");
    }

    public Semver(VersionNumber versionNumber, ReleaseStatus releaseStatus) {
        this(versionNumber, releaseStatus, ReleaseStatus.EA == releaseStatus ? "ea" : "", "");
    }

    public Semver(VersionNumber versionNumber, String pre, String metadata) {
        this(versionNumber, pre != null && !pre.isEmpty() ? ReleaseStatus.EA : ReleaseStatus.GA, pre, metadata);
    }

    public Semver(VersionNumber versionNumber, ReleaseStatus releaseStatus, String metadata) {
        this(versionNumber, releaseStatus, ReleaseStatus.EA == releaseStatus ? "ea" : "", metadata);
    }

    public Semver(VersionNumber versionNumber, ReleaseStatus releaseStatus, String pre, String metadata) {
        MatchResult buildNumberResult;
        Integer build;
        int meta;
        this.versionNumber = versionNumber;
        ReleaseStatus releaseStatus2 = this.releaseStatus = versionNumber.getReleaseStatus().isPresent() ? versionNumber.getReleaseStatus().get() : releaseStatus;
        this.pre = pre == null ? (ReleaseStatus.EA == releaseStatus ? "-ea" : "") : pre;
        this.metadata = metadata == null ? "" : metadata;
        this.comparison = Comparison.EQUAL;
        this.preBuild = "";
        if (versionNumber.getBuild().isPresent() && versionNumber.getBuild().getAsInt() > 0) {
            this.preBuild = Integer.toString(versionNumber.getBuild().getAsInt());
        }
        if (Helper.isPositiveInteger(this.metadata) && (meta = Integer.parseInt(metadata)) == 0) {
            this.metadata = "";
        }
        if (this.preBuild.isEmpty() && !metadata.isEmpty() && Helper.isPositiveInteger(this.metadata)) {
            this.preBuild = this.metadata;
            Integer build2 = Integer.valueOf(this.preBuild);
            if (build2 > 0) {
                this.versionNumber.setBuild(build2);
            }
        }
        if (this.pre != null) {
            MatchResult eaResult;
            Matcher eaMatcher = EA_PATTERN.matcher(this.pre);
            List eaResults = eaMatcher.results().collect(Collectors.toList());
            if (!eaResults.isEmpty() && (eaResult = (MatchResult)eaResults.get(0)).group(1) != null) {
                this.versionNumber.setReleaseStatus(ReleaseStatus.EA);
                if (eaResult.group(4) != null) {
                    String string = this.preBuild = !eaResult.group(4).equals("0") ? eaResult.group(4) : "";
                    if ((this.versionNumber.getBuild() == null || this.versionNumber.getBuild().isEmpty()) && !this.preBuild.isEmpty() && (build = Integer.valueOf(Integer.parseInt(this.preBuild))) > 0) {
                        this.versionNumber.setBuild(build);
                    }
                }
            }
            if (this.pre.matches("[a-zA-Z]+") && this.pre.length() > 0) {
                this.pre = "ea";
            }
        }
        if (!(this.pre == null || this.pre.isEmpty() || this.pre.startsWith("+") || this.pre.startsWith("-"))) {
            this.pre = "-" + pre;
        }
        if (!(this.metadata == null || this.metadata.isEmpty() || this.metadata.startsWith("-") || this.metadata.startsWith("+"))) {
            this.metadata = "+" + metadata;
        }
        if (!this.pre.isEmpty() && !this.pre.startsWith("-")) {
            throw new IllegalArgumentException("pre-release argument has to start with \"-\"");
        }
        if (!this.metadata.isEmpty() && !this.metadata.startsWith("+")) {
            throw new IllegalArgumentException("metadata argument has to start with \"+\"");
        }
        if (ReleaseStatus.EA == this.releaseStatus && !this.pre.isEmpty() && !this.pre.toLowerCase().startsWith("-ea")) {
            throw new IllegalArgumentException("ReleaseStatus and pre-release argument cannot be different");
        }
        if (ReleaseStatus.GA == this.releaseStatus && !this.pre.isEmpty() && this.pre.toLowerCase().startsWith("-ea")) {
            throw new IllegalArgumentException("ReleaseStatus and pre-release argument cannot be different");
        }
        Matcher buildNumberMatcher = BUILD_NUMBER_PATTERN.matcher(this.metadata);
        List buildNumberResults = buildNumberMatcher.results().collect(Collectors.toList());
        if (!buildNumberResults.isEmpty() && (buildNumberResult = (MatchResult)buildNumberResults.get(0)).group(1) != null && buildNumberResult.group(2) != null && (this.versionNumber.getBuild() == null || this.versionNumber.getBuild().isEmpty()) && (build = Integer.valueOf(Integer.parseInt(buildNumberResult.group(2)))) > 0) {
            this.versionNumber.setBuild(build);
            this.preBuild = Integer.toString(build);
        }
    }

    public VersionNumber getVersionNumber() {
        return this.versionNumber;
    }

    public int getFeature() {
        return this.versionNumber.getFeature().isPresent() ? this.versionNumber.getFeature().getAsInt() : 0;
    }

    public void setFeature(int feature) {
        this.versionNumber.setFeature(feature);
    }

    public int getInterim() {
        return this.versionNumber.getInterim().isPresent() ? this.versionNumber.getInterim().getAsInt() : 0;
    }

    public void setInterim(int interim) {
        this.versionNumber.setInterim(interim);
    }

    public int getUpdate() {
        return this.versionNumber.getUpdate().isPresent() ? this.versionNumber.getUpdate().getAsInt() : 0;
    }

    public void setUpdate(int update) {
        this.versionNumber.setUpdate(update);
    }

    public int getPatch() {
        return this.versionNumber.getPatch().isPresent() ? this.versionNumber.getPatch().getAsInt() : 0;
    }

    public void setPatch(int patch) {
        this.versionNumber.setPatch(patch);
    }

    public int getFifth() {
        return this.versionNumber.getFifth().isPresent() ? this.versionNumber.getFifth().getAsInt() : 0;
    }

    public void setFifth(int fifth) {
        this.versionNumber.setFifth(fifth);
    }

    public int getSixth() {
        return this.versionNumber.getSixth().isPresent() ? this.versionNumber.getSixth().getAsInt() : 0;
    }

    public void setSixth(int sixth) {
        this.versionNumber.setSixth(sixth);
    }

    public ReleaseStatus getReleaseStatus() {
        return this.releaseStatus;
    }

    public SimpleMajorVersion getMajorVersion() {
        return new SimpleMajorVersion(this.getFeature());
    }

    public String getPre() {
        return this.pre;
    }

    public void setPre(String pre) {
        Error err;
        if (pre != null && pre.length() > 0 && (err = this.validatePrerelease(pre)) != null) {
            throw new IllegalArgumentException(err.getMessage());
        }
        this.pre = pre == null ? "" : pre;
        this.releaseStatus = this.pre.isEmpty() ? ReleaseStatus.GA : ReleaseStatus.EA;
    }

    public String getPreBuild() {
        return this.preBuild;
    }

    public void setPreBuild(String preBuild) {
        if (preBuild.matches("[0-9]+")) {
            if (preBuild.length() > 1 && (preBuild.startsWith("0") || preBuild.startsWith("b0"))) {
                throw new IllegalArgumentException("preBuild must be larger than 0");
            }
        } else {
            throw new IllegalArgumentException("Invalid preBuild: " + preBuild + ". It should only contain integers > 0.");
        }
        this.preBuild = preBuild;
    }

    public Integer getPreBuildAsInt() {
        if (this.preBuild == null || this.preBuild.isEmpty()) {
            return -1;
        }
        return Integer.valueOf(this.preBuild);
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        Error err;
        String md = metadata.replaceFirst("\\+", "");
        if (md != null && md.length() > 0 && (err = this.validateMetadata(md)) != null) {
            throw new IllegalArgumentException(err.getMessage());
        }
        this.metadata = md;
    }

    public String getBuild() {
        return this.build;
    }

    public void setBuild(String build) {
        this.build = build;
    }

    public String getOpt() {
        return this.opt;
    }

    public void setOpt(String opt) {
        String op;
        this.opt = op = opt.replaceFirst("\\+", "").replaceFirst("\\-", "");
    }

    public Comparison getComparison() {
        return this.comparison;
    }

    public void setComparison(Comparison comparison) {
        this.comparison = comparison;
    }

    public Semver incSixth() {
        Semver vNext = this;
        if (this.pre != null && !this.pre.isEmpty()) {
            vNext.setBuild("");
            vNext.setOpt("");
            vNext.setMetadata("");
            vNext.setPre("");
        } else {
            vNext.setBuild("");
            vNext.setOpt("");
            vNext.metadata = "";
            vNext.pre = "";
            vNext.setSixth(this.getSixth() + 1);
        }
        return vNext;
    }

    public Semver incFifth() {
        Semver vNext = this;
        vNext.setBuild("");
        vNext.setOpt("");
        vNext.setMetadata("");
        vNext.setPre("");
        vNext.setSixth(0);
        vNext.setFifth(this.getFifth() + 1);
        return vNext;
    }

    public Semver incPatch() {
        Semver vNext = this;
        vNext.setBuild("");
        vNext.setOpt("");
        vNext.setMetadata("");
        vNext.setPre("");
        vNext.setFifth(0);
        vNext.setPatch(this.getPatch() + 1);
        return vNext;
    }

    public Semver incUpdate() {
        Semver vNext = this;
        vNext.setBuild("");
        vNext.setOpt("");
        vNext.setMetadata("");
        vNext.setPre("");
        vNext.setPatch(0);
        vNext.setUpdate(this.getUpdate() + 1);
        return vNext;
    }

    public Semver incInterim() {
        Semver vNext = this;
        vNext.setBuild("");
        vNext.setOpt("");
        vNext.setMetadata("");
        vNext.setPre("");
        vNext.setPatch(0);
        vNext.setUpdate(0);
        vNext.setInterim(this.getInterim() + 1);
        return vNext;
    }

    public Semver incFeature() {
        Semver vNext = this;
        vNext.setBuild("");
        vNext.setOpt("");
        vNext.setMetadata("");
        vNext.setPre("");
        vNext.setPatch(0);
        vNext.setUpdate(0);
        vNext.setInterim(0);
        vNext.setFeature(this.getFeature() + 1);
        return vNext;
    }

    public boolean lessThan(Semver semVer) {
        return this.compareTo(semVer) < 0;
    }

    public boolean greaterThan(Semver semVer) {
        return this.compareTo(semVer) > 0;
    }

    public boolean equalTo(Semver semVer) {
        return this.compareTo(semVer) == 0;
    }

    public static SemverParsingResult fromText(String text) throws IllegalArgumentException {
        SemverParsingResult result = SemverParser.fromText(text);
        if (result.getError1() != null) {
            throw new IllegalArgumentException("Error parsing Semver from text. " + result.getError1());
        }
        if (result.getError2() != null) {
            throw new IllegalArgumentException("Error parsing Semver from text. " + result.getError2());
        }
        return SemverParser.fromText(text);
    }

    private Error validatePrerelease(String prerelease) {
        String[] eparts;
        String[] stringArray = eparts = prerelease.split("\\.");
        int n = eparts.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            if (p.matches("[0-9]+")) {
                if (p.length() > 1 && p.startsWith("0")) {
                    return new Error("Segment starts with 0: " + p);
                }
            } else if (!p.matches("[0-9A-Za-z-]+")) {
                return new Error("Invalid prerelease: " + prerelease);
            }
            ++n2;
        }
        return null;
    }

    private Error validateMetadata(String metadata) {
        String[] eparts;
        String[] stringArray = eparts = metadata.split("\\.");
        int n = eparts.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            if (!p.matches("[0-9A-Za-z-]+")) {
                return new Error("Invalid metadata: " + metadata);
            }
            ++n2;
        }
        return null;
    }

    @Override
    public int compareTo(Semver semVer) {
        int d = this.compareSegment(this.getFeature(), semVer.getFeature());
        if (d != 0) {
            return d;
        }
        d = this.compareSegment(this.getInterim(), semVer.getInterim());
        if (d != 0) {
            return d;
        }
        d = this.compareSegment(this.getUpdate(), semVer.getUpdate());
        if (d != 0) {
            return d;
        }
        d = this.compareSegment(this.getPatch(), semVer.getPatch());
        if (d != 0) {
            return d;
        }
        d = this.compareSegment(this.getFifth(), semVer.getFifth());
        if (d != 0) {
            return d;
        }
        d = this.compareSegment(this.getSixth(), semVer.getSixth());
        if (d != 0) {
            return d;
        }
        ReleaseStatus thisStatus = this.releaseStatus;
        ReleaseStatus otherStatus = semVer.getReleaseStatus();
        if (ReleaseStatus.GA == thisStatus && ReleaseStatus.EA == otherStatus) {
            d = 1;
        } else if (ReleaseStatus.EA == thisStatus && ReleaseStatus.GA == otherStatus) {
            d = -1;
        } else if (thisStatus == otherStatus) {
            int thisBuild = this.getPreBuildAsInt();
            int otherBuild = semVer.getPreBuildAsInt();
            d = Integer.compare(thisBuild, otherBuild);
        } else {
            d = 0;
        }
        return d;
    }

    public boolean isSmallerThan(Semver semver) {
        return this.compareTo(semver) < 0;
    }

    public boolean isSmallerOrEqualThan(Semver semver) {
        return this.compareTo(semver) <= 0;
    }

    public boolean isLargerOrEqualThan(Semver semver) {
        return this.compareTo(semver) >= 0;
    }

    public boolean isLargerThan(Semver semVer) {
        return this.compareTo(semVer) > 0;
    }

    public int compareToIgnoreBuild(Semver semVer) {
        int d = this.compareSegment(this.getFeature(), semVer.getFeature());
        if (d != 0) {
            return d;
        }
        d = this.compareSegment(this.getInterim(), semVer.getInterim());
        if (d != 0) {
            return d;
        }
        d = this.compareSegment(this.getUpdate(), semVer.getUpdate());
        if (d != 0) {
            return d;
        }
        d = this.compareSegment(this.getPatch(), semVer.getPatch());
        if (d != 0) {
            return d;
        }
        d = this.compareSegment(this.getFifth(), semVer.getFifth());
        if (d != 0) {
            return d;
        }
        d = this.compareSegment(this.getSixth(), semVer.getSixth());
        if (d != 0) {
            return d;
        }
        if (this.pre != null && this.pre.isEmpty() && semVer.getPre() != null && semVer.getPre().isEmpty()) {
            return 0;
        }
        if (this.pre == null || this.pre.isEmpty()) {
            return 1;
        }
        if (semVer.getPre() == null || semVer.getPre().isEmpty()) {
            return -1;
        }
        return this.comparePrerelease(this.pre, semVer.getPre());
    }

    private int compareSegment(int s1, int s2) {
        return Integer.compare(s1, s2);
    }

    private int comparePrerelease(String pre1, String pre2) {
        int preParts1Length;
        String[] preParts1 = pre1.split("\\.");
        String[] preParts2 = pre2.split("\\.");
        int preParts2Length = preParts2.length;
        int l = preParts2Length > (preParts1Length = preParts1.length) ? preParts2Length : preParts1Length;
        int i = 0;
        while (i < l) {
            int d;
            String tmp1 = "";
            if (i < preParts1Length) {
                tmp1 = preParts1[i];
            }
            String tmp2 = "";
            if (i < preParts2Length) {
                tmp2 = preParts2[i];
            }
            if ((d = this.comparePrePart(tmp1, tmp2)) != 0) {
                return d;
            }
            ++i;
        }
        return 0;
    }

    private int comparePrePart(String prePart1, String prePart2) {
        Integer prePart2Number;
        Integer prePart1Number;
        if (prePart1.equals(prePart2)) {
            return 0;
        }
        if (prePart1.isEmpty()) {
            return !prePart2.isEmpty() ? -1 : 1;
        }
        if (prePart2.isEmpty()) {
            return !prePart1.isEmpty() ? 1 : -1;
        }
        try {
            prePart1Number = Integer.valueOf(prePart1);
        }
        catch (NumberFormatException numberFormatException) {
            prePart1Number = null;
        }
        try {
            prePart2Number = Integer.valueOf(prePart2);
        }
        catch (NumberFormatException numberFormatException) {
            prePart2Number = null;
        }
        if (prePart1Number != null && prePart2Number != null) {
            return prePart1Number > prePart2Number ? 1 : -1;
        }
        if (prePart2Number != null) {
            return -1;
        }
        if (prePart1Number != null) {
            return 1;
        }
        return -1;
    }

    public String toString(boolean javaFormat) {
        StringBuilder versionBuilder = new StringBuilder();
        versionBuilder.append(Comparison.EQUAL != this.comparison ? this.comparison.getOperator() : "");
        versionBuilder.append(this.versionNumber.toString(OutputFormat.REDUCED, javaFormat, false));
        if (ReleaseStatus.EA == this.releaseStatus) {
            versionBuilder.append("-ea");
        }
        if (this.preBuild == null || this.preBuild.isEmpty()) {
            if (this.metadata != null && !this.metadata.isEmpty()) {
                versionBuilder.append(this.metadata.startsWith("+") ? this.metadata : "+" + this.metadata);
            }
        } else if (this.metadata.isEmpty()) {
            if (this.preBuild.startsWith("+")) {
                this.preBuild = this.preBuild.substring(1);
            }
            try {
                Integer pb = Integer.valueOf(this.preBuild);
                if (pb > 0) {
                    versionBuilder.append("+").append(pb);
                }
            }
            catch (NumberFormatException numberFormatException) {
                versionBuilder.append(this.preBuild.startsWith("+") ? this.preBuild : "+" + this.preBuild);
            }
        } else {
            versionBuilder.append(this.metadata.startsWith("+") ? this.metadata : "+" + this.metadata);
        }
        return versionBuilder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Semver semver = (Semver)o;
        return Objects.equals(this.versionNumber, semver.versionNumber) && this.releaseStatus == semver.releaseStatus && Objects.equals(this.pre, semver.pre) && Objects.equals(this.preBuild, semver.preBuild) && Objects.equals(this.metadata, semver.metadata) && this.comparison == semver.comparison;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.versionNumber, this.releaseStatus, this.pre, this.preBuild, this.metadata, this.comparison});
    }

    public String toString() {
        return this.toString(true);
    }
}

