/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.jdktools.versioning;

import eu.hansolo.jdktools.util.Comparison;
import eu.hansolo.jdktools.util.Helper;
import eu.hansolo.jdktools.versioning.Semver;
import eu.hansolo.jdktools.versioning.SemverParsingResult;
import eu.hansolo.jdktools.versioning.VersionNumber;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class SemverParser {
    private static final Pattern SEM_VER_PATTERN = Pattern.compile("^(<|<=|>|>=|=)?v?([0-9]+)(\\.[0-9]+)?(\\.[0-9]+)?(\\.[0-9]+)?(\\.[0-9]+)?(\\.[0-9]+)?(-([0-9A-Za-z\\-]+(\\.[0-9A-Za-z\\-]+)*))?(\\+([0-9A-Za-z\\-]+(\\.[0-9A-Za-z\\-]+)*))?((<|<=|>|>=|=)?v?([0-9]+)(\\.[0-9]+)?(\\.[0-9]+)?(\\.[0-9]+)?(\\.[0-9]+)?(\\.[0-9]+)?(-([0-9A-Za-z\\-]+(\\.[0-9A-Za-z\\-]+)*))?(\\+([0-9A-Za-z\\-]+(\\.[0-9A-Za-z\\-]+)*))?)?$");
    private static final Pattern OPT_PATTERN = Pattern.compile("(([0-9]+(\\.[0-9]+)?))?(\\-([a-zA-Z0-9\\-]*))?");

    private SemverParser() {
    }

    public static SemverParsingResult fromText(String text) {
        Error err1;
        Matcher semverMatcher;
        List results;
        String versionText1;
        SemverParsingResult parsingResult = new SemverParsingResult();
        String string = versionText1 = text.startsWith("1.") ? text.replace("1.", "") : text;
        if (versionText1.contains("_")) {
            versionText1 = versionText1.replace("_", ".");
        }
        if (versionText1.matches("[0-9]+u[0-9]+.*")) {
            versionText1 = versionText1.replace("u", ".0.");
        }
        if ((results = (semverMatcher = SEM_VER_PATTERN.matcher(versionText1)).results().collect(Collectors.toList())).isEmpty()) {
            parsingResult.setError1(new Error("Invalid semver: " + versionText1));
            return parsingResult;
        }
        MatchResult result = (MatchResult)results.get(0);
        String metadata1 = result.group(12) != null ? result.group(12) : "";
        String pre1 = result.group(9) != null ? result.group(9) : "";
        Matcher optMatcher = OPT_PATTERN.matcher(metadata1);
        List optResults = optMatcher.results().collect(Collectors.toList());
        String build1 = "";
        String opt1 = "";
        if (!optResults.isEmpty()) {
            MatchResult optResult = (MatchResult)optResults.get(0);
            build1 = optResult.group(2) != null ? optResult.group(2) : "";
            String string2 = opt1 = optResult.group(5) != null ? optResult.group(5) : "";
        }
        if (pre1.equals("ea.0")) {
            pre1 = "ea";
        }
        if (pre1.startsWith("b") && metadata1.isEmpty()) {
            metadata1 = pre1;
            pre1 = "";
        }
        VersionNumber versionNumber1 = new VersionNumber();
        Comparison comparison1 = result.group(1) == null ? Comparison.EQUAL : Comparison.fromText(result.group(1));
        try {
            if (result.group(2) == null) {
                parsingResult.setError1(new Error("Feature version cannot be null"));
                return parsingResult;
            }
            versionNumber1.setFeature(Integer.parseInt(result.group(2)));
        }
        catch (NumberFormatException e) {
            parsingResult.setError1(new Error("Error when parsing feature version " + result.group(2) + ": " + e));
            return parsingResult;
        }
        try {
            if (result.group(3) == null) {
                versionNumber1.setInterim(0);
            } else {
                versionNumber1.setInterim(Integer.parseInt(Helper.trimPrefix(result.group(3), "\\.")));
            }
        }
        catch (NumberFormatException e) {
            parsingResult.setError1(new Error("Error when parsing interim version " + result.group(3) + ": " + e));
            return parsingResult;
        }
        try {
            if (result.group(4) == null) {
                versionNumber1.setUpdate(0);
            } else {
                versionNumber1.setUpdate(Integer.parseInt(Helper.trimPrefix(result.group(4), "\\.")));
            }
        }
        catch (NumberFormatException e) {
            parsingResult.setError1(new Error("Error when parsing update version " + result.group(4) + ": " + e));
            return parsingResult;
        }
        try {
            if (result.group(5) == null) {
                versionNumber1.setPatch(0);
            } else {
                versionNumber1.setPatch(Integer.parseInt(Helper.trimPrefix(result.group(5), "\\.")));
            }
        }
        catch (NumberFormatException e) {
            parsingResult.setError1(new Error("Error when parsing patch version " + result.group(5) + ": " + e));
            return parsingResult;
        }
        try {
            if (result.group(6) == null) {
                versionNumber1.setFifth(0);
            } else {
                versionNumber1.setFifth(Integer.parseInt(Helper.trimPrefix(result.group(6), "\\.")));
            }
        }
        catch (NumberFormatException e) {
            parsingResult.setError1(new Error("Error when parsing fifth number " + result.group(6) + ": " + e));
            return parsingResult;
        }
        try {
            if (result.group(7) == null) {
                versionNumber1.setSixth(0);
            } else {
                versionNumber1.setSixth(Integer.parseInt(Helper.trimPrefix(result.group(7), "\\.")));
            }
        }
        catch (NumberFormatException e) {
            parsingResult.setError1(new Error("Error when parsing sixth number " + result.group(7) + ": " + e));
            return parsingResult;
        }
        if (pre1 != null && !pre1.isEmpty()) {
            String[] eparts = pre1.split("\\.");
            if (eparts.length > 0 && eparts[0].matches("[a-zA-Z]+") && eparts[0].length() > 0) {
                pre1 = "ea";
                String string3 = opt1 = eparts[0].equals("ea") ? opt1 : eparts[0];
            }
            if (eparts.length > 1 && Helper.isPositiveInteger(eparts[1])) {
                metadata1 = eparts[1];
            }
            if ((err1 = SemverParser.validatePrerelease(pre1)) != null) {
                parsingResult.setError1(err1);
                return parsingResult;
            }
        }
        if (metadata1 != null && !metadata1.isEmpty() && (err1 = SemverParser.validateMetadata(metadata1)) != null) {
            parsingResult.setError1(err1);
            return parsingResult;
        }
        Semver semVer1 = new Semver(versionNumber1, pre1, metadata1);
        semVer1.setBuild(build1);
        semVer1.setOpt(opt1);
        semVer1.setComparison(comparison1);
        parsingResult.setSemver1(semVer1);
        Predicate<Semver> filter = null;
        if (result.groupCount() == 27 && result.group(14) != null) {
            Error err2;
            boolean oldFormat;
            String metadata2 = result.group(26) != null ? result.group(26) : "";
            String pre2 = result.group(23) != null ? result.group(23) : "";
            optMatcher.reset(metadata2);
            optResults.clear();
            optResults.addAll(optMatcher.results().collect(Collectors.toList()));
            String build2 = "";
            String opt2 = "";
            if (!optResults.isEmpty()) {
                MatchResult optResult = (MatchResult)optResults.get(0);
                build2 = optResult.group(2) != null ? optResult.group(2) : "";
                String string4 = opt2 = optResult.group(5) != null ? optResult.group(5) : "";
            }
            if (pre2.equals("ea.0")) {
                pre2 = "ea";
            }
            if (pre2.startsWith("b") && metadata2.isEmpty()) {
                metadata2 = pre2;
                pre2 = "";
            }
            VersionNumber versionNumber2 = new VersionNumber();
            Comparison comparison2 = result.group(15) == null ? Comparison.EQUAL : Comparison.fromText(result.group(15));
            try {
                if (result.group(16) == null) {
                    parsingResult.setError2(new Error("Feature version cannot be null"));
                    return parsingResult;
                }
                oldFormat = Integer.parseInt(result.group(16)) == 1;
                versionNumber2.setFeature(Integer.parseInt(result.group(16)));
            }
            catch (NumberFormatException e) {
                parsingResult.setError2(new Error("Error when parsing feature version " + result.group(16) + ": " + e));
                return parsingResult;
            }
            try {
                if (result.group(17) == null) {
                    versionNumber2.setInterim(0);
                } else {
                    versionNumber2.setInterim(Integer.parseInt(Helper.trimPrefix(result.group(17), "\\.")));
                }
            }
            catch (NumberFormatException e) {
                parsingResult.setError2(new Error("Error when parsing interim version " + result.group(17) + ": " + e));
                return parsingResult;
            }
            try {
                if (result.group(18) == null) {
                    versionNumber2.setUpdate(0);
                } else {
                    versionNumber2.setUpdate(Integer.parseInt(Helper.trimPrefix(result.group(18), "\\.")));
                }
            }
            catch (NumberFormatException e) {
                parsingResult.setError2(new Error("Error when parsing update version " + result.group(18) + ": " + e));
                return parsingResult;
            }
            try {
                if (result.group(19) == null) {
                    versionNumber2.setPatch(0);
                } else {
                    versionNumber2.setPatch(Integer.parseInt(Helper.trimPrefix(result.group(19), "\\.")));
                }
            }
            catch (NumberFormatException e) {
                parsingResult.setError2(new Error("Error when parsing patch version " + result.group(19) + ": " + e));
                return parsingResult;
            }
            try {
                if (result.group(20) == null) {
                    versionNumber2.setFifth(0);
                } else {
                    versionNumber2.setFifth(Integer.parseInt(Helper.trimPrefix(result.group(20), "\\.")));
                }
            }
            catch (NumberFormatException e) {
                parsingResult.setError2(new Error("Error when parsing fifth number " + result.group(20) + ": " + e));
                return parsingResult;
            }
            try {
                if (result.group(21) == null) {
                    versionNumber2.setSixth(0);
                } else {
                    versionNumber2.setSixth(Integer.parseInt(Helper.trimPrefix(result.group(21), "\\.")));
                }
            }
            catch (NumberFormatException e) {
                parsingResult.setError2(new Error("Error when parsing sixth number " + result.group(21) + ": " + e));
                return parsingResult;
            }
            if (oldFormat) {
                versionNumber2.setFeature(versionNumber2.getInterim().getAsInt());
                versionNumber2.setInterim(versionNumber2.getUpdate().getAsInt());
                versionNumber2.setUpdate(versionNumber2.getPatch().getAsInt());
                versionNumber2.setPatch(0);
            }
            if (pre2 != null && !pre2.isEmpty()) {
                String[] eparts = pre2.split("\\.");
                if (eparts.length > 0 && eparts[0].matches("[a-zA-Z]+") && eparts[0].length() > 0) {
                    pre2 = "ea";
                    String string5 = opt2 = eparts[0].equals("ea") ? opt2 : eparts[0];
                }
                if (eparts.length > 1 && Helper.isPositiveInteger(eparts[1])) {
                    metadata2 = eparts[1];
                }
                if ((err2 = SemverParser.validatePrerelease(pre2)) != null) {
                    parsingResult.setError2(err2);
                    return parsingResult;
                }
            }
            if (metadata2 != null && !metadata2.isEmpty() && (err2 = SemverParser.validateMetadata(metadata2)) != null) {
                parsingResult.setError2(err2);
                return parsingResult;
            }
            Semver semVer2 = new Semver(versionNumber2, pre2, metadata2);
            semVer2.setBuild(build2);
            semVer2.setOpt(opt2);
            semVer2.setComparison(comparison2);
            block12 : switch (comparison1) {
                case LESS_THAN: {
                    filter = semVer -> semVer.lessThan(semVer1);
                    break;
                }
                case LESS_THAN_OR_EQUAL: {
                    filter = semVer -> semVer.lessThan(semVer1) || semVer.equalTo(semVer1);
                    break;
                }
                case GREATER_THAN: {
                    switch (comparison2) {
                        case LESS_THAN: {
                            filter = semVer -> semVer.greaterThan(semVer1) && semVer.lessThan(semVer2);
                            break block12;
                        }
                        case LESS_THAN_OR_EQUAL: {
                            filter = semVer -> semVer.greaterThan(semVer1) && (semVer.lessThan(semVer2) || semVer.equalTo(semVer2));
                            break block12;
                        }
                    }
                    filter = semVer -> semVer.greaterThan(semVer1);
                    break;
                }
                case GREATER_THAN_OR_EQUAL: {
                    switch (comparison2) {
                        case LESS_THAN: {
                            filter = semVer -> (semVer.equalTo(semVer1) || semVer.greaterThan(semVer1)) && semVer.lessThan(semVer2);
                            break block12;
                        }
                        case LESS_THAN_OR_EQUAL: {
                            filter = semVer -> !(!semVer.equalTo(semVer1) && !semVer.greaterThan(semVer1) || !semVer.lessThan(semVer2) && !semVer.equalTo(semVer2));
                            break block12;
                        }
                    }
                    filter = semVer -> semVer.equalTo(semVer1) || semVer.greaterThan(semVer1);
                }
            }
            parsingResult.setFilter(filter);
            parsingResult.setSemver2(semVer2);
            return parsingResult;
        }
        switch (comparison1) {
            case LESS_THAN: {
                filter = semVer -> semVer.lessThan(semVer1);
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                filter = semVer -> semVer.lessThan(semVer1) || semVer.equalTo(semVer1);
                break;
            }
            case GREATER_THAN: {
                filter = semVer -> semVer.greaterThan(semVer1);
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                filter = semVer -> semVer.equalTo(semVer1) || semVer.greaterThan(semVer1);
            }
        }
        parsingResult.setFilter(filter);
        return parsingResult;
    }

    private static Error validatePrerelease(String preRelease) {
        String[] eparts;
        String[] stringArray = eparts = preRelease.split("\\.");
        int n = eparts.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            if (p.matches("[0-9]+")) {
                if (p.length() > 0 && p.startsWith("0")) {
                    return new Error("Segment starts with 0: " + p);
                }
            } else if (!p.matches("[0-9A-Za-z-]+")) {
                return new Error("Invalid preRelease: " + preRelease);
            }
            ++n2;
        }
        return null;
    }

    private static Error validateMetadata(String metadata) {
        String[] eparts;
        String[] stringArray = eparts = metadata.split("\\.");
        int n = eparts.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            if (!p.matches("[0-9A-Za-z-]+")) {
                return new Error("Invalid metadata: " + metadata);
            }
            ++n2;
        }
        return null;
    }
}

