/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.jdktools.versioning;

import eu.hansolo.jdktools.ReleaseStatus;
import eu.hansolo.jdktools.util.Helper;
import eu.hansolo.jdktools.util.OutputFormat;
import eu.hansolo.jdktools.versioning.SimpleMajorVersion;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class VersionNumber
implements Comparable<VersionNumber> {
    public static final Pattern VERSION_NO_PATTERN = Pattern.compile("([1-9]\\d*)((u(\\d+))|(\\.?(\\d+)?\\.?(\\d+)?\\.?(\\d+)?\\.?(\\d+)?\\.(\\d+)))?(([_b])(\\d+))?(([-+.])([a-zA-Z0-9\\-\\+]+)(\\.[0-9]+)?)?");
    public static final Pattern EA_PATTERN = Pattern.compile("(ea|EA)(([.+\\-])([0-9]+))?");
    public static final Pattern EA_BUILD_NUMBER_PATTERN = Pattern.compile("(\\.?)([0-9]+)");
    public static final Pattern BUILD_NUMBER_PATTERN = Pattern.compile("\\+?([bB])([0-9]+)");
    public static final Pattern LEADING_INT_PATTERN = Pattern.compile("^[0-9]*");
    private OptionalInt feature;
    private OptionalInt interim;
    private OptionalInt update;
    private OptionalInt patch;
    private OptionalInt fifth;
    private OptionalInt sixth;
    private OptionalInt build;
    private Optional<ReleaseStatus> releaseStatus;

    public VersionNumber() {
        this(OptionalInt.empty(), OptionalInt.empty(), OptionalInt.empty(), OptionalInt.empty(), OptionalInt.empty(), OptionalInt.empty(), OptionalInt.empty(), Optional.empty());
    }

    public VersionNumber(VersionNumber versionNumber) {
        this(versionNumber.getFeature(), versionNumber.getInterim(), versionNumber.getUpdate(), versionNumber.getPatch(), versionNumber.getFifth(), versionNumber.getSixth(), versionNumber.getBuild(), versionNumber.getReleaseStatus());
    }

    public VersionNumber(Integer feature) {
        this(feature, 0, 0, 0, 0, 0, null, null);
    }

    public VersionNumber(Integer feature, Integer interim) {
        this(feature, interim, 0, 0, 0, 0, null, null);
    }

    public VersionNumber(Integer feature, Integer interim, Integer update) {
        this(feature, interim, update, 0, 0, 0, null, null);
    }

    public VersionNumber(Integer feature, Integer interim, Integer update, Integer patch) throws IllegalArgumentException {
        this(feature, interim, update, patch, 0, 0, null, null);
    }

    public VersionNumber(Integer feature, Integer interim, Integer update, Integer patch, Integer build) throws IllegalArgumentException {
        this(feature, interim, update, patch, 0, 0, build, null);
    }

    public VersionNumber(Integer feature, Integer interim, Integer update, Integer patch, Integer fifth, Integer sixth) {
        this(feature, interim, update, patch, fifth, sixth, null, null);
    }

    public VersionNumber(Integer feature, Integer interim, Integer update, Integer patch, Integer fifth, Integer sixth, Integer build, ReleaseStatus releaseStatus) throws IllegalArgumentException {
        Objects.requireNonNull(feature, "Feature version cannot be null");
        if (feature <= 0) {
            throw new IllegalArgumentException("Feature version cannot be smaller than 0");
        }
        if (interim != null && interim < 0) {
            throw new IllegalArgumentException("Interim version cannot be smaller than 0");
        }
        if (update != null && update < 0) {
            throw new IllegalArgumentException("Update version cannot be smaller than 0");
        }
        if (patch != null && patch < 0) {
            throw new IllegalArgumentException("Patch version cannot be smaller than 0");
        }
        if (fifth != null && fifth < 0) {
            throw new IllegalArgumentException("Fifth number cannot be smaller than 0");
        }
        if (sixth != null && sixth < 0) {
            throw new IllegalArgumentException("Sixth number cannot be smaller than 0");
        }
        if (build != null && build < 0) {
            throw new IllegalArgumentException("Build number cannot be smaller than 0");
        }
        this.feature = OptionalInt.of(feature);
        this.interim = interim == null ? OptionalInt.of(0) : OptionalInt.of(interim);
        this.update = update == null ? OptionalInt.of(0) : OptionalInt.of(update);
        this.patch = patch == null ? OptionalInt.of(0) : OptionalInt.of(patch);
        this.fifth = fifth == null ? OptionalInt.of(0) : OptionalInt.of(fifth);
        this.sixth = sixth == null ? OptionalInt.of(0) : OptionalInt.of(sixth);
        this.build = build == null ? OptionalInt.empty() : OptionalInt.of(build);
        this.releaseStatus = releaseStatus == null ? Optional.empty() : Optional.of(releaseStatus);
    }

    public VersionNumber(OptionalInt feature, OptionalInt interim, OptionalInt update, OptionalInt patch) {
        this(feature, interim, update, patch, OptionalInt.of(0), OptionalInt.of(0), OptionalInt.empty(), Optional.empty());
    }

    public VersionNumber(OptionalInt feature, OptionalInt interim, OptionalInt update, OptionalInt patch, OptionalInt fifth, OptionalInt sixth) {
        this(feature, interim, update, patch, fifth, sixth, OptionalInt.empty(), Optional.empty());
    }

    public VersionNumber(OptionalInt feature, OptionalInt interim, OptionalInt update, OptionalInt patch, OptionalInt fifth, OptionalInt sixth, OptionalInt build, Optional<ReleaseStatus> releaseStatus) {
        if (feature == null) {
            throw new IllegalArgumentException("Feature version cannot be null");
        }
        if (feature != null && feature.isPresent() && feature.getAsInt() <= 0) {
            throw new IllegalArgumentException("Feature version cannot be smaller than 0");
        }
        if (interim != null && interim.isPresent() && interim.getAsInt() < 0) {
            throw new IllegalArgumentException("Interim version cannot be smaller than 0");
        }
        if (update != null && update.isPresent() && update.getAsInt() < 0) {
            throw new IllegalArgumentException("Update version cannot be smaller than 0");
        }
        if (patch != null && patch.isPresent() && patch.getAsInt() < 0) {
            throw new IllegalArgumentException("Patch version cannot be smaller than 0");
        }
        if (fifth != null && fifth.isPresent() && fifth.getAsInt() < 0) {
            throw new IllegalArgumentException("Fifth number cannot be smaller than 0");
        }
        if (sixth != null && sixth.isPresent() && sixth.getAsInt() < 0) {
            throw new IllegalArgumentException("Sixth number cannot be smaller than 0");
        }
        if (build != null && build.isPresent() && build.getAsInt() < 0) {
            throw new IllegalArgumentException("Build number cannot be smaller than 0");
        }
        this.feature = feature;
        this.interim = interim == null ? OptionalInt.of(0) : interim;
        this.update = update == null ? OptionalInt.of(0) : update;
        this.patch = patch == null ? OptionalInt.of(0) : patch;
        this.fifth = fifth == null ? OptionalInt.of(0) : fifth;
        this.sixth = sixth == null ? OptionalInt.of(0) : sixth;
        this.build = build == null ? OptionalInt.empty() : build;
        Optional<Object> optional = this.releaseStatus = releaseStatus == null ? Optional.empty() : releaseStatus;
        if (this.feature == null) {
            this.feature = OptionalInt.empty();
        }
    }

    public OptionalInt getFeature() {
        return this.feature;
    }

    public void setFeature(Integer feature) throws IllegalArgumentException {
        if (feature == null) {
            throw new IllegalArgumentException("Feature version cannot be null");
        }
        if (feature <= 0) {
            throw new IllegalArgumentException("Feature version cannot be smaller than 0 (" + feature + ")");
        }
        this.feature = OptionalInt.of(feature);
    }

    public OptionalInt getInterim() {
        return this.interim;
    }

    public void setInterim(Integer interim) throws IllegalArgumentException {
        if (interim != null && interim < 0) {
            throw new IllegalArgumentException("Interim version cannot be smaller than 0");
        }
        this.interim = interim == null ? OptionalInt.empty() : OptionalInt.of(interim);
    }

    public OptionalInt getUpdate() {
        return this.update;
    }

    public void setUpdate(Integer update) throws IllegalArgumentException {
        if (update != null && update < 0) {
            throw new IllegalArgumentException("Update version cannot be smaller than 0");
        }
        this.update = update == null ? OptionalInt.empty() : OptionalInt.of(update);
    }

    public OptionalInt getPatch() {
        return this.patch;
    }

    public void setPatch(Integer patch) throws IllegalArgumentException {
        if (patch != null && patch < 0) {
            throw new IllegalArgumentException("Patch version cannot be smaller than 0");
        }
        this.patch = patch == null ? OptionalInt.empty() : OptionalInt.of(patch);
    }

    public OptionalInt getFifth() {
        return this.fifth;
    }

    public void setFifth(Integer fifth) throws IllegalArgumentException {
        if (fifth != null && fifth < 0) {
            throw new IllegalArgumentException("Fifth number cannot be smaller than 0");
        }
        this.fifth = fifth == null ? OptionalInt.empty() : OptionalInt.of(fifth);
    }

    public OptionalInt getSixth() {
        return this.sixth;
    }

    public void setSixth(Integer sixth) throws IllegalArgumentException {
        if (sixth != null && sixth < 0) {
            throw new IllegalArgumentException("Sixth number cannot be smaller than 0");
        }
        this.sixth = sixth == null ? OptionalInt.empty() : OptionalInt.of(sixth);
    }

    public OptionalInt getBuild() {
        return this.build;
    }

    public void setBuild(Integer build) throws IllegalArgumentException {
        this.build = build != null && build <= 0 ? OptionalInt.empty() : (build == null ? OptionalInt.empty() : OptionalInt.of(build));
    }

    public Optional<ReleaseStatus> getReleaseStatus() {
        return this.releaseStatus;
    }

    public void setReleaseStatus(ReleaseStatus releaseStatus) {
        if (releaseStatus == null) {
            throw new IllegalArgumentException("Release status cannot be null");
        }
        this.releaseStatus = Optional.of(releaseStatus);
    }

    public SimpleMajorVersion getMajorVersion() {
        return new SimpleMajorVersion(this.feature.isPresent() ? this.feature.getAsInt() : 0);
    }

    public String getNormalizedVersionNumber() {
        StringBuilder versionBuilder = new StringBuilder();
        if (!this.feature.isPresent()) {
            throw new IllegalArgumentException("Feature version number cannot be null");
        }
        versionBuilder.append(this.feature.getAsInt());
        versionBuilder.append(".").append(this.interim.isPresent() ? Integer.valueOf(this.interim.getAsInt()) : "0");
        versionBuilder.append(".").append(this.update.isPresent() ? Integer.valueOf(this.update.getAsInt()) : "0");
        versionBuilder.append(".").append(this.patch.isPresent() ? Integer.valueOf(this.patch.getAsInt()) : "0");
        versionBuilder.append(".").append(this.fifth.isPresent() ? Integer.valueOf(this.fifth.getAsInt()) : "0");
        versionBuilder.append(".").append(this.sixth.isPresent() ? Integer.valueOf(this.sixth.getAsInt()) : "0");
        return versionBuilder.toString();
    }

    public static VersionNumber fromText(String text) throws IllegalArgumentException {
        return VersionNumber.fromText(text, 0);
    }

    public static VersionNumber fromText(String text, int resultToMatch) throws IllegalArgumentException {
        if (text == null || text.isEmpty()) {
            throw new IllegalArgumentException("No version number can be parsed because given text is null or empty.");
        }
        String version = text.startsWith("1.") ? text.replace("1.", "") : text;
        Matcher versionNoMatcher = VERSION_NO_PATTERN.matcher(version);
        List results = versionNoMatcher.results().collect(Collectors.toList());
        int noOfResults = results.size();
        int resultToTake = noOfResults > resultToMatch ? resultToMatch : 0;
        ArrayList<VersionNumber> numbersFound = new ArrayList<VersionNumber>();
        if (noOfResults > 0) {
            MatchResult buildNumberResult;
            Matcher buildNumberMatcher;
            List buildNumberResults;
            MatchResult result = (MatchResult)results.get(resultToTake);
            VersionNumber versionNumber = new VersionNumber(Integer.valueOf(result.group(1)));
            if (result.group(1) != null && result.group(2) != null && result.group(5) != null && result.group(6) != null && result.group(7) != null && result.group(9) != null && result.group(10) != null && result.group(11) != null && result.group(12) != null && result.group(13) != null && result.group(14) != null && result.group(15) != null) {
                versionNumber.setInterim(VersionNumber.getPositiveIntFromText(result.group(6)));
                versionNumber.setUpdate(VersionNumber.getPositiveIntFromText(result.group(7)));
                versionNumber.setPatch(VersionNumber.getPositiveIntFromText(result.group(9)));
            } else if (result.group(1) != null && result.group(2) != null && result.group(5) != null && result.group(6) != null && result.group(7) != null && result.group(10) != null && result.group(11) != null && result.group(12) != null && result.group(13) != null && result.group(14) != null && result.group(15) != null && result.group(16) != null) {
                versionNumber.setInterim(VersionNumber.getPositiveIntFromText(result.group(6)));
                versionNumber.setUpdate(VersionNumber.getPositiveIntFromText(result.group(7)));
                versionNumber.setPatch(VersionNumber.getPositiveIntFromText(result.group(10)));
            } else if (result.group(1) != null && result.group(2) != null && result.group(5) != null && result.group(6) != null && result.group(7) != null && result.group(8) != null && result.group(9) != null && result.group(10) != null && result.group(14) != null && result.group(15) != null && result.group(16) != null) {
                versionNumber.setInterim(VersionNumber.getPositiveIntFromText(result.group(6)));
                versionNumber.setUpdate(VersionNumber.getPositiveIntFromText(result.group(7)));
                versionNumber.setPatch(VersionNumber.getPositiveIntFromText(result.group(8)));
                versionNumber.setFifth(VersionNumber.getPositiveIntFromText(result.group(9)));
                versionNumber.setSixth(VersionNumber.getPositiveIntFromText(result.group(10)));
            } else if (result.group(1) != null && result.group(2) != null && result.group(5) != null && result.group(6) != null && result.group(7) != null && result.group(8) != null && result.group(10) != null && result.group(14) != null && result.group(15) != null && result.group(16) != null) {
                versionNumber.setInterim(VersionNumber.getPositiveIntFromText(result.group(6)));
                versionNumber.setUpdate(VersionNumber.getPositiveIntFromText(result.group(7)));
                versionNumber.setPatch(VersionNumber.getPositiveIntFromText(result.group(8)));
                versionNumber.setFifth(VersionNumber.getPositiveIntFromText(result.group(10)));
            } else if (result.group(1) != null && result.group(2) != null && result.group(5) != null && result.group(10) != null && result.group(11) != null && result.group(12) != null && result.group(13) != null && result.group(14) != null && result.group(15) != null && result.group(16) != null) {
                versionNumber.setInterim(VersionNumber.getPositiveIntFromText(result.group(10)));
                versionNumber.setUpdate(VersionNumber.getPositiveIntFromText(result.group(13)));
            } else if (result.group(1) != null && result.group(2) != null && result.group(5) != null && result.group(6) != null && result.group(7) != null && result.group(10) != null && result.group(14) != null && result.group(15) != null && result.group(16) != null) {
                versionNumber.setInterim(VersionNumber.getPositiveIntFromText(result.group(6)));
                versionNumber.setUpdate(VersionNumber.getPositiveIntFromText(result.group(7)));
                versionNumber.setPatch(VersionNumber.getPositiveIntFromText(result.group(10)));
            } else if (result.group(1) != null && result.group(2) != null && result.group(5) != null && result.group(6) != null && result.group(10) != null && result.group(14) != null && result.group(15) != null && result.group(16) != null) {
                versionNumber.setInterim(VersionNumber.getPositiveIntFromText(result.group(6)));
                versionNumber.setUpdate(VersionNumber.getPositiveIntFromText(result.group(10)));
            } else if (result.group(1) != null && result.group(2) != null && result.group(5) != null && result.group(6) != null && result.group(7) != null && result.group(8) != null && result.group(9) != null && result.group(10) != null) {
                versionNumber.setInterim(VersionNumber.getPositiveIntFromText(result.group(6)));
                versionNumber.setUpdate(VersionNumber.getPositiveIntFromText(result.group(7)));
                versionNumber.setPatch(VersionNumber.getPositiveIntFromText(result.group(8)));
                versionNumber.setFifth(VersionNumber.getPositiveIntFromText(result.group(9)));
                versionNumber.setSixth(VersionNumber.getPositiveIntFromText(result.group(10)));
            } else if (result.group(1) != null && result.group(2) != null && result.group(5) != null && result.group(6) != null && result.group(7) != null && result.group(8) != null && result.group(10) != null) {
                versionNumber.setInterim(VersionNumber.getPositiveIntFromText(result.group(6)));
                versionNumber.setUpdate(VersionNumber.getPositiveIntFromText(result.group(7)));
                versionNumber.setPatch(VersionNumber.getPositiveIntFromText(result.group(8)));
                versionNumber.setFifth(VersionNumber.getPositiveIntFromText(result.group(10)));
            } else if (result.group(1) != null && result.group(2) != null && result.group(3) != null && result.group(4) != null && result.group(14) != null && result.group(15) != null && result.group(16) != null) {
                versionNumber.setInterim(0);
                versionNumber.setUpdate(VersionNumber.getPositiveIntFromText(result.group(4)));
            } else if (result.group(1) != null && result.group(2) != null && result.group(3) != null && result.group(4) != null && result.group(11) != null && result.group(12) != null && result.group(13) != null) {
                versionNumber.setInterim(0);
                versionNumber.setUpdate(VersionNumber.getPositiveIntFromText(result.group(4)));
            } else if (result.group(1) != null && result.group(2) != null && result.group(5) != null && result.group(10) != null && result.group(11) != null && result.group(12) != null && result.group(13) != null) {
                versionNumber.setInterim(0);
                versionNumber.setUpdate(VersionNumber.getPositiveIntFromText(result.group(13)));
            } else if (result.group(1) != null && result.group(2) != null && result.group(5) != null && result.group(6) != null && result.group(7) != null && result.group(10) != null) {
                versionNumber.setInterim(VersionNumber.getPositiveIntFromText(result.group(6)));
                versionNumber.setUpdate(VersionNumber.getPositiveIntFromText(result.group(7)));
                versionNumber.setPatch(VersionNumber.getPositiveIntFromText(result.group(10)));
            } else if (result.group(1) != null && result.group(2) != null && result.group(5) != null && result.group(6) != null && result.group(10) != null) {
                versionNumber.setInterim(VersionNumber.getPositiveIntFromText(result.group(6)));
                versionNumber.setUpdate(VersionNumber.getPositiveIntFromText(result.group(10)));
            } else if (result.group(1) != null && result.group(2) != null && result.group(3) != null && result.group(4) != null) {
                versionNumber.setInterim(0);
                versionNumber.setUpdate(VersionNumber.getPositiveIntFromText(result.group(4)));
            } else if (result.group(1) != null && result.group(2) != null && result.group(5) != null && result.group(10) != null) {
                versionNumber.setInterim(VersionNumber.getPositiveIntFromText(result.group(10)));
            } else if (result.group(1) != null && result.group(14) != null && result.group(15) != null && result.group(16) != null) {
                versionNumber.setInterim(0);
                if (result.group(15).equals("+")) {
                    if (result.group(16).startsWith("b")) {
                        versionNumber.setBuild(Integer.parseInt(result.group(16).substring(1)));
                    } else {
                        versionNumber.setBuild(Integer.parseInt(result.group(16)));
                    }
                    versionNumber.setReleaseStatus(ReleaseStatus.GA);
                }
            }
            if (result.group(16) != null) {
                MatchResult eaResult;
                Matcher eaMatcher = EA_PATTERN.matcher(result.group(16));
                List eaResults = eaMatcher.results().collect(Collectors.toList());
                if (!eaResults.isEmpty() && (eaResult = (MatchResult)eaResults.get(0)).group(1) != null) {
                    versionNumber.setReleaseStatus(ReleaseStatus.EA);
                    if (eaResult.group(4) == null) {
                        Matcher eaBuildNumberMatcher;
                        List eaBuildNumberResults;
                        if (result.group(17) != null && !(eaBuildNumberResults = (eaBuildNumberMatcher = EA_BUILD_NUMBER_PATTERN.matcher(result.group(17))).results().collect(Collectors.toList())).isEmpty()) {
                            MatchResult eaBuildNumberResult = (MatchResult)eaBuildNumberResults.get(0);
                            versionNumber.setBuild(Integer.parseInt(eaBuildNumberResult.group(2)));
                        }
                    } else {
                        versionNumber.setBuild(Integer.parseInt(eaResult.group(4)));
                    }
                }
            } else {
                versionNumber.setReleaseStatus(ReleaseStatus.GA);
            }
            if (!(buildNumberResults = (buildNumberMatcher = BUILD_NUMBER_PATTERN.matcher(version)).results().collect(Collectors.toList())).isEmpty() && (buildNumberResult = (MatchResult)buildNumberResults.get(0)).group(2) != null) {
                versionNumber.setBuild(Integer.parseInt(buildNumberResult.group(2)));
            }
            if (!versionNumber.getInterim().isPresent() || versionNumber.getInterim().isEmpty()) {
                versionNumber.setInterim(0);
            }
            if (!versionNumber.getUpdate().isPresent() || versionNumber.getUpdate().isEmpty()) {
                versionNumber.setUpdate(0);
            }
            if (!versionNumber.getPatch().isPresent() || versionNumber.getPatch().isEmpty()) {
                versionNumber.setPatch(0);
            }
            if (!versionNumber.getFifth().isPresent() || versionNumber.getFifth().isEmpty()) {
                versionNumber.setFifth(0);
            }
            if (!versionNumber.getSixth().isPresent() || versionNumber.getSixth().isEmpty()) {
                versionNumber.setSixth(0);
            }
            numbersFound.add(versionNumber);
        }
        if (numbersFound.isEmpty()) {
            throw new IllegalArgumentException("No suitable version number found in String: " + text);
        }
        return numbersFound.stream().max(Comparator.comparingInt(VersionNumber::numbersAvailable)).get();
    }

    public int numbersAvailable() {
        return 1 + (this.interim.isPresent() ? 1 : 0) + (this.update.isPresent() ? 1 : 0) + (this.patch.isPresent() ? 1 : 0) + (this.fifth.isPresent() ? 1 : 0) + (this.sixth.isPresent() ? 1 : 0);
    }

    private static Integer getPositiveIntFromText(String text) {
        if (Helper.isPositiveInteger(text)) {
            return Integer.valueOf(text);
        }
        return -1;
    }

    private static Integer getLeadingIntFromText(String text) {
        if (text == null || text.isEmpty()) {
            return -1;
        }
        Matcher matcher = LEADING_INT_PATTERN.matcher(text);
        if (matcher.find()) {
            return matcher.group(0).isEmpty() ? -1 : Integer.parseInt(matcher.group(0));
        }
        return -1;
    }

    public int compareForFilterTo(VersionNumber otherVersionNumber) {
        int comparisonResult = 0;
        if (!this.feature.isPresent() || !otherVersionNumber.getFeature().isPresent()) {
            return comparisonResult;
        }
        String[] version1Splits = this.toString().split("\\.");
        String[] version2Splits = otherVersionNumber.toString().split("\\.");
        int maxLengthOfVersionSplits = Math.min(version1Splits.length, version2Splits.length);
        int i = 0;
        while (i < maxLengthOfVersionSplits) {
            Integer v2;
            Integer v1 = i < version1Splits.length ? Integer.parseInt(version1Splits[i]) : 0;
            int compare = v1.compareTo(v2 = Integer.valueOf(i < version2Splits.length ? Integer.parseInt(version2Splits[i]) : 0));
            if (compare != 0) {
                comparisonResult = compare;
                break;
            }
            ++i;
        }
        return comparisonResult;
    }

    public int hashCode() {
        return Objects.hash(this.feature.getAsInt(), this.interim.orElse(0), this.update.orElse(0), this.patch.orElse(0));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VersionNumber)) {
            return false;
        }
        VersionNumber other = (VersionNumber)obj;
        boolean isEqual = this.feature.getAsInt() == other.getFeature().getAsInt() ? (this.interim.isPresent() ? (other.getInterim().isPresent() ? (this.interim.getAsInt() == other.getInterim().getAsInt() ? (this.update.isPresent() ? (other.getUpdate().isPresent() ? (this.update.getAsInt() == other.getUpdate().getAsInt() ? (this.patch.isPresent() ? (other.getPatch().isPresent() ? (this.patch.getAsInt() == other.getPatch().getAsInt() ? (this.fifth.isPresent() ? (other.getFifth().isPresent() ? (this.fifth.getAsInt() == other.getFifth().getAsInt() ? (this.sixth.isPresent() ? (other.getSixth().isPresent() ? this.sixth.getAsInt() == other.getSixth().getAsInt() : false) : true) : false) : false) : true) : false) : false) : true) : false) : false) : true) : false) : false) : true) : false;
        if (isEqual && this.releaseStatus.isPresent() && ReleaseStatus.EA == this.releaseStatus.get() && this.build.isPresent() && other.getReleaseStatus().isPresent() && ReleaseStatus.EA == other.getReleaseStatus().get() && other.getBuild().isPresent()) {
            isEqual = this.getBuild().getAsInt() == other.getBuild().getAsInt();
        }
        return isEqual;
    }

    public static boolean equalsExceptBuild(VersionNumber v1, VersionNumber v2) {
        return v1.equals(v2);
    }

    public static boolean equalsIncludingBuild(VersionNumber v1, VersionNumber v2) {
        return v1.compareTo(v2) == 0;
    }

    public String toStringInclBuild(boolean javaFormat) {
        return this.toString(OutputFormat.REDUCED, javaFormat, true);
    }

    public String toString(OutputFormat outputFormat, boolean javaFormat, boolean includeReleaseStatusAndBuild) {
        String pre = this.releaseStatus.isPresent() ? (ReleaseStatus.EA == this.releaseStatus.get() ? "-ea" : "") : "";
        String build = this.build.isPresent() && this.build.getAsInt() > 0 ? "+" + this.build.getAsInt() : "";
        StringBuilder versionBuilder = new StringBuilder();
        switch (outputFormat) {
            case REDUCED: 
            case REDUCED_COMPRESSED: {
                if (this.feature.isPresent()) {
                    versionBuilder.append(this.feature.getAsInt());
                }
                if (this.sixth.isPresent() && this.sixth.getAsInt() != 0) {
                    if (this.interim.isPresent()) {
                        versionBuilder.append(".").append(this.interim.getAsInt());
                    }
                    if (this.update.isPresent()) {
                        versionBuilder.append(".").append(this.update.getAsInt());
                    }
                    if (this.patch.isPresent()) {
                        versionBuilder.append(".").append(this.patch.getAsInt());
                    }
                    if (!javaFormat) {
                        if (this.fifth.isPresent()) {
                            versionBuilder.append(".").append(this.fifth.getAsInt());
                        }
                        if (this.sixth.isPresent()) {
                            versionBuilder.append(".").append(this.sixth.getAsInt());
                        }
                    }
                    if (includeReleaseStatusAndBuild) {
                        versionBuilder.append(pre).append(build);
                    }
                    return versionBuilder.toString();
                }
                if (this.fifth.isPresent() && this.fifth.getAsInt() != 0) {
                    if (this.interim.isPresent()) {
                        versionBuilder.append(".").append(this.interim.getAsInt());
                    }
                    if (this.update.isPresent()) {
                        versionBuilder.append(".").append(this.update.getAsInt());
                    }
                    if (this.patch.isPresent()) {
                        versionBuilder.append(".").append(this.patch.getAsInt());
                    }
                    if (!javaFormat && this.fifth.isPresent()) {
                        versionBuilder.append(".").append(this.fifth.getAsInt());
                    }
                    if (includeReleaseStatusAndBuild) {
                        versionBuilder.append(pre).append(build);
                    }
                    return versionBuilder.toString();
                }
                if (this.patch.isPresent() && this.patch.getAsInt() != 0) {
                    if (this.interim.isPresent()) {
                        versionBuilder.append(".").append(this.interim.getAsInt());
                    }
                    if (this.update.isPresent()) {
                        versionBuilder.append(".").append(this.update.getAsInt());
                    }
                    if (this.patch.isPresent()) {
                        versionBuilder.append(".").append(this.patch.getAsInt());
                    }
                    if (includeReleaseStatusAndBuild) {
                        versionBuilder.append(pre).append(build);
                    }
                    return versionBuilder.toString();
                }
                if (this.update.isPresent() && this.update.getAsInt() != 0) {
                    if (this.interim.isPresent()) {
                        versionBuilder.append(".").append(this.interim.getAsInt());
                    }
                    if (this.update.isPresent()) {
                        versionBuilder.append(".").append(this.update.getAsInt());
                    }
                    if (includeReleaseStatusAndBuild) {
                        versionBuilder.append(pre).append(build);
                    }
                    return versionBuilder.toString();
                }
                if (this.interim.isPresent() && this.interim.getAsInt() != 0) {
                    if (this.interim.isPresent()) {
                        versionBuilder.append(".").append(this.interim.getAsInt());
                    }
                    if (includeReleaseStatusAndBuild) {
                        versionBuilder.append(pre).append(build);
                    }
                    return versionBuilder.toString();
                }
                if (includeReleaseStatusAndBuild) {
                    versionBuilder.append(pre).append(build);
                }
                return versionBuilder.toString();
            }
        }
        if (this.feature.isPresent()) {
            versionBuilder.append(this.feature.getAsInt());
        }
        if (this.interim.isPresent()) {
            versionBuilder.append(".").append(this.interim.getAsInt());
        }
        if (this.update.isPresent()) {
            versionBuilder.append(".").append(this.update.getAsInt());
        }
        if (this.patch.isPresent()) {
            versionBuilder.append(".").append(this.patch.getAsInt());
        }
        if (!javaFormat) {
            if (this.fifth.isPresent()) {
                versionBuilder.append(".").append(this.fifth.getAsInt());
            }
            if (this.sixth.isPresent()) {
                versionBuilder.append(".").append(this.sixth.getAsInt());
            }
        }
        if (includeReleaseStatusAndBuild) {
            versionBuilder.append(pre).append(build);
        }
        return versionBuilder.toString();
    }

    public String toString() {
        return this.toString(OutputFormat.FULL, true, true);
    }

    @Override
    public int compareTo(VersionNumber otherVersionNumber) {
        int ret;
        if (this.feature.isPresent() && otherVersionNumber.getFeature().isPresent()) {
            if (this.feature.getAsInt() > otherVersionNumber.getFeature().getAsInt()) {
                ret = 1;
            } else if (this.feature.getAsInt() < otherVersionNumber.getFeature().getAsInt()) {
                ret = -1;
            } else if (this.interim.isPresent() && otherVersionNumber.getInterim().isPresent()) {
                if (this.interim.getAsInt() > otherVersionNumber.getInterim().getAsInt()) {
                    ret = 1;
                } else if (this.interim.getAsInt() < otherVersionNumber.getInterim().getAsInt()) {
                    ret = -1;
                } else if (this.update.isPresent() && otherVersionNumber.getUpdate().isPresent()) {
                    if (this.update.getAsInt() > otherVersionNumber.getUpdate().getAsInt()) {
                        ret = 1;
                    } else if (this.update.getAsInt() < otherVersionNumber.getUpdate().getAsInt()) {
                        ret = -1;
                    } else if (this.patch.isPresent() && otherVersionNumber.getPatch().isPresent()) {
                        if (this.patch.getAsInt() > otherVersionNumber.getPatch().getAsInt()) {
                            ret = 1;
                        } else if (this.patch.getAsInt() < otherVersionNumber.getPatch().getAsInt()) {
                            ret = -1;
                        } else if (this.fifth.isPresent() && otherVersionNumber.getFifth().isPresent()) {
                            if (this.fifth.getAsInt() > otherVersionNumber.getFifth().getAsInt()) {
                                ret = 1;
                            } else if (this.fifth.getAsInt() < otherVersionNumber.getFifth().getAsInt()) {
                                ret = -1;
                            } else if (this.sixth.isPresent() && otherVersionNumber.getSixth().isPresent()) {
                                if (this.sixth.getAsInt() > otherVersionNumber.getSixth().getAsInt()) {
                                    ret = 1;
                                } else if (this.sixth.getAsInt() < otherVersionNumber.getSixth().getAsInt()) {
                                    ret = -1;
                                } else {
                                    ReleaseStatus otherStatus;
                                    ReleaseStatus thisStatus = this.releaseStatus.isPresent() ? this.releaseStatus.get() : ReleaseStatus.GA;
                                    ReleaseStatus releaseStatus = otherStatus = otherVersionNumber.getReleaseStatus().isPresent() ? otherVersionNumber.getReleaseStatus().get() : ReleaseStatus.GA;
                                    if (ReleaseStatus.GA == thisStatus && ReleaseStatus.EA == otherStatus) {
                                        ret = 1;
                                    } else if (ReleaseStatus.EA == thisStatus && ReleaseStatus.GA == otherStatus) {
                                        ret = -1;
                                    } else if (thisStatus == otherStatus) {
                                        int thisBuild = this.build.isPresent() ? this.build.getAsInt() : 0;
                                        int otherBuild = otherVersionNumber.getBuild().isPresent() ? otherVersionNumber.getBuild().getAsInt() : 0;
                                        ret = Integer.compare(thisBuild, otherBuild);
                                    } else {
                                        ret = 0;
                                    }
                                }
                            } else {
                                ret = this.sixth.isPresent() && otherVersionNumber.getSixth().isEmpty() ? 1 : (this.sixth.isEmpty() && otherVersionNumber.getSixth().isPresent() ? -1 : 0);
                            }
                        } else {
                            ret = this.fifth.isPresent() && otherVersionNumber.getFifth().isEmpty() ? 1 : (this.fifth.isEmpty() && otherVersionNumber.getFifth().isPresent() ? -1 : 0);
                        }
                    } else {
                        ret = this.patch.isPresent() && otherVersionNumber.getPatch().isEmpty() ? 1 : (this.patch.isEmpty() && otherVersionNumber.getPatch().isPresent() ? -1 : 0);
                    }
                } else {
                    ret = this.update.isPresent() && otherVersionNumber.getUpdate().isEmpty() ? 1 : (this.update.isEmpty() && otherVersionNumber.getUpdate().isPresent() ? -1 : 0);
                }
            } else {
                ret = this.interim.isPresent() && otherVersionNumber.getInterim().isEmpty() ? 1 : (this.interim.isEmpty() && otherVersionNumber.getInterim().isPresent() ? -1 : 0);
            }
        } else {
            ret = this.feature.isPresent() && otherVersionNumber.getFeature().isEmpty() ? 1 : (this.feature.isEmpty() && otherVersionNumber.getFeature().isPresent() ? -1 : 0);
        }
        if (ret == 0) {
            if (this.releaseStatus.isPresent() && ReleaseStatus.EA == this.releaseStatus.get() && this.build.isPresent() && otherVersionNumber.getReleaseStatus().isPresent() && ReleaseStatus.EA == otherVersionNumber.getReleaseStatus().get() && otherVersionNumber.getBuild().isPresent()) {
                int buildNumber = this.getBuild().getAsInt();
                int otherBuildNumber = otherVersionNumber.getBuild().getAsInt();
                ret = Integer.compare(buildNumber, otherBuildNumber);
            } else {
                ret = this.releaseStatus.isPresent() && ReleaseStatus.EA == this.releaseStatus.get() && this.build.isPresent() && otherVersionNumber.getReleaseStatus().isPresent() && ReleaseStatus.EA == otherVersionNumber.getReleaseStatus().get() && otherVersionNumber.getBuild().isEmpty() ? 1 : (this.releaseStatus.isPresent() && ReleaseStatus.EA == this.releaseStatus.get() && this.build.isEmpty() && otherVersionNumber.getReleaseStatus().isPresent() && ReleaseStatus.EA == otherVersionNumber.getReleaseStatus().get() && otherVersionNumber.getBuild().isPresent() ? -1 : 0);
            }
        }
        return ret;
    }

    public boolean isSmallerThan(VersionNumber versionNumber) {
        return this.compareTo(versionNumber) < 0;
    }

    public boolean isSmallerOrEqualThan(VersionNumber versionNumber) {
        return this.compareTo(versionNumber) <= 0;
    }

    public boolean isLargerOrEqualThan(VersionNumber versionNumber) {
        return this.compareTo(versionNumber) >= 0;
    }

    public boolean isLargerThan(VersionNumber versionNumber) {
        return this.compareTo(versionNumber) > 0;
    }
}

