/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa;

import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.GaugeDesign;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Circle;

public class FGauge
extends Region {
    public static final double PREFERRED_WIDTH = 270.0;
    public static final double PREFERRED_HEIGHT = 270.0;
    public static final double MINIMUM_WIDTH = 50.0;
    public static final double MINIMUM_HEIGHT = 50.0;
    public static final double MAXIMUM_WIDTH = 1024.0;
    public static final double MAXIMUM_HEIGHT = 1024.0;
    private Gauge gauge;
    private double size;
    private Region frame;
    private Circle background;
    private Circle foreground;
    private GaugeDesign gaugeDesign;
    private GaugeDesign.GaugeBackground gaugeBackground;
    private InnerShadow innerShadow;

    public FGauge() {
        this(new Gauge(), GaugeDesign.BLACK_METAL, GaugeDesign.GaugeBackground.BEIGE);
    }

    public FGauge(Gauge GAUGE, GaugeDesign DESIGN) {
        this(GAUGE, DESIGN, GaugeDesign.GaugeBackground.DARK_GRAY);
    }

    public FGauge(Gauge GAUGE, GaugeDesign DESIGN, GaugeDesign.GaugeBackground BACKGROUND) {
        this.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("framed-gauge.css").toExternalForm());
        this.getStyleClass().setAll((Object[])new String[]{"framed-gauge"});
        this.gauge = GAUGE;
        this.gaugeDesign = DESIGN;
        this.gaugeBackground = BACKGROUND;
        Skin skin = this.gauge.getSkin();
        if (skin == null) {
            throw new RuntimeException("Please use a valid Skin.");
        }
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if (Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0 || Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0) {
            this.setPrefSize(270.0, 270.0);
        }
        if (Double.compare(this.getMinWidth(), 0.0) <= 0 || Double.compare(this.getMinHeight(), 0.0) <= 0) {
            this.setMinSize(50.0, 50.0);
        }
        if (Double.compare(this.getMaxWidth(), 0.0) <= 0 || Double.compare(this.getMaxHeight(), 0.0) <= 0) {
            this.setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.innerShadow = new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.35), 20.0, 0.0, 0.0, 20.0);
        this.frame = new Region();
        this.background = new Circle();
        this.background.setEffect((Effect)this.innerShadow);
        this.foreground = new Circle();
        this.foreground.setMouseTransparent(true);
        this.getChildren().setAll((Object[])new Node[]{this.frame, this.background, this.gauge, this.foreground});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.redraw());
        this.heightProperty().addListener(o -> this.redraw());
    }

    public GaugeDesign getGaugeDesign() {
        return this.gaugeDesign;
    }

    public void setGaugeDesign(GaugeDesign DESIGN) {
        this.gaugeDesign = DESIGN;
        this.redraw();
    }

    public GaugeDesign.GaugeBackground getGaugeBackground() {
        return this.gaugeBackground;
    }

    public void setGaugeBackground(GaugeDesign.GaugeBackground BACKGROUND) {
        this.gaugeBackground = BACKGROUND;
        this.redraw();
    }

    public boolean isForegroundVisible() {
        return this.foreground.isVisible();
    }

    public void setForegroundVisible(boolean VISIBLE) {
        this.foreground.setVisible(VISIBLE);
        this.foreground.setManaged(VISIBLE);
    }

    public Gauge getGauge() {
        return this.gauge;
    }

    public void setGauge(Gauge GAUGE) {
        this.gauge = GAUGE;
    }

    private void redraw() {
        double height;
        double width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        double d = this.size = width < (height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom()) ? width : height;
        if (this.size > 0.0) {
            if (this.getWidth() > this.getHeight()) {
                this.setTranslateX(0.5 * (this.getWidth() - this.size));
            } else if (this.getHeight() > this.getWidth()) {
                this.setTranslateY(0.5 * (this.getHeight() - this.size));
            }
            this.frame.setPrefSize(this.size, this.size);
            this.frame.setBorder(this.gaugeDesign.getBorder(this.size));
            this.background.setCenterX(this.size * 0.5);
            this.background.setCenterY(this.size * 0.5);
            this.background.setRadius(this.size * 0.4375);
            this.background.setFill(this.gaugeBackground.getPaint(this.background.getLayoutBounds().getMinX(), this.background.getLayoutBounds().getMinY(), this.background.getLayoutBounds().getMaxX(), this.background.getLayoutBounds().getMaxY()));
            switch (this.gaugeDesign) {
                case NONE: {
                    this.frame.setVisible(false);
                    this.foreground.setVisible(false);
                    this.background.setVisible(false);
                    break;
                }
                case ENZO: {
                    this.background.setFill((Paint)Color.rgb((int)240, (int)240, (int)240));
                    this.innerShadow.setRadius(0.07407407 * this.size);
                    this.innerShadow.setOffsetX(0.0);
                    this.innerShadow.setOffsetY(0.07407407 * this.size);
                    this.innerShadow.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.35));
                    this.foreground.setFill((Paint)Color.TRANSPARENT);
                    this.foreground.setStroke(null);
                    break;
                }
                default: {
                    this.frame.setVisible(true);
                    this.foreground.setVisible(true);
                    this.background.setVisible(true);
                    this.innerShadow.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.65));
                    this.innerShadow.setRadius(0.08 * this.size);
                    this.innerShadow.setOffsetX(0.0);
                    this.innerShadow.setOffsetY(0.0 * this.size);
                    this.foreground.setFill((Paint)new RadialGradient(0.0, 0.0, this.size * 0.5, this.size * this.gaugeDesign.FRAME_FACTOR * 0.5, this.size, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)255, (int)255, (int)255, (double)0.6)), new Stop(0.4, Color.TRANSPARENT)}));
                    this.foreground.setStroke(null);
                }
            }
            this.gauge.setPrefSize(this.size * (1.0 - this.gaugeDesign.FRAME_FACTOR * 2.0), this.size * (1.0 - this.gaugeDesign.FRAME_FACTOR * 2.0));
            this.gauge.relocate(this.gaugeDesign.FRAME_FACTOR * this.size, this.gaugeDesign.FRAME_FACTOR * this.size);
            this.foreground.setCenterX(this.size * 0.5);
            this.foreground.setCenterY(this.size * 0.5);
            this.foreground.setRadius(this.size * 0.42);
        }
    }
}

