/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa;

import eu.hansolo.medusa.FGauge;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.GaugeDesign;
import eu.hansolo.medusa.skins.GaugeSkin;
import java.util.HashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.scene.control.Skin;

public class FGaugeBuilder<B extends FGaugeBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected FGaugeBuilder() {
    }

    public static final FGaugeBuilder create() {
        return new FGaugeBuilder();
    }

    public final B gauge(Gauge GAUGE) {
        this.properties.put("gauge", (Property)new SimpleObjectProperty((Object)GAUGE));
        return (B)this;
    }

    public final B gaugeDesign(GaugeDesign DESIGN) {
        this.properties.put("gaugeDesign", (Property)new SimpleObjectProperty((Object)DESIGN));
        return (B)this;
    }

    public final B gaugeBackground(GaugeDesign.GaugeBackground BACKGROUND) {
        this.properties.put("gaugeBackground", (Property)new SimpleObjectProperty((Object)BACKGROUND));
        return (B)this;
    }

    public final B foregroundVisible(boolean VISIBLE) {
        this.properties.put("foregroundVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final FGauge build() {
        Gauge gauge = this.properties.get("gauge") == null ? new Gauge() : (Gauge)((Object)((ObjectProperty)this.properties.get("gauge")).get());
        GaugeDesign design = this.properties.get("gaugeDesign") == null ? GaugeDesign.METAL : (GaugeDesign)((Object)((ObjectProperty)this.properties.get("gaugeDesign")).get());
        GaugeDesign.GaugeBackground background = this.properties.get("gaugeBackground") == null ? GaugeDesign.GaugeBackground.DARK_GRAY : (GaugeDesign.GaugeBackground)((Object)((ObjectProperty)this.properties.get("gaugeBackground")).get());
        Skin skin = gauge.getSkin();
        if (skin != null && gauge.getSkin().getClass() != GaugeSkin.class) {
            throw new RuntimeException("Please change Skin to GaugeSkin.");
        }
        FGauge CONTROL = new FGauge(gauge, design, background);
        for (String key : this.properties.keySet()) {
            Dimension2D dim;
            if ("prefSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setPrefSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("minSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setPrefSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("maxSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setPrefSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("prefWidth".equals(key)) {
                CONTROL.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("prefHeight".equals(key)) {
                CONTROL.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minWidth".equals(key)) {
                CONTROL.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minHeight".equals(key)) {
                CONTROL.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxWidth".equals(key)) {
                CONTROL.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxHeight".equals(key)) {
                CONTROL.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleX".equals(key)) {
                CONTROL.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleY".equals(key)) {
                CONTROL.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutX".equals(key)) {
                CONTROL.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutY".equals(key)) {
                CONTROL.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateX".equals(key)) {
                CONTROL.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateY".equals(key)) {
                CONTROL.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if (!"foregroundVisible".equals(key)) continue;
            CONTROL.setForegroundVisible(((BooleanProperty)this.properties.get(key)).get());
        }
        return CONTROL;
    }
}

