/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa;

import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.tools.ConicalGradient;
import eu.hansolo.medusa.tools.Helper;
import javafx.geometry.Insets;
import javafx.scene.image.Image;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderImage;
import javafx.scene.layout.BorderRepeat;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum GaugeDesign {
    NONE(0.0){

        @Override
        public Border getBorder(double SIZE) {
            return Border.EMPTY;
        }
    }
    ,
    METAL(0.08333333){

        @Override
        public Border getBorder(double SIZE) {
            double fromX = 0.0;
            double fromY = 0.0;
            double toX = 0.0;
            double toY = SIZE;
            Stop[] stops = new Stop[]{new Stop(0.0, Color.rgb((int)254, (int)254, (int)254)), new Stop(0.07, Color.rgb((int)210, (int)210, (int)210)), new Stop(0.12, Color.rgb((int)179, (int)179, (int)179)), new Stop(1.0, Color.rgb((int)213, (int)213, (int)213))};
            BorderStroke outerBorder = new BorderStroke((Paint)Color.rgb((int)132, (int)132, (int)132), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(1.0), Insets.EMPTY);
            BorderStroke innerBorder = new BorderStroke((Paint)new LinearGradient(fromX, fromY, toX, toY, false, CycleMethod.NO_CYCLE, stops), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(this.FRAME_FACTOR * SIZE), new Insets(0.0037037 * SIZE));
            return new Border(new BorderStroke[]{outerBorder, innerBorder});
        }
    }
    ,
    TILTED_GRAY(0.08333333){

        @Override
        public Border getBorder(double SIZE) {
            double fromX = 0.2336448598130841 * SIZE;
            double fromY = 0.08411214953271028 * SIZE;
            double toX = 0.8125818236066633 * SIZE;
            double toY = 0.9109198204038422 * SIZE;
            Stop[] stops = new Stop[]{new Stop(0.0, Color.WHITE), new Stop(0.07, Color.rgb((int)210, (int)210, (int)210)), new Stop(0.16, Color.rgb((int)179, (int)179, (int)179)), new Stop(0.33, Color.WHITE), new Stop(0.55, Color.rgb((int)197, (int)197, (int)197)), new Stop(0.79, Color.WHITE), new Stop(1.0, Color.rgb((int)102, (int)102, (int)102))};
            BorderStroke outerBorder = new BorderStroke((Paint)Color.rgb((int)132, (int)132, (int)132), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(1.0), Insets.EMPTY);
            BorderStroke innerBorder = new BorderStroke((Paint)new LinearGradient(fromX, fromY, toX, toY, false, CycleMethod.NO_CYCLE, stops), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(this.FRAME_FACTOR * SIZE), new Insets(0.0037037 * SIZE));
            return new Border(new BorderStroke[]{outerBorder, innerBorder});
        }
    }
    ,
    TILTED_BLACK(0.08333333){

        @Override
        public Border getBorder(double SIZE) {
            double fromX = 0.2336448598130841 * SIZE;
            double fromY = 0.08411214953271028 * SIZE;
            double toX = 0.8125818236066633 * SIZE;
            double toY = 0.9109198204038422 * SIZE;
            Stop[] stops = new Stop[]{new Stop(0.0, Color.rgb((int)102, (int)102, (int)102)), new Stop(0.21, Color.BLACK), new Stop(0.47, Color.rgb((int)102, (int)102, (int)102)), new Stop(1.0, Color.BLACK)};
            BorderStroke outerBorder = new BorderStroke((Paint)Color.rgb((int)132, (int)132, (int)132), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(1.0), Insets.EMPTY);
            BorderStroke innerBorder = new BorderStroke((Paint)new LinearGradient(fromX, fromY, toX, toY, false, CycleMethod.NO_CYCLE, stops), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(this.FRAME_FACTOR * SIZE), new Insets(0.0037037 * SIZE));
            return new Border(new BorderStroke[]{outerBorder, innerBorder});
        }
    }
    ,
    STEEL(0.08333333){

        @Override
        public Border getBorder(double SIZE) {
            double fromX = 0.0;
            double fromY = 0.0;
            double toX = 0.0;
            double toY = SIZE;
            Stop[] stops = new Stop[]{new Stop(0.0, Color.rgb((int)231, (int)237, (int)237)), new Stop(0.03, Color.rgb((int)189, (int)199, (int)198)), new Stop(0.06, Color.rgb((int)192, (int)201, (int)200)), new Stop(0.48, Color.rgb((int)23, (int)31, (int)33)), new Stop(0.93, Color.rgb((int)196, (int)205, (int)204)), new Stop(0.96, Color.rgb((int)194, (int)204, (int)203)), new Stop(1.0, Color.rgb((int)189, (int)201, (int)199))};
            BorderStroke outerBorder = new BorderStroke((Paint)Color.rgb((int)132, (int)132, (int)132), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(1.0), Insets.EMPTY);
            BorderStroke innerBorder = new BorderStroke((Paint)new LinearGradient(fromX, fromY, toX, toY, false, CycleMethod.NO_CYCLE, stops), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(this.FRAME_FACTOR * SIZE), new Insets(0.0037037 * SIZE));
            return new Border(new BorderStroke[]{outerBorder, innerBorder});
        }
    }
    ,
    BRASS(0.08333333){

        @Override
        public Border getBorder(double SIZE) {
            double fromX = 0.0;
            double fromY = 0.0;
            double toX = 0.0;
            double toY = SIZE;
            Stop[] stops = new Stop[]{new Stop(0.0, Color.rgb((int)249, (int)243, (int)155)), new Stop(0.05, Color.rgb((int)246, (int)226, (int)101)), new Stop(0.1, Color.rgb((int)240, (int)225, (int)132)), new Stop(0.5, Color.rgb((int)90, (int)57, (int)22)), new Stop(0.9, Color.rgb((int)249, (int)237, (int)139)), new Stop(0.95, Color.rgb((int)243, (int)226, (int)108)), new Stop(1.0, Color.rgb((int)202, (int)182, (int)113))};
            BorderStroke outerBorder = new BorderStroke((Paint)Color.rgb((int)132, (int)132, (int)132), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(1.0), Insets.EMPTY);
            BorderStroke innerBorder = new BorderStroke((Paint)new LinearGradient(fromX, fromY, toX, toY, false, CycleMethod.NO_CYCLE, stops), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(this.FRAME_FACTOR * SIZE), new Insets(0.0037037 * SIZE));
            return new Border(new BorderStroke[]{outerBorder, innerBorder});
        }
    }
    ,
    GOLD(0.08333333){

        @Override
        public Border getBorder(double SIZE) {
            double fromX = 0.0;
            double fromY = 0.0;
            double toX = 0.0;
            double toY = SIZE;
            Stop[] stops = new Stop[]{new Stop(0.0, Color.rgb((int)255, (int)255, (int)207)), new Stop(0.15, Color.rgb((int)255, (int)237, (int)96)), new Stop(0.22, Color.rgb((int)254, (int)199, (int)57)), new Stop(0.3, Color.rgb((int)255, (int)249, (int)203)), new Stop(0.38, Color.rgb((int)255, (int)199, (int)64)), new Stop(0.44, Color.rgb((int)252, (int)194, (int)60)), new Stop(0.51, Color.rgb((int)255, (int)204, (int)59)), new Stop(0.6, Color.rgb((int)213, (int)134, (int)29)), new Stop(0.68, Color.rgb((int)255, (int)201, (int)56)), new Stop(0.75, Color.rgb((int)212, (int)135, (int)29)), new Stop(1.0, Color.rgb((int)247, (int)238, (int)101))};
            BorderStroke outerBorder = new BorderStroke((Paint)Color.rgb((int)132, (int)132, (int)132), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(1.0), Insets.EMPTY);
            BorderStroke innerBorder = new BorderStroke((Paint)new LinearGradient(fromX, fromY, toX, toY, false, CycleMethod.NO_CYCLE, stops), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(this.FRAME_FACTOR * SIZE), new Insets(0.0037037 * SIZE));
            return new Border(new BorderStroke[]{outerBorder, innerBorder});
        }
    }
    ,
    BLACK_METAL(0.08333333){

        @Override
        public Border getBorder(double SIZE) {
            Stop[] stops = new Stop[]{new Stop(0.0, Color.rgb((int)254, (int)254, (int)254)), new Stop(0.125, Color.rgb((int)0, (int)0, (int)0)), new Stop(0.347222, Color.rgb((int)153, (int)153, (int)153)), new Stop(0.5, Color.rgb((int)0, (int)0, (int)0)), new Stop(0.6805555, Color.rgb((int)153, (int)153, (int)153)), new Stop(0.875, Color.rgb((int)0, (int)0, (int)0)), new Stop(1.0, Color.rgb((int)254, (int)254, (int)254))};
            ConicalGradient gradient = new ConicalGradient(SIZE * 0.5, SIZE * 0.5, Gauge.ScaleDirection.CLOCKWISE, stops);
            Image image = gradient.getRoundImage(SIZE);
            BorderStroke outerBorder = new BorderStroke((Paint)Color.rgb((int)132, (int)132, (int)132), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(1.0), Insets.EMPTY);
            BorderImage innerBorder = new BorderImage(image, BorderWidths.DEFAULT, new Insets(0.0037037 * SIZE), BorderWidths.EMPTY, true, BorderRepeat.STRETCH, BorderRepeat.STRETCH);
            return new Border(new BorderStroke[]{outerBorder}, new BorderImage[]{innerBorder});
        }
    }
    ,
    SHINY_METAL(0.08333333){

        @Override
        public Border getBorder(double SIZE) {
            Stop[] stops = new Stop[]{new Stop(0.0, Color.rgb((int)254, (int)254, (int)254)), new Stop(0.125, Color.rgb((int)179, (int)179, (int)179)), new Stop(0.347222, Color.rgb((int)238, (int)238, (int)238)), new Stop(0.45, Color.rgb((int)179, (int)179, (int)179)), new Stop(0.5, Color.rgb((int)179, (int)179, (int)179)), new Stop(0.55, Color.rgb((int)179, (int)179, (int)179)), new Stop(0.6805555, Color.rgb((int)238, (int)238, (int)238)), new Stop(0.875, Color.rgb((int)179, (int)179, (int)179)), new Stop(1.0, Color.rgb((int)254, (int)254, (int)254))};
            ConicalGradient gradient = new ConicalGradient(SIZE * 0.5, SIZE * 0.5, Gauge.ScaleDirection.CLOCKWISE, stops);
            Image image = gradient.getRoundImage(SIZE);
            BorderStroke outerBorder = new BorderStroke((Paint)Color.rgb((int)132, (int)132, (int)132), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(1.0), Insets.EMPTY);
            BorderImage innerBorder = new BorderImage(image, new BorderWidths(1.0), new Insets(0.0037037 * SIZE), BorderWidths.EMPTY, true, BorderRepeat.STRETCH, BorderRepeat.STRETCH);
            return new Border(new BorderStroke[]{outerBorder}, new BorderImage[]{innerBorder});
        }
    }
    ,
    ENZO(0.04814815){

        @Override
        public Border getBorder(double SIZE) {
            BorderStroke outerBorder = new BorderStroke((Paint)new LinearGradient(0.0, 0.0, 0.0, SIZE, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)224, (int)224, (int)224)), new Stop(0.26, Color.rgb((int)133, (int)133, (int)133)), new Stop(1.0, Color.rgb((int)84, (int)84, (int)84))}), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(this.FRAME_FACTOR * SIZE), Insets.EMPTY);
            BorderStroke highlightBorder = new BorderStroke((Paint)new LinearGradient(0.0, 0.02222222 * SIZE, 0.0, SIZE - 0.04444444 * SIZE, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)255, (int)255, (int)255)), new Stop(0.5, Color.rgb((int)146, (int)146, (int)147)), new Stop(1.0, Color.rgb((int)135, (int)136, (int)138))}), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(this.FRAME_FACTOR * SIZE), new Insets(0.02222222 * SIZE));
            BorderStroke innerBorder = new BorderStroke((Paint)new LinearGradient(0.0, 0.02592593 * SIZE, 0.0, SIZE - 0.05185186 * SIZE, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)71, (int)72, (int)72)), new Stop(0.5, Color.rgb((int)110, (int)106, (int)107)), new Stop(1.0, Color.rgb((int)186, (int)185, (int)187))}), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(this.FRAME_FACTOR * SIZE), new Insets(0.02592593 * SIZE));
            return new Border(new BorderStroke[]{outerBorder, highlightBorder, innerBorder});
        }
    }
    ,
    FLAT(0.08333333){

        @Override
        public Border getBorder(double SIZE) {
            BorderStroke outerBorder = new BorderStroke((Paint)Color.rgb((int)132, (int)132, (int)132), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(1.0), Insets.EMPTY);
            BorderStroke innerBorder = new BorderStroke((Paint)this.frameColor, BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(this.FRAME_FACTOR * SIZE), new Insets(0.0037037 * SIZE));
            return new Border(new BorderStroke[]{outerBorder, innerBorder});
        }
    }
    ,
    TRANSPARENT(0.0){

        @Override
        public Border getBorder(double SIZE) {
            return Border.EMPTY;
        }
    };

    public final double FRAME_FACTOR;
    public Color frameColor;

    public abstract Border getBorder(double var1);

    private GaugeDesign(double FRAME_FACTOR) {
        this.FRAME_FACTOR = FRAME_FACTOR;
        this.frameColor = Color.TRANSPARENT;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum GaugeBackground {
        DARK_GRAY{

            @Override
            public Paint getPaint(double X1, double Y1, double X2, double Y2) {
                Stop[] stops = new Stop[]{new Stop(0.0, Color.BLACK), new Stop(0.4, Color.rgb((int)51, (int)51, (int)51)), new Stop(1.0, Color.rgb((int)153, (int)153, (int)153))};
                return new LinearGradient(0.0, Y1, 0.0, Y2, false, CycleMethod.NO_CYCLE, stops);
            }
        }
        ,
        BEIGE{

            @Override
            public Paint getPaint(double X1, double Y1, double X2, double Y2) {
                Stop[] stops = new Stop[]{new Stop(0.0, Color.rgb((int)178, (int)172, (int)150)), new Stop(0.4, Color.rgb((int)204, (int)205, (int)184)), new Stop(1.0, Color.rgb((int)231, (int)231, (int)214))};
                return new LinearGradient(0.0, Y1, 0.0, Y2, false, CycleMethod.NO_CYCLE, stops);
            }
        }
        ,
        ANTHRACITE{

            @Override
            public Paint getPaint(double X1, double Y1, double X2, double Y2) {
                Stop[] stops = new Stop[]{new Stop(0.0, Color.rgb((int)50, (int)50, (int)54)), new Stop(0.4, Color.rgb((int)47, (int)47, (int)51)), new Stop(1.0, Color.rgb((int)69, (int)69, (int)74))};
                return new LinearGradient(0.0, Y1, 0.0, Y2, false, CycleMethod.NO_CYCLE, stops);
            }
        }
        ,
        LIGHT_GRAY{

            @Override
            public Paint getPaint(double X1, double Y1, double X2, double Y2) {
                Stop[] stops = new Stop[]{new Stop(0.0, Color.rgb((int)130, (int)130, (int)130)), new Stop(0.4, Color.rgb((int)181, (int)181, (int)181)), new Stop(1.0, Color.rgb((int)253, (int)253, (int)253))};
                return new LinearGradient(0.0, Y1, 0.0, Y2, false, CycleMethod.NO_CYCLE, stops);
            }
        }
        ,
        WHITE{

            @Override
            public Paint getPaint(double X1, double Y1, double X2, double Y2) {
                return Color.WHITE;
            }
        }
        ,
        BLACK{

            @Override
            public Paint getPaint(double X1, double Y1, double X2, double Y2) {
                return Color.BLACK;
            }
        }
        ,
        CARBON{

            @Override
            public Paint getPaint(double X1, double Y1, double X2, double Y2) {
                return Helper.createCarbonPattern();
            }
        }
        ,
        TRANSPARENT{

            @Override
            public Paint getPaint(double X1, double Y1, double X2, double Y2) {
                return Color.TRANSPARENT;
            }
        };


        public abstract Paint getPaint(double var1, double var3, double var5, double var7);
    }
}

