/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Alarm;
import eu.hansolo.medusa.Clock;
import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.TimeSection;
import eu.hansolo.medusa.skins.ClockSkinBase;
import eu.hansolo.medusa.tools.Helper;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.CacheHint;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Text;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;

public class IndustrialClockSkin
extends ClockSkinBase {
    private static final DateTimeFormatter DATE_NUMBER_FORMATTER = DateTimeFormatter.ofPattern("d");
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm");
    private Map<Alarm, Circle> alarmMap = new ConcurrentHashMap<Alarm, Circle>();
    private DateTimeFormatter dateTimeFormatter;
    private DateTimeFormatter dateTextFormatter;
    private double size;
    private Canvas sectionsAndAreasCanvas;
    private GraphicsContext sectionsAndAreasCtx;
    private Canvas tickCanvas;
    private GraphicsContext tickCtx;
    private Path hour;
    private Path minute;
    private Path second;
    private Text title;
    private Text dateText;
    private Text dateNumber;
    private Text text;
    private Circle centerDot;
    private Pane pane;
    private Pane alarmPane;
    private Rotate hourRotate;
    private Rotate minuteRotate = new Rotate();
    private Rotate secondRotate;
    private Group shadowGroupHour;
    private Group shadowGroupMinute;
    private Group shadowGroupSecond;
    private DropShadow dropShadow;
    private List<TimeSection> sections;
    private List<TimeSection> areas;
    private boolean sectionsVisible;
    private boolean highlightSections;
    private boolean areasVisible;
    private boolean highlightAreas;

    public IndustrialClockSkin(Clock clock) {
        super(clock);
        this.hourRotate = new Rotate();
        this.secondRotate = new Rotate();
        this.sections = clock.getSections();
        this.areas = clock.getAreas();
        this.sections = clock.getSections();
        this.highlightSections = clock.isHighlightSections();
        this.sectionsVisible = clock.getSectionsVisible();
        this.areas = clock.getAreas();
        this.highlightAreas = clock.isHighlightAreas();
        this.areasVisible = clock.getAreasVisible();
        this.dateTimeFormatter = DateTimeFormatter.ofPattern("EEEE\ndd.MM.YYYY\nHH:mm:ss").withLocale(clock.getLocale());
        this.dateTextFormatter = DateTimeFormatter.ofPattern("EE").withLocale(clock.getLocale());
        this.updateAlarms();
        this.initGraphics();
        this.registerListeners();
    }

    @Override
    protected void initGraphics() {
        if (Double.compare(this.clock.getPrefWidth(), 0.0) <= 0 || Double.compare(this.clock.getPrefHeight(), 0.0) <= 0 || Double.compare(this.clock.getWidth(), 0.0) <= 0 || Double.compare(this.clock.getHeight(), 0.0) <= 0) {
            if (this.clock.getPrefWidth() > 0.0 && this.clock.getPrefHeight() > 0.0) {
                this.clock.setPrefSize(this.clock.getPrefWidth(), this.clock.getPrefHeight());
            } else {
                this.clock.setPrefSize(250.0, 250.0);
            }
        }
        this.sectionsAndAreasCanvas = new Canvas(250.0, 250.0);
        this.sectionsAndAreasCtx = this.sectionsAndAreasCanvas.getGraphicsContext2D();
        this.tickCanvas = new Canvas(250.0, 250.0);
        this.tickCtx = this.tickCanvas.getGraphicsContext2D();
        this.alarmPane = new Pane();
        this.hour = new Path();
        this.hour.setFillRule(FillRule.EVEN_ODD);
        this.hour.setStroke(null);
        this.hour.getTransforms().setAll((Object[])new Transform[]{this.hourRotate});
        this.minute = new Path();
        this.minute.setFillRule(FillRule.EVEN_ODD);
        this.minute.setStroke(null);
        this.minute.getTransforms().setAll((Object[])new Transform[]{this.minuteRotate});
        this.second = new Path();
        this.second.setFillRule(FillRule.EVEN_ODD);
        this.second.setStroke(null);
        this.second.getTransforms().setAll((Object[])new Transform[]{this.secondRotate});
        this.second.setVisible(this.clock.isSecondsVisible());
        this.second.setManaged(this.clock.isSecondsVisible());
        this.centerDot = new Circle();
        this.centerDot.setFill((Paint)Color.WHITE);
        this.dropShadow = new DropShadow();
        this.dropShadow.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.25));
        this.dropShadow.setBlurType(BlurType.TWO_PASS_BOX);
        this.dropShadow.setRadius(3.75);
        this.dropShadow.setOffsetY(3.75);
        this.shadowGroupHour = new Group(new Node[]{this.hour});
        this.shadowGroupMinute = new Group(new Node[]{this.minute});
        this.shadowGroupSecond = new Group(new Node[]{this.second});
        this.shadowGroupHour.setEffect((Effect)(this.clock.getShadowsEnabled() ? this.dropShadow : null));
        this.shadowGroupMinute.setEffect((Effect)(this.clock.getShadowsEnabled() ? this.dropShadow : null));
        this.shadowGroupSecond.setEffect((Effect)(this.clock.getShadowsEnabled() ? this.dropShadow : null));
        this.title = new Text("");
        this.title.setVisible(this.clock.isTitleVisible());
        this.title.setManaged(this.clock.isTitleVisible());
        this.dateText = new Text("");
        this.dateText.setVisible(this.clock.isDateVisible());
        this.dateText.setManaged(this.clock.isDateVisible());
        this.dateNumber = new Text("");
        this.dateNumber.setVisible(this.clock.isDateVisible());
        this.dateNumber.setManaged(this.clock.isDateVisible());
        this.text = new Text("");
        this.text.setVisible(this.clock.isTextVisible());
        this.text.setManaged(this.clock.isTextVisible());
        this.pane = new Pane(new Node[]{this.sectionsAndAreasCanvas, this.tickCanvas, this.alarmPane, this.title, this.dateText, this.dateNumber, this.text, this.shadowGroupMinute, this.shadowGroupHour, this.shadowGroupSecond, this.centerDot});
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.clock.getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(this.clock.getBorderWidth()))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.clock.getBackgroundPaint(), new CornerRadii(1024.0), Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.clock.localeProperty().addListener(o -> {
            this.dateTimeFormatter = DateTimeFormatter.ofPattern("EEEE\ndd.MM.YYYY\nHH:mm:ss").withLocale(this.clock.getLocale());
            this.dateTextFormatter = DateTimeFormatter.ofPattern("EE").withLocale(this.clock.getLocale());
        });
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            this.title.setVisible(this.clock.isTitleVisible());
            this.title.setManaged(this.clock.isTitleVisible());
            this.text.setVisible(this.clock.isTextVisible());
            this.text.setManaged(this.clock.isTextVisible());
            this.dateText.setVisible(this.clock.isDateVisible());
            this.dateText.setManaged(this.clock.isDateVisible());
            this.dateNumber.setVisible(this.clock.isDateVisible());
            this.dateNumber.setManaged(this.clock.isDateVisible());
            this.second.setVisible(this.clock.isSecondsVisible());
            this.second.setManaged(this.clock.isSecondsVisible());
        } else if ("SECTION".equals(EVENT_TYPE)) {
            this.sections = this.clock.getSections();
            this.highlightSections = this.clock.isHighlightSections();
            this.sectionsVisible = this.clock.getSectionsVisible();
            this.areas = this.clock.getAreas();
            this.highlightAreas = this.clock.isHighlightAreas();
            this.areasVisible = this.clock.getAreasVisible();
            this.redraw();
        }
    }

    private void drawTicks() {
        double startAngle = 180.0;
        double angleStep = 1.5;
        Point2D center = new Point2D(this.size * 0.5, this.size * 0.5);
        Color hourTickMarkColor = this.clock.getHourTickMarkColor();
        Color minuteTickMarkColor = this.clock.getMinuteTickMarkColor();
        boolean hourTickMarksVisible = this.clock.isHourTickMarksVisible();
        boolean minuteTickMarksVisible = this.clock.isMinuteTickMarksVisible();
        this.tickCtx.clearRect(0.0, 0.0, this.size, this.size);
        this.tickCtx.setLineCap(StrokeLineCap.BUTT);
        this.tickCtx.setLineWidth(this.size * 0.02493075);
        double angle = 0.0;
        double counter = 0.0;
        while (Double.compare(counter, 239.0) <= 0) {
            double sinValue = Math.sin(Math.toRadians(angle + startAngle));
            double cosValue = Math.cos(Math.toRadians(angle + startAngle));
            Point2D innerPoint = new Point2D(center.getX() + this.size * 0.35277778 * sinValue, center.getY() + this.size * 0.35277778 * cosValue);
            Point2D innerMinutePoint = new Point2D(center.getX() + this.size * 0.40972222 * sinValue, center.getY() + this.size * 0.40972222 * cosValue);
            Point2D outerPoint = new Point2D(center.getX() + this.size * 0.46388889 * sinValue, center.getY() + this.size * 0.46388889 * cosValue);
            if (counter % 20.0 == 0.0) {
                this.tickCtx.setStroke((Paint)hourTickMarkColor);
                if (hourTickMarksVisible) {
                    this.tickCtx.setLineWidth(this.size * 0.02493075);
                    this.tickCtx.strokeLine(innerPoint.getX(), innerPoint.getY(), outerPoint.getX(), outerPoint.getY());
                } else if (minuteTickMarksVisible) {
                    this.tickCtx.strokeLine(innerMinutePoint.getX(), innerMinutePoint.getY(), outerPoint.getX(), outerPoint.getY());
                }
            } else if (counter % 4.0 == 0.0 && minuteTickMarksVisible) {
                this.tickCtx.setLineWidth(this.size * 0.00833333);
                this.tickCtx.setStroke((Paint)minuteTickMarkColor);
                this.tickCtx.strokeLine(innerMinutePoint.getX(), innerMinutePoint.getY(), outerPoint.getX(), outerPoint.getY());
            }
            angle -= angleStep;
            counter += 1.0;
        }
    }

    private void createHourPointer() {
        double width = this.size;
        double height = this.size;
        this.hour.setCache(false);
        this.hour.getElements().clear();
        this.hour.getElements().add((Object)new MoveTo(0.4930555555555556 * width, 0.28541666666666665 * height));
        this.hour.getElements().add((Object)new CubicCurveTo(0.4930555555555556 * width, 0.28125 * height, 0.49583333333333335 * width, 0.27847222222222223 * height, 0.5 * width, 0.27847222222222223 * height));
        this.hour.getElements().add((Object)new CubicCurveTo(0.5041666666666667 * width, 0.27847222222222223 * height, 0.5069444444444444 * width, 0.28125 * height, 0.5069444444444444 * width, 0.28541666666666665 * height));
        this.hour.getElements().add((Object)new CubicCurveTo(0.5069444444444444 * width, 0.28541666666666665 * height, 0.5069444444444444 * width, 0.39375 * height, 0.5069444444444444 * width, 0.39375 * height));
        this.hour.getElements().add((Object)new LineTo(0.4930555555555556 * width, 0.39375 * height));
        this.hour.getElements().add((Object)new CubicCurveTo(0.4930555555555556 * width, 0.39375 * height, 0.4930555555555556 * width, 0.28541666666666665 * height, 0.4930555555555556 * width, 0.28541666666666665 * height));
        this.hour.getElements().add((Object)new ClosePath());
        this.hour.getElements().add((Object)new MoveTo(0.4847222222222222 * width, 0.28541666666666665 * height));
        this.hour.getElements().add((Object)new CubicCurveTo(0.4847222222222222 * width, 0.28541666666666665 * height, 0.4847222222222222 * width, 0.49722222222222223 * height, 0.4847222222222222 * width, 0.49722222222222223 * height));
        this.hour.getElements().add((Object)new CubicCurveTo(0.4847222222222222 * width, 0.5055555555555555 * height, 0.49166666666666664 * width, 0.5125 * height, 0.5 * width, 0.5125 * height));
        this.hour.getElements().add((Object)new CubicCurveTo(0.5083333333333333 * width, 0.5125 * height, 0.5152777777777777 * width, 0.5055555555555555 * height, 0.5152777777777777 * width, 0.49722222222222223 * height));
        this.hour.getElements().add((Object)new CubicCurveTo(0.5152777777777777 * width, 0.49722222222222223 * height, 0.5152777777777777 * width, 0.28541666666666665 * height, 0.5152777777777777 * width, 0.28541666666666665 * height));
        this.hour.getElements().add((Object)new CubicCurveTo(0.5152777777777777 * width, 0.27708333333333335 * height, 0.5083333333333333 * width, 0.2701388888888889 * height, 0.5 * width, 0.2701388888888889 * height));
        this.hour.getElements().add((Object)new CubicCurveTo(0.49166666666666664 * width, 0.2701388888888889 * height, 0.4847222222222222 * width, 0.27708333333333335 * height, 0.4847222222222222 * width, 0.28541666666666665 * height));
        this.hour.getElements().add((Object)new ClosePath());
        this.hour.setCache(true);
        this.hour.setCacheHint(CacheHint.ROTATE);
    }

    private void createMinutePointer() {
        double width = this.size;
        double height = this.size;
        this.minute.setCache(false);
        this.minute.getElements().clear();
        this.minute.getElements().add((Object)new MoveTo(0.4930555555555556 * width, 0.17083333333333334 * height));
        this.minute.getElements().add((Object)new CubicCurveTo(0.4930555555555556 * width, 0.16666666666666666 * height, 0.49583333333333335 * width, 0.1638888888888889 * height, 0.5 * width, 0.1638888888888889 * height));
        this.minute.getElements().add((Object)new CubicCurveTo(0.5041666666666667 * width, 0.1638888888888889 * height, 0.5069444444444444 * width, 0.16666666666666666 * height, 0.5069444444444444 * width, 0.17083333333333334 * height));
        this.minute.getElements().add((Object)new CubicCurveTo(0.5069444444444444 * width, 0.17083333333333334 * height, 0.5069444444444444 * width, 0.33194444444444443 * height, 0.5069444444444444 * width, 0.33194444444444443 * height));
        this.minute.getElements().add((Object)new LineTo(0.4930555555555556 * width, 0.33194444444444443 * height));
        this.minute.getElements().add((Object)new CubicCurveTo(0.4930555555555556 * width, 0.33194444444444443 * height, 0.4930555555555556 * width, 0.17083333333333334 * height, 0.4930555555555556 * width, 0.17083333333333334 * height));
        this.minute.getElements().add((Object)new ClosePath());
        this.minute.getElements().add((Object)new MoveTo(0.4722222222222222 * width, 0.5 * height));
        this.minute.getElements().add((Object)new CubicCurveTo(0.4722222222222222 * width, 0.5152777777777777 * height, 0.4847222222222222 * width, 0.5277777777777778 * height, 0.5 * width, 0.5277777777777778 * height));
        this.minute.getElements().add((Object)new CubicCurveTo(0.5152777777777777 * width, 0.5277777777777778 * height, 0.5277777777777778 * width, 0.5152777777777777 * height, 0.5277777777777778 * width, 0.5 * height));
        this.minute.getElements().add((Object)new CubicCurveTo(0.5277777777777778 * width, 0.49027777777777776 * height, 0.5229166666666667 * width, 0.48194444444444445 * height, 0.5152777777777777 * width, 0.47708333333333336 * height));
        this.minute.getElements().add((Object)new CubicCurveTo(0.5152777777777777 * width, 0.47708333333333336 * height, 0.5152777777777777 * width, 0.17083333333333334 * height, 0.5152777777777777 * width, 0.17083333333333334 * height));
        this.minute.getElements().add((Object)new CubicCurveTo(0.5152777777777777 * width, 0.1625 * height, 0.5083333333333333 * width, 0.15555555555555556 * height, 0.5 * width, 0.15555555555555556 * height));
        this.minute.getElements().add((Object)new CubicCurveTo(0.49166666666666664 * width, 0.15555555555555556 * height, 0.4847222222222222 * width, 0.1625 * height, 0.4847222222222222 * width, 0.17083333333333334 * height));
        this.minute.getElements().add((Object)new CubicCurveTo(0.4847222222222222 * width, 0.17083333333333334 * height, 0.4847222222222222 * width, 0.47708333333333336 * height, 0.4847222222222222 * width, 0.47708333333333336 * height));
        this.minute.getElements().add((Object)new CubicCurveTo(0.47708333333333336 * width, 0.48194444444444445 * height, 0.4722222222222222 * width, 0.49027777777777776 * height, 0.4722222222222222 * width, 0.5 * height));
        this.minute.getElements().add((Object)new ClosePath());
        this.minute.setCache(true);
        this.minute.setCacheHint(CacheHint.ROTATE);
    }

    private void createSecondPointer() {
        double width = this.size;
        double height = this.size;
        this.second.setCache(false);
        this.second.getElements().clear();
        this.second.getElements().add((Object)new MoveTo(0.4951388888888889 * width, 0.5 * height));
        this.second.getElements().add((Object)new CubicCurveTo(0.4951388888888889 * width, 0.49722222222222223 * height, 0.49722222222222223 * width, 0.4951388888888889 * height, 0.5 * width, 0.4951388888888889 * height));
        this.second.getElements().add((Object)new CubicCurveTo(0.5027777777777778 * width, 0.4951388888888889 * height, 0.5048611111111111 * width, 0.49722222222222223 * height, 0.5048611111111111 * width, 0.5 * height));
        this.second.getElements().add((Object)new CubicCurveTo(0.5048611111111111 * width, 0.5027777777777778 * height, 0.5027777777777778 * width, 0.5048611111111111 * height, 0.5 * width, 0.5048611111111111 * height));
        this.second.getElements().add((Object)new CubicCurveTo(0.49722222222222223 * width, 0.5048611111111111 * height, 0.4951388888888889 * width, 0.5027777777777778 * height, 0.4951388888888889 * width, 0.5 * height));
        this.second.getElements().add((Object)new ClosePath());
        this.second.getElements().add((Object)new MoveTo(0.4875 * width, 0.5 * height));
        this.second.getElements().add((Object)new CubicCurveTo(0.4875 * width, 0.5048611111111111 * height, 0.49027777777777776 * width, 0.5090277777777777 * height, 0.49444444444444446 * width, 0.5111111111111111 * height));
        this.second.getElements().add((Object)new CubicCurveTo(0.49444444444444446 * width, 0.5111111111111111 * height, 0.49444444444444446 * width, 0.5638888888888889 * height, 0.49444444444444446 * width, 0.5638888888888889 * height));
        this.second.getElements().add((Object)new LineTo(0.5055555555555555 * width, 0.5638888888888889 * height));
        this.second.getElements().add((Object)new CubicCurveTo(0.5055555555555555 * width, 0.5638888888888889 * height, 0.5055555555555555 * width, 0.5111111111111111 * height, 0.5055555555555555 * width, 0.5111111111111111 * height));
        this.second.getElements().add((Object)new CubicCurveTo(0.5097222222222222 * width, 0.5090277777777777 * height, 0.5125 * width, 0.5048611111111111 * height, 0.5125 * width, 0.5 * height));
        this.second.getElements().add((Object)new CubicCurveTo(0.5125 * width, 0.4951388888888889 * height, 0.5097222222222222 * width, 0.4909722222222222 * height, 0.5055555555555555 * width, 0.4888888888888889 * height));
        this.second.getElements().add((Object)new CubicCurveTo(0.5055555555555555 * width, 0.4888888888888889 * height, 0.5055555555555555 * width, 0.19027777777777777 * height, 0.5055555555555555 * width, 0.19027777777777777 * height));
        this.second.getElements().add((Object)new LineTo(0.49444444444444446 * width, 0.19027777777777777 * height));
        this.second.getElements().add((Object)new CubicCurveTo(0.49444444444444446 * width, 0.19027777777777777 * height, 0.49444444444444446 * width, 0.4888888888888889 * height, 0.49444444444444446 * width, 0.4888888888888889 * height));
        this.second.getElements().add((Object)new CubicCurveTo(0.49027777777777776 * width, 0.4909722222222222 * height, 0.4875 * width, 0.4951388888888889 * height, 0.4875 * width, 0.5 * height));
        this.second.getElements().add((Object)new ClosePath());
        this.second.setCache(true);
        this.second.setCacheHint(CacheHint.ROTATE);
    }

    @Override
    public void updateTime(ZonedDateTime TIME) {
        if (this.clock.isDiscreteMinutes()) {
            this.minuteRotate.setAngle((double)(TIME.getMinute() * 6));
        } else {
            this.minuteRotate.setAngle((double)(TIME.getMinute() * 6) + (double)TIME.getSecond() * 0.1);
        }
        if (this.second.isVisible()) {
            if (this.clock.isDiscreteSeconds()) {
                this.secondRotate.setAngle((double)(TIME.getSecond() * 6));
            } else {
                this.secondRotate.setAngle((double)(TIME.getSecond() * 6) + (double)TIME.get(ChronoField.MILLI_OF_SECOND) * 0.006);
            }
        }
        if (this.clock.isDiscreteHours()) {
            this.hourRotate.setAngle((double)(TIME.getHour() * 30));
        } else {
            this.hourRotate.setAngle(0.5 * (double)(60 * TIME.getHour() + TIME.getMinute()));
        }
        if (this.text.isVisible()) {
            this.text.setText(TIME_FORMATTER.format(TIME));
            Helper.adjustTextSize(this.text, 0.6 * this.size, this.size * 0.12);
            this.text.relocate((this.size - this.text.getLayoutBounds().getWidth()) * 0.5, this.size * 0.6);
        }
        if (this.dateText.isVisible()) {
            this.dateText.setText(this.dateTextFormatter.format(TIME).toUpperCase());
            Helper.adjustTextSize(this.dateText, 0.3 * this.size, this.size * 0.05);
            this.dateText.relocate((this.size * 0.5 - this.dateText.getLayoutBounds().getWidth()) * 0.5 + this.size * 0.4, (this.size - this.dateText.getLayoutBounds().getHeight()) * 0.5);
        }
        if (this.dateNumber.isVisible()) {
            this.dateNumber.setText(DATE_NUMBER_FORMATTER.format(TIME).toUpperCase());
            Helper.adjustTextSize(this.dateNumber, 0.3 * this.size, this.size * 0.05);
            this.dateNumber.relocate((this.size * 0.5 - this.dateNumber.getLayoutBounds().getWidth()) * 0.5 + this.size * 0.51, (this.size - this.dateNumber.getLayoutBounds().getHeight()) * 0.5);
        }
        if (TIME.getMinute() == 0 && TIME.getSecond() == 0) {
            Helper.drawAlarms(this.clock, this.size, 0.0225, 0.4775, this.alarmMap, this.dateTimeFormatter, TIME);
        }
        if (this.highlightAreas | this.highlightSections) {
            this.sectionsAndAreasCtx.clearRect(0.0, 0.0, this.size, this.size);
            if (this.areasVisible) {
                Helper.drawTimeAreas(this.clock, this.sectionsAndAreasCtx, this.areas, this.size, 0.0, 0.0, 1.0, 1.0);
            }
            if (this.sectionsVisible) {
                Helper.drawTimeSections(this.clock, this.sectionsAndAreasCtx, this.sections, this.size, 0.02, 0.02, 0.96, 0.96, 0.04);
            }
        }
    }

    @Override
    public void updateAlarms() {
        this.alarmMap.clear();
        for (Alarm alarm : this.clock.getAlarms()) {
            this.alarmMap.put(alarm, new Circle());
        }
    }

    @Override
    protected void resize() {
        double height;
        double width = this.clock.getWidth() - this.clock.getInsets().getLeft() - this.clock.getInsets().getRight();
        double d = this.size = width < (height = this.clock.getHeight() - this.clock.getInsets().getTop() - this.clock.getInsets().getBottom()) ? width : height;
        if (this.size > 0.0) {
            double center = this.size * 0.5;
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((this.clock.getWidth() - this.size) * 0.5, (this.clock.getHeight() - this.size) * 0.5);
            this.dropShadow.setRadius(0.012 * this.size);
            this.dropShadow.setOffsetY(0.012 * this.size);
            this.sectionsAndAreasCanvas.setWidth(this.size);
            this.sectionsAndAreasCanvas.setHeight(this.size);
            this.tickCanvas.setWidth(this.size);
            this.tickCanvas.setHeight(this.size);
            this.alarmPane.setMaxSize(this.size, this.size);
            this.createHourPointer();
            this.hour.setFill((Paint)this.clock.getHourColor());
            this.hour.relocate((this.size - this.hour.getLayoutBounds().getWidth()) * 0.5, this.size * 0.27361111);
            this.createMinutePointer();
            this.minute.setFill((Paint)this.clock.getMinuteColor());
            this.minute.relocate((this.size - this.minute.getLayoutBounds().getWidth()) * 0.5, this.size * 0.15555556);
            this.createSecondPointer();
            this.second.setFill((Paint)this.clock.getSecondColor());
            this.second.relocate((this.size - this.second.getLayoutBounds().getWidth()) * 0.5, this.size * 0.19027778);
            this.centerDot.setCenterX(this.size * 0.5);
            this.centerDot.setCenterY(this.size * 0.5);
            this.centerDot.setRadius(this.size * 0.00486111);
            this.title.setFill((Paint)this.clock.getTextColor());
            this.title.setFont(Fonts.latoLight(this.size * 0.12));
            this.title.relocate((this.size - this.title.getLayoutBounds().getWidth()) * 0.5, this.size * 0.25);
            this.dateText.setFill((Paint)this.clock.getDateColor());
            this.dateText.setFont(Fonts.latoLight(this.size * 0.06666667));
            this.dateText.relocate((center - this.dateText.getLayoutBounds().getWidth()) * 0.5 + this.size * 0.4, (this.size - this.dateText.getLayoutBounds().getHeight()) * 0.5);
            this.dateNumber.setFill((Paint)this.clock.getSecondColor());
            this.dateNumber.setFont(Fonts.latoLight(this.size * 0.06666667));
            this.dateNumber.relocate((center - this.dateNumber.getLayoutBounds().getWidth()) * 0.5 + this.size * 0.51, (this.size - this.dateNumber.getLayoutBounds().getHeight()) * 0.5);
            this.text.setFill((Paint)this.clock.getTextColor());
            this.text.setFont(Fonts.latoLight(this.size * 0.12));
            this.text.relocate((this.size - this.text.getLayoutBounds().getWidth()) * 0.5, this.size * 0.6);
            this.hourRotate.setPivotX(this.size * 0.5);
            this.hourRotate.setPivotY(this.size * 0.5);
            this.minuteRotate.setPivotX(this.size * 0.5);
            this.minuteRotate.setPivotY(this.size * 0.5);
            this.secondRotate.setPivotX(this.size * 0.5);
            this.secondRotate.setPivotY(this.size * 0.5);
        }
    }

    @Override
    protected void redraw() {
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.clock.getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(this.clock.getBorderWidth() / 250.0 * this.size))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.clock.getBackgroundPaint(), new CornerRadii(1024.0), Insets.EMPTY)}));
        this.hour.setFill((Paint)this.clock.getHourColor());
        this.minute.setFill((Paint)this.clock.getMinuteColor());
        this.second.setFill((Paint)this.clock.getSecondColor());
        this.title.setFill((Paint)this.clock.getTitleColor());
        this.dateText.setFill((Paint)this.clock.getDateColor());
        this.text.setFill((Paint)this.clock.getTextColor());
        this.shadowGroupHour.setEffect((Effect)(this.clock.getShadowsEnabled() ? this.dropShadow : null));
        this.shadowGroupMinute.setEffect((Effect)(this.clock.getShadowsEnabled() ? this.dropShadow : null));
        this.shadowGroupSecond.setEffect((Effect)(this.clock.getShadowsEnabled() ? this.dropShadow : null));
        this.sectionsAndAreasCtx.clearRect(0.0, 0.0, this.size, this.size);
        if (this.areasVisible) {
            Helper.drawTimeAreas(this.clock, this.sectionsAndAreasCtx, this.areas, this.size, 0.0, 0.0, 1.0, 1.0);
        }
        if (this.sectionsVisible) {
            Helper.drawTimeSections(this.clock, this.sectionsAndAreasCtx, this.sections, this.size, 0.02, 0.02, 0.96, 0.96, 0.04);
        }
        this.tickCanvas.setCache(false);
        this.drawTicks();
        this.tickCanvas.setCache(true);
        this.tickCanvas.setCacheHint(CacheHint.QUALITY);
        ZonedDateTime time = this.clock.getTime();
        this.updateTime(time);
        this.title.setText(this.clock.getTitle());
        Helper.adjustTextSize(this.title, 0.6 * this.size, this.size * 0.12);
        this.title.relocate((this.size - this.title.getLayoutBounds().getWidth()) * 0.5, this.size * 0.25);
        this.text.setText(TIME_FORMATTER.format(time));
        Helper.adjustTextSize(this.text, 0.6 * this.size, this.size * 0.12);
        this.text.relocate((this.size - this.text.getLayoutBounds().getWidth()) * 0.5, this.size * 0.6);
        this.dateText.setText(this.dateTextFormatter.format(time).toUpperCase());
        Helper.adjustTextSize(this.dateText, 0.3 * this.size, this.size * 0.05);
        this.dateText.relocate((this.size * 0.5 - this.dateText.getLayoutBounds().getWidth()) * 0.5 + this.size * 0.4, (this.size - this.dateText.getLayoutBounds().getHeight()) * 0.5);
        this.dateNumber.setText(DATE_NUMBER_FORMATTER.format(time).toUpperCase());
        Helper.adjustTextSize(this.dateNumber, 0.3 * this.size, this.size * 0.05);
        this.dateNumber.relocate((this.size * 0.5 - this.dateNumber.getLayoutBounds().getWidth()) * 0.5 + this.size * 0.51, (this.size - this.dateNumber.getLayoutBounds().getHeight()) * 0.5);
        this.alarmPane.getChildren().setAll(this.alarmMap.values());
        Helper.drawAlarms(this.clock, this.size, 0.0225, 0.4775, this.alarmMap, this.dateTimeFormatter, time);
    }
}

