/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.LcdDesign;
import eu.hansolo.medusa.Section;
import eu.hansolo.medusa.skins.GaugeSkinBase;
import eu.hansolo.medusa.tools.Helper;
import java.util.List;
import java.util.Locale;
import javafx.beans.InvalidationListener;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class LinearSkin
extends GaugeSkinBase {
    protected static final double MINIMUM_WIDTH = 100.0;
    protected static final double MINIMUM_HEIGHT = 100.0;
    protected static final double MAXIMUM_WIDTH = 1024.0;
    protected static final double MAXIMUM_HEIGHT = 1024.0;
    private double preferredWidth = 140.0;
    private double preferredHeight = 350.0;
    private double aspectRatio = 2.5;
    private double size;
    private double width;
    private double height;
    private double stepSize;
    private Pane pane;
    private Orientation orientation;
    private Canvas ticksAndSectionsCanvas;
    private GraphicsContext ticksAndSections;
    private Text unitText;
    private Text titleText;
    private Text valueText;
    private Line barBorder1;
    private Line barBorder2;
    private Rectangle barBackground;
    private Rectangle bar;
    private Rectangle barHighlight;
    private double ledSize;
    private InnerShadow ledOnShadow;
    private InnerShadow ledOffShadow;
    private Paint ledFramePaint;
    private Paint ledOnPaint;
    private Paint ledOffPaint;
    private Paint ledHighlightPaint;
    private Canvas ledCanvas;
    private GraphicsContext led;
    private Rectangle lcd;
    private String tickLabelFormatString;
    private Locale locale;
    private double minValuePosition;
    private double maxValuePosition;
    private double zeroPosition;
    private List<Section> sections;
    private List<Section> areas;
    private InvalidationListener currentValueListener;
    private InvalidationListener paneSizeListener;

    public LinearSkin(Gauge gauge) {
        super(gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.orientation = gauge.getOrientation();
        this.tickLabelFormatString = "%." + Integer.toString(gauge.getTickLabelDecimals()) + "f";
        this.locale = gauge.getLocale();
        this.sections = gauge.getSections();
        this.areas = gauge.getAreas();
        this.currentValueListener = o -> this.setBar(gauge.getCurrentValue());
        this.paneSizeListener = o -> this.handleEvents("RESIZE");
        if (Orientation.VERTICAL == this.orientation) {
            this.preferredWidth = 140.0;
            this.preferredHeight = 350.0;
        } else {
            this.preferredWidth = 350.0;
            this.preferredHeight = 140.0;
        }
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.gauge.getPrefWidth(), 0.0) <= 0 || Double.compare(this.gauge.getPrefHeight(), 0.0) <= 0 || Double.compare(this.gauge.getWidth(), 0.0) <= 0 || Double.compare(this.gauge.getHeight(), 0.0) <= 0) {
            if (this.gauge.getPrefWidth() > 0.0 && this.gauge.getPrefHeight() > 0.0) {
                this.gauge.setPrefSize(this.gauge.getPrefWidth(), this.gauge.getPrefHeight());
            } else {
                this.gauge.setPrefSize(this.preferredWidth, this.preferredHeight);
            }
        }
        this.barBorder1 = new Line();
        this.barBorder2 = new Line();
        this.barBackground = new Rectangle();
        this.ticksAndSectionsCanvas = new Canvas(this.preferredWidth, this.preferredHeight);
        this.ticksAndSections = this.ticksAndSectionsCanvas.getGraphicsContext2D();
        this.ledCanvas = new Canvas();
        this.led = this.ledCanvas.getGraphicsContext2D();
        Helper.enableNode((Node)this.ledCanvas, this.gauge.isLedVisible());
        this.lcd = new Rectangle(0.3 * this.preferredWidth, 0.014 * this.preferredHeight);
        this.lcd.setArcWidth(0.0125 * this.preferredHeight);
        this.lcd.setArcHeight(0.0125 * this.preferredHeight);
        this.lcd.relocate((this.preferredWidth - this.lcd.getWidth()) * 0.5, 0.44 * this.preferredHeight);
        Helper.enableNode((Node)this.lcd, this.gauge.isLcdVisible() && this.gauge.isValueVisible());
        this.bar = new Rectangle();
        this.bar.setStroke(null);
        this.barHighlight = new Rectangle();
        this.barHighlight.setStroke(null);
        Helper.enableNode((Node)this.barHighlight, this.gauge.isBarEffectEnabled());
        this.titleText = new Text(this.gauge.getTitle());
        this.titleText.setFill((Paint)this.gauge.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.gauge.getTitle().isEmpty());
        this.unitText = new Text(this.gauge.getUnit());
        this.unitText.setFill((Paint)this.gauge.getUnitColor());
        Helper.enableNode((Node)this.unitText, !this.gauge.getUnit().isEmpty());
        this.valueText = new Text(Helper.formatNumber(this.gauge.getLocale(), this.gauge.getFormatString(), this.gauge.getDecimals(), this.gauge.getCurrentValue()));
        this.valueText.setFill((Paint)this.gauge.getValueColor());
        Helper.enableNode((Node)this.valueText, this.gauge.isValueVisible());
        this.pane = new Pane(new Node[]{this.barBorder1, this.barBorder2, this.barBackground, this.ticksAndSectionsCanvas, this.titleText, this.unitText, this.ledCanvas, this.lcd, this.valueText, this.bar, this.barHighlight});
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.gauge.getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(this.gauge.getBorderWidth()))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.gauge.getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.gauge.currentValueProperty().addListener(this.currentValueListener);
        this.pane.widthProperty().addListener(this.paneSizeListener);
        this.pane.heightProperty().addListener(this.paneSizeListener);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("FINISHED".equals(EVENT_TYPE)) {
            if (this.gauge.isHighlightSections()) {
                this.redraw();
            }
        } else if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.ledCanvas, this.gauge.isLedVisible());
            Helper.enableNode((Node)this.titleText, !this.gauge.getTitle().isEmpty());
            Helper.enableNode((Node)this.unitText, !this.gauge.getUnit().isEmpty());
            Helper.enableNode((Node)this.valueText, this.gauge.isValueVisible());
            Helper.enableNode((Node)this.lcd, this.gauge.isLcdVisible() && this.gauge.isValueVisible());
            Helper.enableNode((Node)this.barHighlight, this.gauge.isBarEffectEnabled());
            this.resize();
            this.redraw();
        } else if ("LED".equals(EVENT_TYPE)) {
            if (this.gauge.isLedVisible()) {
                this.drawLed();
            }
        } else if ("LCD".equals(EVENT_TYPE)) {
            if (this.gauge.isLcdVisible()) {
                this.redraw();
            }
        } else if ("SECTION".equals(EVENT_TYPE)) {
            this.sections = this.gauge.getSections();
            this.areas = this.gauge.getAreas();
            this.resize();
            this.redraw();
        } else if ("RECALC".equals(EVENT_TYPE)) {
            this.orientation = this.gauge.getOrientation();
            if (Orientation.VERTICAL == this.orientation) {
                this.width = this.height / this.aspectRatio;
            } else {
                this.height = this.width / this.aspectRatio;
            }
            this.resize();
            this.redraw();
        }
    }

    @Override
    public void dispose() {
        this.gauge.currentValueProperty().removeListener(this.currentValueListener);
        this.pane.widthProperty().removeListener(this.paneSizeListener);
        this.pane.heightProperty().removeListener(this.paneSizeListener);
        super.dispose();
    }

    private void drawTickMarks(GraphicsContext CTX) {
        double maxPosition;
        double minPosition;
        if (Double.compare(this.stepSize, 0.0) <= 0) {
            return;
        }
        CTX.setFont(Fonts.robotoLight(0.06 * this.size));
        CTX.setStroke((Paint)this.gauge.getTickMarkColor());
        CTX.setFill((Paint)this.gauge.getTickLabelColor());
        if (Orientation.VERTICAL == this.orientation) {
            minPosition = this.barBackground.getLayoutY() + this.size * 0.0035;
            maxPosition = this.barBackground.getLayoutY() + this.barBackground.getLayoutBounds().getHeight();
        } else {
            minPosition = this.barBackground.getLayoutX();
            maxPosition = this.barBackground.getLayoutX() + this.barBackground.getLayoutBounds().getWidth();
        }
        double anchorX = this.barBackground.getLayoutX() - 0.075 * this.width;
        double anchorY = this.barBackground.getLayoutY() + this.barBackground.getHeight() + 0.075 * this.height;
        double majorTickSpace = this.gauge.getMajorTickSpace();
        double minorTickSpace = this.gauge.getMinorTickSpace();
        double minValue = this.gauge.getMinValue();
        double maxValue = this.gauge.getMaxValue();
        if (this.gauge.getSectionsVisible()) {
            this.drawSections(CTX);
        }
        int counter = 0;
        double i = minPosition;
        while (Double.compare(i, maxPosition + 1.0) <= 0) {
            Point2D textPoint;
            Point2D outerPoint;
            Point2D innerMinorPoint;
            Point2D innerMediumPoint;
            Point2D innerPoint;
            if (Orientation.VERTICAL == this.orientation) {
                innerPoint = new Point2D(anchorX, i);
                innerMediumPoint = new Point2D(anchorX + 0.015 * this.width, i);
                innerMinorPoint = new Point2D(anchorX + 0.03 * this.width, i);
                outerPoint = new Point2D(anchorX + 0.05 * this.width, i);
                textPoint = new Point2D(anchorX - 0.02 * this.width, i);
            } else {
                innerPoint = new Point2D(i, anchorY);
                innerMediumPoint = new Point2D(i, anchorY - 0.015 * this.height);
                innerMinorPoint = new Point2D(i, anchorY - 0.03 * this.height);
                outerPoint = new Point2D(i, anchorY - 0.05 * this.height);
                textPoint = new Point2D(i, anchorY + 0.05 * this.height);
            }
            if ((double)counter % majorTickSpace == 0.0) {
                if (this.gauge.getMajorTickMarksVisible()) {
                    CTX.setLineWidth(this.size * 0.007);
                    CTX.strokeLine(innerPoint.getX(), innerPoint.getY(), outerPoint.getX(), outerPoint.getY());
                }
                if (this.gauge.getTickLabelsVisible()) {
                    CTX.setTextBaseline(VPos.CENTER);
                    if (Orientation.VERTICAL == this.orientation) {
                        CTX.setTextAlign(TextAlignment.RIGHT);
                        CTX.fillText(String.format(this.locale, this.tickLabelFormatString, (maxValue -= majorTickSpace) + majorTickSpace), textPoint.getX(), textPoint.getY());
                    } else {
                        CTX.setTextAlign(TextAlignment.CENTER);
                        CTX.fillText(String.format(this.locale, this.tickLabelFormatString, (minValue += majorTickSpace) - majorTickSpace), textPoint.getX(), textPoint.getY());
                    }
                }
            } else if (minorTickSpace % 2.0 != 0.0 && counter % 5 == 0) {
                if (this.gauge.getMediumTickMarksVisible()) {
                    CTX.setLineWidth(this.size * 0.006);
                    CTX.strokeLine(innerMediumPoint.getX(), innerMediumPoint.getY(), outerPoint.getX(), outerPoint.getY());
                }
            } else if ((double)counter % minorTickSpace == 0.0 && this.gauge.getMinorTickMarksVisible()) {
                CTX.setLineWidth(this.size * 0.005);
                CTX.strokeLine(innerMinorPoint.getX(), innerMinorPoint.getY(), outerPoint.getX(), outerPoint.getY());
            }
            ++counter;
            i += this.stepSize;
        }
    }

    private void drawSections(GraphicsContext CTX) {
        if (!this.gauge.getSectionsVisible() && this.sections.isEmpty()) {
            return;
        }
        double value = this.gauge.getCurrentValue();
        int listSize = this.sections.size();
        double minValue = this.gauge.getMinValue();
        CTX.save();
        if (Orientation.VERTICAL == this.orientation) {
            double minPosition = this.barBackground.getLayoutY() + this.barBackground.getLayoutBounds().getHeight() - this.size * 0.0035;
            double anchorX = this.barBackground.getLayoutX() - 0.079 * this.width;
            int i = 0;
            while (i < listSize) {
                Section section = this.sections.get(i);
                double sectionHeight = (section.getStop() - section.getStart()) * this.stepSize;
                if (this.gauge.isHighlightSections()) {
                    CTX.setFill((Paint)(section.contains(value) ? section.getHighlightColor() : section.getColor()));
                } else {
                    CTX.setFill((Paint)section.getColor());
                }
                CTX.fillRect(anchorX, minPosition - sectionHeight - (section.getStart() - minValue) * this.stepSize, 0.057 * this.width, sectionHeight);
                ++i;
            }
        } else {
            double minPosition = this.barBackground.getLayoutX();
            double anchorY = this.barBackground.getLayoutY() + this.barBackground.getHeight() + 0.021 * this.height;
            int i = 0;
            while (i < listSize) {
                Section section = this.sections.get(i);
                double sectionWidth = (section.getStop() - section.getStart()) * this.stepSize;
                if (this.gauge.isHighlightSections()) {
                    CTX.setFill((Paint)(section.contains(value) ? section.getHighlightColor() : section.getColor()));
                } else {
                    CTX.setFill((Paint)section.getColor());
                }
                CTX.fillRect(minPosition + (section.getStart() - minValue) * this.stepSize, anchorY, sectionWidth, 0.059 * this.height);
                ++i;
            }
        }
        CTX.restore();
    }

    private void setBar(double VALUE) {
        double maxValue = (this.gauge.getMaxValue() - this.gauge.getMinValue()) * this.stepSize;
        if (Orientation.VERTICAL == this.orientation) {
            double valueHeight = 0.0;
            double layoutY = 0.0;
            if (this.gauge.isStartFromZero()) {
                double maxV = this.gauge.getMaxValue();
                double maxY = maxV * this.stepSize;
                double valY = VALUE * this.stepSize;
                double minV = this.gauge.getMinValue();
                double minY = minV * this.stepSize;
                if ((valY > minY || minY < 0.0) && (valY < maxY || maxY > 0.0)) {
                    valY = Helper.clamp(minY, maxY, valY);
                    if (maxY < 0.0) {
                        layoutY = -maxY;
                        valueHeight = maxY - valY;
                    } else if (minY > 0.0) {
                        layoutY = -valY;
                        valueHeight = valY - minY;
                    } else if (valY < 0.0) {
                        layoutY = 0.0;
                        valueHeight = -valY;
                    } else {
                        layoutY = -valY;
                        valueHeight = valY;
                    }
                }
            } else {
                valueHeight = Helper.clamp(0.0, maxValue, (VALUE - this.gauge.getMinValue()) * this.stepSize);
                layoutY = -valueHeight;
            }
            this.bar.setLayoutY(layoutY);
            this.bar.setHeight(valueHeight);
            this.barHighlight.setLayoutY(layoutY);
            this.barHighlight.setHeight(valueHeight);
            this.valueText.setText(Helper.formatNumber(this.gauge.getLocale(), this.gauge.getFormatString(), this.gauge.getDecimals(), VALUE));
            if (this.gauge.isLcdVisible()) {
                this.valueText.setLayoutX(0.88 * this.width - this.valueText.getLayoutBounds().getWidth());
            } else {
                this.valueText.setLayoutX((this.width - this.valueText.getLayoutBounds().getWidth()) * 0.5);
            }
        } else {
            double valueWidth = 0.0;
            double layoutX = 0.0;
            if (this.gauge.isStartFromZero()) {
                double maxV = this.gauge.getMaxValue();
                double maxX = maxV * this.stepSize;
                double valX = VALUE * this.stepSize;
                double minV = this.gauge.getMinValue();
                double minX = minV * this.stepSize;
                if ((valX > minX || minX < 0.0) && (valX < maxX || maxX > 0.0)) {
                    valX = Helper.clamp(minX, maxX, valX);
                    if (maxX < 0.0) {
                        layoutX = valX;
                        valueWidth = maxX - valX;
                    } else if (minX > 0.0) {
                        layoutX = minX;
                        valueWidth = valX - minX;
                    } else if (valX < 0.0) {
                        layoutX = valX;
                        valueWidth = -valX;
                    } else {
                        layoutX = 0.0;
                        valueWidth = valX;
                    }
                }
            } else {
                valueWidth = Helper.clamp(0.0, maxValue, (VALUE - this.gauge.getMinValue()) * this.stepSize);
            }
            this.bar.setLayoutX(layoutX);
            this.bar.setWidth(valueWidth);
            this.barHighlight.setLayoutX(layoutX);
            this.barHighlight.setWidth(valueWidth);
            this.valueText.setText(Helper.formatNumber(this.gauge.getLocale(), this.gauge.getFormatString(), this.gauge.getDecimals(), VALUE));
            this.valueText.setLayoutX(0.98 * this.width - this.valueText.getLayoutBounds().getWidth());
        }
        this.setBarColor(VALUE);
    }

    private void setBarColor(double VALUE) {
        if (!this.gauge.getAreasVisible() && !this.gauge.isGradientBarEnabled()) {
            this.bar.setFill((Paint)this.gauge.getBarColor());
        } else if (this.gauge.isGradientBarEnabled() && this.gauge.getGradientBarStops().size() > 1) {
            this.bar.setFill((Paint)this.gauge.getGradientLookup().getColorAt((VALUE - this.gauge.getMinValue()) / this.gauge.getRange()));
        } else {
            this.bar.setFill((Paint)this.gauge.getBarColor());
            int listSize = this.areas.size();
            int i = 0;
            while (i < listSize) {
                Section area = this.areas.get(i);
                if (area.contains(VALUE)) {
                    this.bar.setFill((Paint)area.getColor());
                    break;
                }
                ++i;
            }
        }
    }

    private void drawLed() {
        boolean isFlatLed;
        this.led.clearRect(0.0, 0.0, this.ledSize, this.ledSize);
        boolean bl = isFlatLed = Gauge.LedType.FLAT == this.gauge.getLedType();
        if (!isFlatLed) {
            this.led.setFill(this.ledFramePaint);
            this.led.fillOval(0.0, 0.0, this.ledSize, this.ledSize);
        } else {
            double lineWidth = 0.0037037 * this.size;
            this.led.setStroke(this.ledFramePaint);
            this.led.setLineWidth(lineWidth);
            this.led.strokeOval(lineWidth, lineWidth, this.ledSize - 2.0 * lineWidth, this.ledSize - 2.0 * lineWidth);
        }
        this.led.save();
        if (this.gauge.isLedOn()) {
            this.led.setEffect((Effect)this.ledOnShadow);
            this.led.setFill(this.ledOnPaint);
        } else {
            this.led.setEffect((Effect)this.ledOffShadow);
            this.led.setFill(this.ledOffPaint);
        }
        if (isFlatLed) {
            this.led.fillOval(0.2 * this.ledSize, 0.2 * this.ledSize, 0.6 * this.ledSize, 0.6 * this.ledSize);
        } else {
            this.led.fillOval(0.14 * this.ledSize, 0.14 * this.ledSize, 0.72 * this.ledSize, 0.72 * this.ledSize);
        }
        this.led.restore();
        this.led.setFill(this.ledHighlightPaint);
        this.led.fillOval(0.21 * this.ledSize, 0.21 * this.ledSize, 0.58 * this.ledSize, 0.58 * this.ledSize);
    }

    private void resizeText() {
        if (Orientation.VERTICAL == this.orientation) {
            double maxWidth = this.width * 0.95;
            double fontSize = this.width * 0.13;
            this.titleText.setFont(Fonts.robotoRegular(fontSize));
            this.titleText.setText(this.gauge.getTitle());
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
            this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, 0.0);
            fontSize = this.width * 0.08;
            this.unitText.setFont(Fonts.robotoRegular(fontSize));
            this.unitText.setText(this.gauge.getUnit());
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
            this.unitText.relocate((this.width - this.unitText.getLayoutBounds().getWidth()) * 0.5, 0.075 * this.height);
            if (this.gauge.isLcdVisible()) {
                switch (this.gauge.getLcdFont()) {
                    case LCD: {
                        this.valueText.setFont(Fonts.digital(0.24 * this.width));
                        this.valueText.relocate(0.88 * this.width - this.valueText.getLayoutBounds().getWidth(), 0.877 * this.height);
                        break;
                    }
                    case DIGITAL: {
                        this.valueText.setFont(Fonts.digitalReadout(0.225 * this.width));
                        this.valueText.relocate(0.88 * this.width - this.valueText.getLayoutBounds().getWidth(), 0.875 * this.height);
                        break;
                    }
                    case DIGITAL_BOLD: {
                        this.valueText.setFont(Fonts.digitalReadoutBold(0.225 * this.width));
                        this.valueText.relocate(0.88 * this.width - this.valueText.getLayoutBounds().getWidth(), 0.875 * this.height);
                        break;
                    }
                    case ELEKTRA: {
                        this.valueText.setFont(Fonts.elektra(0.24 * this.width));
                        this.valueText.relocate(0.88 * this.width - this.valueText.getLayoutBounds().getWidth(), 0.867 * this.height);
                        break;
                    }
                    default: {
                        this.valueText.setFont(Fonts.robotoMedium(0.22 * this.width));
                        this.valueText.relocate(0.88 * this.width - this.valueText.getLayoutBounds().getWidth(), 0.855 * this.height);
                        break;
                    }
                }
            } else {
                this.valueText.setFont(Fonts.robotoRegular(0.17 * this.width));
                this.valueText.relocate((this.width - this.valueText.getLayoutBounds().getWidth()) * 0.5, this.height * 0.877);
            }
        } else {
            double maxWidth = this.width * 0.8;
            double fontSize = this.height * 0.15;
            this.titleText.setFont(Fonts.robotoRegular(fontSize));
            this.titleText.setText(this.gauge.getTitle());
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
            this.titleText.relocate(0.03571429 * this.height, 0.03571429 * this.height);
            fontSize = this.height * 0.1;
            this.unitText.setFont(Fonts.robotoRegular(fontSize));
            this.unitText.setText(this.gauge.getUnit());
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
            this.unitText.relocate((this.width - this.unitText.getLayoutBounds().getWidth()) * 0.5, 0.8 * this.height);
            if (this.gauge.isLcdVisible()) {
                switch (this.gauge.getLcdFont()) {
                    case LCD: {
                        this.valueText.setFont(Fonts.digital(0.24 * this.height));
                        this.valueText.relocate(0.98 * this.width - this.valueText.getLayoutBounds().getWidth(), 0.052 * this.height);
                        break;
                    }
                    case DIGITAL: {
                        this.valueText.setFont(Fonts.digitalReadout(0.225 * this.height));
                        this.valueText.relocate(0.98 * this.width - this.valueText.getLayoutBounds().getWidth(), 0.05 * this.height);
                        break;
                    }
                    case DIGITAL_BOLD: {
                        this.valueText.setFont(Fonts.digitalReadoutBold(0.225 * this.height));
                        this.valueText.relocate(0.98 * this.width - this.valueText.getLayoutBounds().getWidth(), 0.05 * this.height);
                        break;
                    }
                    case ELEKTRA: {
                        this.valueText.setFont(Fonts.elektra(0.24 * this.height));
                        this.valueText.relocate(0.98 * this.width - this.valueText.getLayoutBounds().getWidth(), 0.042 * this.height);
                        break;
                    }
                    default: {
                        this.valueText.setFont(Fonts.robotoMedium(0.22 * this.height));
                        this.valueText.relocate(0.98 * this.width - this.valueText.getLayoutBounds().getWidth(), 0.03 * this.height);
                        break;
                    }
                }
            } else {
                this.valueText.setFont(Fonts.robotoRegular(0.17 * this.height));
                this.valueText.relocate(0.98 * this.width - this.valueText.getLayoutBounds().getWidth(), 0.03 * this.height);
            }
        }
    }

    @Override
    protected void resize() {
        this.width = this.gauge.getWidth() - this.gauge.getInsets().getLeft() - this.gauge.getInsets().getRight();
        this.height = this.gauge.getHeight() - this.gauge.getInsets().getTop() - this.gauge.getInsets().getBottom();
        if (this.width > 0.0 && this.height > 0.0) {
            boolean isFlatLed;
            this.orientation = this.gauge.getOrientation();
            double currentValue = this.gauge.getCurrentValue();
            Color tickMarkColor = this.gauge.getTickMarkColor();
            Color barBorderColor = Color.color((double)tickMarkColor.getRed(), (double)tickMarkColor.getGreen(), (double)tickMarkColor.getBlue(), (double)0.5);
            boolean bl = isFlatLed = Gauge.LedType.FLAT == this.gauge.getLedType();
            if (Orientation.VERTICAL == this.orientation) {
                this.width = this.height / this.aspectRatio;
                this.size = this.width < this.height ? this.width : this.height;
                this.stepSize = Math.abs(0.66793 * this.height / this.gauge.getRange());
                this.pane.setMaxSize(this.width, this.height);
                this.pane.relocate((this.gauge.getWidth() - this.width) * 0.5, (this.gauge.getHeight() - this.height) * 0.5);
                this.width = this.pane.getLayoutBounds().getWidth();
                this.height = this.pane.getLayoutBounds().getHeight();
                this.barBackground.setWidth(0.14286 * this.width);
                this.barBackground.setHeight(0.67143 * this.height);
                this.barBackground.relocate((this.width - this.barBackground.getWidth()) * 0.5, (this.height - this.barBackground.getHeight()) * 0.5);
                this.barBackground.setStroke(null);
                this.barBackground.setFill((Paint)new LinearGradient(0.0, this.barBackground.getLayoutBounds().getMinY(), 0.0, this.barBackground.getLayoutBounds().getMaxY(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)255, (int)255, (int)255, (double)0.05)), new Stop(0.5, Color.rgb((int)255, (int)255, (int)255, (double)0.15)), new Stop(1.0, Color.rgb((int)255, (int)255, (int)255, (double)0.05))}));
                this.minValuePosition = this.barBackground.getLayoutY() + this.barBackground.getLayoutBounds().getHeight();
                this.maxValuePosition = this.barBackground.getLayoutY();
                this.zeroPosition = this.minValuePosition + this.gauge.getMinValue() * this.stepSize;
                this.barBorder1.setStartX(this.barBackground.getLayoutX() - 1.0);
                this.barBorder1.setStartY(this.maxValuePosition);
                this.barBorder1.setEndX(this.barBackground.getLayoutX() - 1.0);
                this.barBorder1.setEndY(this.minValuePosition);
                this.barBorder2.setStartX(this.barBackground.getLayoutX() + this.barBackground.getLayoutBounds().getWidth() + 1.0);
                this.barBorder2.setStartY(this.maxValuePosition);
                this.barBorder2.setEndX(this.barBackground.getLayoutX() + this.barBackground.getLayoutBounds().getWidth() + 1.0);
                this.barBorder2.setEndY(this.minValuePosition);
                this.barBorder1.setStroke((Paint)barBorderColor);
                this.barBorder2.setStroke((Paint)barBorderColor);
                this.bar.setWidth(0.14286 * this.width);
                this.bar.setLayoutX(0.0);
                this.bar.setLayoutY(0.0);
                this.bar.setTranslateX((this.width - this.bar.getWidth()) * 0.5);
                this.bar.setTranslateY(this.gauge.isStartFromZero() ? this.zeroPosition : this.minValuePosition);
                this.barHighlight.setWidth(this.bar.getWidth());
                this.barHighlight.setLayoutX(0.0);
                this.barHighlight.setLayoutY(0.0);
                this.barHighlight.setTranslateX(this.bar.getTranslateX());
                this.barHighlight.setTranslateY(this.bar.getTranslateY());
                this.setBar(currentValue);
                this.ticksAndSectionsCanvas.setCache(false);
                this.ticksAndSectionsCanvas.setWidth(this.height / this.aspectRatio);
                this.ticksAndSectionsCanvas.setHeight(this.height);
                this.ticksAndSections.clearRect(0.0, 0.0, this.ticksAndSectionsCanvas.getWidth(), this.ticksAndSectionsCanvas.getHeight());
                this.drawTickMarks(this.ticksAndSections);
                this.ticksAndSectionsCanvas.setCache(true);
                this.ticksAndSectionsCanvas.setCacheHint(CacheHint.QUALITY);
                this.ledSize = isFlatLed ? 0.08 * this.width : 0.09 * this.width;
                this.ledCanvas.setWidth(this.ledSize);
                this.ledCanvas.setHeight(this.ledSize);
                this.ledCanvas.relocate((this.width - this.ledSize) * 0.5, 0.12 * this.height);
                this.ledOffShadow = isFlatLed ? null : new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.65), 0.07 * this.ledSize, 0.0, 0.0, 0.0);
                InnerShadow innerShadow = this.ledOnShadow = isFlatLed ? null : new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.65), 0.07 * this.ledSize, 0.0, 0.0, 0.0);
                if (!isFlatLed) {
                    this.ledOnShadow.setInput((Effect)new DropShadow(BlurType.TWO_PASS_BOX, this.gauge.getLedColor(), 0.36 * this.ledSize, 0.0, 0.0, 0.0));
                }
                if (this.gauge.isLcdVisible()) {
                    this.lcd.setWidth(0.8 * this.width);
                    this.lcd.setHeight(0.22 * this.width);
                    this.lcd.setArcWidth(0.0125 * this.size);
                    this.lcd.setArcHeight(0.0125 * this.size);
                    this.lcd.relocate((this.width - this.lcd.getWidth()) * 0.5, 0.87 * this.height);
                }
            } else {
                this.height = this.width / this.aspectRatio;
                this.size = this.width < this.height ? this.width : this.height;
                this.stepSize = Math.abs(0.9 * this.width / this.gauge.getRange());
                this.pane.setMaxSize(this.width, this.height);
                this.pane.relocate((this.gauge.getWidth() - this.width) * 0.5, (this.gauge.getHeight() - this.height) * 0.5);
                this.width = this.pane.getLayoutBounds().getWidth();
                this.height = this.pane.getLayoutBounds().getHeight();
                this.barBackground.setWidth(0.9 * this.width);
                this.barBackground.setHeight(0.14286 * this.height);
                this.barBackground.relocate((this.width - this.barBackground.getWidth()) * 0.5, (this.height - this.barBackground.getHeight()) * 0.5);
                this.barBackground.setStroke(null);
                this.barBackground.setFill((Paint)new LinearGradient(this.barBackground.getLayoutBounds().getMinX(), 0.0, this.barBackground.getLayoutBounds().getMaxX(), 0.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)255, (int)255, (int)255, (double)0.05)), new Stop(0.5, Color.rgb((int)255, (int)255, (int)255, (double)0.15)), new Stop(1.0, Color.rgb((int)255, (int)255, (int)255, (double)0.05))}));
                this.minValuePosition = this.barBackground.getLayoutX();
                this.maxValuePosition = this.barBackground.getLayoutX() + this.barBackground.getLayoutBounds().getWidth();
                this.zeroPosition = this.minValuePosition - this.gauge.getMinValue() * this.stepSize;
                this.barBorder1.setStartX(this.minValuePosition);
                this.barBorder1.setStartY(this.barBackground.getLayoutY() - 1.0);
                this.barBorder1.setEndX(this.maxValuePosition);
                this.barBorder1.setEndY(this.barBackground.getLayoutY() - 1.0);
                this.barBorder2.setStartX(this.minValuePosition);
                this.barBorder2.setStartY(this.barBackground.getLayoutY() + this.barBackground.getLayoutBounds().getHeight() + 1.0);
                this.barBorder2.setEndX(this.maxValuePosition);
                this.barBorder2.setEndY(this.barBackground.getLayoutY() + this.barBackground.getLayoutBounds().getHeight() + 1.0);
                this.barBorder1.setStroke((Paint)barBorderColor);
                this.barBorder2.setStroke((Paint)barBorderColor);
                this.bar.setHeight(0.14286 * this.height);
                this.bar.setLayoutX(0.0);
                this.bar.setLayoutY(0.0);
                this.bar.setTranslateX(this.gauge.isStartFromZero() ? this.zeroPosition : this.minValuePosition);
                this.bar.setTranslateY((this.height - this.bar.getHeight()) * 0.5);
                this.barHighlight.setHeight(this.bar.getHeight());
                this.barHighlight.setLayoutX(0.0);
                this.barHighlight.setLayoutY(0.0);
                this.barHighlight.setTranslateX(this.bar.getTranslateX());
                this.barHighlight.setTranslateY(this.bar.getTranslateY());
                this.setBar(currentValue);
                this.ticksAndSectionsCanvas.setCache(false);
                this.ticksAndSectionsCanvas.setWidth(this.width);
                this.ticksAndSectionsCanvas.setHeight(this.height);
                this.ticksAndSections.clearRect(0.0, 0.0, this.ticksAndSectionsCanvas.getWidth(), this.ticksAndSectionsCanvas.getHeight());
                this.drawTickMarks(this.ticksAndSections);
                this.ticksAndSectionsCanvas.setCache(true);
                this.ticksAndSectionsCanvas.setCacheHint(CacheHint.QUALITY);
                this.ledSize = isFlatLed ? 0.08 * this.height : 0.09 * this.height;
                this.ledCanvas.setWidth(this.ledSize);
                this.ledCanvas.setHeight(this.ledSize);
                this.ledCanvas.relocate(0.955 * this.width, (this.height - this.ledSize) * 0.5);
                this.ledOffShadow = isFlatLed ? null : new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.65), 0.07 * this.ledSize, 0.0, 0.0, 0.0);
                InnerShadow innerShadow = this.ledOnShadow = isFlatLed ? null : new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.65), 0.07 * this.ledSize, 0.0, 0.0, 0.0);
                if (!isFlatLed) {
                    this.ledOnShadow.setInput((Effect)new DropShadow(BlurType.TWO_PASS_BOX, this.gauge.getLedColor(), 0.36 * this.ledSize, 0.0, 0.0, 0.0));
                }
                if (this.gauge.isLcdVisible()) {
                    this.lcd.setWidth(0.3 * this.width);
                    this.lcd.setHeight(0.22 * this.height);
                    this.lcd.setArcWidth(0.0125 * this.size);
                    this.lcd.setArcHeight(0.0125 * this.size);
                    this.lcd.relocate(this.width - this.lcd.getWidth() - 0.03571429 * this.height, 0.03571429 * this.height);
                }
            }
            this.resizeText();
        }
    }

    @Override
    protected void redraw() {
        this.locale = this.gauge.getLocale();
        this.tickLabelFormatString = "%." + Integer.toString(this.gauge.getTickLabelDecimals()) + "f";
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.gauge.getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(Orientation.HORIZONTAL == this.orientation ? this.gauge.getBorderWidth() / this.preferredHeight * this.height : this.gauge.getBorderWidth() / this.preferredWidth * this.width))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.gauge.getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        if (this.gauge.getAreasVisible()) {
            this.setBarColor(this.gauge.getCurrentValue());
        } else {
            this.bar.setFill((Paint)this.gauge.getBarColor());
        }
        if (Orientation.VERTICAL == this.orientation) {
            this.barHighlight.setFill((Paint)new LinearGradient(this.barHighlight.getLayoutX(), 0.0, this.barHighlight.getLayoutX() + this.barHighlight.getWidth(), 0.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)255, (int)255, (int)255, (double)0.65)), new Stop(0.92, Color.TRANSPARENT), new Stop(1.0, Color.rgb((int)0, (int)0, (int)0, (double)0.2))}));
        } else {
            this.barHighlight.setFill((Paint)new LinearGradient(0.0, this.barHighlight.getLayoutY(), 0.0, this.barHighlight.getLayoutY() + this.barHighlight.getHeight(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)255, (int)255, (int)255, (double)0.65)), new Stop(0.92, Color.TRANSPARENT), new Stop(1.0, Color.rgb((int)0, (int)0, (int)0, (double)0.2))}));
        }
        if (this.gauge.isLedVisible()) {
            Color LED_COLOR = this.gauge.getLedColor();
            switch (this.gauge.getLedType()) {
                case FLAT: {
                    this.ledFramePaint = Color.WHITE;
                    this.ledOnPaint = new LinearGradient(0.0, 0.25 * this.ledSize, 0.0, 0.74 * this.ledSize, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, LED_COLOR), new Stop(1.0, LED_COLOR.deriveColor(0.0, 1.0, 0.5, 1.0))});
                    this.ledOffPaint = new LinearGradient(0.0, 0.25 * this.ledSize, 0.0, 0.74 * this.ledSize, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, LED_COLOR.deriveColor(0.0, 1.0, 0.5, 1.0)), new Stop(1.0, LED_COLOR.deriveColor(0.0, 1.0, 0.13, 1.0))});
                    this.ledHighlightPaint = Color.TRANSPARENT;
                    break;
                }
                default: {
                    this.ledFramePaint = new LinearGradient(0.14 * this.ledSize, 0.14 * this.ledSize, 0.84 * this.ledSize, 0.84 * this.ledSize, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)20, (int)20, (int)20, (double)0.65)), new Stop(0.15, Color.rgb((int)20, (int)20, (int)20, (double)0.65)), new Stop(0.26, Color.rgb((int)41, (int)41, (int)41, (double)0.65)), new Stop(0.26, Color.rgb((int)41, (int)41, (int)41, (double)0.64)), new Stop(0.85, Color.rgb((int)200, (int)200, (int)200, (double)0.41)), new Stop(1.0, Color.rgb((int)200, (int)200, (int)200, (double)0.35))});
                    this.ledOnPaint = new LinearGradient(0.25 * this.ledSize, 0.25 * this.ledSize, 0.74 * this.ledSize, 0.74 * this.ledSize, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, LED_COLOR.deriveColor(0.0, 1.0, 0.77, 1.0)), new Stop(0.49, LED_COLOR.deriveColor(0.0, 1.0, 0.5, 1.0)), new Stop(1.0, LED_COLOR)});
                    this.ledOffPaint = new LinearGradient(0.25 * this.ledSize, 0.25 * this.ledSize, 0.74 * this.ledSize, 0.74 * this.ledSize, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, LED_COLOR.deriveColor(0.0, 1.0, 0.2, 1.0)), new Stop(0.49, LED_COLOR.deriveColor(0.0, 1.0, 0.13, 1.0)), new Stop(1.0, LED_COLOR.deriveColor(0.0, 1.0, 0.2, 1.0))});
                    this.ledHighlightPaint = new RadialGradient(0.0, 0.0, 0.3 * this.ledSize, 0.3 * this.ledSize, 0.29 * this.ledSize, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.WHITE), new Stop(1.0, Color.TRANSPARENT)});
                }
            }
            this.drawLed();
        }
        this.ticksAndSectionsCanvas.setCache(false);
        this.ticksAndSections.clearRect(0.0, 0.0, this.ticksAndSectionsCanvas.getWidth(), this.ticksAndSectionsCanvas.getHeight());
        this.drawTickMarks(this.ticksAndSections);
        this.ticksAndSectionsCanvas.setCache(true);
        this.ticksAndSectionsCanvas.setCacheHint(CacheHint.QUALITY);
        LcdDesign lcdDesign = this.gauge.getLcdDesign();
        Color[] lcdColors = lcdDesign.getColors();
        if (this.gauge.isLcdVisible() && this.gauge.isValueVisible()) {
            LinearGradient lcdGradient = new LinearGradient(0.0, 1.0, 0.0, this.lcd.getHeight() - 1.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, lcdColors[0]), new Stop(0.03, lcdColors[1]), new Stop(0.5, lcdColors[2]), new Stop(0.5, lcdColors[3]), new Stop(1.0, lcdColors[4])});
            Object lcdFramePaint = LcdDesign.FLAT_CUSTOM == lcdDesign ? lcdDesign.lcdForegroundColor : new LinearGradient(0.0, 0.0, 0.0, this.lcd.getHeight(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)26, (int)26, (int)26)), new Stop(0.01, Color.rgb((int)77, (int)77, (int)77)), new Stop(0.99, Color.rgb((int)77, (int)77, (int)77)), new Stop(1.0, Color.rgb((int)221, (int)221, (int)221))});
            this.lcd.setFill((Paint)lcdGradient);
            this.lcd.setStroke((Paint)lcdFramePaint);
        }
        this.titleText.setText(this.gauge.getTitle());
        this.titleText.setFill((Paint)this.gauge.getTitleColor());
        this.unitText.setFill((Paint)this.gauge.getUnitColor());
        this.unitText.setText(this.gauge.getUnit());
        this.valueText.setFill((Paint)(this.gauge.isLcdVisible() ? lcdColors[5] : this.gauge.getValueColor()));
        this.resizeText();
    }
}

