/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Clock;
import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.skins.ClockSkinBase;
import eu.hansolo.medusa.tools.Helper;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.Circle;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Text;
import javafx.util.Duration;

public class MinimalClockSkin
extends ClockSkinBase {
    private static final DateTimeFormatter HOUR_FORMATTER = DateTimeFormatter.ofPattern("HH");
    private static final DateTimeFormatter MINUTE_FORMATTER = DateTimeFormatter.ofPattern("mm");
    private DateTimeFormatter dateTextFormatter;
    private double size;
    private Circle secondBackgroundCircle;
    private Text dateText;
    private Text hour;
    private Text minute;
    private Circle minuteCircle;
    private Arc secondArc;
    private Pane pane;
    private DoubleProperty minuteAngle;
    private Timeline timeline;
    private InvalidationListener minuteAngleListener;

    public MinimalClockSkin(final Clock clock) {
        super(clock);
        this.minuteAngle = new DoublePropertyBase(-1.0){

            public Object getBean() {
                return clock;
            }

            public String getName() {
                return "minuteAngle";
            }
        };
        this.timeline = new Timeline();
        this.minuteAngleListener = o -> this.moveMinute(this.minuteAngle.get());
        this.dateTextFormatter = DateTimeFormatter.ofPattern("ccc., dd. MMM.").withLocale(clock.getLocale());
        this.initGraphics();
        this.registerListeners();
    }

    @Override
    protected void initGraphics() {
        if (Double.compare(this.clock.getPrefWidth(), 0.0) <= 0 || Double.compare(this.clock.getPrefHeight(), 0.0) <= 0 || Double.compare(this.clock.getWidth(), 0.0) <= 0 || Double.compare(this.clock.getHeight(), 0.0) <= 0) {
            if (this.clock.getPrefWidth() > 0.0 && this.clock.getPrefHeight() > 0.0) {
                this.clock.setPrefSize(this.clock.getPrefWidth(), this.clock.getPrefHeight());
            } else {
                this.clock.setPrefSize(250.0, 250.0);
            }
        }
        ZonedDateTime time = this.clock.getTime();
        this.secondBackgroundCircle = new Circle(125.0, 125.0, 120.0);
        this.secondBackgroundCircle.setStrokeWidth(2.0);
        this.secondBackgroundCircle.setStrokeType(StrokeType.CENTERED);
        this.secondBackgroundCircle.setStrokeLineCap(StrokeLineCap.ROUND);
        this.secondBackgroundCircle.setFill(null);
        this.secondBackgroundCircle.setStroke((Paint)Helper.getTranslucentColorFrom(this.clock.getSecondColor(), 0.2));
        this.secondBackgroundCircle.setVisible(this.clock.isSecondsVisible());
        this.secondBackgroundCircle.setManaged(this.clock.isSecondsVisible());
        this.dateText = new Text(this.dateTextFormatter.format(time));
        this.dateText.setVisible(this.clock.isDateVisible());
        this.dateText.setManaged(this.clock.isDateVisible());
        this.hour = new Text(HOUR_FORMATTER.format(time));
        this.hour.setFill((Paint)this.clock.getHourColor());
        this.minute = new Text(MINUTE_FORMATTER.format(time));
        this.minute.setFill((Paint)this.clock.getMinuteColor());
        this.minuteCircle = new Circle(18.75);
        this.secondArc = new Arc(125.0, 125.0, 240.0, 120.0, 90.0, (double)(-6 * this.clock.getTime().getSecond()));
        this.secondArc.setStrokeWidth(2.0);
        this.secondArc.setStrokeType(StrokeType.CENTERED);
        this.secondArc.setStrokeLineCap(StrokeLineCap.BUTT);
        this.secondArc.setFill(null);
        this.secondArc.setStroke((Paint)this.clock.getSecondColor());
        this.secondArc.setVisible(this.clock.isSecondsVisible());
        this.secondArc.setManaged(this.clock.isSecondsVisible());
        this.pane = new Pane(new Node[]{this.secondBackgroundCircle, this.dateText, this.hour, this.secondArc, this.minuteCircle, this.minute});
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.clock.getBackgroundPaint(), new CornerRadii(1024.0), new Insets(10.0))}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.minuteAngle.addListener(this.minuteAngleListener);
        this.clock.localeProperty().addListener(o -> {
            DateTimeFormatter dateTimeFormatter = this.dateTextFormatter = DateTimeFormatter.ofPattern("ccc., dd. MMM.").withLocale(this.clock.getLocale());
        });
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            boolean isDateVisible = this.clock.isDateVisible();
            this.dateText.setVisible(isDateVisible);
            this.dateText.setManaged(isDateVisible);
            boolean isSecondsVisible = this.clock.isSecondsVisible();
            this.secondBackgroundCircle.setVisible(isSecondsVisible);
            this.secondBackgroundCircle.setManaged(isSecondsVisible);
            this.secondArc.setVisible(isSecondsVisible);
            this.secondArc.setManaged(isSecondsVisible);
        } else {
            "FINISHED".equals(EVENT_TYPE);
        }
    }

    @Override
    public void dispose() {
        this.minuteAngle.removeListener(this.minuteAngleListener);
        super.dispose();
    }

    @Override
    public void updateTime(ZonedDateTime TIME) {
        if (this.dateText.isVisible()) {
            this.dateText.setText(this.dateTextFormatter.format(TIME));
            Helper.adjustTextSize(this.dateText, 0.6 * this.size, this.size * 0.08);
            this.dateText.relocate((this.size - this.dateText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.22180451);
        }
        this.hour.setText(HOUR_FORMATTER.format(TIME));
        Helper.adjustTextSize(this.hour, 0.6 * this.size, 0.6 * this.size);
        this.hour.relocate((this.size - this.hour.getLayoutBounds().getWidth()) * 0.5, (this.size - this.hour.getLayoutBounds().getHeight()) * 0.65);
        this.minute.setText(MINUTE_FORMATTER.format(TIME));
        Helper.adjustTextSize(this.minute, 0.1 * this.size, 0.075 * this.size);
        if (this.minuteAngle.get() == -1.0) {
            this.moveMinute(6 * TIME.getMinute());
        }
        KeyValue kv1 = new KeyValue((WritableValue)this.minuteAngle, (Object)this.minuteAngle.get());
        KeyValue kv2 = new KeyValue((WritableValue)this.minuteAngle, (Object)(6 * TIME.getMinute()));
        KeyFrame kf1 = new KeyFrame(Duration.ZERO, new KeyValue[]{kv1});
        KeyFrame kf2 = new KeyFrame(Duration.millis((double)100.0), new KeyValue[]{kv2});
        this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{kf1, kf2});
        this.timeline.play();
        if (this.secondBackgroundCircle.isVisible()) {
            this.secondArc.setLength((double)(-6 * TIME.getSecond()));
            if (this.clock.isDiscreteSeconds()) {
                this.secondArc.setLength((double)(-6 * TIME.getSecond()));
            } else {
                this.secondArc.setLength((double)(-6 * TIME.getSecond()) - (double)TIME.get(ChronoField.MILLI_OF_SECOND) * 0.006);
            }
        }
    }

    @Override
    public void updateAlarms() {
    }

    private void moveMinute(double ANGLE) {
        double center = this.size * 0.5;
        double sinValue = Math.sin(Math.toRadians(-ANGLE + 180.0));
        double cosValue = Math.cos(Math.toRadians(-ANGLE + 180.0));
        this.minuteCircle.setCenterX(center + this.size * 0.45 * sinValue);
        this.minuteCircle.setCenterY(center + this.size * 0.45 * cosValue);
        this.minute.relocate(this.minuteCircle.getCenterX() - this.minute.getLayoutBounds().getWidth() * 0.5, this.minuteCircle.getCenterY() - this.minute.getLayoutBounds().getHeight() * 0.5);
    }

    @Override
    protected void resize() {
        double height;
        double width = this.clock.getWidth() - this.clock.getInsets().getLeft() - this.clock.getInsets().getRight();
        double d = this.size = width < (height = this.clock.getHeight() - this.clock.getInsets().getTop() - this.clock.getInsets().getBottom()) ? width : height;
        if (this.size > 0.0) {
            double center = this.size * 0.5;
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((this.clock.getWidth() - this.size) * 0.5, (this.clock.getHeight() - this.size) * 0.5);
            this.secondBackgroundCircle.setCenterX(center);
            this.secondBackgroundCircle.setCenterY(center);
            this.secondBackgroundCircle.setRadius(this.size * 0.45);
            this.secondBackgroundCircle.setStrokeWidth(this.size * 0.02819549);
            this.secondArc.setCenterX(center);
            this.secondArc.setCenterY(center);
            this.secondArc.setRadiusX(this.size * 0.45);
            this.secondArc.setRadiusY(this.size * 0.45);
            this.secondArc.setStrokeWidth(this.size * 0.02819549);
            this.dateText.setFont(Fonts.robotoLight(this.size * 0.08082707));
            this.hour.setFont(Fonts.robotoThin(this.size * 0.6));
            this.minute.setFont(Fonts.robotoRegular(this.size * 0.075));
            this.minuteCircle.setRadius(this.size * 0.075);
            this.moveMinute(6 * this.clock.getTime().getMinute());
        }
    }

    @Override
    protected void redraw() {
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.clock.getBackgroundPaint(), new CornerRadii(1024.0), new Insets(this.size * 0.035))}));
        this.secondBackgroundCircle.setStroke((Paint)Helper.getTranslucentColorFrom(this.clock.getSecondColor(), 0.6));
        this.secondArc.setStroke((Paint)this.clock.getSecondColor());
        this.dateText.setFill((Paint)this.clock.getTextColor());
        this.hour.setFill((Paint)this.clock.getTextColor());
        this.minuteCircle.setFill((Paint)this.clock.getMinuteColor());
        this.minute.setFill((Paint)this.clock.getTextColor());
        ZonedDateTime time = this.clock.getTime();
        this.updateTime(time);
    }
}

