/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Clock;
import eu.hansolo.medusa.skins.ClockSkinBase;
import eu.hansolo.medusa.tools.Helper;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import javafx.animation.AnimationTimer;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;

public class MorphingClockSkin
extends ClockSkinBase {
    protected static final double PREFERRED_WIDTH = 415.0;
    protected static final double PREFERRED_HEIGHT = 110.0;
    protected static final double MINIMUM_WIDTH = 50.0;
    protected static final double MINIMUM_HEIGHT = 20.0;
    protected static final double MAXIMUM_WIDTH = 4096.0;
    protected static final double MAXIMUM_HEIGHT = 4096.0;
    private static final DateTimeFormatter HHMMSS_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
    private static final DateTimeFormatter AMPM_HHMMSS_FORMATTER = DateTimeFormatter.ofPattern("hh:mm:ss");
    private static final long INTERVAL = 40000000L;
    private double aspectRatio = 0.26506024;
    private double width;
    private double height;
    private Pane pane;
    private Canvas canvas;
    private GraphicsContext ctx;
    private double dotSize;
    private double spacer;
    private double digitSpacer;
    private double digitWidth;
    private double digitHeight;
    private Color hourColor;
    private Color hourOffColor;
    private Color minuteColor;
    private Color minuteOffColor;
    private Color secondColor;
    private Color secondOffColor;
    private RadialGradient hourGradient;
    private RadialGradient hourOffGradient;
    private RadialGradient minuteGradient;
    private RadialGradient minuteOffGradient;
    private RadialGradient secondGradient;
    private RadialGradient secondOffGradient;
    private int[][] hl;
    private int[][] hr;
    private int[][] ml;
    private int[][] mr;
    private int[][] sl;
    private int[][] sr;
    private int oldHourLeft;
    private int oldHourRight;
    private int oldMinLeft;
    private int oldMinRight;
    private int oldSecLeft;
    private int oldSecRight;
    private int hourLeft;
    private int hourRight;
    private int minLeft;
    private int minRight;
    private int secLeft;
    private int secRight;
    private int step;
    private long lastTimerCall;
    private AnimationTimer timer;

    public MorphingClockSkin(Clock clock) {
        super(clock);
        this.hourColor = clock.getHourColor();
        this.hourOffColor = Helper.getTranslucentColorFrom(this.hourColor, 0.15);
        this.minuteColor = clock.getMinuteColor();
        this.minuteOffColor = Helper.getTranslucentColorFrom(this.minuteColor, 0.15);
        this.secondColor = clock.getSecondColor();
        this.secondOffColor = Helper.getTranslucentColorFrom(this.secondColor, 0.15);
        this.hl = new int[15][8];
        this.hr = new int[15][8];
        this.ml = new int[15][8];
        this.mr = new int[15][8];
        this.sl = new int[15][8];
        this.sr = new int[15][8];
        this.hourLeft = 0;
        this.hourRight = 0;
        this.minLeft = 0;
        this.minRight = 0;
        this.secLeft = 0;
        this.secRight = 0;
        this.step = 0;
        this.lastTimerCall = System.nanoTime();
        this.timer = new AnimationTimer(){

            public void handle(long now) {
                if (now > MorphingClockSkin.this.lastTimerCall + 40000000L) {
                    if (MorphingClockSkin.this.hourLeft != MorphingClockSkin.this.oldHourLeft) {
                        MorphingClockSkin.this.hl = MorphingClockSkin.this.animateArray(MorphingClockSkin.this.hourLeft, MorphingClockSkin.this.step);
                    }
                    if (MorphingClockSkin.this.hourRight != MorphingClockSkin.this.oldHourRight) {
                        MorphingClockSkin.this.hr = MorphingClockSkin.this.animateArray(MorphingClockSkin.this.hourRight, MorphingClockSkin.this.step);
                    }
                    if (MorphingClockSkin.this.minLeft != MorphingClockSkin.this.oldMinLeft) {
                        MorphingClockSkin.this.ml = MorphingClockSkin.this.animateArray(MorphingClockSkin.this.minLeft, MorphingClockSkin.this.step);
                    }
                    if (MorphingClockSkin.this.minRight != MorphingClockSkin.this.oldMinRight) {
                        MorphingClockSkin.this.mr = MorphingClockSkin.this.animateArray(MorphingClockSkin.this.minRight, MorphingClockSkin.this.step);
                    }
                    if (MorphingClockSkin.this.secLeft != MorphingClockSkin.this.oldSecLeft) {
                        MorphingClockSkin.this.sl = MorphingClockSkin.this.animateArray(MorphingClockSkin.this.secLeft, MorphingClockSkin.this.step);
                    }
                    if (MorphingClockSkin.this.secRight != MorphingClockSkin.this.oldSecRight) {
                        MorphingClockSkin.this.sr = MorphingClockSkin.this.animateArray(MorphingClockSkin.this.secRight, MorphingClockSkin.this.step);
                    }
                    MorphingClockSkin.this.drawTime();
                    ++MorphingClockSkin.this.step;
                    if (MorphingClockSkin.this.step > 7) {
                        MorphingClockSkin.this.step = 0;
                        MorphingClockSkin.this.updateArrays();
                        this.stop();
                    }
                    MorphingClockSkin.this.lastTimerCall = now;
                }
            }
        };
        this.initGraphics();
        this.registerListeners();
        this.timer.start();
    }

    @Override
    protected void initGraphics() {
        if (Double.compare(this.clock.getPrefWidth(), 0.0) <= 0 || Double.compare(this.clock.getPrefHeight(), 0.0) <= 0 || Double.compare(this.clock.getWidth(), 0.0) <= 0 || Double.compare(this.clock.getHeight(), 0.0) <= 0) {
            if (this.clock.getPrefWidth() > 0.0 && this.clock.getPrefHeight() > 0.0) {
                this.clock.setPrefSize(this.clock.getPrefWidth(), this.clock.getPrefHeight());
            } else {
                this.clock.setPrefSize(415.0, 110.0);
            }
        }
        this.canvas = new Canvas(415.0, 110.0);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.ctx.setLineWidth(1.0);
        this.ctx.setStroke(null);
        this.pane = new Pane(new Node[]{this.canvas});
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.clock.getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(this.clock.getBorderWidth()))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.clock.getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if (!"VISIBILITY".equals(EVENT_TYPE) && "SECTION".equals(EVENT_TYPE)) {
            this.redraw();
        }
    }

    private void drawTime() {
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        this.drawMatrix(0.0, 0.0, this.hl, (Paint)this.hourGradient, (Paint)this.hourOffGradient);
        this.drawMatrix(this.digitWidth + this.digitSpacer, 0.0, this.hr, (Paint)this.hourGradient, (Paint)this.hourOffGradient);
        this.drawMatrix(2.0 * this.digitWidth + 3.0 * this.digitSpacer, 0.0, this.ml, (Paint)this.minuteGradient, (Paint)this.minuteOffGradient);
        this.drawMatrix(3.0 * this.digitWidth + 4.0 * this.digitSpacer, 0.0, this.mr, (Paint)this.minuteGradient, (Paint)this.minuteOffGradient);
        this.drawMatrix(4.0 * this.digitWidth + 6.0 * this.digitSpacer, 0.0, this.sl, (Paint)this.secondGradient, (Paint)this.secondOffGradient);
        this.drawMatrix(5.0 * this.digitWidth + 7.0 * this.digitSpacer, 0.0, this.sr, (Paint)this.secondGradient, (Paint)this.secondOffGradient);
    }

    private void drawMatrix(double X, double Y, int[][] MATRIX, Paint ON_PAINT, Paint OFF_PAINT) {
        double y = Y;
        int row = 0;
        while (row < 15) {
            double x = X;
            int col = 0;
            while (col < 8) {
                boolean fill = MATRIX[row][col] == 1;
                this.ctx.setFill(fill ? ON_PAINT : OFF_PAINT);
                this.ctx.fillOval(x, y, this.dotSize, this.dotSize);
                x = X + (double)(col + 1) * (this.dotSize + this.spacer);
                ++col;
            }
            y = Y + (double)(row + 1) * (this.dotSize + this.spacer);
            ++row;
        }
    }

    private void updateArrays() {
        this.hl = this.updateArray(this.hourLeft);
        this.hr = this.updateArray(this.hourRight);
        this.ml = this.updateArray(this.minLeft);
        this.mr = this.updateArray(this.minRight);
        this.sl = this.updateArray(this.secLeft);
        this.sr = this.updateArray(this.secRight);
    }

    private int[][] updateArray(int DIGIT) {
        return switch (DIGIT) {
            case 0 -> {
                int[][] v0 = new int[15][];
                int[] v1 = new int[8];
                v1[1] = 1;
                v1[2] = 1;
                v1[3] = 1;
                v1[4] = 1;
                v1[5] = 1;
                v1[6] = 1;
                v0[0] = v1;
                int[] v2 = new int[8];
                v2[0] = 1;
                v2[7] = 1;
                v0[1] = v2;
                int[] v3 = new int[8];
                v3[0] = 1;
                v3[7] = 1;
                v0[2] = v3;
                int[] v4 = new int[8];
                v4[0] = 1;
                v4[7] = 1;
                v0[3] = v4;
                int[] v5 = new int[8];
                v5[0] = 1;
                v5[7] = 1;
                v0[4] = v5;
                int[] v6 = new int[8];
                v6[0] = 1;
                v6[7] = 1;
                v0[5] = v6;
                int[] v7 = new int[8];
                v7[0] = 1;
                v7[7] = 1;
                v0[6] = v7;
                v0[7] = new int[8];
                int[] v8 = new int[8];
                v8[0] = 1;
                v8[7] = 1;
                v0[8] = v8;
                int[] v9 = new int[8];
                v9[0] = 1;
                v9[7] = 1;
                v0[9] = v9;
                int[] v10 = new int[8];
                v10[0] = 1;
                v10[7] = 1;
                v0[10] = v10;
                int[] v11 = new int[8];
                v11[0] = 1;
                v11[7] = 1;
                v0[11] = v11;
                int[] v12 = new int[8];
                v12[0] = 1;
                v12[7] = 1;
                v0[12] = v12;
                int[] v13 = new int[8];
                v13[0] = 1;
                v13[7] = 1;
                v0[13] = v13;
                int[] v14 = new int[8];
                v14[1] = 1;
                v14[2] = 1;
                v14[3] = 1;
                v14[4] = 1;
                v14[5] = 1;
                v14[6] = 1;
                v0[14] = v14;
                yield v0;
            }
            case 1 -> {
                int[][] v15 = new int[15][];
                v15[0] = new int[8];
                int[] v16 = new int[8];
                v16[7] = 1;
                v15[1] = v16;
                int[] v17 = new int[8];
                v17[7] = 1;
                v15[2] = v17;
                int[] v18 = new int[8];
                v18[7] = 1;
                v15[3] = v18;
                int[] v19 = new int[8];
                v19[7] = 1;
                v15[4] = v19;
                int[] v20 = new int[8];
                v20[7] = 1;
                v15[5] = v20;
                int[] v21 = new int[8];
                v21[7] = 1;
                v15[6] = v21;
                v15[7] = new int[8];
                int[] v22 = new int[8];
                v22[7] = 1;
                v15[8] = v22;
                int[] v23 = new int[8];
                v23[7] = 1;
                v15[9] = v23;
                int[] v24 = new int[8];
                v24[7] = 1;
                v15[10] = v24;
                int[] v25 = new int[8];
                v25[7] = 1;
                v15[11] = v25;
                int[] v26 = new int[8];
                v26[7] = 1;
                v15[12] = v26;
                int[] v27 = new int[8];
                v27[7] = 1;
                v15[13] = v27;
                v15[14] = new int[8];
                yield v15;
            }
            case 2 -> {
                int[][] v28 = new int[15][];
                int[] v29 = new int[8];
                v29[1] = 1;
                v29[2] = 1;
                v29[3] = 1;
                v29[4] = 1;
                v29[5] = 1;
                v29[6] = 1;
                v28[0] = v29;
                int[] v30 = new int[8];
                v30[7] = 1;
                v28[1] = v30;
                int[] v31 = new int[8];
                v31[7] = 1;
                v28[2] = v31;
                int[] v32 = new int[8];
                v32[7] = 1;
                v28[3] = v32;
                int[] v33 = new int[8];
                v33[7] = 1;
                v28[4] = v33;
                int[] v34 = new int[8];
                v34[7] = 1;
                v28[5] = v34;
                int[] v35 = new int[8];
                v35[7] = 1;
                v28[6] = v35;
                int[] v36 = new int[8];
                v36[1] = 1;
                v36[2] = 1;
                v36[3] = 1;
                v36[4] = 1;
                v36[5] = 1;
                v36[6] = 1;
                v28[7] = v36;
                int[] v37 = new int[8];
                v37[0] = 1;
                v28[8] = v37;
                int[] v38 = new int[8];
                v38[0] = 1;
                v28[9] = v38;
                int[] v39 = new int[8];
                v39[0] = 1;
                v28[10] = v39;
                int[] v40 = new int[8];
                v40[0] = 1;
                v28[11] = v40;
                int[] v41 = new int[8];
                v41[0] = 1;
                v28[12] = v41;
                int[] v42 = new int[8];
                v42[0] = 1;
                v28[13] = v42;
                int[] v43 = new int[8];
                v43[1] = 1;
                v43[2] = 1;
                v43[3] = 1;
                v43[4] = 1;
                v43[5] = 1;
                v43[6] = 1;
                v28[14] = v43;
                yield v28;
            }
            case 3 -> {
                int[][] v44 = new int[15][];
                int[] v45 = new int[8];
                v45[1] = 1;
                v45[2] = 1;
                v45[3] = 1;
                v45[4] = 1;
                v45[5] = 1;
                v45[6] = 1;
                v44[0] = v45;
                int[] v46 = new int[8];
                v46[7] = 1;
                v44[1] = v46;
                int[] v47 = new int[8];
                v47[7] = 1;
                v44[2] = v47;
                int[] v48 = new int[8];
                v48[7] = 1;
                v44[3] = v48;
                int[] v49 = new int[8];
                v49[7] = 1;
                v44[4] = v49;
                int[] v50 = new int[8];
                v50[7] = 1;
                v44[5] = v50;
                int[] v51 = new int[8];
                v51[7] = 1;
                v44[6] = v51;
                int[] v52 = new int[8];
                v52[1] = 1;
                v52[2] = 1;
                v52[3] = 1;
                v52[4] = 1;
                v52[5] = 1;
                v52[6] = 1;
                v44[7] = v52;
                int[] v53 = new int[8];
                v53[7] = 1;
                v44[8] = v53;
                int[] v54 = new int[8];
                v54[7] = 1;
                v44[9] = v54;
                int[] v55 = new int[8];
                v55[7] = 1;
                v44[10] = v55;
                int[] v56 = new int[8];
                v56[7] = 1;
                v44[11] = v56;
                int[] v57 = new int[8];
                v57[7] = 1;
                v44[12] = v57;
                int[] v58 = new int[8];
                v58[7] = 1;
                v44[13] = v58;
                int[] v59 = new int[8];
                v59[1] = 1;
                v59[2] = 1;
                v59[3] = 1;
                v59[4] = 1;
                v59[5] = 1;
                v59[6] = 1;
                v44[14] = v59;
                yield v44;
            }
            case 4 -> {
                int[][] v60 = new int[15][];
                v60[0] = new int[8];
                int[] v61 = new int[8];
                v61[0] = 1;
                v61[7] = 1;
                v60[1] = v61;
                int[] v62 = new int[8];
                v62[0] = 1;
                v62[7] = 1;
                v60[2] = v62;
                int[] v63 = new int[8];
                v63[0] = 1;
                v63[7] = 1;
                v60[3] = v63;
                int[] v64 = new int[8];
                v64[0] = 1;
                v64[7] = 1;
                v60[4] = v64;
                int[] v65 = new int[8];
                v65[0] = 1;
                v65[7] = 1;
                v60[5] = v65;
                int[] v66 = new int[8];
                v66[0] = 1;
                v66[7] = 1;
                v60[6] = v66;
                int[] v67 = new int[8];
                v67[1] = 1;
                v67[2] = 1;
                v67[3] = 1;
                v67[4] = 1;
                v67[5] = 1;
                v67[6] = 1;
                v60[7] = v67;
                int[] v68 = new int[8];
                v68[7] = 1;
                v60[8] = v68;
                int[] v69 = new int[8];
                v69[7] = 1;
                v60[9] = v69;
                int[] v70 = new int[8];
                v70[7] = 1;
                v60[10] = v70;
                int[] v71 = new int[8];
                v71[7] = 1;
                v60[11] = v71;
                int[] v72 = new int[8];
                v72[7] = 1;
                v60[12] = v72;
                int[] v73 = new int[8];
                v73[7] = 1;
                v60[13] = v73;
                v60[14] = new int[8];
                yield v60;
            }
            case 5 -> {
                int[][] v74 = new int[15][];
                int[] v75 = new int[8];
                v75[1] = 1;
                v75[2] = 1;
                v75[3] = 1;
                v75[4] = 1;
                v75[5] = 1;
                v75[6] = 1;
                v74[0] = v75;
                int[] v76 = new int[8];
                v76[0] = 1;
                v74[1] = v76;
                int[] v77 = new int[8];
                v77[0] = 1;
                v74[2] = v77;
                int[] v78 = new int[8];
                v78[0] = 1;
                v74[3] = v78;
                int[] v79 = new int[8];
                v79[0] = 1;
                v74[4] = v79;
                int[] v80 = new int[8];
                v80[0] = 1;
                v74[5] = v80;
                int[] v81 = new int[8];
                v81[0] = 1;
                v74[6] = v81;
                int[] v82 = new int[8];
                v82[1] = 1;
                v82[2] = 1;
                v82[3] = 1;
                v82[4] = 1;
                v82[5] = 1;
                v82[6] = 1;
                v74[7] = v82;
                int[] v83 = new int[8];
                v83[7] = 1;
                v74[8] = v83;
                int[] v84 = new int[8];
                v84[7] = 1;
                v74[9] = v84;
                int[] v85 = new int[8];
                v85[7] = 1;
                v74[10] = v85;
                int[] v86 = new int[8];
                v86[7] = 1;
                v74[11] = v86;
                int[] v87 = new int[8];
                v87[7] = 1;
                v74[12] = v87;
                int[] v88 = new int[8];
                v88[7] = 1;
                v74[13] = v88;
                int[] v89 = new int[8];
                v89[1] = 1;
                v89[2] = 1;
                v89[3] = 1;
                v89[4] = 1;
                v89[5] = 1;
                v89[6] = 1;
                v74[14] = v89;
                yield v74;
            }
            case 6 -> {
                int[][] v90 = new int[15][];
                int[] v91 = new int[8];
                v91[1] = 1;
                v91[2] = 1;
                v91[3] = 1;
                v91[4] = 1;
                v91[5] = 1;
                v91[6] = 1;
                v90[0] = v91;
                int[] v92 = new int[8];
                v92[0] = 1;
                v90[1] = v92;
                int[] v93 = new int[8];
                v93[0] = 1;
                v90[2] = v93;
                int[] v94 = new int[8];
                v94[0] = 1;
                v90[3] = v94;
                int[] v95 = new int[8];
                v95[0] = 1;
                v90[4] = v95;
                int[] v96 = new int[8];
                v96[0] = 1;
                v90[5] = v96;
                int[] v97 = new int[8];
                v97[0] = 1;
                v90[6] = v97;
                int[] v98 = new int[8];
                v98[1] = 1;
                v98[2] = 1;
                v98[3] = 1;
                v98[4] = 1;
                v98[5] = 1;
                v98[6] = 1;
                v90[7] = v98;
                int[] v99 = new int[8];
                v99[0] = 1;
                v99[7] = 1;
                v90[8] = v99;
                int[] v100 = new int[8];
                v100[0] = 1;
                v100[7] = 1;
                v90[9] = v100;
                int[] v101 = new int[8];
                v101[0] = 1;
                v101[7] = 1;
                v90[10] = v101;
                int[] v102 = new int[8];
                v102[0] = 1;
                v102[7] = 1;
                v90[11] = v102;
                int[] v103 = new int[8];
                v103[0] = 1;
                v103[7] = 1;
                v90[12] = v103;
                int[] v104 = new int[8];
                v104[0] = 1;
                v104[7] = 1;
                v90[13] = v104;
                int[] v105 = new int[8];
                v105[1] = 1;
                v105[2] = 1;
                v105[3] = 1;
                v105[4] = 1;
                v105[5] = 1;
                v105[6] = 1;
                v90[14] = v105;
                yield v90;
            }
            case 7 -> {
                int[][] v106 = new int[15][];
                int[] v107 = new int[8];
                v107[1] = 1;
                v107[2] = 1;
                v107[3] = 1;
                v107[4] = 1;
                v107[5] = 1;
                v107[6] = 1;
                v106[0] = v107;
                int[] v108 = new int[8];
                v108[7] = 1;
                v106[1] = v108;
                int[] v109 = new int[8];
                v109[7] = 1;
                v106[2] = v109;
                int[] v110 = new int[8];
                v110[7] = 1;
                v106[3] = v110;
                int[] v111 = new int[8];
                v111[7] = 1;
                v106[4] = v111;
                int[] v112 = new int[8];
                v112[7] = 1;
                v106[5] = v112;
                int[] v113 = new int[8];
                v113[7] = 1;
                v106[6] = v113;
                v106[7] = new int[8];
                int[] v114 = new int[8];
                v114[7] = 1;
                v106[8] = v114;
                int[] v115 = new int[8];
                v115[7] = 1;
                v106[9] = v115;
                int[] v116 = new int[8];
                v116[7] = 1;
                v106[10] = v116;
                int[] v117 = new int[8];
                v117[7] = 1;
                v106[11] = v117;
                int[] v118 = new int[8];
                v118[7] = 1;
                v106[12] = v118;
                int[] v119 = new int[8];
                v119[7] = 1;
                v106[13] = v119;
                v106[14] = new int[8];
                yield v106;
            }
            case 8 -> {
                int[][] v120 = new int[15][];
                int[] v121 = new int[8];
                v121[1] = 1;
                v121[2] = 1;
                v121[3] = 1;
                v121[4] = 1;
                v121[5] = 1;
                v121[6] = 1;
                v120[0] = v121;
                int[] v122 = new int[8];
                v122[0] = 1;
                v122[7] = 1;
                v120[1] = v122;
                int[] v123 = new int[8];
                v123[0] = 1;
                v123[7] = 1;
                v120[2] = v123;
                int[] v124 = new int[8];
                v124[0] = 1;
                v124[7] = 1;
                v120[3] = v124;
                int[] v125 = new int[8];
                v125[0] = 1;
                v125[7] = 1;
                v120[4] = v125;
                int[] v126 = new int[8];
                v126[0] = 1;
                v126[7] = 1;
                v120[5] = v126;
                int[] v127 = new int[8];
                v127[0] = 1;
                v127[7] = 1;
                v120[6] = v127;
                int[] v128 = new int[8];
                v128[1] = 1;
                v128[2] = 1;
                v128[3] = 1;
                v128[4] = 1;
                v128[5] = 1;
                v128[6] = 1;
                v120[7] = v128;
                int[] v129 = new int[8];
                v129[0] = 1;
                v129[7] = 1;
                v120[8] = v129;
                int[] v130 = new int[8];
                v130[0] = 1;
                v130[7] = 1;
                v120[9] = v130;
                int[] v131 = new int[8];
                v131[0] = 1;
                v131[7] = 1;
                v120[10] = v131;
                int[] v132 = new int[8];
                v132[0] = 1;
                v132[7] = 1;
                v120[11] = v132;
                int[] v133 = new int[8];
                v133[0] = 1;
                v133[7] = 1;
                v120[12] = v133;
                int[] v134 = new int[8];
                v134[0] = 1;
                v134[7] = 1;
                v120[13] = v134;
                int[] v135 = new int[8];
                v135[1] = 1;
                v135[2] = 1;
                v135[3] = 1;
                v135[4] = 1;
                v135[5] = 1;
                v135[6] = 1;
                v120[14] = v135;
                yield v120;
            }
            case 9 -> {
                int[][] v136 = new int[15][];
                int[] v137 = new int[8];
                v137[1] = 1;
                v137[2] = 1;
                v137[3] = 1;
                v137[4] = 1;
                v137[5] = 1;
                v137[6] = 1;
                v136[0] = v137;
                int[] v138 = new int[8];
                v138[0] = 1;
                v138[7] = 1;
                v136[1] = v138;
                int[] v139 = new int[8];
                v139[0] = 1;
                v139[7] = 1;
                v136[2] = v139;
                int[] v140 = new int[8];
                v140[0] = 1;
                v140[7] = 1;
                v136[3] = v140;
                int[] v141 = new int[8];
                v141[0] = 1;
                v141[7] = 1;
                v136[4] = v141;
                int[] v142 = new int[8];
                v142[0] = 1;
                v142[7] = 1;
                v136[5] = v142;
                int[] v143 = new int[8];
                v143[0] = 1;
                v143[7] = 1;
                v136[6] = v143;
                int[] v144 = new int[8];
                v144[1] = 1;
                v144[2] = 1;
                v144[3] = 1;
                v144[4] = 1;
                v144[5] = 1;
                v144[6] = 1;
                v136[7] = v144;
                int[] v145 = new int[8];
                v145[7] = 1;
                v136[8] = v145;
                int[] v146 = new int[8];
                v146[7] = 1;
                v136[9] = v146;
                int[] v147 = new int[8];
                v147[7] = 1;
                v136[10] = v147;
                int[] v148 = new int[8];
                v148[7] = 1;
                v136[11] = v148;
                int[] v149 = new int[8];
                v149[7] = 1;
                v136[12] = v149;
                int[] v150 = new int[8];
                v150[7] = 1;
                v136[13] = v150;
                int[] v151 = new int[8];
                v151[1] = 1;
                v151[2] = 1;
                v151[3] = 1;
                v151[4] = 1;
                v151[5] = 1;
                v151[6] = 1;
                v136[14] = v151;
                yield v136;
            }
            default -> new int[][]{new int[8], new int[8], new int[8], new int[8], new int[8], new int[8], new int[8], new int[8], new int[8], new int[8], new int[8], new int[8], new int[8], new int[8], new int[8]};
        };
    }

    private int[][] animateArray(int DIGIT, int STEP) {
        switch (DIGIT) {
            case 0: {
                return this.toZero(STEP);
            }
            case 1: {
                return this.toOne(STEP);
            }
            case 2: {
                return this.toTwo(STEP);
            }
            case 3: {
                return this.toThree(STEP);
            }
            case 4: {
                return this.toFour(STEP);
            }
            case 5: {
                return this.toFive(STEP);
            }
            case 6: {
                return this.toSix(STEP);
            }
            case 7: {
                return this.toSeven(STEP);
            }
            case 8: {
                return this.toEight(STEP);
            }
            case 9: {
                return this.toNine(STEP);
            }
        }
        return new int[][]{new int[8], new int[8], new int[8], new int[8], new int[8], new int[8], new int[8], new int[8], new int[8], new int[8], new int[8], new int[8], new int[8], new int[8], new int[8]};
    }

    private int[][] toZero(int STEP) {
        return switch (STEP) {
            case 0 -> {
                int[][] v0 = new int[15][];
                int[] v1 = new int[8];
                v1[1] = 1;
                v1[2] = 1;
                v1[3] = 1;
                v1[4] = 1;
                v1[5] = 1;
                v1[6] = 1;
                v0[0] = v1;
                int[] v2 = new int[8];
                v2[0] = 1;
                v2[7] = 1;
                v0[1] = v2;
                int[] v3 = new int[8];
                v3[0] = 1;
                v3[7] = 1;
                v0[2] = v3;
                int[] v4 = new int[8];
                v4[0] = 1;
                v4[7] = 1;
                v0[3] = v4;
                int[] v5 = new int[8];
                v5[0] = 1;
                v5[7] = 1;
                v0[4] = v5;
                int[] v6 = new int[8];
                v6[0] = 1;
                v6[7] = 1;
                v0[5] = v6;
                int[] v7 = new int[8];
                v7[0] = 1;
                v7[7] = 1;
                v0[6] = v7;
                int[] v8 = new int[8];
                v8[1] = 1;
                v8[2] = 1;
                v8[3] = 1;
                v8[4] = 1;
                v8[5] = 1;
                v8[6] = 1;
                v0[7] = v8;
                int[] v9 = new int[8];
                v9[7] = 1;
                v0[8] = v9;
                int[] v10 = new int[8];
                v10[7] = 1;
                v0[9] = v10;
                int[] v11 = new int[8];
                v11[7] = 1;
                v0[10] = v11;
                int[] v12 = new int[8];
                v12[7] = 1;
                v0[11] = v12;
                int[] v13 = new int[8];
                v13[7] = 1;
                v0[12] = v13;
                int[] v14 = new int[8];
                v14[7] = 1;
                v0[13] = v14;
                int[] v15 = new int[8];
                v15[1] = 1;
                v15[2] = 1;
                v15[3] = 1;
                v15[4] = 1;
                v15[5] = 1;
                v15[6] = 1;
                v0[14] = v15;
                yield v0;
            }
            case 1 -> {
                int[][] v16 = new int[15][];
                int[] v17 = new int[8];
                v17[1] = 1;
                v17[2] = 1;
                v17[3] = 1;
                v17[4] = 1;
                v17[5] = 1;
                v17[6] = 1;
                v16[0] = v17;
                int[] v18 = new int[8];
                v18[0] = 1;
                v18[7] = 1;
                v16[1] = v18;
                int[] v19 = new int[8];
                v19[0] = 1;
                v19[7] = 1;
                v16[2] = v19;
                int[] v20 = new int[8];
                v20[0] = 1;
                v20[7] = 1;
                v16[3] = v20;
                int[] v21 = new int[8];
                v21[0] = 1;
                v21[7] = 1;
                v16[4] = v21;
                int[] v22 = new int[8];
                v22[0] = 1;
                v22[7] = 1;
                v16[5] = v22;
                int[] v23 = new int[8];
                v23[0] = 1;
                v23[7] = 1;
                v16[6] = v23;
                int[] v24 = new int[8];
                v24[1] = 1;
                v24[2] = 1;
                v24[3] = 1;
                v24[4] = 1;
                v24[5] = 1;
                v16[7] = v24;
                int[] v25 = new int[8];
                v25[0] = 1;
                v25[7] = 1;
                v16[8] = v25;
                int[] v26 = new int[8];
                v26[7] = 1;
                v16[9] = v26;
                int[] v27 = new int[8];
                v27[7] = 1;
                v16[10] = v27;
                int[] v28 = new int[8];
                v28[7] = 1;
                v16[11] = v28;
                int[] v29 = new int[8];
                v29[7] = 1;
                v16[12] = v29;
                int[] v30 = new int[8];
                v30[7] = 1;
                v16[13] = v30;
                int[] v31 = new int[8];
                v31[1] = 1;
                v31[2] = 1;
                v31[3] = 1;
                v31[4] = 1;
                v31[5] = 1;
                v31[6] = 1;
                v16[14] = v31;
                yield v16;
            }
            case 2 -> {
                int[][] v32 = new int[15][];
                int[] v33 = new int[8];
                v33[1] = 1;
                v33[2] = 1;
                v33[3] = 1;
                v33[4] = 1;
                v33[5] = 1;
                v33[6] = 1;
                v32[0] = v33;
                int[] v34 = new int[8];
                v34[0] = 1;
                v34[7] = 1;
                v32[1] = v34;
                int[] v35 = new int[8];
                v35[0] = 1;
                v35[7] = 1;
                v32[2] = v35;
                int[] v36 = new int[8];
                v36[0] = 1;
                v36[7] = 1;
                v32[3] = v36;
                int[] v37 = new int[8];
                v37[0] = 1;
                v37[7] = 1;
                v32[4] = v37;
                int[] v38 = new int[8];
                v38[0] = 1;
                v38[7] = 1;
                v32[5] = v38;
                int[] v39 = new int[8];
                v39[0] = 1;
                v39[7] = 1;
                v32[6] = v39;
                int[] v40 = new int[8];
                v40[1] = 1;
                v40[2] = 1;
                v40[3] = 1;
                v40[4] = 1;
                v32[7] = v40;
                int[] v41 = new int[8];
                v41[0] = 1;
                v41[7] = 1;
                v32[8] = v41;
                int[] v42 = new int[8];
                v42[0] = 1;
                v42[7] = 1;
                v32[9] = v42;
                int[] v43 = new int[8];
                v43[7] = 1;
                v32[10] = v43;
                int[] v44 = new int[8];
                v44[7] = 1;
                v32[11] = v44;
                int[] v45 = new int[8];
                v45[7] = 1;
                v32[12] = v45;
                int[] v46 = new int[8];
                v46[7] = 1;
                v32[13] = v46;
                int[] v47 = new int[8];
                v47[1] = 1;
                v47[2] = 1;
                v47[3] = 1;
                v47[4] = 1;
                v47[5] = 1;
                v47[6] = 1;
                v32[14] = v47;
                yield v32;
            }
            case 3 -> {
                int[][] v48 = new int[15][];
                int[] v49 = new int[8];
                v49[1] = 1;
                v49[2] = 1;
                v49[3] = 1;
                v49[4] = 1;
                v49[5] = 1;
                v49[6] = 1;
                v48[0] = v49;
                int[] v50 = new int[8];
                v50[0] = 1;
                v50[7] = 1;
                v48[1] = v50;
                int[] v51 = new int[8];
                v51[0] = 1;
                v51[7] = 1;
                v48[2] = v51;
                int[] v52 = new int[8];
                v52[0] = 1;
                v52[7] = 1;
                v48[3] = v52;
                int[] v53 = new int[8];
                v53[0] = 1;
                v53[7] = 1;
                v48[4] = v53;
                int[] v54 = new int[8];
                v54[0] = 1;
                v54[7] = 1;
                v48[5] = v54;
                int[] v55 = new int[8];
                v55[0] = 1;
                v55[7] = 1;
                v48[6] = v55;
                int[] v56 = new int[8];
                v56[1] = 1;
                v56[2] = 1;
                v56[3] = 1;
                v48[7] = v56;
                int[] v57 = new int[8];
                v57[0] = 1;
                v57[7] = 1;
                v48[8] = v57;
                int[] v58 = new int[8];
                v58[0] = 1;
                v58[7] = 1;
                v48[9] = v58;
                int[] v59 = new int[8];
                v59[0] = 1;
                v59[7] = 1;
                v48[10] = v59;
                int[] v60 = new int[8];
                v60[7] = 1;
                v48[11] = v60;
                int[] v61 = new int[8];
                v61[7] = 1;
                v48[12] = v61;
                int[] v62 = new int[8];
                v62[7] = 1;
                v48[13] = v62;
                int[] v63 = new int[8];
                v63[1] = 1;
                v63[2] = 1;
                v63[3] = 1;
                v63[4] = 1;
                v63[5] = 1;
                v63[6] = 1;
                v48[14] = v63;
                yield v48;
            }
            case 4 -> {
                int[][] v64 = new int[15][];
                int[] v65 = new int[8];
                v65[1] = 1;
                v65[2] = 1;
                v65[3] = 1;
                v65[4] = 1;
                v65[5] = 1;
                v65[6] = 1;
                v64[0] = v65;
                int[] v66 = new int[8];
                v66[0] = 1;
                v66[7] = 1;
                v64[1] = v66;
                int[] v67 = new int[8];
                v67[0] = 1;
                v67[7] = 1;
                v64[2] = v67;
                int[] v68 = new int[8];
                v68[0] = 1;
                v68[7] = 1;
                v64[3] = v68;
                int[] v69 = new int[8];
                v69[0] = 1;
                v69[7] = 1;
                v64[4] = v69;
                int[] v70 = new int[8];
                v70[0] = 1;
                v70[7] = 1;
                v64[5] = v70;
                int[] v71 = new int[8];
                v71[0] = 1;
                v71[7] = 1;
                v64[6] = v71;
                int[] v72 = new int[8];
                v72[1] = 1;
                v72[2] = 1;
                v64[7] = v72;
                int[] v73 = new int[8];
                v73[0] = 1;
                v73[7] = 1;
                v64[8] = v73;
                int[] v74 = new int[8];
                v74[0] = 1;
                v74[7] = 1;
                v64[9] = v74;
                int[] v75 = new int[8];
                v75[0] = 1;
                v75[7] = 1;
                v64[10] = v75;
                int[] v76 = new int[8];
                v76[0] = 1;
                v76[7] = 1;
                v64[11] = v76;
                int[] v77 = new int[8];
                v77[7] = 1;
                v64[12] = v77;
                int[] v78 = new int[8];
                v78[7] = 1;
                v64[13] = v78;
                int[] v79 = new int[8];
                v79[1] = 1;
                v79[2] = 1;
                v79[3] = 1;
                v79[4] = 1;
                v79[5] = 1;
                v79[6] = 1;
                v64[14] = v79;
                yield v64;
            }
            case 5 -> {
                int[][] v80 = new int[15][];
                int[] v81 = new int[8];
                v81[1] = 1;
                v81[2] = 1;
                v81[3] = 1;
                v81[4] = 1;
                v81[5] = 1;
                v81[6] = 1;
                v80[0] = v81;
                int[] v82 = new int[8];
                v82[0] = 1;
                v82[7] = 1;
                v80[1] = v82;
                int[] v83 = new int[8];
                v83[0] = 1;
                v83[7] = 1;
                v80[2] = v83;
                int[] v84 = new int[8];
                v84[0] = 1;
                v84[7] = 1;
                v80[3] = v84;
                int[] v85 = new int[8];
                v85[0] = 1;
                v85[7] = 1;
                v80[4] = v85;
                int[] v86 = new int[8];
                v86[0] = 1;
                v86[7] = 1;
                v80[5] = v86;
                int[] v87 = new int[8];
                v87[0] = 1;
                v87[7] = 1;
                v80[6] = v87;
                int[] v88 = new int[8];
                v88[1] = 1;
                v80[7] = v88;
                int[] v89 = new int[8];
                v89[0] = 1;
                v89[7] = 1;
                v80[8] = v89;
                int[] v90 = new int[8];
                v90[0] = 1;
                v90[7] = 1;
                v80[9] = v90;
                int[] v91 = new int[8];
                v91[0] = 1;
                v91[7] = 1;
                v80[10] = v91;
                int[] v92 = new int[8];
                v92[0] = 1;
                v92[7] = 1;
                v80[11] = v92;
                int[] v93 = new int[8];
                v93[0] = 1;
                v93[7] = 1;
                v80[12] = v93;
                int[] v94 = new int[8];
                v94[7] = 1;
                v80[13] = v94;
                int[] v95 = new int[8];
                v95[1] = 1;
                v95[2] = 1;
                v95[3] = 1;
                v95[4] = 1;
                v95[5] = 1;
                v95[6] = 1;
                v80[14] = v95;
                yield v80;
            }
            case 6 -> {
                int[][] v96 = new int[15][];
                int[] v97 = new int[8];
                v97[1] = 1;
                v97[2] = 1;
                v97[3] = 1;
                v97[4] = 1;
                v97[5] = 1;
                v97[6] = 1;
                v96[0] = v97;
                int[] v98 = new int[8];
                v98[0] = 1;
                v98[7] = 1;
                v96[1] = v98;
                int[] v99 = new int[8];
                v99[0] = 1;
                v99[7] = 1;
                v96[2] = v99;
                int[] v100 = new int[8];
                v100[0] = 1;
                v100[7] = 1;
                v96[3] = v100;
                int[] v101 = new int[8];
                v101[0] = 1;
                v101[7] = 1;
                v96[4] = v101;
                int[] v102 = new int[8];
                v102[0] = 1;
                v102[7] = 1;
                v96[5] = v102;
                int[] v103 = new int[8];
                v103[0] = 1;
                v103[7] = 1;
                v96[6] = v103;
                v96[7] = new int[8];
                int[] v104 = new int[8];
                v104[0] = 1;
                v104[7] = 1;
                v96[8] = v104;
                int[] v105 = new int[8];
                v105[0] = 1;
                v105[7] = 1;
                v96[9] = v105;
                int[] v106 = new int[8];
                v106[0] = 1;
                v106[7] = 1;
                v96[10] = v106;
                int[] v107 = new int[8];
                v107[0] = 1;
                v107[7] = 1;
                v96[11] = v107;
                int[] v108 = new int[8];
                v108[0] = 1;
                v108[7] = 1;
                v96[12] = v108;
                int[] v109 = new int[8];
                v109[0] = 1;
                v109[7] = 1;
                v96[13] = v109;
                int[] v110 = new int[8];
                v110[1] = 1;
                v110[2] = 1;
                v110[3] = 1;
                v110[4] = 1;
                v110[5] = 1;
                v110[6] = 1;
                v96[14] = v110;
                yield v96;
            }
            case 7 -> {
                int[][] v111 = new int[15][];
                int[] v112 = new int[8];
                v112[1] = 1;
                v112[2] = 1;
                v112[3] = 1;
                v112[4] = 1;
                v112[5] = 1;
                v112[6] = 1;
                v111[0] = v112;
                int[] v113 = new int[8];
                v113[0] = 1;
                v113[7] = 1;
                v111[1] = v113;
                int[] v114 = new int[8];
                v114[0] = 1;
                v114[7] = 1;
                v111[2] = v114;
                int[] v115 = new int[8];
                v115[0] = 1;
                v115[7] = 1;
                v111[3] = v115;
                int[] v116 = new int[8];
                v116[0] = 1;
                v116[7] = 1;
                v111[4] = v116;
                int[] v117 = new int[8];
                v117[0] = 1;
                v117[7] = 1;
                v111[5] = v117;
                int[] v118 = new int[8];
                v118[0] = 1;
                v118[7] = 1;
                v111[6] = v118;
                v111[7] = new int[8];
                int[] v119 = new int[8];
                v119[0] = 1;
                v119[7] = 1;
                v111[8] = v119;
                int[] v120 = new int[8];
                v120[0] = 1;
                v120[7] = 1;
                v111[9] = v120;
                int[] v121 = new int[8];
                v121[0] = 1;
                v121[7] = 1;
                v111[10] = v121;
                int[] v122 = new int[8];
                v122[0] = 1;
                v122[7] = 1;
                v111[11] = v122;
                int[] v123 = new int[8];
                v123[0] = 1;
                v123[7] = 1;
                v111[12] = v123;
                int[] v124 = new int[8];
                v124[0] = 1;
                v124[7] = 1;
                v111[13] = v124;
                int[] v125 = new int[8];
                v125[1] = 1;
                v125[2] = 1;
                v125[3] = 1;
                v125[4] = 1;
                v125[5] = 1;
                v125[6] = 1;
                v111[14] = v125;
                yield v111;
            }
            default -> {
                int[][] v126 = new int[15][];
                int[] v127 = new int[8];
                v127[1] = 1;
                v127[2] = 1;
                v127[3] = 1;
                v127[4] = 1;
                v127[5] = 1;
                v127[6] = 1;
                v126[0] = v127;
                int[] v128 = new int[8];
                v128[0] = 1;
                v128[7] = 1;
                v126[1] = v128;
                int[] v129 = new int[8];
                v129[0] = 1;
                v129[7] = 1;
                v126[2] = v129;
                int[] v130 = new int[8];
                v130[0] = 1;
                v130[7] = 1;
                v126[3] = v130;
                int[] v131 = new int[8];
                v131[0] = 1;
                v131[7] = 1;
                v126[4] = v131;
                int[] v132 = new int[8];
                v132[0] = 1;
                v132[7] = 1;
                v126[5] = v132;
                int[] v133 = new int[8];
                v133[0] = 1;
                v133[7] = 1;
                v126[6] = v133;
                v126[7] = new int[8];
                int[] v134 = new int[8];
                v134[0] = 1;
                v134[7] = 1;
                v126[8] = v134;
                int[] v135 = new int[8];
                v135[0] = 1;
                v135[7] = 1;
                v126[9] = v135;
                int[] v136 = new int[8];
                v136[0] = 1;
                v136[7] = 1;
                v126[10] = v136;
                int[] v137 = new int[8];
                v137[0] = 1;
                v137[7] = 1;
                v126[11] = v137;
                int[] v138 = new int[8];
                v138[0] = 1;
                v138[7] = 1;
                v126[12] = v138;
                int[] v139 = new int[8];
                v139[0] = 1;
                v139[7] = 1;
                v126[13] = v139;
                int[] v140 = new int[8];
                v140[1] = 1;
                v140[2] = 1;
                v140[3] = 1;
                v140[4] = 1;
                v140[5] = 1;
                v140[6] = 1;
                v126[14] = v140;
                yield v126;
            }
        };
    }

    private int[][] toOne(int STEP) {
        return switch (STEP) {
            case 0 -> {
                int[][] v0 = new int[15][];
                int[] v1 = new int[8];
                v1[1] = 1;
                v1[2] = 1;
                v1[3] = 1;
                v1[4] = 1;
                v1[5] = 1;
                v1[6] = 1;
                v0[0] = v1;
                int[] v2 = new int[8];
                v2[0] = 1;
                v2[7] = 1;
                v0[1] = v2;
                int[] v3 = new int[8];
                v3[0] = 1;
                v3[7] = 1;
                v0[2] = v3;
                int[] v4 = new int[8];
                v4[0] = 1;
                v4[7] = 1;
                v0[3] = v4;
                int[] v5 = new int[8];
                v5[0] = 1;
                v5[7] = 1;
                v0[4] = v5;
                int[] v6 = new int[8];
                v6[0] = 1;
                v6[7] = 1;
                v0[5] = v6;
                int[] v7 = new int[8];
                v7[0] = 1;
                v7[7] = 1;
                v0[6] = v7;
                v0[7] = new int[8];
                int[] v8 = new int[8];
                v8[0] = 1;
                v8[7] = 1;
                v0[8] = v8;
                int[] v9 = new int[8];
                v9[0] = 1;
                v9[7] = 1;
                v0[9] = v9;
                int[] v10 = new int[8];
                v10[0] = 1;
                v10[7] = 1;
                v0[10] = v10;
                int[] v11 = new int[8];
                v11[0] = 1;
                v11[7] = 1;
                v0[11] = v11;
                int[] v12 = new int[8];
                v12[0] = 1;
                v12[7] = 1;
                v0[12] = v12;
                int[] v13 = new int[8];
                v13[0] = 1;
                v13[7] = 1;
                v0[13] = v13;
                int[] v14 = new int[8];
                v14[1] = 1;
                v14[2] = 1;
                v14[3] = 1;
                v14[4] = 1;
                v14[5] = 1;
                v14[6] = 1;
                v0[14] = v14;
                yield v0;
            }
            case 1 -> {
                int[][] v15 = new int[15][];
                int[] v16 = new int[8];
                v16[1] = 1;
                v16[2] = 1;
                v16[3] = 1;
                v16[4] = 1;
                v16[5] = 1;
                v16[6] = 1;
                v15[0] = v16;
                int[] v17 = new int[8];
                v17[1] = 1;
                v17[7] = 1;
                v15[1] = v17;
                int[] v18 = new int[8];
                v18[1] = 1;
                v18[7] = 1;
                v15[2] = v18;
                int[] v19 = new int[8];
                v19[1] = 1;
                v19[7] = 1;
                v15[3] = v19;
                int[] v20 = new int[8];
                v20[1] = 1;
                v20[7] = 1;
                v15[4] = v20;
                int[] v21 = new int[8];
                v21[1] = 1;
                v21[7] = 1;
                v15[5] = v21;
                int[] v22 = new int[8];
                v22[1] = 1;
                v22[7] = 1;
                v15[6] = v22;
                v15[7] = new int[8];
                int[] v23 = new int[8];
                v23[1] = 1;
                v23[7] = 1;
                v15[8] = v23;
                int[] v24 = new int[8];
                v24[1] = 1;
                v24[7] = 1;
                v15[9] = v24;
                int[] v25 = new int[8];
                v25[1] = 1;
                v25[7] = 1;
                v15[10] = v25;
                int[] v26 = new int[8];
                v26[1] = 1;
                v26[7] = 1;
                v15[11] = v26;
                int[] v27 = new int[8];
                v27[1] = 1;
                v27[7] = 1;
                v15[12] = v27;
                int[] v28 = new int[8];
                v28[1] = 1;
                v28[7] = 1;
                v15[13] = v28;
                int[] v29 = new int[8];
                v29[1] = 1;
                v29[2] = 1;
                v29[3] = 1;
                v29[4] = 1;
                v29[5] = 1;
                v29[6] = 1;
                v15[14] = v29;
                yield v15;
            }
            case 2 -> {
                int[][] v30 = new int[15][];
                int[] v31 = new int[8];
                v31[2] = 1;
                v31[3] = 1;
                v31[4] = 1;
                v31[5] = 1;
                v31[6] = 1;
                v30[0] = v31;
                int[] v32 = new int[8];
                v32[2] = 1;
                v32[7] = 1;
                v30[1] = v32;
                int[] v33 = new int[8];
                v33[2] = 1;
                v33[7] = 1;
                v30[2] = v33;
                int[] v34 = new int[8];
                v34[2] = 1;
                v34[7] = 1;
                v30[3] = v34;
                int[] v35 = new int[8];
                v35[2] = 1;
                v35[7] = 1;
                v30[4] = v35;
                int[] v36 = new int[8];
                v36[2] = 1;
                v36[7] = 1;
                v30[5] = v36;
                int[] v37 = new int[8];
                v37[2] = 1;
                v37[7] = 1;
                v30[6] = v37;
                v30[7] = new int[8];
                int[] v38 = new int[8];
                v38[2] = 1;
                v38[7] = 1;
                v30[8] = v38;
                int[] v39 = new int[8];
                v39[2] = 1;
                v39[7] = 1;
                v30[9] = v39;
                int[] v40 = new int[8];
                v40[2] = 1;
                v40[7] = 1;
                v30[10] = v40;
                int[] v41 = new int[8];
                v41[2] = 1;
                v41[7] = 1;
                v30[11] = v41;
                int[] v42 = new int[8];
                v42[2] = 1;
                v42[7] = 1;
                v30[12] = v42;
                int[] v43 = new int[8];
                v43[2] = 1;
                v43[7] = 1;
                v30[13] = v43;
                int[] v44 = new int[8];
                v44[2] = 1;
                v44[3] = 1;
                v44[4] = 1;
                v44[5] = 1;
                v44[6] = 1;
                v30[14] = v44;
                yield v30;
            }
            case 3 -> {
                int[][] v45 = new int[15][];
                int[] v46 = new int[8];
                v46[3] = 1;
                v46[4] = 1;
                v46[5] = 1;
                v46[6] = 1;
                v45[0] = v46;
                int[] v47 = new int[8];
                v47[3] = 1;
                v47[7] = 1;
                v45[1] = v47;
                int[] v48 = new int[8];
                v48[3] = 1;
                v48[7] = 1;
                v45[2] = v48;
                int[] v49 = new int[8];
                v49[3] = 1;
                v49[7] = 1;
                v45[3] = v49;
                int[] v50 = new int[8];
                v50[3] = 1;
                v50[7] = 1;
                v45[4] = v50;
                int[] v51 = new int[8];
                v51[3] = 1;
                v51[7] = 1;
                v45[5] = v51;
                int[] v52 = new int[8];
                v52[3] = 1;
                v52[7] = 1;
                v45[6] = v52;
                v45[7] = new int[8];
                int[] v53 = new int[8];
                v53[3] = 1;
                v53[7] = 1;
                v45[8] = v53;
                int[] v54 = new int[8];
                v54[3] = 1;
                v54[7] = 1;
                v45[9] = v54;
                int[] v55 = new int[8];
                v55[3] = 1;
                v55[7] = 1;
                v45[10] = v55;
                int[] v56 = new int[8];
                v56[3] = 1;
                v56[7] = 1;
                v45[11] = v56;
                int[] v57 = new int[8];
                v57[3] = 1;
                v57[7] = 1;
                v45[12] = v57;
                int[] v58 = new int[8];
                v58[3] = 1;
                v58[7] = 1;
                v45[13] = v58;
                int[] v59 = new int[8];
                v59[3] = 1;
                v59[4] = 1;
                v59[5] = 1;
                v59[6] = 1;
                v45[14] = v59;
                yield v45;
            }
            case 4 -> {
                int[][] v60 = new int[15][];
                int[] v61 = new int[8];
                v61[4] = 1;
                v61[5] = 1;
                v61[6] = 1;
                v60[0] = v61;
                int[] v62 = new int[8];
                v62[4] = 1;
                v62[7] = 1;
                v60[1] = v62;
                int[] v63 = new int[8];
                v63[4] = 1;
                v63[7] = 1;
                v60[2] = v63;
                int[] v64 = new int[8];
                v64[4] = 1;
                v64[7] = 1;
                v60[3] = v64;
                int[] v65 = new int[8];
                v65[4] = 1;
                v65[7] = 1;
                v60[4] = v65;
                int[] v66 = new int[8];
                v66[4] = 1;
                v66[7] = 1;
                v60[5] = v66;
                int[] v67 = new int[8];
                v67[4] = 1;
                v67[7] = 1;
                v60[6] = v67;
                v60[7] = new int[8];
                int[] v68 = new int[8];
                v68[4] = 1;
                v68[7] = 1;
                v60[8] = v68;
                int[] v69 = new int[8];
                v69[4] = 1;
                v69[7] = 1;
                v60[9] = v69;
                int[] v70 = new int[8];
                v70[4] = 1;
                v70[7] = 1;
                v60[10] = v70;
                int[] v71 = new int[8];
                v71[4] = 1;
                v71[7] = 1;
                v60[11] = v71;
                int[] v72 = new int[8];
                v72[4] = 1;
                v72[7] = 1;
                v60[12] = v72;
                int[] v73 = new int[8];
                v73[4] = 1;
                v73[7] = 1;
                v60[13] = v73;
                int[] v74 = new int[8];
                v74[4] = 1;
                v74[5] = 1;
                v74[6] = 1;
                v60[14] = v74;
                yield v60;
            }
            case 5 -> {
                int[][] v75 = new int[15][];
                int[] v76 = new int[8];
                v76[5] = 1;
                v76[6] = 1;
                v75[0] = v76;
                int[] v77 = new int[8];
                v77[5] = 1;
                v77[7] = 1;
                v75[1] = v77;
                int[] v78 = new int[8];
                v78[5] = 1;
                v78[7] = 1;
                v75[2] = v78;
                int[] v79 = new int[8];
                v79[5] = 1;
                v79[7] = 1;
                v75[3] = v79;
                int[] v80 = new int[8];
                v80[5] = 1;
                v80[7] = 1;
                v75[4] = v80;
                int[] v81 = new int[8];
                v81[5] = 1;
                v81[7] = 1;
                v75[5] = v81;
                int[] v82 = new int[8];
                v82[5] = 1;
                v82[7] = 1;
                v75[6] = v82;
                v75[7] = new int[8];
                int[] v83 = new int[8];
                v83[5] = 1;
                v83[7] = 1;
                v75[8] = v83;
                int[] v84 = new int[8];
                v84[5] = 1;
                v84[7] = 1;
                v75[9] = v84;
                int[] v85 = new int[8];
                v85[5] = 1;
                v85[7] = 1;
                v75[10] = v85;
                int[] v86 = new int[8];
                v86[5] = 1;
                v86[7] = 1;
                v75[11] = v86;
                int[] v87 = new int[8];
                v87[5] = 1;
                v87[7] = 1;
                v75[12] = v87;
                int[] v88 = new int[8];
                v88[5] = 1;
                v88[7] = 1;
                v75[13] = v88;
                int[] v89 = new int[8];
                v89[5] = 1;
                v89[6] = 1;
                v75[14] = v89;
                yield v75;
            }
            case 6 -> {
                int[][] v90 = new int[15][];
                int[] v91 = new int[8];
                v91[6] = 1;
                v90[0] = v91;
                int[] v92 = new int[8];
                v92[6] = 1;
                v92[7] = 1;
                v90[1] = v92;
                int[] v93 = new int[8];
                v93[6] = 1;
                v93[7] = 1;
                v90[2] = v93;
                int[] v94 = new int[8];
                v94[6] = 1;
                v94[7] = 1;
                v90[3] = v94;
                int[] v95 = new int[8];
                v95[6] = 1;
                v95[7] = 1;
                v90[4] = v95;
                int[] v96 = new int[8];
                v96[6] = 1;
                v96[7] = 1;
                v90[5] = v96;
                int[] v97 = new int[8];
                v97[6] = 1;
                v97[7] = 1;
                v90[6] = v97;
                v90[7] = new int[8];
                int[] v98 = new int[8];
                v98[6] = 1;
                v98[7] = 1;
                v90[8] = v98;
                int[] v99 = new int[8];
                v99[6] = 1;
                v99[7] = 1;
                v90[9] = v99;
                int[] v100 = new int[8];
                v100[6] = 1;
                v100[7] = 1;
                v90[10] = v100;
                int[] v101 = new int[8];
                v101[6] = 1;
                v101[7] = 1;
                v90[11] = v101;
                int[] v102 = new int[8];
                v102[6] = 1;
                v102[7] = 1;
                v90[12] = v102;
                int[] v103 = new int[8];
                v103[6] = 1;
                v103[7] = 1;
                v90[13] = v103;
                int[] v104 = new int[8];
                v104[6] = 1;
                v90[14] = v104;
                yield v90;
            }
            case 7 -> {
                int[][] v105 = new int[15][];
                v105[0] = new int[8];
                int[] v106 = new int[8];
                v106[7] = 1;
                v105[1] = v106;
                int[] v107 = new int[8];
                v107[7] = 1;
                v105[2] = v107;
                int[] v108 = new int[8];
                v108[7] = 1;
                v105[3] = v108;
                int[] v109 = new int[8];
                v109[7] = 1;
                v105[4] = v109;
                int[] v110 = new int[8];
                v110[7] = 1;
                v105[5] = v110;
                int[] v111 = new int[8];
                v111[7] = 1;
                v105[6] = v111;
                v105[7] = new int[8];
                int[] v112 = new int[8];
                v112[7] = 1;
                v105[8] = v112;
                int[] v113 = new int[8];
                v113[7] = 1;
                v105[9] = v113;
                int[] v114 = new int[8];
                v114[7] = 1;
                v105[10] = v114;
                int[] v115 = new int[8];
                v115[7] = 1;
                v105[11] = v115;
                int[] v116 = new int[8];
                v116[7] = 1;
                v105[12] = v116;
                int[] v117 = new int[8];
                v117[7] = 1;
                v105[13] = v117;
                v105[14] = new int[8];
                yield v105;
            }
            default -> {
                int[][] v118 = new int[15][];
                v118[0] = new int[8];
                int[] v119 = new int[8];
                v119[7] = 1;
                v118[1] = v119;
                int[] v120 = new int[8];
                v120[7] = 1;
                v118[2] = v120;
                int[] v121 = new int[8];
                v121[7] = 1;
                v118[3] = v121;
                int[] v122 = new int[8];
                v122[7] = 1;
                v118[4] = v122;
                int[] v123 = new int[8];
                v123[7] = 1;
                v118[5] = v123;
                int[] v124 = new int[8];
                v124[7] = 1;
                v118[6] = v124;
                v118[7] = new int[8];
                int[] v125 = new int[8];
                v125[7] = 1;
                v118[8] = v125;
                int[] v126 = new int[8];
                v126[7] = 1;
                v118[9] = v126;
                int[] v127 = new int[8];
                v127[7] = 1;
                v118[10] = v127;
                int[] v128 = new int[8];
                v128[7] = 1;
                v118[11] = v128;
                int[] v129 = new int[8];
                v129[7] = 1;
                v118[12] = v129;
                int[] v130 = new int[8];
                v130[7] = 1;
                v118[13] = v130;
                v118[14] = new int[8];
                yield v118;
            }
        };
    }

    private int[][] toTwo(int STEP) {
        return switch (STEP) {
            case 0 -> {
                int[][] v0 = new int[15][];
                v0[0] = new int[8];
                int[] v1 = new int[8];
                v1[7] = 1;
                v0[1] = v1;
                int[] v2 = new int[8];
                v2[7] = 1;
                v0[2] = v2;
                int[] v3 = new int[8];
                v3[7] = 1;
                v0[3] = v3;
                int[] v4 = new int[8];
                v4[7] = 1;
                v0[4] = v4;
                int[] v5 = new int[8];
                v5[7] = 1;
                v0[5] = v5;
                int[] v6 = new int[8];
                v6[7] = 1;
                v0[6] = v6;
                v0[7] = new int[8];
                int[] v7 = new int[8];
                v7[7] = 1;
                v0[8] = v7;
                int[] v8 = new int[8];
                v8[7] = 1;
                v0[9] = v8;
                int[] v9 = new int[8];
                v9[7] = 1;
                v0[10] = v9;
                int[] v10 = new int[8];
                v10[7] = 1;
                v0[11] = v10;
                int[] v11 = new int[8];
                v11[7] = 1;
                v0[12] = v11;
                int[] v12 = new int[8];
                v12[7] = 1;
                v0[13] = v12;
                v0[14] = new int[8];
                yield v0;
            }
            case 1 -> {
                int[][] v13 = new int[15][];
                int[] v14 = new int[8];
                v14[6] = 1;
                v13[0] = v14;
                int[] v15 = new int[8];
                v15[7] = 1;
                v13[1] = v15;
                int[] v16 = new int[8];
                v16[7] = 1;
                v13[2] = v16;
                int[] v17 = new int[8];
                v17[7] = 1;
                v13[3] = v17;
                int[] v18 = new int[8];
                v18[7] = 1;
                v13[4] = v18;
                int[] v19 = new int[8];
                v19[7] = 1;
                v13[5] = v19;
                int[] v20 = new int[8];
                v20[7] = 1;
                v13[6] = v20;
                int[] v21 = new int[8];
                v21[6] = 1;
                v13[7] = v21;
                int[] v22 = new int[8];
                v22[6] = 1;
                v13[8] = v22;
                int[] v23 = new int[8];
                v23[6] = 1;
                v13[9] = v23;
                int[] v24 = new int[8];
                v24[6] = 1;
                v13[10] = v24;
                int[] v25 = new int[8];
                v25[6] = 1;
                v13[11] = v25;
                int[] v26 = new int[8];
                v26[6] = 1;
                v13[12] = v26;
                int[] v27 = new int[8];
                v27[6] = 1;
                v13[13] = v27;
                int[] v28 = new int[8];
                v28[6] = 1;
                v13[14] = v28;
                yield v13;
            }
            case 2 -> {
                int[][] v29 = new int[15][];
                int[] v30 = new int[8];
                v30[5] = 1;
                v30[6] = 1;
                v29[0] = v30;
                int[] v31 = new int[8];
                v31[7] = 1;
                v29[1] = v31;
                int[] v32 = new int[8];
                v32[7] = 1;
                v29[2] = v32;
                int[] v33 = new int[8];
                v33[7] = 1;
                v29[3] = v33;
                int[] v34 = new int[8];
                v34[7] = 1;
                v29[4] = v34;
                int[] v35 = new int[8];
                v35[7] = 1;
                v29[5] = v35;
                int[] v36 = new int[8];
                v36[7] = 1;
                v29[6] = v36;
                int[] v37 = new int[8];
                v37[5] = 1;
                v37[6] = 1;
                v29[7] = v37;
                int[] v38 = new int[8];
                v38[5] = 1;
                v29[8] = v38;
                int[] v39 = new int[8];
                v39[5] = 1;
                v29[9] = v39;
                int[] v40 = new int[8];
                v40[5] = 1;
                v29[10] = v40;
                int[] v41 = new int[8];
                v41[5] = 1;
                v29[11] = v41;
                int[] v42 = new int[8];
                v42[5] = 1;
                v29[12] = v42;
                int[] v43 = new int[8];
                v43[5] = 1;
                v29[13] = v43;
                int[] v44 = new int[8];
                v44[5] = 1;
                v44[6] = 1;
                v29[14] = v44;
                yield v29;
            }
            case 3 -> {
                int[][] v45 = new int[15][];
                int[] v46 = new int[8];
                v46[4] = 1;
                v46[5] = 1;
                v46[6] = 1;
                v45[0] = v46;
                int[] v47 = new int[8];
                v47[7] = 1;
                v45[1] = v47;
                int[] v48 = new int[8];
                v48[7] = 1;
                v45[2] = v48;
                int[] v49 = new int[8];
                v49[7] = 1;
                v45[3] = v49;
                int[] v50 = new int[8];
                v50[7] = 1;
                v45[4] = v50;
                int[] v51 = new int[8];
                v51[7] = 1;
                v45[5] = v51;
                int[] v52 = new int[8];
                v52[7] = 1;
                v45[6] = v52;
                int[] v53 = new int[8];
                v53[4] = 1;
                v53[5] = 1;
                v53[6] = 1;
                v45[7] = v53;
                int[] v54 = new int[8];
                v54[4] = 1;
                v45[8] = v54;
                int[] v55 = new int[8];
                v55[4] = 1;
                v45[9] = v55;
                int[] v56 = new int[8];
                v56[4] = 1;
                v45[10] = v56;
                int[] v57 = new int[8];
                v57[4] = 1;
                v45[11] = v57;
                int[] v58 = new int[8];
                v58[4] = 1;
                v45[12] = v58;
                int[] v59 = new int[8];
                v59[4] = 1;
                v45[13] = v59;
                int[] v60 = new int[8];
                v60[4] = 1;
                v60[5] = 1;
                v60[6] = 1;
                v45[14] = v60;
                yield v45;
            }
            case 4 -> {
                int[][] v61 = new int[15][];
                int[] v62 = new int[8];
                v62[3] = 1;
                v62[4] = 1;
                v62[5] = 1;
                v62[6] = 1;
                v61[0] = v62;
                int[] v63 = new int[8];
                v63[7] = 1;
                v61[1] = v63;
                int[] v64 = new int[8];
                v64[7] = 1;
                v61[2] = v64;
                int[] v65 = new int[8];
                v65[7] = 1;
                v61[3] = v65;
                int[] v66 = new int[8];
                v66[7] = 1;
                v61[4] = v66;
                int[] v67 = new int[8];
                v67[7] = 1;
                v61[5] = v67;
                int[] v68 = new int[8];
                v68[7] = 1;
                v61[6] = v68;
                int[] v69 = new int[8];
                v69[3] = 1;
                v69[4] = 1;
                v69[5] = 1;
                v69[6] = 1;
                v61[7] = v69;
                int[] v70 = new int[8];
                v70[3] = 1;
                v61[8] = v70;
                int[] v71 = new int[8];
                v71[3] = 1;
                v61[9] = v71;
                int[] v72 = new int[8];
                v72[3] = 1;
                v61[10] = v72;
                int[] v73 = new int[8];
                v73[3] = 1;
                v61[11] = v73;
                int[] v74 = new int[8];
                v74[3] = 1;
                v61[12] = v74;
                int[] v75 = new int[8];
                v75[3] = 1;
                v61[13] = v75;
                int[] v76 = new int[8];
                v76[3] = 1;
                v76[4] = 1;
                v76[5] = 1;
                v76[6] = 1;
                v61[14] = v76;
                yield v61;
            }
            case 5 -> {
                int[][] v77 = new int[15][];
                int[] v78 = new int[8];
                v78[2] = 1;
                v78[3] = 1;
                v78[4] = 1;
                v78[5] = 1;
                v78[6] = 1;
                v77[0] = v78;
                int[] v79 = new int[8];
                v79[7] = 1;
                v77[1] = v79;
                int[] v80 = new int[8];
                v80[7] = 1;
                v77[2] = v80;
                int[] v81 = new int[8];
                v81[7] = 1;
                v77[3] = v81;
                int[] v82 = new int[8];
                v82[7] = 1;
                v77[4] = v82;
                int[] v83 = new int[8];
                v83[7] = 1;
                v77[5] = v83;
                int[] v84 = new int[8];
                v84[7] = 1;
                v77[6] = v84;
                int[] v85 = new int[8];
                v85[2] = 1;
                v85[3] = 1;
                v85[4] = 1;
                v85[5] = 1;
                v85[6] = 1;
                v77[7] = v85;
                int[] v86 = new int[8];
                v86[2] = 1;
                v77[8] = v86;
                int[] v87 = new int[8];
                v87[2] = 1;
                v77[9] = v87;
                int[] v88 = new int[8];
                v88[2] = 1;
                v77[10] = v88;
                int[] v89 = new int[8];
                v89[2] = 1;
                v77[11] = v89;
                int[] v90 = new int[8];
                v90[2] = 1;
                v77[12] = v90;
                int[] v91 = new int[8];
                v91[2] = 1;
                v77[13] = v91;
                int[] v92 = new int[8];
                v92[2] = 1;
                v92[3] = 1;
                v92[4] = 1;
                v92[5] = 1;
                v92[6] = 1;
                v77[14] = v92;
                yield v77;
            }
            case 6 -> {
                int[][] v93 = new int[15][];
                int[] v94 = new int[8];
                v94[1] = 1;
                v94[2] = 1;
                v94[3] = 1;
                v94[4] = 1;
                v94[5] = 1;
                v94[6] = 1;
                v93[0] = v94;
                int[] v95 = new int[8];
                v95[7] = 1;
                v93[1] = v95;
                int[] v96 = new int[8];
                v96[7] = 1;
                v93[2] = v96;
                int[] v97 = new int[8];
                v97[7] = 1;
                v93[3] = v97;
                int[] v98 = new int[8];
                v98[7] = 1;
                v93[4] = v98;
                int[] v99 = new int[8];
                v99[7] = 1;
                v93[5] = v99;
                int[] v100 = new int[8];
                v100[7] = 1;
                v93[6] = v100;
                int[] v101 = new int[8];
                v101[1] = 1;
                v101[2] = 1;
                v101[3] = 1;
                v101[4] = 1;
                v101[5] = 1;
                v101[6] = 1;
                v93[7] = v101;
                int[] v102 = new int[8];
                v102[1] = 1;
                v93[8] = v102;
                int[] v103 = new int[8];
                v103[1] = 1;
                v93[9] = v103;
                int[] v104 = new int[8];
                v104[1] = 1;
                v93[10] = v104;
                int[] v105 = new int[8];
                v105[1] = 1;
                v93[11] = v105;
                int[] v106 = new int[8];
                v106[1] = 1;
                v93[12] = v106;
                int[] v107 = new int[8];
                v107[1] = 1;
                v93[13] = v107;
                int[] v108 = new int[8];
                v108[1] = 1;
                v108[2] = 1;
                v108[3] = 1;
                v108[4] = 1;
                v108[5] = 1;
                v108[6] = 1;
                v93[14] = v108;
                yield v93;
            }
            case 7 -> {
                int[][] v109 = new int[15][];
                int[] v110 = new int[8];
                v110[1] = 1;
                v110[2] = 1;
                v110[3] = 1;
                v110[4] = 1;
                v110[5] = 1;
                v110[6] = 1;
                v109[0] = v110;
                int[] v111 = new int[8];
                v111[7] = 1;
                v109[1] = v111;
                int[] v112 = new int[8];
                v112[7] = 1;
                v109[2] = v112;
                int[] v113 = new int[8];
                v113[7] = 1;
                v109[3] = v113;
                int[] v114 = new int[8];
                v114[7] = 1;
                v109[4] = v114;
                int[] v115 = new int[8];
                v115[7] = 1;
                v109[5] = v115;
                int[] v116 = new int[8];
                v116[7] = 1;
                v109[6] = v116;
                int[] v117 = new int[8];
                v117[1] = 1;
                v117[2] = 1;
                v117[3] = 1;
                v117[4] = 1;
                v117[5] = 1;
                v117[6] = 1;
                v109[7] = v117;
                int[] v118 = new int[8];
                v118[0] = 1;
                v109[8] = v118;
                int[] v119 = new int[8];
                v119[0] = 1;
                v109[9] = v119;
                int[] v120 = new int[8];
                v120[0] = 1;
                v109[10] = v120;
                int[] v121 = new int[8];
                v121[0] = 1;
                v109[11] = v121;
                int[] v122 = new int[8];
                v122[0] = 1;
                v109[12] = v122;
                int[] v123 = new int[8];
                v123[0] = 1;
                v109[13] = v123;
                int[] v124 = new int[8];
                v124[1] = 1;
                v124[2] = 1;
                v124[3] = 1;
                v124[4] = 1;
                v124[5] = 1;
                v124[6] = 1;
                v109[14] = v124;
                yield v109;
            }
            default -> {
                int[][] v125 = new int[15][];
                int[] v126 = new int[8];
                v126[1] = 1;
                v126[2] = 1;
                v126[3] = 1;
                v126[4] = 1;
                v126[5] = 1;
                v126[6] = 1;
                v125[0] = v126;
                int[] v127 = new int[8];
                v127[7] = 1;
                v125[1] = v127;
                int[] v128 = new int[8];
                v128[7] = 1;
                v125[2] = v128;
                int[] v129 = new int[8];
                v129[7] = 1;
                v125[3] = v129;
                int[] v130 = new int[8];
                v130[7] = 1;
                v125[4] = v130;
                int[] v131 = new int[8];
                v131[7] = 1;
                v125[5] = v131;
                int[] v132 = new int[8];
                v132[7] = 1;
                v125[6] = v132;
                int[] v133 = new int[8];
                v133[1] = 1;
                v133[2] = 1;
                v133[3] = 1;
                v133[4] = 1;
                v133[5] = 1;
                v133[6] = 1;
                v125[7] = v133;
                int[] v134 = new int[8];
                v134[0] = 1;
                v125[8] = v134;
                int[] v135 = new int[8];
                v135[0] = 1;
                v125[9] = v135;
                int[] v136 = new int[8];
                v136[0] = 1;
                v125[10] = v136;
                int[] v137 = new int[8];
                v137[0] = 1;
                v125[11] = v137;
                int[] v138 = new int[8];
                v138[0] = 1;
                v125[12] = v138;
                int[] v139 = new int[8];
                v139[0] = 1;
                v125[13] = v139;
                int[] v140 = new int[8];
                v140[1] = 1;
                v140[2] = 1;
                v140[3] = 1;
                v140[4] = 1;
                v140[5] = 1;
                v140[6] = 1;
                v125[14] = v140;
                yield v125;
            }
        };
    }

    private int[][] toThree(int STEP) {
        return switch (STEP) {
            case 0 -> {
                int[][] v0 = new int[15][];
                int[] v1 = new int[8];
                v1[1] = 1;
                v1[2] = 1;
                v1[3] = 1;
                v1[4] = 1;
                v1[5] = 1;
                v1[6] = 1;
                v0[0] = v1;
                int[] v2 = new int[8];
                v2[7] = 1;
                v0[1] = v2;
                int[] v3 = new int[8];
                v3[7] = 1;
                v0[2] = v3;
                int[] v4 = new int[8];
                v4[7] = 1;
                v0[3] = v4;
                int[] v5 = new int[8];
                v5[7] = 1;
                v0[4] = v5;
                int[] v6 = new int[8];
                v6[7] = 1;
                v0[5] = v6;
                int[] v7 = new int[8];
                v7[7] = 1;
                v0[6] = v7;
                int[] v8 = new int[8];
                v8[1] = 1;
                v8[2] = 1;
                v8[3] = 1;
                v8[4] = 1;
                v8[5] = 1;
                v8[6] = 1;
                v0[7] = v8;
                int[] v9 = new int[8];
                v9[0] = 1;
                v0[8] = v9;
                int[] v10 = new int[8];
                v10[0] = 1;
                v0[9] = v10;
                int[] v11 = new int[8];
                v11[0] = 1;
                v0[10] = v11;
                int[] v12 = new int[8];
                v12[0] = 1;
                v0[11] = v12;
                int[] v13 = new int[8];
                v13[0] = 1;
                v0[12] = v13;
                int[] v14 = new int[8];
                v14[0] = 1;
                v0[13] = v14;
                int[] v15 = new int[8];
                v15[1] = 1;
                v15[2] = 1;
                v15[3] = 1;
                v15[4] = 1;
                v15[5] = 1;
                v15[6] = 1;
                v0[14] = v15;
                yield v0;
            }
            case 1 -> {
                int[][] v16 = new int[15][];
                int[] v17 = new int[8];
                v17[1] = 1;
                v17[2] = 1;
                v17[3] = 1;
                v17[4] = 1;
                v17[5] = 1;
                v17[6] = 1;
                v16[0] = v17;
                int[] v18 = new int[8];
                v18[7] = 1;
                v16[1] = v18;
                int[] v19 = new int[8];
                v19[7] = 1;
                v16[2] = v19;
                int[] v20 = new int[8];
                v20[7] = 1;
                v16[3] = v20;
                int[] v21 = new int[8];
                v21[7] = 1;
                v16[4] = v21;
                int[] v22 = new int[8];
                v22[7] = 1;
                v16[5] = v22;
                int[] v23 = new int[8];
                v23[7] = 1;
                v16[6] = v23;
                int[] v24 = new int[8];
                v24[1] = 1;
                v24[2] = 1;
                v24[3] = 1;
                v24[4] = 1;
                v24[5] = 1;
                v24[6] = 1;
                v16[7] = v24;
                int[] v25 = new int[8];
                v25[1] = 1;
                v16[8] = v25;
                int[] v26 = new int[8];
                v26[1] = 1;
                v16[9] = v26;
                int[] v27 = new int[8];
                v27[1] = 1;
                v16[10] = v27;
                int[] v28 = new int[8];
                v28[1] = 1;
                v16[11] = v28;
                int[] v29 = new int[8];
                v29[1] = 1;
                v16[12] = v29;
                int[] v30 = new int[8];
                v30[1] = 1;
                v16[13] = v30;
                int[] v31 = new int[8];
                v31[1] = 1;
                v31[2] = 1;
                v31[3] = 1;
                v31[4] = 1;
                v31[5] = 1;
                v31[6] = 1;
                v16[14] = v31;
                yield v16;
            }
            case 2 -> {
                int[][] v32 = new int[15][];
                int[] v33 = new int[8];
                v33[1] = 1;
                v33[2] = 1;
                v33[3] = 1;
                v33[4] = 1;
                v33[5] = 1;
                v33[6] = 1;
                v32[0] = v33;
                int[] v34 = new int[8];
                v34[7] = 1;
                v32[1] = v34;
                int[] v35 = new int[8];
                v35[7] = 1;
                v32[2] = v35;
                int[] v36 = new int[8];
                v36[7] = 1;
                v32[3] = v36;
                int[] v37 = new int[8];
                v37[7] = 1;
                v32[4] = v37;
                int[] v38 = new int[8];
                v38[7] = 1;
                v32[5] = v38;
                int[] v39 = new int[8];
                v39[7] = 1;
                v32[6] = v39;
                int[] v40 = new int[8];
                v40[1] = 1;
                v40[2] = 1;
                v40[3] = 1;
                v40[4] = 1;
                v40[5] = 1;
                v40[6] = 1;
                v32[7] = v40;
                int[] v41 = new int[8];
                v41[2] = 1;
                v32[8] = v41;
                int[] v42 = new int[8];
                v42[2] = 1;
                v32[9] = v42;
                int[] v43 = new int[8];
                v43[2] = 1;
                v32[10] = v43;
                int[] v44 = new int[8];
                v44[2] = 1;
                v32[11] = v44;
                int[] v45 = new int[8];
                v45[2] = 1;
                v32[12] = v45;
                int[] v46 = new int[8];
                v46[2] = 1;
                v32[13] = v46;
                int[] v47 = new int[8];
                v47[1] = 1;
                v47[2] = 1;
                v47[3] = 1;
                v47[4] = 1;
                v47[5] = 1;
                v47[6] = 1;
                v32[14] = v47;
                yield v32;
            }
            case 3 -> {
                int[][] v48 = new int[15][];
                int[] v49 = new int[8];
                v49[1] = 1;
                v49[2] = 1;
                v49[3] = 1;
                v49[4] = 1;
                v49[5] = 1;
                v49[6] = 1;
                v48[0] = v49;
                int[] v50 = new int[8];
                v50[7] = 1;
                v48[1] = v50;
                int[] v51 = new int[8];
                v51[7] = 1;
                v48[2] = v51;
                int[] v52 = new int[8];
                v52[7] = 1;
                v48[3] = v52;
                int[] v53 = new int[8];
                v53[7] = 1;
                v48[4] = v53;
                int[] v54 = new int[8];
                v54[7] = 1;
                v48[5] = v54;
                int[] v55 = new int[8];
                v55[7] = 1;
                v48[6] = v55;
                int[] v56 = new int[8];
                v56[1] = 1;
                v56[2] = 1;
                v56[3] = 1;
                v56[4] = 1;
                v56[5] = 1;
                v56[6] = 1;
                v48[7] = v56;
                int[] v57 = new int[8];
                v57[3] = 1;
                v48[8] = v57;
                int[] v58 = new int[8];
                v58[3] = 1;
                v48[9] = v58;
                int[] v59 = new int[8];
                v59[3] = 1;
                v48[10] = v59;
                int[] v60 = new int[8];
                v60[3] = 1;
                v48[11] = v60;
                int[] v61 = new int[8];
                v61[3] = 1;
                v48[12] = v61;
                int[] v62 = new int[8];
                v62[3] = 1;
                v48[13] = v62;
                int[] v63 = new int[8];
                v63[1] = 1;
                v63[2] = 1;
                v63[3] = 1;
                v63[4] = 1;
                v63[5] = 1;
                v63[6] = 1;
                v48[14] = v63;
                yield v48;
            }
            case 4 -> {
                int[][] v64 = new int[15][];
                int[] v65 = new int[8];
                v65[1] = 1;
                v65[2] = 1;
                v65[3] = 1;
                v65[4] = 1;
                v65[5] = 1;
                v65[6] = 1;
                v64[0] = v65;
                int[] v66 = new int[8];
                v66[7] = 1;
                v64[1] = v66;
                int[] v67 = new int[8];
                v67[7] = 1;
                v64[2] = v67;
                int[] v68 = new int[8];
                v68[7] = 1;
                v64[3] = v68;
                int[] v69 = new int[8];
                v69[7] = 1;
                v64[4] = v69;
                int[] v70 = new int[8];
                v70[7] = 1;
                v64[5] = v70;
                int[] v71 = new int[8];
                v71[7] = 1;
                v64[6] = v71;
                int[] v72 = new int[8];
                v72[1] = 1;
                v72[2] = 1;
                v72[3] = 1;
                v72[4] = 1;
                v72[5] = 1;
                v72[6] = 1;
                v64[7] = v72;
                int[] v73 = new int[8];
                v73[4] = 1;
                v64[8] = v73;
                int[] v74 = new int[8];
                v74[4] = 1;
                v64[9] = v74;
                int[] v75 = new int[8];
                v75[4] = 1;
                v64[10] = v75;
                int[] v76 = new int[8];
                v76[4] = 1;
                v64[11] = v76;
                int[] v77 = new int[8];
                v77[4] = 1;
                v64[12] = v77;
                int[] v78 = new int[8];
                v78[4] = 1;
                v64[13] = v78;
                int[] v79 = new int[8];
                v79[1] = 1;
                v79[2] = 1;
                v79[3] = 1;
                v79[4] = 1;
                v79[5] = 1;
                v79[6] = 1;
                v64[14] = v79;
                yield v64;
            }
            case 5 -> {
                int[][] v80 = new int[15][];
                int[] v81 = new int[8];
                v81[1] = 1;
                v81[2] = 1;
                v81[3] = 1;
                v81[4] = 1;
                v81[5] = 1;
                v81[6] = 1;
                v80[0] = v81;
                int[] v82 = new int[8];
                v82[7] = 1;
                v80[1] = v82;
                int[] v83 = new int[8];
                v83[7] = 1;
                v80[2] = v83;
                int[] v84 = new int[8];
                v84[7] = 1;
                v80[3] = v84;
                int[] v85 = new int[8];
                v85[7] = 1;
                v80[4] = v85;
                int[] v86 = new int[8];
                v86[7] = 1;
                v80[5] = v86;
                int[] v87 = new int[8];
                v87[7] = 1;
                v80[6] = v87;
                int[] v88 = new int[8];
                v88[1] = 1;
                v88[2] = 1;
                v88[3] = 1;
                v88[4] = 1;
                v88[5] = 1;
                v88[6] = 1;
                v80[7] = v88;
                int[] v89 = new int[8];
                v89[5] = 1;
                v80[8] = v89;
                int[] v90 = new int[8];
                v90[5] = 1;
                v80[9] = v90;
                int[] v91 = new int[8];
                v91[5] = 1;
                v80[10] = v91;
                int[] v92 = new int[8];
                v92[5] = 1;
                v80[11] = v92;
                int[] v93 = new int[8];
                v93[5] = 1;
                v80[12] = v93;
                int[] v94 = new int[8];
                v94[5] = 1;
                v80[13] = v94;
                int[] v95 = new int[8];
                v95[1] = 1;
                v95[2] = 1;
                v95[3] = 1;
                v95[4] = 1;
                v95[5] = 1;
                v95[6] = 1;
                v80[14] = v95;
                yield v80;
            }
            case 6 -> {
                int[][] v96 = new int[15][];
                int[] v97 = new int[8];
                v97[1] = 1;
                v97[2] = 1;
                v97[3] = 1;
                v97[4] = 1;
                v97[5] = 1;
                v97[6] = 1;
                v96[0] = v97;
                int[] v98 = new int[8];
                v98[7] = 1;
                v96[1] = v98;
                int[] v99 = new int[8];
                v99[7] = 1;
                v96[2] = v99;
                int[] v100 = new int[8];
                v100[7] = 1;
                v96[3] = v100;
                int[] v101 = new int[8];
                v101[7] = 1;
                v96[4] = v101;
                int[] v102 = new int[8];
                v102[7] = 1;
                v96[5] = v102;
                int[] v103 = new int[8];
                v103[7] = 1;
                v96[6] = v103;
                int[] v104 = new int[8];
                v104[1] = 1;
                v104[2] = 1;
                v104[3] = 1;
                v104[4] = 1;
                v104[5] = 1;
                v104[6] = 1;
                v96[7] = v104;
                int[] v105 = new int[8];
                v105[6] = 1;
                v96[8] = v105;
                int[] v106 = new int[8];
                v106[6] = 1;
                v96[9] = v106;
                int[] v107 = new int[8];
                v107[6] = 1;
                v96[10] = v107;
                int[] v108 = new int[8];
                v108[6] = 1;
                v96[11] = v108;
                int[] v109 = new int[8];
                v109[6] = 1;
                v96[12] = v109;
                int[] v110 = new int[8];
                v110[6] = 1;
                v96[13] = v110;
                int[] v111 = new int[8];
                v111[1] = 1;
                v111[2] = 1;
                v111[3] = 1;
                v111[4] = 1;
                v111[5] = 1;
                v111[6] = 1;
                v96[14] = v111;
                yield v96;
            }
            case 7 -> {
                int[][] v112 = new int[15][];
                int[] v113 = new int[8];
                v113[1] = 1;
                v113[2] = 1;
                v113[3] = 1;
                v113[4] = 1;
                v113[5] = 1;
                v113[6] = 1;
                v112[0] = v113;
                int[] v114 = new int[8];
                v114[7] = 1;
                v112[1] = v114;
                int[] v115 = new int[8];
                v115[7] = 1;
                v112[2] = v115;
                int[] v116 = new int[8];
                v116[7] = 1;
                v112[3] = v116;
                int[] v117 = new int[8];
                v117[7] = 1;
                v112[4] = v117;
                int[] v118 = new int[8];
                v118[7] = 1;
                v112[5] = v118;
                int[] v119 = new int[8];
                v119[7] = 1;
                v112[6] = v119;
                int[] v120 = new int[8];
                v120[1] = 1;
                v120[2] = 1;
                v120[3] = 1;
                v120[4] = 1;
                v120[5] = 1;
                v120[6] = 1;
                v112[7] = v120;
                int[] v121 = new int[8];
                v121[7] = 1;
                v112[8] = v121;
                int[] v122 = new int[8];
                v122[7] = 1;
                v112[9] = v122;
                int[] v123 = new int[8];
                v123[7] = 1;
                v112[10] = v123;
                int[] v124 = new int[8];
                v124[7] = 1;
                v112[11] = v124;
                int[] v125 = new int[8];
                v125[7] = 1;
                v112[12] = v125;
                int[] v126 = new int[8];
                v126[7] = 1;
                v112[13] = v126;
                int[] v127 = new int[8];
                v127[1] = 1;
                v127[2] = 1;
                v127[3] = 1;
                v127[4] = 1;
                v127[5] = 1;
                v127[6] = 1;
                v112[14] = v127;
                yield v112;
            }
            default -> {
                int[][] v128 = new int[15][];
                int[] v129 = new int[8];
                v129[1] = 1;
                v129[2] = 1;
                v129[3] = 1;
                v129[4] = 1;
                v129[5] = 1;
                v129[6] = 1;
                v128[0] = v129;
                int[] v130 = new int[8];
                v130[7] = 1;
                v128[1] = v130;
                int[] v131 = new int[8];
                v131[7] = 1;
                v128[2] = v131;
                int[] v132 = new int[8];
                v132[7] = 1;
                v128[3] = v132;
                int[] v133 = new int[8];
                v133[7] = 1;
                v128[4] = v133;
                int[] v134 = new int[8];
                v134[7] = 1;
                v128[5] = v134;
                int[] v135 = new int[8];
                v135[7] = 1;
                v128[6] = v135;
                int[] v136 = new int[8];
                v136[1] = 1;
                v136[2] = 1;
                v136[3] = 1;
                v136[4] = 1;
                v136[5] = 1;
                v136[6] = 1;
                v128[7] = v136;
                int[] v137 = new int[8];
                v137[7] = 1;
                v128[8] = v137;
                int[] v138 = new int[8];
                v138[7] = 1;
                v128[9] = v138;
                int[] v139 = new int[8];
                v139[7] = 1;
                v128[10] = v139;
                int[] v140 = new int[8];
                v140[7] = 1;
                v128[11] = v140;
                int[] v141 = new int[8];
                v141[7] = 1;
                v128[12] = v141;
                int[] v142 = new int[8];
                v142[7] = 1;
                v128[13] = v142;
                int[] v143 = new int[8];
                v143[1] = 1;
                v143[2] = 1;
                v143[3] = 1;
                v143[4] = 1;
                v143[5] = 1;
                v143[6] = 1;
                v128[14] = v143;
                yield v128;
            }
        };
    }

    private int[][] toFour(int STEP) {
        return switch (STEP) {
            case 0 -> {
                int[][] v0 = new int[15][];
                int[] v1 = new int[8];
                v1[1] = 1;
                v1[2] = 1;
                v1[3] = 1;
                v1[4] = 1;
                v1[5] = 1;
                v1[6] = 1;
                v0[0] = v1;
                int[] v2 = new int[8];
                v2[7] = 1;
                v0[1] = v2;
                int[] v3 = new int[8];
                v3[7] = 1;
                v0[2] = v3;
                int[] v4 = new int[8];
                v4[7] = 1;
                v0[3] = v4;
                int[] v5 = new int[8];
                v5[7] = 1;
                v0[4] = v5;
                int[] v6 = new int[8];
                v6[7] = 1;
                v0[5] = v6;
                int[] v7 = new int[8];
                v7[7] = 1;
                v0[6] = v7;
                int[] v8 = new int[8];
                v8[1] = 1;
                v8[2] = 1;
                v8[3] = 1;
                v8[4] = 1;
                v8[5] = 1;
                v8[6] = 1;
                v0[7] = v8;
                int[] v9 = new int[8];
                v9[7] = 1;
                v0[8] = v9;
                int[] v10 = new int[8];
                v10[7] = 1;
                v0[9] = v10;
                int[] v11 = new int[8];
                v11[7] = 1;
                v0[10] = v11;
                int[] v12 = new int[8];
                v12[7] = 1;
                v0[11] = v12;
                int[] v13 = new int[8];
                v13[7] = 1;
                v0[12] = v13;
                int[] v14 = new int[8];
                v14[7] = 1;
                v0[13] = v14;
                int[] v15 = new int[8];
                v15[1] = 1;
                v15[2] = 1;
                v15[3] = 1;
                v15[4] = 1;
                v15[5] = 1;
                v15[6] = 1;
                v0[14] = v15;
                yield v0;
            }
            case 1 -> {
                int[][] v16 = new int[15][];
                int[] v17 = new int[8];
                v17[1] = 1;
                v17[2] = 1;
                v17[3] = 1;
                v17[4] = 1;
                v17[5] = 1;
                v16[0] = v17;
                int[] v18 = new int[8];
                v18[0] = 1;
                v18[7] = 1;
                v16[1] = v18;
                int[] v19 = new int[8];
                v19[7] = 1;
                v16[2] = v19;
                int[] v20 = new int[8];
                v20[7] = 1;
                v16[3] = v20;
                int[] v21 = new int[8];
                v21[7] = 1;
                v16[4] = v21;
                int[] v22 = new int[8];
                v22[7] = 1;
                v16[5] = v22;
                int[] v23 = new int[8];
                v23[7] = 1;
                v16[6] = v23;
                int[] v24 = new int[8];
                v24[1] = 1;
                v24[2] = 1;
                v24[3] = 1;
                v24[4] = 1;
                v24[5] = 1;
                v24[6] = 1;
                v16[7] = v24;
                int[] v25 = new int[8];
                v25[7] = 1;
                v16[8] = v25;
                int[] v26 = new int[8];
                v26[7] = 1;
                v16[9] = v26;
                int[] v27 = new int[8];
                v27[7] = 1;
                v16[10] = v27;
                int[] v28 = new int[8];
                v28[7] = 1;
                v16[11] = v28;
                int[] v29 = new int[8];
                v29[7] = 1;
                v16[12] = v29;
                int[] v30 = new int[8];
                v30[7] = 1;
                v16[13] = v30;
                int[] v31 = new int[8];
                v31[2] = 1;
                v31[3] = 1;
                v31[4] = 1;
                v31[5] = 1;
                v31[6] = 1;
                v16[14] = v31;
                yield v16;
            }
            case 2 -> {
                int[][] v32 = new int[15][];
                int[] v33 = new int[8];
                v33[1] = 1;
                v33[2] = 1;
                v33[3] = 1;
                v33[4] = 1;
                v32[0] = v33;
                int[] v34 = new int[8];
                v34[0] = 1;
                v34[7] = 1;
                v32[1] = v34;
                int[] v35 = new int[8];
                v35[0] = 1;
                v35[7] = 1;
                v32[2] = v35;
                int[] v36 = new int[8];
                v36[7] = 1;
                v32[3] = v36;
                int[] v37 = new int[8];
                v37[7] = 1;
                v32[4] = v37;
                int[] v38 = new int[8];
                v38[7] = 1;
                v32[5] = v38;
                int[] v39 = new int[8];
                v39[7] = 1;
                v32[6] = v39;
                int[] v40 = new int[8];
                v40[1] = 1;
                v40[2] = 1;
                v40[3] = 1;
                v40[4] = 1;
                v40[5] = 1;
                v40[6] = 1;
                v32[7] = v40;
                int[] v41 = new int[8];
                v41[7] = 1;
                v32[8] = v41;
                int[] v42 = new int[8];
                v42[7] = 1;
                v32[9] = v42;
                int[] v43 = new int[8];
                v43[7] = 1;
                v32[10] = v43;
                int[] v44 = new int[8];
                v44[7] = 1;
                v32[11] = v44;
                int[] v45 = new int[8];
                v45[7] = 1;
                v32[12] = v45;
                int[] v46 = new int[8];
                v46[7] = 1;
                v32[13] = v46;
                int[] v47 = new int[8];
                v47[3] = 1;
                v47[4] = 1;
                v47[5] = 1;
                v47[6] = 1;
                v32[14] = v47;
                yield v32;
            }
            case 3 -> {
                int[][] v48 = new int[15][];
                int[] v49 = new int[8];
                v49[1] = 1;
                v49[2] = 1;
                v49[3] = 1;
                v48[0] = v49;
                int[] v50 = new int[8];
                v50[0] = 1;
                v50[7] = 1;
                v48[1] = v50;
                int[] v51 = new int[8];
                v51[0] = 1;
                v51[7] = 1;
                v48[2] = v51;
                int[] v52 = new int[8];
                v52[0] = 1;
                v52[7] = 1;
                v48[3] = v52;
                int[] v53 = new int[8];
                v53[7] = 1;
                v48[4] = v53;
                int[] v54 = new int[8];
                v54[7] = 1;
                v48[5] = v54;
                int[] v55 = new int[8];
                v55[7] = 1;
                v48[6] = v55;
                int[] v56 = new int[8];
                v56[1] = 1;
                v56[2] = 1;
                v56[3] = 1;
                v56[4] = 1;
                v56[5] = 1;
                v56[6] = 1;
                v48[7] = v56;
                int[] v57 = new int[8];
                v57[7] = 1;
                v48[8] = v57;
                int[] v58 = new int[8];
                v58[7] = 1;
                v48[9] = v58;
                int[] v59 = new int[8];
                v59[7] = 1;
                v48[10] = v59;
                int[] v60 = new int[8];
                v60[7] = 1;
                v48[11] = v60;
                int[] v61 = new int[8];
                v61[7] = 1;
                v48[12] = v61;
                int[] v62 = new int[8];
                v62[7] = 1;
                v48[13] = v62;
                int[] v63 = new int[8];
                v63[4] = 1;
                v63[5] = 1;
                v63[6] = 1;
                v48[14] = v63;
                yield v48;
            }
            case 4 -> {
                int[][] v64 = new int[15][];
                int[] v65 = new int[8];
                v65[1] = 1;
                v65[2] = 1;
                v64[0] = v65;
                int[] v66 = new int[8];
                v66[0] = 1;
                v66[7] = 1;
                v64[1] = v66;
                int[] v67 = new int[8];
                v67[0] = 1;
                v67[7] = 1;
                v64[2] = v67;
                int[] v68 = new int[8];
                v68[0] = 1;
                v68[7] = 1;
                v64[3] = v68;
                int[] v69 = new int[8];
                v69[0] = 1;
                v69[7] = 1;
                v64[4] = v69;
                int[] v70 = new int[8];
                v70[7] = 1;
                v64[5] = v70;
                int[] v71 = new int[8];
                v71[7] = 1;
                v64[6] = v71;
                int[] v72 = new int[8];
                v72[1] = 1;
                v72[2] = 1;
                v72[3] = 1;
                v72[4] = 1;
                v72[5] = 1;
                v72[6] = 1;
                v64[7] = v72;
                int[] v73 = new int[8];
                v73[7] = 1;
                v64[8] = v73;
                int[] v74 = new int[8];
                v74[7] = 1;
                v64[9] = v74;
                int[] v75 = new int[8];
                v75[7] = 1;
                v64[10] = v75;
                int[] v76 = new int[8];
                v76[7] = 1;
                v64[11] = v76;
                int[] v77 = new int[8];
                v77[7] = 1;
                v64[12] = v77;
                int[] v78 = new int[8];
                v78[7] = 1;
                v64[13] = v78;
                int[] v79 = new int[8];
                v79[5] = 1;
                v79[6] = 1;
                v64[14] = v79;
                yield v64;
            }
            case 5 -> {
                int[][] v80 = new int[15][];
                int[] v81 = new int[8];
                v81[1] = 1;
                v80[0] = v81;
                int[] v82 = new int[8];
                v82[0] = 1;
                v82[7] = 1;
                v80[1] = v82;
                int[] v83 = new int[8];
                v83[0] = 1;
                v83[7] = 1;
                v80[2] = v83;
                int[] v84 = new int[8];
                v84[0] = 1;
                v84[7] = 1;
                v80[3] = v84;
                int[] v85 = new int[8];
                v85[0] = 1;
                v85[7] = 1;
                v80[4] = v85;
                int[] v86 = new int[8];
                v86[0] = 1;
                v86[7] = 1;
                v80[5] = v86;
                int[] v87 = new int[8];
                v87[7] = 1;
                v80[6] = v87;
                int[] v88 = new int[8];
                v88[1] = 1;
                v88[2] = 1;
                v88[3] = 1;
                v88[4] = 1;
                v88[5] = 1;
                v88[6] = 1;
                v80[7] = v88;
                int[] v89 = new int[8];
                v89[7] = 1;
                v80[8] = v89;
                int[] v90 = new int[8];
                v90[7] = 1;
                v80[9] = v90;
                int[] v91 = new int[8];
                v91[7] = 1;
                v80[10] = v91;
                int[] v92 = new int[8];
                v92[7] = 1;
                v80[11] = v92;
                int[] v93 = new int[8];
                v93[7] = 1;
                v80[12] = v93;
                int[] v94 = new int[8];
                v94[7] = 1;
                v80[13] = v94;
                int[] v95 = new int[8];
                v95[6] = 1;
                v80[14] = v95;
                yield v80;
            }
            case 6 -> {
                int[][] v96 = new int[15][];
                v96[0] = new int[8];
                int[] v97 = new int[8];
                v97[0] = 1;
                v97[7] = 1;
                v96[1] = v97;
                int[] v98 = new int[8];
                v98[0] = 1;
                v98[7] = 1;
                v96[2] = v98;
                int[] v99 = new int[8];
                v99[0] = 1;
                v99[7] = 1;
                v96[3] = v99;
                int[] v100 = new int[8];
                v100[0] = 1;
                v100[7] = 1;
                v96[4] = v100;
                int[] v101 = new int[8];
                v101[0] = 1;
                v101[7] = 1;
                v96[5] = v101;
                int[] v102 = new int[8];
                v102[0] = 1;
                v102[7] = 1;
                v96[6] = v102;
                int[] v103 = new int[8];
                v103[1] = 1;
                v103[2] = 1;
                v103[3] = 1;
                v103[4] = 1;
                v103[5] = 1;
                v103[6] = 1;
                v96[7] = v103;
                int[] v104 = new int[8];
                v104[7] = 1;
                v96[8] = v104;
                int[] v105 = new int[8];
                v105[7] = 1;
                v96[9] = v105;
                int[] v106 = new int[8];
                v106[7] = 1;
                v96[10] = v106;
                int[] v107 = new int[8];
                v107[7] = 1;
                v96[11] = v107;
                int[] v108 = new int[8];
                v108[7] = 1;
                v96[12] = v108;
                int[] v109 = new int[8];
                v109[7] = 1;
                v96[13] = v109;
                v96[14] = new int[8];
                yield v96;
            }
            case 7 -> {
                int[][] v110 = new int[15][];
                v110[0] = new int[8];
                int[] v111 = new int[8];
                v111[0] = 1;
                v111[7] = 1;
                v110[1] = v111;
                int[] v112 = new int[8];
                v112[0] = 1;
                v112[7] = 1;
                v110[2] = v112;
                int[] v113 = new int[8];
                v113[0] = 1;
                v113[7] = 1;
                v110[3] = v113;
                int[] v114 = new int[8];
                v114[0] = 1;
                v114[7] = 1;
                v110[4] = v114;
                int[] v115 = new int[8];
                v115[0] = 1;
                v115[7] = 1;
                v110[5] = v115;
                int[] v116 = new int[8];
                v116[0] = 1;
                v116[7] = 1;
                v110[6] = v116;
                int[] v117 = new int[8];
                v117[1] = 1;
                v117[2] = 1;
                v117[3] = 1;
                v117[4] = 1;
                v117[5] = 1;
                v117[6] = 1;
                v110[7] = v117;
                int[] v118 = new int[8];
                v118[7] = 1;
                v110[8] = v118;
                int[] v119 = new int[8];
                v119[7] = 1;
                v110[9] = v119;
                int[] v120 = new int[8];
                v120[7] = 1;
                v110[10] = v120;
                int[] v121 = new int[8];
                v121[7] = 1;
                v110[11] = v121;
                int[] v122 = new int[8];
                v122[7] = 1;
                v110[12] = v122;
                int[] v123 = new int[8];
                v123[7] = 1;
                v110[13] = v123;
                v110[14] = new int[8];
                yield v110;
            }
            default -> {
                int[][] v124 = new int[15][];
                v124[0] = new int[8];
                int[] v125 = new int[8];
                v125[0] = 1;
                v125[7] = 1;
                v124[1] = v125;
                int[] v126 = new int[8];
                v126[0] = 1;
                v126[7] = 1;
                v124[2] = v126;
                int[] v127 = new int[8];
                v127[0] = 1;
                v127[7] = 1;
                v124[3] = v127;
                int[] v128 = new int[8];
                v128[0] = 1;
                v128[7] = 1;
                v124[4] = v128;
                int[] v129 = new int[8];
                v129[0] = 1;
                v129[7] = 1;
                v124[5] = v129;
                int[] v130 = new int[8];
                v130[0] = 1;
                v130[7] = 1;
                v124[6] = v130;
                int[] v131 = new int[8];
                v131[1] = 1;
                v131[2] = 1;
                v131[3] = 1;
                v131[4] = 1;
                v131[5] = 1;
                v131[6] = 1;
                v124[7] = v131;
                int[] v132 = new int[8];
                v132[7] = 1;
                v124[8] = v132;
                int[] v133 = new int[8];
                v133[7] = 1;
                v124[9] = v133;
                int[] v134 = new int[8];
                v134[7] = 1;
                v124[10] = v134;
                int[] v135 = new int[8];
                v135[7] = 1;
                v124[11] = v135;
                int[] v136 = new int[8];
                v136[7] = 1;
                v124[12] = v136;
                int[] v137 = new int[8];
                v137[7] = 1;
                v124[13] = v137;
                v124[14] = new int[8];
                yield v124;
            }
        };
    }

    private int[][] toFive(int STEP) {
        return switch (STEP) {
            case 0 -> {
                int[][] v0 = new int[15][];
                v0[0] = new int[8];
                int[] v1 = new int[8];
                v1[0] = 1;
                v1[7] = 1;
                v0[1] = v1;
                int[] v2 = new int[8];
                v2[0] = 1;
                v2[7] = 1;
                v0[2] = v2;
                int[] v3 = new int[8];
                v3[0] = 1;
                v3[7] = 1;
                v0[3] = v3;
                int[] v4 = new int[8];
                v4[0] = 1;
                v4[7] = 1;
                v0[4] = v4;
                int[] v5 = new int[8];
                v5[0] = 1;
                v5[7] = 1;
                v0[5] = v5;
                int[] v6 = new int[8];
                v6[0] = 1;
                v6[7] = 1;
                v0[6] = v6;
                int[] v7 = new int[8];
                v7[1] = 1;
                v7[2] = 1;
                v7[3] = 1;
                v7[4] = 1;
                v7[5] = 1;
                v7[6] = 1;
                v0[7] = v7;
                int[] v8 = new int[8];
                v8[7] = 1;
                v0[8] = v8;
                int[] v9 = new int[8];
                v9[7] = 1;
                v0[9] = v9;
                int[] v10 = new int[8];
                v10[7] = 1;
                v0[10] = v10;
                int[] v11 = new int[8];
                v11[7] = 1;
                v0[11] = v11;
                int[] v12 = new int[8];
                v12[7] = 1;
                v0[12] = v12;
                int[] v13 = new int[8];
                v13[7] = 1;
                v0[13] = v13;
                v0[14] = new int[8];
                yield v0;
            }
            case 1 -> {
                int[][] v14 = new int[15][];
                int[] v15 = new int[8];
                v15[6] = 1;
                v14[0] = v15;
                int[] v16 = new int[8];
                v16[0] = 1;
                v16[7] = 1;
                v14[1] = v16;
                int[] v17 = new int[8];
                v17[0] = 1;
                v17[7] = 1;
                v14[2] = v17;
                int[] v18 = new int[8];
                v18[0] = 1;
                v18[7] = 1;
                v14[3] = v18;
                int[] v19 = new int[8];
                v19[0] = 1;
                v19[7] = 1;
                v14[4] = v19;
                int[] v20 = new int[8];
                v20[0] = 1;
                v20[7] = 1;
                v14[5] = v20;
                int[] v21 = new int[8];
                v21[0] = 1;
                v14[6] = v21;
                int[] v22 = new int[8];
                v22[1] = 1;
                v22[2] = 1;
                v22[3] = 1;
                v22[4] = 1;
                v22[5] = 1;
                v22[6] = 1;
                v14[7] = v22;
                int[] v23 = new int[8];
                v23[7] = 1;
                v14[8] = v23;
                int[] v24 = new int[8];
                v24[7] = 1;
                v14[9] = v24;
                int[] v25 = new int[8];
                v25[7] = 1;
                v14[10] = v25;
                int[] v26 = new int[8];
                v26[7] = 1;
                v14[11] = v26;
                int[] v27 = new int[8];
                v27[7] = 1;
                v14[12] = v27;
                int[] v28 = new int[8];
                v28[7] = 1;
                v14[13] = v28;
                int[] v29 = new int[8];
                v29[6] = 1;
                v14[14] = v29;
                yield v14;
            }
            case 2 -> {
                int[][] v30 = new int[15][];
                int[] v31 = new int[8];
                v31[5] = 1;
                v31[6] = 1;
                v30[0] = v31;
                int[] v32 = new int[8];
                v32[0] = 1;
                v32[7] = 1;
                v30[1] = v32;
                int[] v33 = new int[8];
                v33[0] = 1;
                v33[7] = 1;
                v30[2] = v33;
                int[] v34 = new int[8];
                v34[0] = 1;
                v34[7] = 1;
                v30[3] = v34;
                int[] v35 = new int[8];
                v35[0] = 1;
                v35[7] = 1;
                v30[4] = v35;
                int[] v36 = new int[8];
                v36[0] = 1;
                v30[5] = v36;
                int[] v37 = new int[8];
                v37[0] = 1;
                v30[6] = v37;
                int[] v38 = new int[8];
                v38[1] = 1;
                v38[2] = 1;
                v38[3] = 1;
                v38[4] = 1;
                v38[5] = 1;
                v38[6] = 1;
                v30[7] = v38;
                int[] v39 = new int[8];
                v39[7] = 1;
                v30[8] = v39;
                int[] v40 = new int[8];
                v40[7] = 1;
                v30[9] = v40;
                int[] v41 = new int[8];
                v41[7] = 1;
                v30[10] = v41;
                int[] v42 = new int[8];
                v42[7] = 1;
                v30[11] = v42;
                int[] v43 = new int[8];
                v43[7] = 1;
                v30[12] = v43;
                int[] v44 = new int[8];
                v44[7] = 1;
                v30[13] = v44;
                int[] v45 = new int[8];
                v45[5] = 1;
                v45[6] = 1;
                v30[14] = v45;
                yield v30;
            }
            case 3 -> {
                int[][] v46 = new int[15][];
                int[] v47 = new int[8];
                v47[4] = 1;
                v47[5] = 1;
                v47[6] = 1;
                v46[0] = v47;
                int[] v48 = new int[8];
                v48[0] = 1;
                v48[7] = 1;
                v46[1] = v48;
                int[] v49 = new int[8];
                v49[0] = 1;
                v49[7] = 1;
                v46[2] = v49;
                int[] v50 = new int[8];
                v50[0] = 1;
                v50[7] = 1;
                v46[3] = v50;
                int[] v51 = new int[8];
                v51[0] = 1;
                v46[4] = v51;
                int[] v52 = new int[8];
                v52[0] = 1;
                v46[5] = v52;
                int[] v53 = new int[8];
                v53[0] = 1;
                v46[6] = v53;
                int[] v54 = new int[8];
                v54[1] = 1;
                v54[2] = 1;
                v54[3] = 1;
                v54[4] = 1;
                v54[5] = 1;
                v54[6] = 1;
                v46[7] = v54;
                int[] v55 = new int[8];
                v55[7] = 1;
                v46[8] = v55;
                int[] v56 = new int[8];
                v56[7] = 1;
                v46[9] = v56;
                int[] v57 = new int[8];
                v57[7] = 1;
                v46[10] = v57;
                int[] v58 = new int[8];
                v58[7] = 1;
                v46[11] = v58;
                int[] v59 = new int[8];
                v59[7] = 1;
                v46[12] = v59;
                int[] v60 = new int[8];
                v60[7] = 1;
                v46[13] = v60;
                int[] v61 = new int[8];
                v61[4] = 1;
                v61[5] = 1;
                v61[6] = 1;
                v46[14] = v61;
                yield v46;
            }
            case 4 -> {
                int[][] v62 = new int[15][];
                int[] v63 = new int[8];
                v63[3] = 1;
                v63[4] = 1;
                v63[5] = 1;
                v63[6] = 1;
                v62[0] = v63;
                int[] v64 = new int[8];
                v64[0] = 1;
                v64[7] = 1;
                v62[1] = v64;
                int[] v65 = new int[8];
                v65[0] = 1;
                v65[7] = 1;
                v62[2] = v65;
                int[] v66 = new int[8];
                v66[0] = 1;
                v62[3] = v66;
                int[] v67 = new int[8];
                v67[0] = 1;
                v62[4] = v67;
                int[] v68 = new int[8];
                v68[0] = 1;
                v62[5] = v68;
                int[] v69 = new int[8];
                v69[0] = 1;
                v62[6] = v69;
                int[] v70 = new int[8];
                v70[1] = 1;
                v70[2] = 1;
                v70[3] = 1;
                v70[4] = 1;
                v70[5] = 1;
                v70[6] = 1;
                v62[7] = v70;
                int[] v71 = new int[8];
                v71[7] = 1;
                v62[8] = v71;
                int[] v72 = new int[8];
                v72[7] = 1;
                v62[9] = v72;
                int[] v73 = new int[8];
                v73[7] = 1;
                v62[10] = v73;
                int[] v74 = new int[8];
                v74[7] = 1;
                v62[11] = v74;
                int[] v75 = new int[8];
                v75[7] = 1;
                v62[12] = v75;
                int[] v76 = new int[8];
                v76[7] = 1;
                v62[13] = v76;
                int[] v77 = new int[8];
                v77[3] = 1;
                v77[4] = 1;
                v77[5] = 1;
                v77[6] = 1;
                v62[14] = v77;
                yield v62;
            }
            case 5 -> {
                int[][] v78 = new int[15][];
                int[] v79 = new int[8];
                v79[2] = 1;
                v79[3] = 1;
                v79[4] = 1;
                v79[5] = 1;
                v79[6] = 1;
                v78[0] = v79;
                int[] v80 = new int[8];
                v80[0] = 1;
                v80[7] = 1;
                v78[1] = v80;
                int[] v81 = new int[8];
                v81[0] = 1;
                v78[2] = v81;
                int[] v82 = new int[8];
                v82[0] = 1;
                v78[3] = v82;
                int[] v83 = new int[8];
                v83[0] = 1;
                v78[4] = v83;
                int[] v84 = new int[8];
                v84[0] = 1;
                v78[5] = v84;
                int[] v85 = new int[8];
                v85[0] = 1;
                v78[6] = v85;
                int[] v86 = new int[8];
                v86[1] = 1;
                v86[2] = 1;
                v86[3] = 1;
                v86[4] = 1;
                v86[5] = 1;
                v86[6] = 1;
                v78[7] = v86;
                int[] v87 = new int[8];
                v87[7] = 1;
                v78[8] = v87;
                int[] v88 = new int[8];
                v88[7] = 1;
                v78[9] = v88;
                int[] v89 = new int[8];
                v89[7] = 1;
                v78[10] = v89;
                int[] v90 = new int[8];
                v90[7] = 1;
                v78[11] = v90;
                int[] v91 = new int[8];
                v91[7] = 1;
                v78[12] = v91;
                int[] v92 = new int[8];
                v92[7] = 1;
                v78[13] = v92;
                int[] v93 = new int[8];
                v93[2] = 1;
                v93[3] = 1;
                v93[4] = 1;
                v93[5] = 1;
                v93[6] = 1;
                v78[14] = v93;
                yield v78;
            }
            case 6 -> {
                int[][] v94 = new int[15][];
                int[] v95 = new int[8];
                v95[1] = 1;
                v95[2] = 1;
                v95[3] = 1;
                v95[4] = 1;
                v95[5] = 1;
                v95[6] = 1;
                v94[0] = v95;
                int[] v96 = new int[8];
                v96[0] = 1;
                v94[1] = v96;
                int[] v97 = new int[8];
                v97[0] = 1;
                v94[2] = v97;
                int[] v98 = new int[8];
                v98[0] = 1;
                v94[3] = v98;
                int[] v99 = new int[8];
                v99[0] = 1;
                v94[4] = v99;
                int[] v100 = new int[8];
                v100[0] = 1;
                v94[5] = v100;
                int[] v101 = new int[8];
                v101[0] = 1;
                v94[6] = v101;
                int[] v102 = new int[8];
                v102[1] = 1;
                v102[2] = 1;
                v102[3] = 1;
                v102[4] = 1;
                v102[5] = 1;
                v102[6] = 1;
                v94[7] = v102;
                int[] v103 = new int[8];
                v103[7] = 1;
                v94[8] = v103;
                int[] v104 = new int[8];
                v104[7] = 1;
                v94[9] = v104;
                int[] v105 = new int[8];
                v105[7] = 1;
                v94[10] = v105;
                int[] v106 = new int[8];
                v106[7] = 1;
                v94[11] = v106;
                int[] v107 = new int[8];
                v107[7] = 1;
                v94[12] = v107;
                int[] v108 = new int[8];
                v108[7] = 1;
                v94[13] = v108;
                int[] v109 = new int[8];
                v109[1] = 1;
                v109[2] = 1;
                v109[3] = 1;
                v109[4] = 1;
                v109[5] = 1;
                v109[6] = 1;
                v94[14] = v109;
                yield v94;
            }
            case 7 -> {
                int[][] v110 = new int[15][];
                int[] v111 = new int[8];
                v111[1] = 1;
                v111[2] = 1;
                v111[3] = 1;
                v111[4] = 1;
                v111[5] = 1;
                v111[6] = 1;
                v110[0] = v111;
                int[] v112 = new int[8];
                v112[0] = 1;
                v110[1] = v112;
                int[] v113 = new int[8];
                v113[0] = 1;
                v110[2] = v113;
                int[] v114 = new int[8];
                v114[0] = 1;
                v110[3] = v114;
                int[] v115 = new int[8];
                v115[0] = 1;
                v110[4] = v115;
                int[] v116 = new int[8];
                v116[0] = 1;
                v110[5] = v116;
                int[] v117 = new int[8];
                v117[0] = 1;
                v110[6] = v117;
                int[] v118 = new int[8];
                v118[1] = 1;
                v118[2] = 1;
                v118[3] = 1;
                v118[4] = 1;
                v118[5] = 1;
                v118[6] = 1;
                v110[7] = v118;
                int[] v119 = new int[8];
                v119[7] = 1;
                v110[8] = v119;
                int[] v120 = new int[8];
                v120[7] = 1;
                v110[9] = v120;
                int[] v121 = new int[8];
                v121[7] = 1;
                v110[10] = v121;
                int[] v122 = new int[8];
                v122[7] = 1;
                v110[11] = v122;
                int[] v123 = new int[8];
                v123[7] = 1;
                v110[12] = v123;
                int[] v124 = new int[8];
                v124[7] = 1;
                v110[13] = v124;
                int[] v125 = new int[8];
                v125[1] = 1;
                v125[2] = 1;
                v125[3] = 1;
                v125[4] = 1;
                v125[5] = 1;
                v125[6] = 1;
                v110[14] = v125;
                yield v110;
            }
            default -> {
                int[][] v126 = new int[15][];
                int[] v127 = new int[8];
                v127[1] = 1;
                v127[2] = 1;
                v127[3] = 1;
                v127[4] = 1;
                v127[5] = 1;
                v127[6] = 1;
                v126[0] = v127;
                int[] v128 = new int[8];
                v128[0] = 1;
                v126[1] = v128;
                int[] v129 = new int[8];
                v129[0] = 1;
                v126[2] = v129;
                int[] v130 = new int[8];
                v130[0] = 1;
                v126[3] = v130;
                int[] v131 = new int[8];
                v131[0] = 1;
                v126[4] = v131;
                int[] v132 = new int[8];
                v132[0] = 1;
                v126[5] = v132;
                int[] v133 = new int[8];
                v133[0] = 1;
                v126[6] = v133;
                int[] v134 = new int[8];
                v134[1] = 1;
                v134[2] = 1;
                v134[3] = 1;
                v134[4] = 1;
                v134[5] = 1;
                v134[6] = 1;
                v126[7] = v134;
                int[] v135 = new int[8];
                v135[7] = 1;
                v126[8] = v135;
                int[] v136 = new int[8];
                v136[7] = 1;
                v126[9] = v136;
                int[] v137 = new int[8];
                v137[7] = 1;
                v126[10] = v137;
                int[] v138 = new int[8];
                v138[7] = 1;
                v126[11] = v138;
                int[] v139 = new int[8];
                v139[7] = 1;
                v126[12] = v139;
                int[] v140 = new int[8];
                v140[7] = 1;
                v126[13] = v140;
                int[] v141 = new int[8];
                v141[1] = 1;
                v141[2] = 1;
                v141[3] = 1;
                v141[4] = 1;
                v141[5] = 1;
                v141[6] = 1;
                v126[14] = v141;
                yield v126;
            }
        };
    }

    private int[][] toSix(int STEP) {
        return switch (STEP) {
            case 0 -> {
                int[][] v0 = new int[15][];
                int[] v1 = new int[8];
                v1[1] = 1;
                v1[2] = 1;
                v1[3] = 1;
                v1[4] = 1;
                v1[5] = 1;
                v1[6] = 1;
                v0[0] = v1;
                int[] v2 = new int[8];
                v2[0] = 1;
                v0[1] = v2;
                int[] v3 = new int[8];
                v3[0] = 1;
                v0[2] = v3;
                int[] v4 = new int[8];
                v4[0] = 1;
                v0[3] = v4;
                int[] v5 = new int[8];
                v5[0] = 1;
                v0[4] = v5;
                int[] v6 = new int[8];
                v6[0] = 1;
                v0[5] = v6;
                int[] v7 = new int[8];
                v7[0] = 1;
                v0[6] = v7;
                int[] v8 = new int[8];
                v8[1] = 1;
                v8[2] = 1;
                v8[3] = 1;
                v8[4] = 1;
                v8[5] = 1;
                v8[6] = 1;
                v0[7] = v8;
                int[] v9 = new int[8];
                v9[7] = 1;
                v0[8] = v9;
                int[] v10 = new int[8];
                v10[7] = 1;
                v0[9] = v10;
                int[] v11 = new int[8];
                v11[7] = 1;
                v0[10] = v11;
                int[] v12 = new int[8];
                v12[7] = 1;
                v0[11] = v12;
                int[] v13 = new int[8];
                v13[7] = 1;
                v0[12] = v13;
                int[] v14 = new int[8];
                v14[7] = 1;
                v0[13] = v14;
                int[] v15 = new int[8];
                v15[1] = 1;
                v15[2] = 1;
                v15[3] = 1;
                v15[4] = 1;
                v15[5] = 1;
                v15[6] = 1;
                v0[14] = v15;
                yield v0;
            }
            case 1 -> {
                int[][] v16 = new int[15][];
                int[] v17 = new int[8];
                v17[1] = 1;
                v17[2] = 1;
                v17[3] = 1;
                v17[4] = 1;
                v17[5] = 1;
                v17[6] = 1;
                v16[0] = v17;
                int[] v18 = new int[8];
                v18[0] = 1;
                v16[1] = v18;
                int[] v19 = new int[8];
                v19[0] = 1;
                v16[2] = v19;
                int[] v20 = new int[8];
                v20[0] = 1;
                v16[3] = v20;
                int[] v21 = new int[8];
                v21[0] = 1;
                v16[4] = v21;
                int[] v22 = new int[8];
                v22[0] = 1;
                v16[5] = v22;
                int[] v23 = new int[8];
                v23[0] = 1;
                v16[6] = v23;
                int[] v24 = new int[8];
                v24[1] = 1;
                v24[2] = 1;
                v24[3] = 1;
                v24[4] = 1;
                v24[5] = 1;
                v24[6] = 1;
                v16[7] = v24;
                int[] v25 = new int[8];
                v25[6] = 1;
                v25[7] = 1;
                v16[8] = v25;
                int[] v26 = new int[8];
                v26[6] = 1;
                v26[7] = 1;
                v16[9] = v26;
                int[] v27 = new int[8];
                v27[6] = 1;
                v27[7] = 1;
                v16[10] = v27;
                int[] v28 = new int[8];
                v28[6] = 1;
                v28[7] = 1;
                v16[11] = v28;
                int[] v29 = new int[8];
                v29[6] = 1;
                v29[7] = 1;
                v16[12] = v29;
                int[] v30 = new int[8];
                v30[6] = 1;
                v30[7] = 1;
                v16[13] = v30;
                int[] v31 = new int[8];
                v31[1] = 1;
                v31[2] = 1;
                v31[3] = 1;
                v31[4] = 1;
                v31[5] = 1;
                v31[6] = 1;
                v16[14] = v31;
                yield v16;
            }
            case 2 -> {
                int[][] v32 = new int[15][];
                int[] v33 = new int[8];
                v33[1] = 1;
                v33[2] = 1;
                v33[3] = 1;
                v33[4] = 1;
                v33[5] = 1;
                v33[6] = 1;
                v32[0] = v33;
                int[] v34 = new int[8];
                v34[0] = 1;
                v32[1] = v34;
                int[] v35 = new int[8];
                v35[0] = 1;
                v32[2] = v35;
                int[] v36 = new int[8];
                v36[0] = 1;
                v32[3] = v36;
                int[] v37 = new int[8];
                v37[0] = 1;
                v32[4] = v37;
                int[] v38 = new int[8];
                v38[0] = 1;
                v32[5] = v38;
                int[] v39 = new int[8];
                v39[0] = 1;
                v32[6] = v39;
                int[] v40 = new int[8];
                v40[1] = 1;
                v40[2] = 1;
                v40[3] = 1;
                v40[4] = 1;
                v40[5] = 1;
                v40[6] = 1;
                v32[7] = v40;
                int[] v41 = new int[8];
                v41[5] = 1;
                v41[7] = 1;
                v32[8] = v41;
                int[] v42 = new int[8];
                v42[5] = 1;
                v42[7] = 1;
                v32[9] = v42;
                int[] v43 = new int[8];
                v43[5] = 1;
                v43[7] = 1;
                v32[10] = v43;
                int[] v44 = new int[8];
                v44[5] = 1;
                v44[7] = 1;
                v32[11] = v44;
                int[] v45 = new int[8];
                v45[5] = 1;
                v45[7] = 1;
                v32[12] = v45;
                int[] v46 = new int[8];
                v46[5] = 1;
                v46[7] = 1;
                v32[13] = v46;
                int[] v47 = new int[8];
                v47[1] = 1;
                v47[2] = 1;
                v47[3] = 1;
                v47[4] = 1;
                v47[5] = 1;
                v47[6] = 1;
                v32[14] = v47;
                yield v32;
            }
            case 3 -> {
                int[][] v48 = new int[15][];
                int[] v49 = new int[8];
                v49[1] = 1;
                v49[2] = 1;
                v49[3] = 1;
                v49[4] = 1;
                v49[5] = 1;
                v49[6] = 1;
                v48[0] = v49;
                int[] v50 = new int[8];
                v50[0] = 1;
                v48[1] = v50;
                int[] v51 = new int[8];
                v51[0] = 1;
                v48[2] = v51;
                int[] v52 = new int[8];
                v52[0] = 1;
                v48[3] = v52;
                int[] v53 = new int[8];
                v53[0] = 1;
                v48[4] = v53;
                int[] v54 = new int[8];
                v54[0] = 1;
                v48[5] = v54;
                int[] v55 = new int[8];
                v55[0] = 1;
                v48[6] = v55;
                int[] v56 = new int[8];
                v56[1] = 1;
                v56[2] = 1;
                v56[3] = 1;
                v56[4] = 1;
                v56[5] = 1;
                v56[6] = 1;
                v48[7] = v56;
                int[] v57 = new int[8];
                v57[4] = 1;
                v57[7] = 1;
                v48[8] = v57;
                int[] v58 = new int[8];
                v58[4] = 1;
                v58[7] = 1;
                v48[9] = v58;
                int[] v59 = new int[8];
                v59[4] = 1;
                v59[7] = 1;
                v48[10] = v59;
                int[] v60 = new int[8];
                v60[4] = 1;
                v60[7] = 1;
                v48[11] = v60;
                int[] v61 = new int[8];
                v61[4] = 1;
                v61[7] = 1;
                v48[12] = v61;
                int[] v62 = new int[8];
                v62[4] = 1;
                v62[7] = 1;
                v48[13] = v62;
                int[] v63 = new int[8];
                v63[1] = 1;
                v63[2] = 1;
                v63[3] = 1;
                v63[4] = 1;
                v63[5] = 1;
                v63[6] = 1;
                v48[14] = v63;
                yield v48;
            }
            case 4 -> {
                int[][] v64 = new int[15][];
                int[] v65 = new int[8];
                v65[1] = 1;
                v65[2] = 1;
                v65[3] = 1;
                v65[4] = 1;
                v65[5] = 1;
                v65[6] = 1;
                v64[0] = v65;
                int[] v66 = new int[8];
                v66[0] = 1;
                v64[1] = v66;
                int[] v67 = new int[8];
                v67[0] = 1;
                v64[2] = v67;
                int[] v68 = new int[8];
                v68[0] = 1;
                v64[3] = v68;
                int[] v69 = new int[8];
                v69[0] = 1;
                v64[4] = v69;
                int[] v70 = new int[8];
                v70[0] = 1;
                v64[5] = v70;
                int[] v71 = new int[8];
                v71[0] = 1;
                v64[6] = v71;
                int[] v72 = new int[8];
                v72[1] = 1;
                v72[2] = 1;
                v72[3] = 1;
                v72[4] = 1;
                v72[5] = 1;
                v72[6] = 1;
                v64[7] = v72;
                int[] v73 = new int[8];
                v73[3] = 1;
                v73[7] = 1;
                v64[8] = v73;
                int[] v74 = new int[8];
                v74[3] = 1;
                v74[7] = 1;
                v64[9] = v74;
                int[] v75 = new int[8];
                v75[3] = 1;
                v75[7] = 1;
                v64[10] = v75;
                int[] v76 = new int[8];
                v76[3] = 1;
                v76[7] = 1;
                v64[11] = v76;
                int[] v77 = new int[8];
                v77[3] = 1;
                v77[7] = 1;
                v64[12] = v77;
                int[] v78 = new int[8];
                v78[3] = 1;
                v78[7] = 1;
                v64[13] = v78;
                int[] v79 = new int[8];
                v79[1] = 1;
                v79[2] = 1;
                v79[3] = 1;
                v79[4] = 1;
                v79[5] = 1;
                v79[6] = 1;
                v64[14] = v79;
                yield v64;
            }
            case 5 -> {
                int[][] v80 = new int[15][];
                int[] v81 = new int[8];
                v81[1] = 1;
                v81[2] = 1;
                v81[3] = 1;
                v81[4] = 1;
                v81[5] = 1;
                v81[6] = 1;
                v80[0] = v81;
                int[] v82 = new int[8];
                v82[0] = 1;
                v80[1] = v82;
                int[] v83 = new int[8];
                v83[0] = 1;
                v80[2] = v83;
                int[] v84 = new int[8];
                v84[0] = 1;
                v80[3] = v84;
                int[] v85 = new int[8];
                v85[0] = 1;
                v80[4] = v85;
                int[] v86 = new int[8];
                v86[0] = 1;
                v80[5] = v86;
                int[] v87 = new int[8];
                v87[0] = 1;
                v80[6] = v87;
                int[] v88 = new int[8];
                v88[1] = 1;
                v88[2] = 1;
                v88[3] = 1;
                v88[4] = 1;
                v88[5] = 1;
                v88[6] = 1;
                v80[7] = v88;
                int[] v89 = new int[8];
                v89[2] = 1;
                v89[7] = 1;
                v80[8] = v89;
                int[] v90 = new int[8];
                v90[2] = 1;
                v90[7] = 1;
                v80[9] = v90;
                int[] v91 = new int[8];
                v91[2] = 1;
                v91[7] = 1;
                v80[10] = v91;
                int[] v92 = new int[8];
                v92[2] = 1;
                v92[7] = 1;
                v80[11] = v92;
                int[] v93 = new int[8];
                v93[2] = 1;
                v93[7] = 1;
                v80[12] = v93;
                int[] v94 = new int[8];
                v94[2] = 1;
                v94[7] = 1;
                v80[13] = v94;
                int[] v95 = new int[8];
                v95[1] = 1;
                v95[2] = 1;
                v95[3] = 1;
                v95[4] = 1;
                v95[5] = 1;
                v95[6] = 1;
                v80[14] = v95;
                yield v80;
            }
            case 6 -> {
                int[][] v96 = new int[15][];
                int[] v97 = new int[8];
                v97[1] = 1;
                v97[2] = 1;
                v97[3] = 1;
                v97[4] = 1;
                v97[5] = 1;
                v97[6] = 1;
                v96[0] = v97;
                int[] v98 = new int[8];
                v98[0] = 1;
                v96[1] = v98;
                int[] v99 = new int[8];
                v99[0] = 1;
                v96[2] = v99;
                int[] v100 = new int[8];
                v100[0] = 1;
                v96[3] = v100;
                int[] v101 = new int[8];
                v101[0] = 1;
                v96[4] = v101;
                int[] v102 = new int[8];
                v102[0] = 1;
                v96[5] = v102;
                int[] v103 = new int[8];
                v103[0] = 1;
                v96[6] = v103;
                int[] v104 = new int[8];
                v104[1] = 1;
                v104[2] = 1;
                v104[3] = 1;
                v104[4] = 1;
                v104[5] = 1;
                v104[6] = 1;
                v96[7] = v104;
                int[] v105 = new int[8];
                v105[1] = 1;
                v105[7] = 1;
                v96[8] = v105;
                int[] v106 = new int[8];
                v106[1] = 1;
                v106[7] = 1;
                v96[9] = v106;
                int[] v107 = new int[8];
                v107[1] = 1;
                v107[7] = 1;
                v96[10] = v107;
                int[] v108 = new int[8];
                v108[1] = 1;
                v108[7] = 1;
                v96[11] = v108;
                int[] v109 = new int[8];
                v109[1] = 1;
                v109[7] = 1;
                v96[12] = v109;
                int[] v110 = new int[8];
                v110[1] = 1;
                v110[7] = 1;
                v96[13] = v110;
                int[] v111 = new int[8];
                v111[1] = 1;
                v111[2] = 1;
                v111[3] = 1;
                v111[4] = 1;
                v111[5] = 1;
                v111[6] = 1;
                v96[14] = v111;
                yield v96;
            }
            case 7 -> {
                int[][] v112 = new int[15][];
                int[] v113 = new int[8];
                v113[1] = 1;
                v113[2] = 1;
                v113[3] = 1;
                v113[4] = 1;
                v113[5] = 1;
                v113[6] = 1;
                v112[0] = v113;
                int[] v114 = new int[8];
                v114[0] = 1;
                v112[1] = v114;
                int[] v115 = new int[8];
                v115[0] = 1;
                v112[2] = v115;
                int[] v116 = new int[8];
                v116[0] = 1;
                v112[3] = v116;
                int[] v117 = new int[8];
                v117[0] = 1;
                v112[4] = v117;
                int[] v118 = new int[8];
                v118[0] = 1;
                v112[5] = v118;
                int[] v119 = new int[8];
                v119[0] = 1;
                v112[6] = v119;
                int[] v120 = new int[8];
                v120[1] = 1;
                v120[2] = 1;
                v120[3] = 1;
                v120[4] = 1;
                v120[5] = 1;
                v120[6] = 1;
                v112[7] = v120;
                int[] v121 = new int[8];
                v121[0] = 1;
                v121[7] = 1;
                v112[8] = v121;
                int[] v122 = new int[8];
                v122[0] = 1;
                v122[7] = 1;
                v112[9] = v122;
                int[] v123 = new int[8];
                v123[0] = 1;
                v123[7] = 1;
                v112[10] = v123;
                int[] v124 = new int[8];
                v124[0] = 1;
                v124[7] = 1;
                v112[11] = v124;
                int[] v125 = new int[8];
                v125[0] = 1;
                v125[7] = 1;
                v112[12] = v125;
                int[] v126 = new int[8];
                v126[0] = 1;
                v126[7] = 1;
                v112[13] = v126;
                int[] v127 = new int[8];
                v127[1] = 1;
                v127[2] = 1;
                v127[3] = 1;
                v127[4] = 1;
                v127[5] = 1;
                v127[6] = 1;
                v112[14] = v127;
                yield v112;
            }
            default -> {
                int[][] v128 = new int[15][];
                int[] v129 = new int[8];
                v129[1] = 1;
                v129[2] = 1;
                v129[3] = 1;
                v129[4] = 1;
                v129[5] = 1;
                v129[6] = 1;
                v128[0] = v129;
                int[] v130 = new int[8];
                v130[0] = 1;
                v128[1] = v130;
                int[] v131 = new int[8];
                v131[0] = 1;
                v128[2] = v131;
                int[] v132 = new int[8];
                v132[0] = 1;
                v128[3] = v132;
                int[] v133 = new int[8];
                v133[0] = 1;
                v128[4] = v133;
                int[] v134 = new int[8];
                v134[0] = 1;
                v128[5] = v134;
                int[] v135 = new int[8];
                v135[0] = 1;
                v128[6] = v135;
                int[] v136 = new int[8];
                v136[1] = 1;
                v136[2] = 1;
                v136[3] = 1;
                v136[4] = 1;
                v136[5] = 1;
                v136[6] = 1;
                v128[7] = v136;
                int[] v137 = new int[8];
                v137[0] = 1;
                v137[7] = 1;
                v128[8] = v137;
                int[] v138 = new int[8];
                v138[0] = 1;
                v138[7] = 1;
                v128[9] = v138;
                int[] v139 = new int[8];
                v139[0] = 1;
                v139[7] = 1;
                v128[10] = v139;
                int[] v140 = new int[8];
                v140[0] = 1;
                v140[7] = 1;
                v128[11] = v140;
                int[] v141 = new int[8];
                v141[0] = 1;
                v141[7] = 1;
                v128[12] = v141;
                int[] v142 = new int[8];
                v142[0] = 1;
                v142[7] = 1;
                v128[13] = v142;
                int[] v143 = new int[8];
                v143[1] = 1;
                v143[2] = 1;
                v143[3] = 1;
                v143[4] = 1;
                v143[5] = 1;
                v143[6] = 1;
                v128[14] = v143;
                yield v128;
            }
        };
    }

    private int[][] toSeven(int STEP) {
        return switch (STEP) {
            case 0 -> {
                int[][] v0 = new int[15][];
                int[] v1 = new int[8];
                v1[1] = 1;
                v1[2] = 1;
                v1[3] = 1;
                v1[4] = 1;
                v1[5] = 1;
                v1[6] = 1;
                v0[0] = v1;
                int[] v2 = new int[8];
                v2[0] = 1;
                v0[1] = v2;
                int[] v3 = new int[8];
                v3[0] = 1;
                v0[2] = v3;
                int[] v4 = new int[8];
                v4[0] = 1;
                v0[3] = v4;
                int[] v5 = new int[8];
                v5[0] = 1;
                v0[4] = v5;
                int[] v6 = new int[8];
                v6[0] = 1;
                v0[5] = v6;
                int[] v7 = new int[8];
                v7[0] = 1;
                v0[6] = v7;
                int[] v8 = new int[8];
                v8[1] = 1;
                v8[2] = 1;
                v8[3] = 1;
                v8[4] = 1;
                v8[5] = 1;
                v8[6] = 1;
                v0[7] = v8;
                int[] v9 = new int[8];
                v9[0] = 1;
                v9[7] = 1;
                v0[8] = v9;
                int[] v10 = new int[8];
                v10[0] = 1;
                v10[7] = 1;
                v0[9] = v10;
                int[] v11 = new int[8];
                v11[0] = 1;
                v11[7] = 1;
                v0[10] = v11;
                int[] v12 = new int[8];
                v12[0] = 1;
                v12[7] = 1;
                v0[11] = v12;
                int[] v13 = new int[8];
                v13[0] = 1;
                v13[7] = 1;
                v0[12] = v13;
                int[] v14 = new int[8];
                v14[0] = 1;
                v14[7] = 1;
                v0[13] = v14;
                int[] v15 = new int[8];
                v15[1] = 1;
                v15[2] = 1;
                v15[3] = 1;
                v15[4] = 1;
                v15[5] = 1;
                v15[6] = 1;
                v0[14] = v15;
                yield v0;
            }
            case 1 -> {
                int[][] v16 = new int[15][];
                int[] v17 = new int[8];
                v17[1] = 1;
                v17[2] = 1;
                v17[3] = 1;
                v17[4] = 1;
                v17[5] = 1;
                v17[6] = 1;
                v16[0] = v17;
                int[] v18 = new int[8];
                v18[1] = 1;
                v16[1] = v18;
                int[] v19 = new int[8];
                v19[1] = 1;
                v16[2] = v19;
                int[] v20 = new int[8];
                v20[1] = 1;
                v16[3] = v20;
                int[] v21 = new int[8];
                v21[1] = 1;
                v16[4] = v21;
                int[] v22 = new int[8];
                v22[1] = 1;
                v16[5] = v22;
                int[] v23 = new int[8];
                v23[1] = 1;
                v16[6] = v23;
                int[] v24 = new int[8];
                v24[1] = 1;
                v24[2] = 1;
                v24[3] = 1;
                v24[4] = 1;
                v24[5] = 1;
                v24[6] = 1;
                v16[7] = v24;
                int[] v25 = new int[8];
                v25[1] = 1;
                v25[7] = 1;
                v16[8] = v25;
                int[] v26 = new int[8];
                v26[1] = 1;
                v26[7] = 1;
                v16[9] = v26;
                int[] v27 = new int[8];
                v27[1] = 1;
                v27[7] = 1;
                v16[10] = v27;
                int[] v28 = new int[8];
                v28[1] = 1;
                v28[7] = 1;
                v16[11] = v28;
                int[] v29 = new int[8];
                v29[1] = 1;
                v29[7] = 1;
                v16[12] = v29;
                int[] v30 = new int[8];
                v30[1] = 1;
                v30[7] = 1;
                v16[13] = v30;
                int[] v31 = new int[8];
                v31[1] = 1;
                v31[2] = 1;
                v31[3] = 1;
                v31[4] = 1;
                v31[5] = 1;
                v31[6] = 1;
                v16[14] = v31;
                yield v16;
            }
            case 2 -> {
                int[][] v32 = new int[15][];
                int[] v33 = new int[8];
                v33[1] = 1;
                v33[2] = 1;
                v33[3] = 1;
                v33[4] = 1;
                v33[5] = 1;
                v33[6] = 1;
                v32[0] = v33;
                int[] v34 = new int[8];
                v34[2] = 1;
                v32[1] = v34;
                int[] v35 = new int[8];
                v35[2] = 1;
                v32[2] = v35;
                int[] v36 = new int[8];
                v36[2] = 1;
                v32[3] = v36;
                int[] v37 = new int[8];
                v37[2] = 1;
                v32[4] = v37;
                int[] v38 = new int[8];
                v38[2] = 1;
                v32[5] = v38;
                int[] v39 = new int[8];
                v39[2] = 1;
                v32[6] = v39;
                int[] v40 = new int[8];
                v40[2] = 1;
                v40[3] = 1;
                v40[4] = 1;
                v40[5] = 1;
                v40[6] = 1;
                v32[7] = v40;
                int[] v41 = new int[8];
                v41[2] = 1;
                v41[7] = 1;
                v32[8] = v41;
                int[] v42 = new int[8];
                v42[2] = 1;
                v42[7] = 1;
                v32[9] = v42;
                int[] v43 = new int[8];
                v43[2] = 1;
                v43[7] = 1;
                v32[10] = v43;
                int[] v44 = new int[8];
                v44[2] = 1;
                v44[7] = 1;
                v32[11] = v44;
                int[] v45 = new int[8];
                v45[2] = 1;
                v45[7] = 1;
                v32[12] = v45;
                int[] v46 = new int[8];
                v46[2] = 1;
                v46[7] = 1;
                v32[13] = v46;
                int[] v47 = new int[8];
                v47[2] = 1;
                v47[3] = 1;
                v47[4] = 1;
                v47[5] = 1;
                v47[6] = 1;
                v32[14] = v47;
                yield v32;
            }
            case 3 -> {
                int[][] v48 = new int[15][];
                int[] v49 = new int[8];
                v49[1] = 1;
                v49[2] = 1;
                v49[3] = 1;
                v49[4] = 1;
                v49[5] = 1;
                v49[6] = 1;
                v48[0] = v49;
                int[] v50 = new int[8];
                v50[3] = 1;
                v48[1] = v50;
                int[] v51 = new int[8];
                v51[3] = 1;
                v48[2] = v51;
                int[] v52 = new int[8];
                v52[3] = 1;
                v48[3] = v52;
                int[] v53 = new int[8];
                v53[3] = 1;
                v48[4] = v53;
                int[] v54 = new int[8];
                v54[3] = 1;
                v48[5] = v54;
                int[] v55 = new int[8];
                v55[3] = 1;
                v48[6] = v55;
                int[] v56 = new int[8];
                v56[3] = 1;
                v56[4] = 1;
                v56[5] = 1;
                v56[6] = 1;
                v48[7] = v56;
                int[] v57 = new int[8];
                v57[3] = 1;
                v57[7] = 1;
                v48[8] = v57;
                int[] v58 = new int[8];
                v58[3] = 1;
                v58[7] = 1;
                v48[9] = v58;
                int[] v59 = new int[8];
                v59[3] = 1;
                v59[7] = 1;
                v48[10] = v59;
                int[] v60 = new int[8];
                v60[3] = 1;
                v60[7] = 1;
                v48[11] = v60;
                int[] v61 = new int[8];
                v61[3] = 1;
                v61[7] = 1;
                v48[12] = v61;
                int[] v62 = new int[8];
                v62[3] = 1;
                v62[7] = 1;
                v48[13] = v62;
                int[] v63 = new int[8];
                v63[3] = 1;
                v63[4] = 1;
                v63[5] = 1;
                v63[6] = 1;
                v48[14] = v63;
                yield v48;
            }
            case 4 -> {
                int[][] v64 = new int[15][];
                int[] v65 = new int[8];
                v65[1] = 1;
                v65[2] = 1;
                v65[3] = 1;
                v65[4] = 1;
                v65[5] = 1;
                v65[6] = 1;
                v64[0] = v65;
                int[] v66 = new int[8];
                v66[4] = 1;
                v64[1] = v66;
                int[] v67 = new int[8];
                v67[4] = 1;
                v64[2] = v67;
                int[] v68 = new int[8];
                v68[4] = 1;
                v64[3] = v68;
                int[] v69 = new int[8];
                v69[4] = 1;
                v64[4] = v69;
                int[] v70 = new int[8];
                v70[4] = 1;
                v64[5] = v70;
                int[] v71 = new int[8];
                v71[4] = 1;
                v64[6] = v71;
                int[] v72 = new int[8];
                v72[4] = 1;
                v72[5] = 1;
                v72[6] = 1;
                v64[7] = v72;
                int[] v73 = new int[8];
                v73[4] = 1;
                v73[7] = 1;
                v64[8] = v73;
                int[] v74 = new int[8];
                v74[4] = 1;
                v74[7] = 1;
                v64[9] = v74;
                int[] v75 = new int[8];
                v75[4] = 1;
                v75[7] = 1;
                v64[10] = v75;
                int[] v76 = new int[8];
                v76[4] = 1;
                v76[7] = 1;
                v64[11] = v76;
                int[] v77 = new int[8];
                v77[4] = 1;
                v77[7] = 1;
                v64[12] = v77;
                int[] v78 = new int[8];
                v78[4] = 1;
                v78[7] = 1;
                v64[13] = v78;
                int[] v79 = new int[8];
                v79[4] = 1;
                v79[5] = 1;
                v79[6] = 1;
                v64[14] = v79;
                yield v64;
            }
            case 5 -> {
                int[][] v80 = new int[15][];
                int[] v81 = new int[8];
                v81[1] = 1;
                v81[2] = 1;
                v81[3] = 1;
                v81[4] = 1;
                v81[5] = 1;
                v81[6] = 1;
                v80[0] = v81;
                int[] v82 = new int[8];
                v82[5] = 1;
                v80[1] = v82;
                int[] v83 = new int[8];
                v83[5] = 1;
                v80[2] = v83;
                int[] v84 = new int[8];
                v84[5] = 1;
                v80[3] = v84;
                int[] v85 = new int[8];
                v85[5] = 1;
                v80[4] = v85;
                int[] v86 = new int[8];
                v86[5] = 1;
                v80[5] = v86;
                int[] v87 = new int[8];
                v87[5] = 1;
                v80[6] = v87;
                int[] v88 = new int[8];
                v88[5] = 1;
                v88[6] = 1;
                v80[7] = v88;
                int[] v89 = new int[8];
                v89[5] = 1;
                v89[7] = 1;
                v80[8] = v89;
                int[] v90 = new int[8];
                v90[5] = 1;
                v90[7] = 1;
                v80[9] = v90;
                int[] v91 = new int[8];
                v91[5] = 1;
                v91[7] = 1;
                v80[10] = v91;
                int[] v92 = new int[8];
                v92[5] = 1;
                v92[7] = 1;
                v80[11] = v92;
                int[] v93 = new int[8];
                v93[5] = 1;
                v93[7] = 1;
                v80[12] = v93;
                int[] v94 = new int[8];
                v94[5] = 1;
                v94[7] = 1;
                v80[13] = v94;
                int[] v95 = new int[8];
                v95[5] = 1;
                v95[6] = 1;
                v80[14] = v95;
                yield v80;
            }
            case 6 -> {
                int[][] v96 = new int[15][];
                int[] v97 = new int[8];
                v97[1] = 1;
                v97[2] = 1;
                v97[3] = 1;
                v97[4] = 1;
                v97[5] = 1;
                v97[6] = 1;
                v96[0] = v97;
                int[] v98 = new int[8];
                v98[6] = 1;
                v96[1] = v98;
                int[] v99 = new int[8];
                v99[6] = 1;
                v96[2] = v99;
                int[] v100 = new int[8];
                v100[6] = 1;
                v96[3] = v100;
                int[] v101 = new int[8];
                v101[6] = 1;
                v96[4] = v101;
                int[] v102 = new int[8];
                v102[6] = 1;
                v96[5] = v102;
                int[] v103 = new int[8];
                v103[6] = 1;
                v96[6] = v103;
                int[] v104 = new int[8];
                v104[6] = 1;
                v96[7] = v104;
                int[] v105 = new int[8];
                v105[6] = 1;
                v105[7] = 1;
                v96[8] = v105;
                int[] v106 = new int[8];
                v106[6] = 1;
                v106[7] = 1;
                v96[9] = v106;
                int[] v107 = new int[8];
                v107[6] = 1;
                v107[7] = 1;
                v96[10] = v107;
                int[] v108 = new int[8];
                v108[6] = 1;
                v108[7] = 1;
                v96[11] = v108;
                int[] v109 = new int[8];
                v109[6] = 1;
                v109[7] = 1;
                v96[12] = v109;
                int[] v110 = new int[8];
                v110[6] = 1;
                v110[7] = 1;
                v96[13] = v110;
                int[] v111 = new int[8];
                v111[6] = 1;
                v96[14] = v111;
                yield v96;
            }
            case 7 -> {
                int[][] v112 = new int[15][];
                int[] v113 = new int[8];
                v113[1] = 1;
                v113[2] = 1;
                v113[3] = 1;
                v113[4] = 1;
                v113[5] = 1;
                v113[6] = 1;
                v112[0] = v113;
                int[] v114 = new int[8];
                v114[7] = 1;
                v112[1] = v114;
                int[] v115 = new int[8];
                v115[7] = 1;
                v112[2] = v115;
                int[] v116 = new int[8];
                v116[7] = 1;
                v112[3] = v116;
                int[] v117 = new int[8];
                v117[7] = 1;
                v112[4] = v117;
                int[] v118 = new int[8];
                v118[7] = 1;
                v112[5] = v118;
                int[] v119 = new int[8];
                v119[7] = 1;
                v112[6] = v119;
                v112[7] = new int[8];
                int[] v120 = new int[8];
                v120[7] = 1;
                v112[8] = v120;
                int[] v121 = new int[8];
                v121[7] = 1;
                v112[9] = v121;
                int[] v122 = new int[8];
                v122[7] = 1;
                v112[10] = v122;
                int[] v123 = new int[8];
                v123[7] = 1;
                v112[11] = v123;
                int[] v124 = new int[8];
                v124[7] = 1;
                v112[12] = v124;
                int[] v125 = new int[8];
                v125[7] = 1;
                v112[13] = v125;
                v112[14] = new int[8];
                yield v112;
            }
            default -> {
                int[][] v126 = new int[15][];
                int[] v127 = new int[8];
                v127[1] = 1;
                v127[2] = 1;
                v127[3] = 1;
                v127[4] = 1;
                v127[5] = 1;
                v127[6] = 1;
                v126[0] = v127;
                int[] v128 = new int[8];
                v128[7] = 1;
                v126[1] = v128;
                int[] v129 = new int[8];
                v129[7] = 1;
                v126[2] = v129;
                int[] v130 = new int[8];
                v130[7] = 1;
                v126[3] = v130;
                int[] v131 = new int[8];
                v131[7] = 1;
                v126[4] = v131;
                int[] v132 = new int[8];
                v132[7] = 1;
                v126[5] = v132;
                int[] v133 = new int[8];
                v133[7] = 1;
                v126[6] = v133;
                v126[7] = new int[8];
                int[] v134 = new int[8];
                v134[7] = 1;
                v126[8] = v134;
                int[] v135 = new int[8];
                v135[7] = 1;
                v126[9] = v135;
                int[] v136 = new int[8];
                v136[7] = 1;
                v126[10] = v136;
                int[] v137 = new int[8];
                v137[7] = 1;
                v126[11] = v137;
                int[] v138 = new int[8];
                v138[7] = 1;
                v126[12] = v138;
                int[] v139 = new int[8];
                v139[7] = 1;
                v126[13] = v139;
                v126[14] = new int[8];
                yield v126;
            }
        };
    }

    private int[][] toEight(int STEP) {
        return switch (STEP) {
            case 0 -> {
                int[][] v0 = new int[15][];
                int[] v1 = new int[8];
                v1[1] = 1;
                v1[2] = 1;
                v1[3] = 1;
                v1[4] = 1;
                v1[5] = 1;
                v1[6] = 1;
                v0[0] = v1;
                int[] v2 = new int[8];
                v2[7] = 1;
                v0[1] = v2;
                int[] v3 = new int[8];
                v3[7] = 1;
                v0[2] = v3;
                int[] v4 = new int[8];
                v4[7] = 1;
                v0[3] = v4;
                int[] v5 = new int[8];
                v5[7] = 1;
                v0[4] = v5;
                int[] v6 = new int[8];
                v6[7] = 1;
                v0[5] = v6;
                int[] v7 = new int[8];
                v7[7] = 1;
                v0[6] = v7;
                v0[7] = new int[8];
                int[] v8 = new int[8];
                v8[7] = 1;
                v0[8] = v8;
                int[] v9 = new int[8];
                v9[7] = 1;
                v0[9] = v9;
                int[] v10 = new int[8];
                v10[7] = 1;
                v0[10] = v10;
                int[] v11 = new int[8];
                v11[7] = 1;
                v0[11] = v11;
                int[] v12 = new int[8];
                v12[7] = 1;
                v0[12] = v12;
                int[] v13 = new int[8];
                v13[7] = 1;
                v0[13] = v13;
                v0[14] = new int[8];
                yield v0;
            }
            case 1 -> {
                int[][] v14 = new int[15][];
                int[] v15 = new int[8];
                v15[1] = 1;
                v15[2] = 1;
                v15[3] = 1;
                v15[4] = 1;
                v15[5] = 1;
                v15[6] = 1;
                v14[0] = v15;
                int[] v16 = new int[8];
                v16[6] = 1;
                v16[7] = 1;
                v14[1] = v16;
                int[] v17 = new int[8];
                v17[6] = 1;
                v17[7] = 1;
                v14[2] = v17;
                int[] v18 = new int[8];
                v18[6] = 1;
                v18[7] = 1;
                v14[3] = v18;
                int[] v19 = new int[8];
                v19[6] = 1;
                v19[7] = 1;
                v14[4] = v19;
                int[] v20 = new int[8];
                v20[6] = 1;
                v20[7] = 1;
                v14[5] = v20;
                int[] v21 = new int[8];
                v21[6] = 1;
                v21[7] = 1;
                v14[6] = v21;
                int[] v22 = new int[8];
                v22[6] = 1;
                v14[7] = v22;
                int[] v23 = new int[8];
                v23[6] = 1;
                v23[7] = 1;
                v14[8] = v23;
                int[] v24 = new int[8];
                v24[6] = 1;
                v24[7] = 1;
                v14[9] = v24;
                int[] v25 = new int[8];
                v25[6] = 1;
                v25[7] = 1;
                v14[10] = v25;
                int[] v26 = new int[8];
                v26[6] = 1;
                v26[7] = 1;
                v14[11] = v26;
                int[] v27 = new int[8];
                v27[6] = 1;
                v27[7] = 1;
                v14[12] = v27;
                int[] v28 = new int[8];
                v28[6] = 1;
                v28[7] = 1;
                v14[13] = v28;
                int[] v29 = new int[8];
                v29[6] = 1;
                v14[14] = v29;
                yield v14;
            }
            case 2 -> {
                int[][] v30 = new int[15][];
                int[] v31 = new int[8];
                v31[1] = 1;
                v31[2] = 1;
                v31[3] = 1;
                v31[4] = 1;
                v31[5] = 1;
                v31[6] = 1;
                v30[0] = v31;
                int[] v32 = new int[8];
                v32[5] = 1;
                v32[7] = 1;
                v30[1] = v32;
                int[] v33 = new int[8];
                v33[5] = 1;
                v33[7] = 1;
                v30[2] = v33;
                int[] v34 = new int[8];
                v34[5] = 1;
                v34[7] = 1;
                v30[3] = v34;
                int[] v35 = new int[8];
                v35[5] = 1;
                v35[7] = 1;
                v30[4] = v35;
                int[] v36 = new int[8];
                v36[5] = 1;
                v36[7] = 1;
                v30[5] = v36;
                int[] v37 = new int[8];
                v37[5] = 1;
                v37[7] = 1;
                v30[6] = v37;
                int[] v38 = new int[8];
                v38[5] = 1;
                v38[6] = 1;
                v30[7] = v38;
                int[] v39 = new int[8];
                v39[5] = 1;
                v39[7] = 1;
                v30[8] = v39;
                int[] v40 = new int[8];
                v40[5] = 1;
                v40[7] = 1;
                v30[9] = v40;
                int[] v41 = new int[8];
                v41[5] = 1;
                v41[7] = 1;
                v30[10] = v41;
                int[] v42 = new int[8];
                v42[5] = 1;
                v42[7] = 1;
                v30[11] = v42;
                int[] v43 = new int[8];
                v43[5] = 1;
                v43[7] = 1;
                v30[12] = v43;
                int[] v44 = new int[8];
                v44[5] = 1;
                v44[7] = 1;
                v30[13] = v44;
                int[] v45 = new int[8];
                v45[5] = 1;
                v45[6] = 1;
                v30[14] = v45;
                yield v30;
            }
            case 3 -> {
                int[][] v46 = new int[15][];
                int[] v47 = new int[8];
                v47[1] = 1;
                v47[2] = 1;
                v47[3] = 1;
                v47[4] = 1;
                v47[5] = 1;
                v47[6] = 1;
                v46[0] = v47;
                int[] v48 = new int[8];
                v48[4] = 1;
                v48[7] = 1;
                v46[1] = v48;
                int[] v49 = new int[8];
                v49[4] = 1;
                v49[7] = 1;
                v46[2] = v49;
                int[] v50 = new int[8];
                v50[4] = 1;
                v50[7] = 1;
                v46[3] = v50;
                int[] v51 = new int[8];
                v51[4] = 1;
                v51[7] = 1;
                v46[4] = v51;
                int[] v52 = new int[8];
                v52[4] = 1;
                v52[7] = 1;
                v46[5] = v52;
                int[] v53 = new int[8];
                v53[4] = 1;
                v53[7] = 1;
                v46[6] = v53;
                int[] v54 = new int[8];
                v54[4] = 1;
                v54[5] = 1;
                v54[6] = 1;
                v46[7] = v54;
                int[] v55 = new int[8];
                v55[4] = 1;
                v55[7] = 1;
                v46[8] = v55;
                int[] v56 = new int[8];
                v56[4] = 1;
                v56[7] = 1;
                v46[9] = v56;
                int[] v57 = new int[8];
                v57[4] = 1;
                v57[7] = 1;
                v46[10] = v57;
                int[] v58 = new int[8];
                v58[4] = 1;
                v58[7] = 1;
                v46[11] = v58;
                int[] v59 = new int[8];
                v59[4] = 1;
                v59[7] = 1;
                v46[12] = v59;
                int[] v60 = new int[8];
                v60[4] = 1;
                v60[7] = 1;
                v46[13] = v60;
                int[] v61 = new int[8];
                v61[4] = 1;
                v61[5] = 1;
                v61[6] = 1;
                v46[14] = v61;
                yield v46;
            }
            case 4 -> {
                int[][] v62 = new int[15][];
                int[] v63 = new int[8];
                v63[1] = 1;
                v63[2] = 1;
                v63[3] = 1;
                v63[4] = 1;
                v63[5] = 1;
                v63[6] = 1;
                v62[0] = v63;
                int[] v64 = new int[8];
                v64[3] = 1;
                v64[7] = 1;
                v62[1] = v64;
                int[] v65 = new int[8];
                v65[3] = 1;
                v65[7] = 1;
                v62[2] = v65;
                int[] v66 = new int[8];
                v66[3] = 1;
                v66[7] = 1;
                v62[3] = v66;
                int[] v67 = new int[8];
                v67[3] = 1;
                v67[7] = 1;
                v62[4] = v67;
                int[] v68 = new int[8];
                v68[3] = 1;
                v68[7] = 1;
                v62[5] = v68;
                int[] v69 = new int[8];
                v69[3] = 1;
                v69[7] = 1;
                v62[6] = v69;
                int[] v70 = new int[8];
                v70[3] = 1;
                v70[4] = 1;
                v70[5] = 1;
                v70[6] = 1;
                v62[7] = v70;
                int[] v71 = new int[8];
                v71[3] = 1;
                v71[7] = 1;
                v62[8] = v71;
                int[] v72 = new int[8];
                v72[3] = 1;
                v72[7] = 1;
                v62[9] = v72;
                int[] v73 = new int[8];
                v73[3] = 1;
                v73[7] = 1;
                v62[10] = v73;
                int[] v74 = new int[8];
                v74[3] = 1;
                v74[7] = 1;
                v62[11] = v74;
                int[] v75 = new int[8];
                v75[3] = 1;
                v75[7] = 1;
                v62[12] = v75;
                int[] v76 = new int[8];
                v76[3] = 1;
                v76[7] = 1;
                v62[13] = v76;
                int[] v77 = new int[8];
                v77[3] = 1;
                v77[4] = 1;
                v77[5] = 1;
                v77[6] = 1;
                v62[14] = v77;
                yield v62;
            }
            case 5 -> {
                int[][] v78 = new int[15][];
                int[] v79 = new int[8];
                v79[1] = 1;
                v79[2] = 1;
                v79[3] = 1;
                v79[4] = 1;
                v79[5] = 1;
                v79[6] = 1;
                v78[0] = v79;
                int[] v80 = new int[8];
                v80[2] = 1;
                v80[7] = 1;
                v78[1] = v80;
                int[] v81 = new int[8];
                v81[2] = 1;
                v81[7] = 1;
                v78[2] = v81;
                int[] v82 = new int[8];
                v82[2] = 1;
                v82[7] = 1;
                v78[3] = v82;
                int[] v83 = new int[8];
                v83[2] = 1;
                v83[7] = 1;
                v78[4] = v83;
                int[] v84 = new int[8];
                v84[2] = 1;
                v84[7] = 1;
                v78[5] = v84;
                int[] v85 = new int[8];
                v85[2] = 1;
                v85[7] = 1;
                v78[6] = v85;
                int[] v86 = new int[8];
                v86[2] = 1;
                v86[3] = 1;
                v86[4] = 1;
                v86[5] = 1;
                v86[6] = 1;
                v78[7] = v86;
                int[] v87 = new int[8];
                v87[2] = 1;
                v87[7] = 1;
                v78[8] = v87;
                int[] v88 = new int[8];
                v88[2] = 1;
                v88[7] = 1;
                v78[9] = v88;
                int[] v89 = new int[8];
                v89[2] = 1;
                v89[7] = 1;
                v78[10] = v89;
                int[] v90 = new int[8];
                v90[2] = 1;
                v90[7] = 1;
                v78[11] = v90;
                int[] v91 = new int[8];
                v91[2] = 1;
                v91[7] = 1;
                v78[12] = v91;
                int[] v92 = new int[8];
                v92[2] = 1;
                v92[7] = 1;
                v78[13] = v92;
                int[] v93 = new int[8];
                v93[2] = 1;
                v93[3] = 1;
                v93[4] = 1;
                v93[5] = 1;
                v93[6] = 1;
                v78[14] = v93;
                yield v78;
            }
            case 6 -> {
                int[][] v94 = new int[15][];
                int[] v95 = new int[8];
                v95[1] = 1;
                v95[2] = 1;
                v95[3] = 1;
                v95[4] = 1;
                v95[5] = 1;
                v95[6] = 1;
                v94[0] = v95;
                int[] v96 = new int[8];
                v96[1] = 1;
                v96[7] = 1;
                v94[1] = v96;
                int[] v97 = new int[8];
                v97[1] = 1;
                v97[7] = 1;
                v94[2] = v97;
                int[] v98 = new int[8];
                v98[1] = 1;
                v98[7] = 1;
                v94[3] = v98;
                int[] v99 = new int[8];
                v99[1] = 1;
                v99[7] = 1;
                v94[4] = v99;
                int[] v100 = new int[8];
                v100[1] = 1;
                v100[7] = 1;
                v94[5] = v100;
                int[] v101 = new int[8];
                v101[1] = 1;
                v101[7] = 1;
                v94[6] = v101;
                int[] v102 = new int[8];
                v102[1] = 1;
                v102[2] = 1;
                v102[3] = 1;
                v102[4] = 1;
                v102[5] = 1;
                v102[6] = 1;
                v94[7] = v102;
                int[] v103 = new int[8];
                v103[1] = 1;
                v103[7] = 1;
                v94[8] = v103;
                int[] v104 = new int[8];
                v104[1] = 1;
                v104[7] = 1;
                v94[9] = v104;
                int[] v105 = new int[8];
                v105[1] = 1;
                v105[7] = 1;
                v94[10] = v105;
                int[] v106 = new int[8];
                v106[1] = 1;
                v106[7] = 1;
                v94[11] = v106;
                int[] v107 = new int[8];
                v107[1] = 1;
                v107[7] = 1;
                v94[12] = v107;
                int[] v108 = new int[8];
                v108[1] = 1;
                v108[7] = 1;
                v94[13] = v108;
                int[] v109 = new int[8];
                v109[1] = 1;
                v109[2] = 1;
                v109[3] = 1;
                v109[4] = 1;
                v109[5] = 1;
                v109[6] = 1;
                v94[14] = v109;
                yield v94;
            }
            case 7 -> {
                int[][] v110 = new int[15][];
                int[] v111 = new int[8];
                v111[1] = 1;
                v111[2] = 1;
                v111[3] = 1;
                v111[4] = 1;
                v111[5] = 1;
                v111[6] = 1;
                v110[0] = v111;
                int[] v112 = new int[8];
                v112[0] = 1;
                v112[7] = 1;
                v110[1] = v112;
                int[] v113 = new int[8];
                v113[0] = 1;
                v113[7] = 1;
                v110[2] = v113;
                int[] v114 = new int[8];
                v114[0] = 1;
                v114[7] = 1;
                v110[3] = v114;
                int[] v115 = new int[8];
                v115[0] = 1;
                v115[7] = 1;
                v110[4] = v115;
                int[] v116 = new int[8];
                v116[0] = 1;
                v116[7] = 1;
                v110[5] = v116;
                int[] v117 = new int[8];
                v117[0] = 1;
                v117[7] = 1;
                v110[6] = v117;
                int[] v118 = new int[8];
                v118[1] = 1;
                v118[2] = 1;
                v118[3] = 1;
                v118[4] = 1;
                v118[5] = 1;
                v118[6] = 1;
                v110[7] = v118;
                int[] v119 = new int[8];
                v119[0] = 1;
                v119[7] = 1;
                v110[8] = v119;
                int[] v120 = new int[8];
                v120[0] = 1;
                v120[7] = 1;
                v110[9] = v120;
                int[] v121 = new int[8];
                v121[0] = 1;
                v121[7] = 1;
                v110[10] = v121;
                int[] v122 = new int[8];
                v122[0] = 1;
                v122[7] = 1;
                v110[11] = v122;
                int[] v123 = new int[8];
                v123[0] = 1;
                v123[7] = 1;
                v110[12] = v123;
                int[] v124 = new int[8];
                v124[0] = 1;
                v124[7] = 1;
                v110[13] = v124;
                int[] v125 = new int[8];
                v125[1] = 1;
                v125[2] = 1;
                v125[3] = 1;
                v125[4] = 1;
                v125[5] = 1;
                v125[6] = 1;
                v110[14] = v125;
                yield v110;
            }
            default -> {
                int[][] v126 = new int[15][];
                int[] v127 = new int[8];
                v127[1] = 1;
                v127[2] = 1;
                v127[3] = 1;
                v127[4] = 1;
                v127[5] = 1;
                v127[6] = 1;
                v126[0] = v127;
                int[] v128 = new int[8];
                v128[0] = 1;
                v128[7] = 1;
                v126[1] = v128;
                int[] v129 = new int[8];
                v129[0] = 1;
                v129[7] = 1;
                v126[2] = v129;
                int[] v130 = new int[8];
                v130[0] = 1;
                v130[7] = 1;
                v126[3] = v130;
                int[] v131 = new int[8];
                v131[0] = 1;
                v131[7] = 1;
                v126[4] = v131;
                int[] v132 = new int[8];
                v132[0] = 1;
                v132[7] = 1;
                v126[5] = v132;
                int[] v133 = new int[8];
                v133[0] = 1;
                v133[7] = 1;
                v126[6] = v133;
                int[] v134 = new int[8];
                v134[1] = 1;
                v134[2] = 1;
                v134[3] = 1;
                v134[4] = 1;
                v134[5] = 1;
                v134[6] = 1;
                v126[7] = v134;
                int[] v135 = new int[8];
                v135[0] = 1;
                v135[7] = 1;
                v126[8] = v135;
                int[] v136 = new int[8];
                v136[0] = 1;
                v136[7] = 1;
                v126[9] = v136;
                int[] v137 = new int[8];
                v137[0] = 1;
                v137[7] = 1;
                v126[10] = v137;
                int[] v138 = new int[8];
                v138[0] = 1;
                v138[7] = 1;
                v126[11] = v138;
                int[] v139 = new int[8];
                v139[0] = 1;
                v139[7] = 1;
                v126[12] = v139;
                int[] v140 = new int[8];
                v140[0] = 1;
                v140[7] = 1;
                v126[13] = v140;
                int[] v141 = new int[8];
                v141[1] = 1;
                v141[2] = 1;
                v141[3] = 1;
                v141[4] = 1;
                v141[5] = 1;
                v141[6] = 1;
                v126[14] = v141;
                yield v126;
            }
        };
    }

    private int[][] toNine(int STEP) {
        return switch (STEP) {
            case 0 -> {
                int[][] v0 = new int[15][];
                int[] v1 = new int[8];
                v1[1] = 1;
                v1[2] = 1;
                v1[3] = 1;
                v1[4] = 1;
                v1[5] = 1;
                v1[6] = 1;
                v0[0] = v1;
                int[] v2 = new int[8];
                v2[0] = 1;
                v2[7] = 1;
                v0[1] = v2;
                int[] v3 = new int[8];
                v3[0] = 1;
                v3[7] = 1;
                v0[2] = v3;
                int[] v4 = new int[8];
                v4[0] = 1;
                v4[7] = 1;
                v0[3] = v4;
                int[] v5 = new int[8];
                v5[0] = 1;
                v5[7] = 1;
                v0[4] = v5;
                int[] v6 = new int[8];
                v6[0] = 1;
                v6[7] = 1;
                v0[5] = v6;
                int[] v7 = new int[8];
                v7[0] = 1;
                v7[7] = 1;
                v0[6] = v7;
                int[] v8 = new int[8];
                v8[1] = 1;
                v8[2] = 1;
                v8[3] = 1;
                v8[4] = 1;
                v8[5] = 1;
                v8[6] = 1;
                v0[7] = v8;
                int[] v9 = new int[8];
                v9[0] = 1;
                v9[7] = 1;
                v0[8] = v9;
                int[] v10 = new int[8];
                v10[0] = 1;
                v10[7] = 1;
                v0[9] = v10;
                int[] v11 = new int[8];
                v11[0] = 1;
                v11[7] = 1;
                v0[10] = v11;
                int[] v12 = new int[8];
                v12[0] = 1;
                v12[7] = 1;
                v0[11] = v12;
                int[] v13 = new int[8];
                v13[0] = 1;
                v13[7] = 1;
                v0[12] = v13;
                int[] v14 = new int[8];
                v14[0] = 1;
                v14[7] = 1;
                v0[13] = v14;
                int[] v15 = new int[8];
                v15[1] = 1;
                v15[2] = 1;
                v15[3] = 1;
                v15[4] = 1;
                v15[5] = 1;
                v15[6] = 1;
                v0[14] = v15;
                yield v0;
            }
            case 1 -> {
                int[][] v16 = new int[15][];
                int[] v17 = new int[8];
                v17[1] = 1;
                v17[2] = 1;
                v17[3] = 1;
                v17[4] = 1;
                v17[5] = 1;
                v17[6] = 1;
                v16[0] = v17;
                int[] v18 = new int[8];
                v18[0] = 1;
                v18[7] = 1;
                v16[1] = v18;
                int[] v19 = new int[8];
                v19[0] = 1;
                v19[7] = 1;
                v16[2] = v19;
                int[] v20 = new int[8];
                v20[0] = 1;
                v20[7] = 1;
                v16[3] = v20;
                int[] v21 = new int[8];
                v21[0] = 1;
                v21[7] = 1;
                v16[4] = v21;
                int[] v22 = new int[8];
                v22[0] = 1;
                v22[7] = 1;
                v16[5] = v22;
                int[] v23 = new int[8];
                v23[0] = 1;
                v23[7] = 1;
                v16[6] = v23;
                int[] v24 = new int[8];
                v24[1] = 1;
                v24[2] = 1;
                v24[3] = 1;
                v24[4] = 1;
                v24[5] = 1;
                v24[6] = 1;
                v16[7] = v24;
                int[] v25 = new int[8];
                v25[1] = 1;
                v25[7] = 1;
                v16[8] = v25;
                int[] v26 = new int[8];
                v26[1] = 1;
                v26[7] = 1;
                v16[9] = v26;
                int[] v27 = new int[8];
                v27[1] = 1;
                v27[7] = 1;
                v16[10] = v27;
                int[] v28 = new int[8];
                v28[1] = 1;
                v28[7] = 1;
                v16[11] = v28;
                int[] v29 = new int[8];
                v29[1] = 1;
                v29[7] = 1;
                v16[12] = v29;
                int[] v30 = new int[8];
                v30[1] = 1;
                v30[7] = 1;
                v16[13] = v30;
                int[] v31 = new int[8];
                v31[1] = 1;
                v31[2] = 1;
                v31[3] = 1;
                v31[4] = 1;
                v31[5] = 1;
                v31[6] = 1;
                v16[14] = v31;
                yield v16;
            }
            case 2 -> {
                int[][] v32 = new int[15][];
                int[] v33 = new int[8];
                v33[1] = 1;
                v33[2] = 1;
                v33[3] = 1;
                v33[4] = 1;
                v33[5] = 1;
                v33[6] = 1;
                v32[0] = v33;
                int[] v34 = new int[8];
                v34[0] = 1;
                v34[7] = 1;
                v32[1] = v34;
                int[] v35 = new int[8];
                v35[0] = 1;
                v35[7] = 1;
                v32[2] = v35;
                int[] v36 = new int[8];
                v36[0] = 1;
                v36[7] = 1;
                v32[3] = v36;
                int[] v37 = new int[8];
                v37[0] = 1;
                v37[7] = 1;
                v32[4] = v37;
                int[] v38 = new int[8];
                v38[0] = 1;
                v38[7] = 1;
                v32[5] = v38;
                int[] v39 = new int[8];
                v39[0] = 1;
                v39[7] = 1;
                v32[6] = v39;
                int[] v40 = new int[8];
                v40[1] = 1;
                v40[2] = 1;
                v40[3] = 1;
                v40[4] = 1;
                v40[5] = 1;
                v40[6] = 1;
                v32[7] = v40;
                int[] v41 = new int[8];
                v41[2] = 1;
                v41[7] = 1;
                v32[8] = v41;
                int[] v42 = new int[8];
                v42[2] = 1;
                v42[7] = 1;
                v32[9] = v42;
                int[] v43 = new int[8];
                v43[2] = 1;
                v43[7] = 1;
                v32[10] = v43;
                int[] v44 = new int[8];
                v44[2] = 1;
                v44[7] = 1;
                v32[11] = v44;
                int[] v45 = new int[8];
                v45[2] = 1;
                v45[7] = 1;
                v32[12] = v45;
                int[] v46 = new int[8];
                v46[2] = 1;
                v46[7] = 1;
                v32[13] = v46;
                int[] v47 = new int[8];
                v47[1] = 1;
                v47[2] = 1;
                v47[3] = 1;
                v47[4] = 1;
                v47[5] = 1;
                v47[6] = 1;
                v32[14] = v47;
                yield v32;
            }
            case 3 -> {
                int[][] v48 = new int[15][];
                int[] v49 = new int[8];
                v49[1] = 1;
                v49[2] = 1;
                v49[3] = 1;
                v49[4] = 1;
                v49[5] = 1;
                v49[6] = 1;
                v48[0] = v49;
                int[] v50 = new int[8];
                v50[0] = 1;
                v50[7] = 1;
                v48[1] = v50;
                int[] v51 = new int[8];
                v51[0] = 1;
                v51[7] = 1;
                v48[2] = v51;
                int[] v52 = new int[8];
                v52[0] = 1;
                v52[7] = 1;
                v48[3] = v52;
                int[] v53 = new int[8];
                v53[0] = 1;
                v53[7] = 1;
                v48[4] = v53;
                int[] v54 = new int[8];
                v54[0] = 1;
                v54[7] = 1;
                v48[5] = v54;
                int[] v55 = new int[8];
                v55[0] = 1;
                v55[7] = 1;
                v48[6] = v55;
                int[] v56 = new int[8];
                v56[1] = 1;
                v56[2] = 1;
                v56[3] = 1;
                v56[4] = 1;
                v56[5] = 1;
                v56[6] = 1;
                v48[7] = v56;
                int[] v57 = new int[8];
                v57[3] = 1;
                v57[7] = 1;
                v48[8] = v57;
                int[] v58 = new int[8];
                v58[3] = 1;
                v58[7] = 1;
                v48[9] = v58;
                int[] v59 = new int[8];
                v59[3] = 1;
                v59[7] = 1;
                v48[10] = v59;
                int[] v60 = new int[8];
                v60[3] = 1;
                v60[7] = 1;
                v48[11] = v60;
                int[] v61 = new int[8];
                v61[3] = 1;
                v61[7] = 1;
                v48[12] = v61;
                int[] v62 = new int[8];
                v62[3] = 1;
                v62[7] = 1;
                v48[13] = v62;
                int[] v63 = new int[8];
                v63[1] = 1;
                v63[2] = 1;
                v63[3] = 1;
                v63[4] = 1;
                v63[5] = 1;
                v63[6] = 1;
                v48[14] = v63;
                yield v48;
            }
            case 4 -> {
                int[][] v64 = new int[15][];
                int[] v65 = new int[8];
                v65[1] = 1;
                v65[2] = 1;
                v65[3] = 1;
                v65[4] = 1;
                v65[5] = 1;
                v65[6] = 1;
                v64[0] = v65;
                int[] v66 = new int[8];
                v66[0] = 1;
                v66[7] = 1;
                v64[1] = v66;
                int[] v67 = new int[8];
                v67[0] = 1;
                v67[7] = 1;
                v64[2] = v67;
                int[] v68 = new int[8];
                v68[0] = 1;
                v68[7] = 1;
                v64[3] = v68;
                int[] v69 = new int[8];
                v69[0] = 1;
                v69[7] = 1;
                v64[4] = v69;
                int[] v70 = new int[8];
                v70[0] = 1;
                v70[7] = 1;
                v64[5] = v70;
                int[] v71 = new int[8];
                v71[0] = 1;
                v71[7] = 1;
                v64[6] = v71;
                int[] v72 = new int[8];
                v72[1] = 1;
                v72[2] = 1;
                v72[3] = 1;
                v72[4] = 1;
                v72[5] = 1;
                v72[6] = 1;
                v64[7] = v72;
                int[] v73 = new int[8];
                v73[4] = 1;
                v73[7] = 1;
                v64[8] = v73;
                int[] v74 = new int[8];
                v74[4] = 1;
                v74[7] = 1;
                v64[9] = v74;
                int[] v75 = new int[8];
                v75[4] = 1;
                v75[7] = 1;
                v64[10] = v75;
                int[] v76 = new int[8];
                v76[4] = 1;
                v76[7] = 1;
                v64[11] = v76;
                int[] v77 = new int[8];
                v77[4] = 1;
                v77[7] = 1;
                v64[12] = v77;
                int[] v78 = new int[8];
                v78[4] = 1;
                v78[7] = 1;
                v64[13] = v78;
                int[] v79 = new int[8];
                v79[1] = 1;
                v79[2] = 1;
                v79[3] = 1;
                v79[4] = 1;
                v79[5] = 1;
                v79[6] = 1;
                v64[14] = v79;
                yield v64;
            }
            case 5 -> {
                int[][] v80 = new int[15][];
                int[] v81 = new int[8];
                v81[1] = 1;
                v81[2] = 1;
                v81[3] = 1;
                v81[4] = 1;
                v81[5] = 1;
                v81[6] = 1;
                v80[0] = v81;
                int[] v82 = new int[8];
                v82[0] = 1;
                v82[7] = 1;
                v80[1] = v82;
                int[] v83 = new int[8];
                v83[0] = 1;
                v83[7] = 1;
                v80[2] = v83;
                int[] v84 = new int[8];
                v84[0] = 1;
                v84[7] = 1;
                v80[3] = v84;
                int[] v85 = new int[8];
                v85[0] = 1;
                v85[7] = 1;
                v80[4] = v85;
                int[] v86 = new int[8];
                v86[0] = 1;
                v86[7] = 1;
                v80[5] = v86;
                int[] v87 = new int[8];
                v87[0] = 1;
                v87[7] = 1;
                v80[6] = v87;
                int[] v88 = new int[8];
                v88[1] = 1;
                v88[2] = 1;
                v88[3] = 1;
                v88[4] = 1;
                v88[5] = 1;
                v88[6] = 1;
                v80[7] = v88;
                int[] v89 = new int[8];
                v89[5] = 1;
                v89[7] = 1;
                v80[8] = v89;
                int[] v90 = new int[8];
                v90[5] = 1;
                v90[7] = 1;
                v80[9] = v90;
                int[] v91 = new int[8];
                v91[5] = 1;
                v91[7] = 1;
                v80[10] = v91;
                int[] v92 = new int[8];
                v92[5] = 1;
                v92[7] = 1;
                v80[11] = v92;
                int[] v93 = new int[8];
                v93[5] = 1;
                v93[7] = 1;
                v80[12] = v93;
                int[] v94 = new int[8];
                v94[5] = 1;
                v94[7] = 1;
                v80[13] = v94;
                int[] v95 = new int[8];
                v95[1] = 1;
                v95[2] = 1;
                v95[3] = 1;
                v95[4] = 1;
                v95[5] = 1;
                v95[6] = 1;
                v80[14] = v95;
                yield v80;
            }
            case 6 -> {
                int[][] v96 = new int[15][];
                int[] v97 = new int[8];
                v97[1] = 1;
                v97[2] = 1;
                v97[3] = 1;
                v97[4] = 1;
                v97[5] = 1;
                v97[6] = 1;
                v96[0] = v97;
                int[] v98 = new int[8];
                v98[0] = 1;
                v98[7] = 1;
                v96[1] = v98;
                int[] v99 = new int[8];
                v99[0] = 1;
                v99[7] = 1;
                v96[2] = v99;
                int[] v100 = new int[8];
                v100[0] = 1;
                v100[7] = 1;
                v96[3] = v100;
                int[] v101 = new int[8];
                v101[0] = 1;
                v101[7] = 1;
                v96[4] = v101;
                int[] v102 = new int[8];
                v102[0] = 1;
                v102[7] = 1;
                v96[5] = v102;
                int[] v103 = new int[8];
                v103[0] = 1;
                v103[7] = 1;
                v96[6] = v103;
                int[] v104 = new int[8];
                v104[1] = 1;
                v104[2] = 1;
                v104[3] = 1;
                v104[4] = 1;
                v104[5] = 1;
                v104[6] = 1;
                v96[7] = v104;
                int[] v105 = new int[8];
                v105[6] = 1;
                v105[7] = 1;
                v96[8] = v105;
                int[] v106 = new int[8];
                v106[6] = 1;
                v106[7] = 1;
                v96[9] = v106;
                int[] v107 = new int[8];
                v107[6] = 1;
                v107[7] = 1;
                v96[10] = v107;
                int[] v108 = new int[8];
                v108[6] = 1;
                v108[7] = 1;
                v96[11] = v108;
                int[] v109 = new int[8];
                v109[6] = 1;
                v109[7] = 1;
                v96[12] = v109;
                int[] v110 = new int[8];
                v110[6] = 1;
                v110[7] = 1;
                v96[13] = v110;
                int[] v111 = new int[8];
                v111[1] = 1;
                v111[2] = 1;
                v111[3] = 1;
                v111[4] = 1;
                v111[5] = 1;
                v111[6] = 1;
                v96[14] = v111;
                yield v96;
            }
            case 7 -> {
                int[][] v112 = new int[15][];
                int[] v113 = new int[8];
                v113[1] = 1;
                v113[2] = 1;
                v113[3] = 1;
                v113[4] = 1;
                v113[5] = 1;
                v113[6] = 1;
                v112[0] = v113;
                int[] v114 = new int[8];
                v114[0] = 1;
                v114[7] = 1;
                v112[1] = v114;
                int[] v115 = new int[8];
                v115[0] = 1;
                v115[7] = 1;
                v112[2] = v115;
                int[] v116 = new int[8];
                v116[0] = 1;
                v116[7] = 1;
                v112[3] = v116;
                int[] v117 = new int[8];
                v117[0] = 1;
                v117[7] = 1;
                v112[4] = v117;
                int[] v118 = new int[8];
                v118[0] = 1;
                v118[7] = 1;
                v112[5] = v118;
                int[] v119 = new int[8];
                v119[0] = 1;
                v119[7] = 1;
                v112[6] = v119;
                int[] v120 = new int[8];
                v120[1] = 1;
                v120[2] = 1;
                v120[3] = 1;
                v120[4] = 1;
                v120[5] = 1;
                v120[6] = 1;
                v112[7] = v120;
                int[] v121 = new int[8];
                v121[7] = 1;
                v112[8] = v121;
                int[] v122 = new int[8];
                v122[7] = 1;
                v112[9] = v122;
                int[] v123 = new int[8];
                v123[7] = 1;
                v112[10] = v123;
                int[] v124 = new int[8];
                v124[7] = 1;
                v112[11] = v124;
                int[] v125 = new int[8];
                v125[7] = 1;
                v112[12] = v125;
                int[] v126 = new int[8];
                v126[7] = 1;
                v112[13] = v126;
                int[] v127 = new int[8];
                v127[1] = 1;
                v127[2] = 1;
                v127[3] = 1;
                v127[4] = 1;
                v127[5] = 1;
                v127[6] = 1;
                v112[14] = v127;
                yield v112;
            }
            default -> {
                int[][] v128 = new int[15][];
                int[] v129 = new int[8];
                v129[1] = 1;
                v129[2] = 1;
                v129[3] = 1;
                v129[4] = 1;
                v129[5] = 1;
                v129[6] = 1;
                v128[0] = v129;
                int[] v130 = new int[8];
                v130[0] = 1;
                v130[7] = 1;
                v128[1] = v130;
                int[] v131 = new int[8];
                v131[0] = 1;
                v131[7] = 1;
                v128[2] = v131;
                int[] v132 = new int[8];
                v132[0] = 1;
                v132[7] = 1;
                v128[3] = v132;
                int[] v133 = new int[8];
                v133[0] = 1;
                v133[7] = 1;
                v128[4] = v133;
                int[] v134 = new int[8];
                v134[0] = 1;
                v134[7] = 1;
                v128[5] = v134;
                int[] v135 = new int[8];
                v135[0] = 1;
                v135[7] = 1;
                v128[6] = v135;
                int[] v136 = new int[8];
                v136[1] = 1;
                v136[2] = 1;
                v136[3] = 1;
                v136[4] = 1;
                v136[5] = 1;
                v136[6] = 1;
                v128[7] = v136;
                int[] v137 = new int[8];
                v137[7] = 1;
                v128[8] = v137;
                int[] v138 = new int[8];
                v138[7] = 1;
                v128[9] = v138;
                int[] v139 = new int[8];
                v139[7] = 1;
                v128[10] = v139;
                int[] v140 = new int[8];
                v140[7] = 1;
                v128[11] = v140;
                int[] v141 = new int[8];
                v141[7] = 1;
                v128[12] = v141;
                int[] v142 = new int[8];
                v142[7] = 1;
                v128[13] = v142;
                int[] v143 = new int[8];
                v143[1] = 1;
                v143[2] = 1;
                v143[3] = 1;
                v143[4] = 1;
                v143[5] = 1;
                v143[6] = 1;
                v128[14] = v143;
                yield v128;
            }
        };
    }

    @Override
    public void updateTime(ZonedDateTime TIME) {
        String timeString = Locale.US == this.clock.getLocale() ? AMPM_HHMMSS_FORMATTER.format(TIME) : HHMMSS_FORMATTER.format(TIME);
        this.oldHourLeft = this.hourLeft;
        this.oldHourRight = this.hourRight;
        this.oldMinLeft = this.minLeft;
        this.oldMinRight = this.minRight;
        this.oldSecLeft = this.secLeft;
        this.oldSecRight = this.secRight;
        this.hourLeft = Integer.parseInt(timeString.substring(0, 1));
        this.hourRight = Integer.parseInt(timeString.substring(1, 2));
        this.minLeft = Integer.parseInt(timeString.substring(3, 4));
        this.minRight = Integer.parseInt(timeString.substring(4, 5));
        this.secLeft = Integer.parseInt(timeString.substring(6, 7));
        this.secRight = Integer.parseInt(timeString.substring(7, 8));
        this.timer.start();
    }

    @Override
    public void updateAlarms() {
    }

    @Override
    protected void resize() {
        this.width = this.clock.getWidth() - this.clock.getInsets().getLeft() - this.clock.getInsets().getRight();
        this.height = this.clock.getHeight() - this.clock.getInsets().getTop() - this.clock.getInsets().getBottom();
        if (this.aspectRatio * this.width > this.height) {
            this.width = 1.0 / (this.aspectRatio / this.height);
        } else if (1.0 / (this.aspectRatio / this.height) > this.width) {
            this.height = this.aspectRatio * this.width;
        }
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.relocate((this.clock.getWidth() - this.height) * 0.5, (this.clock.getHeight() - this.height) * 0.5);
            this.canvas.setWidth(this.width);
            this.canvas.setHeight(this.height);
            this.dotSize = this.height * 0.045455;
            this.spacer = this.height * 0.022727;
            this.digitWidth = 8.0 * this.dotSize + 7.0 * this.spacer;
            this.digitHeight = 15.0 * this.dotSize + 14.0 * this.spacer;
            this.digitSpacer = this.height * 0.09090909;
        }
    }

    @Override
    protected void redraw() {
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.clock.getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(this.clock.getBorderWidth() / 415.0 * this.height))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.clock.getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.hourColor = this.clock.getHourColor();
        this.hourOffColor = Helper.getTranslucentColorFrom(this.hourColor, 0.15);
        this.minuteColor = this.clock.getMinuteColor();
        this.minuteOffColor = Helper.getTranslucentColorFrom(this.minuteColor, 0.15);
        this.secondColor = this.clock.getSecondColor();
        this.secondOffColor = Helper.getTranslucentColorFrom(this.secondColor, 0.15);
        this.hourGradient = new RadialGradient(0.0, 0.0, 0.5, 0.5, 1.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.hourColor), new Stop(0.25, this.hourColor), new Stop(0.43, this.hourColor.darker()), new Stop(0.48, this.hourColor.darker().darker().darker()), new Stop(0.5, this.hourColor.darker().darker().darker().darker())});
        this.hourOffGradient = new RadialGradient(0.0, 0.0, 0.5, 0.5, 1.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.hourOffColor), new Stop(0.25, this.hourOffColor), new Stop(0.43, this.hourOffColor.darker()), new Stop(0.48, this.hourOffColor.darker().darker().darker()), new Stop(0.5, this.hourOffColor.darker().darker().darker().darker())});
        this.minuteGradient = new RadialGradient(0.0, 0.0, 0.5, 0.5, 1.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.minuteColor), new Stop(0.25, this.minuteColor), new Stop(0.43, this.minuteColor.darker()), new Stop(0.48, this.minuteColor.darker().darker().darker()), new Stop(0.5, this.minuteColor.darker().darker().darker().darker())});
        this.minuteOffGradient = new RadialGradient(0.0, 0.0, 0.5, 0.5, 1.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.minuteOffColor), new Stop(0.25, this.minuteOffColor), new Stop(0.43, this.minuteOffColor.darker()), new Stop(0.48, this.minuteOffColor.darker().darker().darker()), new Stop(0.5, this.minuteOffColor.darker().darker().darker().darker())});
        this.secondGradient = new RadialGradient(0.0, 0.0, 0.5, 0.5, 1.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.secondColor), new Stop(0.25, this.secondColor), new Stop(0.43, this.secondColor.darker()), new Stop(0.48, this.secondColor.darker().darker().darker()), new Stop(0.5, this.secondColor.darker().darker().darker().darker())});
        this.secondOffGradient = new RadialGradient(0.0, 0.0, 0.5, 0.5, 1.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.secondOffColor), new Stop(0.25, this.secondOffColor), new Stop(0.43, this.secondOffColor.darker()), new Stop(0.48, this.secondOffColor.darker().darker().darker()), new Stop(0.5, this.secondOffColor.darker().darker().darker().darker())});
        this.drawTime();
    }
}

