/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.Section;
import eu.hansolo.medusa.skins.GaugeSkinBase;
import eu.hansolo.medusa.tools.Helper;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.collections.ListChangeListener;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.image.Image;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;

public class SectionSkin
extends GaugeSkinBase {
    private double START_ANGLE = 300.0;
    private double ANGLE_RANGE = 240.0;
    private double size;
    private Pane pane;
    private Path ring;
    private Canvas sectionsCanvas;
    private GraphicsContext sectionsCtx;
    private Circle mask;
    private Circle knob;
    private Path needle;
    private Rotate needleRotate;
    private Text valueText;
    private Text titleText;
    private double angleStep;
    private List<Section> sections;
    private boolean highlightSections;
    private boolean sectionsVisible;
    private double minValue;
    private double maxValue;
    private ListChangeListener<Section> sectionListener;
    private InvalidationListener currentValueListener;

    public SectionSkin(Gauge gauge) {
        super(gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.angleStep = this.ANGLE_RANGE / (gauge.getMaxValue() - gauge.getMinValue());
        this.sections = gauge.getSections();
        this.highlightSections = gauge.isHighlightSections();
        this.sectionsVisible = gauge.getSectionsVisible();
        this.minValue = gauge.getMinValue();
        this.maxValue = gauge.getMaxValue();
        this.sectionListener = c -> this.handleEvents("RESIZE");
        this.currentValueListener = o -> this.rotateNeedle(gauge.getCurrentValue());
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.gauge.getPrefWidth(), 0.0) <= 0 || Double.compare(this.gauge.getPrefHeight(), 0.0) <= 0 || Double.compare(this.gauge.getWidth(), 0.0) <= 0 || Double.compare(this.gauge.getHeight(), 0.0) <= 0) {
            if (this.gauge.getPrefWidth() > 0.0 && this.gauge.getPrefHeight() > 0.0) {
                this.gauge.setPrefSize(this.gauge.getPrefWidth(), this.gauge.getPrefHeight());
            } else {
                this.gauge.setPrefSize(250.0, 250.0);
            }
        }
        this.ring = new Path();
        this.ring.setFillRule(FillRule.EVEN_ODD);
        this.ring.setStroke(null);
        this.ring.setFill((Paint)Gauge.DARK_COLOR);
        this.ring.setEffect((Effect)new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)255, (int)255, (int)255, (double)0.35), 1.0, 0.0, 0.0, 1.0));
        this.sectionsCanvas = new Canvas(250.0, 250.0);
        this.sectionsCtx = this.sectionsCanvas.getGraphicsContext2D();
        this.mask = new Circle();
        this.mask.setStroke(null);
        this.mask.setFill(this.gauge.getBackgroundPaint());
        this.knob = new Circle();
        this.knob.setStroke(null);
        this.knob.setFill((Paint)this.gauge.getKnobColor());
        this.angleStep = this.ANGLE_RANGE / this.gauge.getRange();
        double targetAngle = 180.0 - this.START_ANGLE + (this.gauge.getValue() - this.gauge.getMinValue()) * this.angleStep;
        this.needleRotate = new Rotate(180.0 - this.START_ANGLE);
        this.needleRotate.setAngle(Helper.clamp(180.0 - this.START_ANGLE, 180.0 - this.START_ANGLE + this.ANGLE_RANGE, targetAngle));
        this.needle = new Path();
        this.needle.setFillRule(FillRule.EVEN_ODD);
        this.needle.setStroke(null);
        this.needle.getTransforms().setAll((Object[])new Transform[]{this.needleRotate});
        this.valueText = new Text(String.valueOf(Helper.formatNumber(this.gauge.getLocale(), this.gauge.getFormatString(), this.gauge.getDecimals(), this.gauge.getMinValue())) + this.gauge.getUnit());
        this.valueText.setMouseTransparent(true);
        this.valueText.setTextOrigin(VPos.CENTER);
        this.valueText.setFill((Paint)this.gauge.getValueColor());
        Helper.enableNode((Node)this.valueText, this.gauge.isValueVisible());
        this.titleText = new Text(this.gauge.getTitle());
        this.titleText.setTextOrigin(VPos.CENTER);
        this.titleText.setFill((Paint)this.gauge.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.gauge.getTitle().isEmpty());
        this.pane = new Pane(new Node[]{this.ring, this.sectionsCanvas, this.mask, this.knob, this.needle, this.valueText, this.titleText});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.gauge.getSections().addListener(this.sectionListener);
        this.gauge.currentValueProperty().addListener(this.currentValueListener);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("FINISHED".equals(EVENT_TYPE)) {
            if (this.gauge.getCheckSectionsForValue()) {
                double currentValue = this.gauge.getCurrentValue();
                int listSize = this.sections.size();
                int i = 0;
                while (i < listSize) {
                    this.sections.get(i).checkForValue(currentValue);
                    ++i;
                }
            }
            if (this.highlightSections) {
                this.drawSections();
            }
        } else if ("RECALC".equals(EVENT_TYPE)) {
            this.minValue = this.gauge.getMinValue();
            this.maxValue = this.gauge.getMaxValue();
            this.angleStep = this.ANGLE_RANGE / this.gauge.getRange();
            this.needleRotate.setAngle(180.0 - this.START_ANGLE + (this.gauge.getValue() - this.gauge.getMinValue()) * this.angleStep);
            this.resize();
            this.rotateNeedle(this.gauge.getCurrentValue());
        } else if ("SECTION".equals(EVENT_TYPE)) {
            this.sections = this.gauge.getSections();
            this.highlightSections = this.gauge.isHighlightSections();
            this.resize();
            this.redraw();
        } else if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.valueText, this.gauge.isValueVisible());
            Helper.enableNode((Node)this.titleText, !this.gauge.getTitle().isEmpty());
        }
    }

    @Override
    public void dispose() {
        this.gauge.getSections().removeListener(this.sectionListener);
        this.gauge.currentValueProperty().removeListener(this.currentValueListener);
        super.dispose();
    }

    private void rotateNeedle(double VALUE) {
        double targetAngle = 180.0 - this.START_ANGLE + (VALUE - this.gauge.getMinValue()) * this.angleStep;
        this.needleRotate.setAngle(Helper.clamp(180.0 - this.START_ANGLE, 180.0 - this.START_ANGLE + this.ANGLE_RANGE, targetAngle));
        this.valueText.setText(String.valueOf(Helper.formatNumber(this.gauge.getLocale(), this.gauge.getFormatString(), this.gauge.getDecimals(), VALUE)) + this.gauge.getUnit());
        this.valueText.setTranslateX((this.size - this.valueText.getLayoutBounds().getWidth()) * 0.5);
        if (this.valueText.getLayoutBounds().getWidth() > 0.395 * this.size) {
            this.resizeText();
        }
    }

    private void createNeedle() {
        double needleWidth = this.size * 0.04;
        double needleHeight = this.size * 0.4675;
        this.needle.getElements().clear();
        this.needle.getElements().add((Object)new MoveTo(0.3125 * needleWidth, 0.015957446808510637 * needleHeight));
        this.needle.getElements().add((Object)new CubicCurveTo(0.3125 * needleWidth, 0.005319148936170213 * needleHeight, 0.4375 * needleWidth, 0.0, 0.5 * needleWidth, 0.0));
        this.needle.getElements().add((Object)new CubicCurveTo(0.5625 * needleWidth, 0.0, 0.6875 * needleWidth, 0.005319148936170213 * needleHeight, 0.6875 * needleWidth, 0.015957446808510637 * needleHeight));
        this.needle.getElements().add((Object)new CubicCurveTo(0.6875 * needleWidth, 0.015957446808510637 * needleHeight, needleWidth, 0.9946808510638298 * needleHeight, needleWidth, 0.9946808510638298 * needleHeight));
        this.needle.getElements().add((Object)new LineTo(0.0, 0.9946808510638298 * needleHeight));
        this.needle.getElements().add((Object)new CubicCurveTo(0.0, 0.9946808510638298 * needleHeight, 0.3125 * needleWidth, 0.015957446808510637 * needleHeight, 0.3125 * needleWidth, 0.015957446808510637 * needleHeight));
        this.needle.getElements().add((Object)new ClosePath());
        this.needle.setFill((Paint)new LinearGradient(this.needle.getLayoutBounds().getMinX(), 0.0, this.needle.getLayoutBounds().getMaxX(), 0.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.gauge.getNeedleColor().darker()), new Stop(0.5, this.gauge.getNeedleColor()), new Stop(1.0, this.gauge.getNeedleColor().darker())}));
    }

    private void drawSections() {
        this.sectionsCtx.clearRect(0.0, 0.0, this.size, this.size);
        if (!this.sectionsVisible | this.sections.isEmpty()) {
            return;
        }
        double value = this.gauge.getCurrentValue();
        boolean sectionTextVisible = this.gauge.isSectionTextVisible();
        boolean sectionIconVisible = this.gauge.getSectionIconsVisible();
        double offset = this.START_ANGLE - 90.0;
        int listSize = this.sections.size();
        double xy = this.size * 0.0325;
        double wh = this.size - this.size * 0.065;
        double center = this.size * 0.5;
        this.angleStep = this.ANGLE_RANGE / this.gauge.getRange();
        this.sectionsCtx.setFont(Fonts.robotoCondensedLight(0.05 * this.size));
        this.sectionsCtx.setTextAlign(TextAlignment.CENTER);
        this.sectionsCtx.setTextBaseline(VPos.CENTER);
        int i = 0;
        while (i < listSize) {
            Section section = this.sections.get(i);
            if (!(section.getStart() > this.maxValue) && !(section.getStop() < this.minValue)) {
                Image icon;
                double SECTION_START_ANGLE = section.getStart() < this.minValue && section.getStop() < this.maxValue ? 0.0 : (section.getStart() - this.minValue) * this.angleStep;
                double SECTION_ANGLE_EXTEND = Double.compare(section.getStop(), this.maxValue) > 0 ? (this.maxValue - section.getStart()) * this.angleStep : (Double.compare(section.getStart(), this.minValue) < 0 ? (section.getStop() - this.minValue) * this.angleStep : (section.getStop() - section.getStart()) * this.angleStep);
                this.sectionsCtx.save();
                if (this.highlightSections) {
                    this.sectionsCtx.setFill((Paint)(section.contains(value) ? section.getHighlightColor() : section.getColor()));
                } else {
                    this.sectionsCtx.setFill((Paint)section.getColor());
                }
                this.sectionsCtx.fillArc(xy, xy, wh, wh, offset - SECTION_START_ANGLE, -SECTION_ANGLE_EXTEND, ArcType.ROUND);
                this.sectionsCtx.setStroke((Paint)Gauge.DARK_COLOR);
                this.sectionsCtx.setLineWidth(this.size * 0.005);
                this.sectionsCtx.strokeArc(xy, xy, wh, wh, offset - SECTION_START_ANGLE, -SECTION_ANGLE_EXTEND, ArcType.ROUND);
                if (sectionTextVisible) {
                    double angle = offset - 90.0 - SECTION_START_ANGLE - SECTION_ANGLE_EXTEND * 0.5;
                    sinValue = -Math.sin(Math.toRadians(angle));
                    cosValue = -Math.cos(Math.toRadians(angle));
                    double textPointX = center + this.size * 0.4 * sinValue;
                    double textPointY = center + this.size * 0.4 * cosValue;
                    this.sectionsCtx.save();
                    this.sectionsCtx.translate(textPointX, textPointY);
                    this.sectionsCtx.rotate(-angle);
                    this.sectionsCtx.translate(-textPointX, -textPointY);
                    this.sectionsCtx.setFill((Paint)section.getTextColor());
                    this.sectionsCtx.fillText(section.getText(), textPointX, textPointY, 0.2 * this.size);
                    this.sectionsCtx.restore();
                } else if (this.size > 0.0 && sectionIconVisible && (icon = section.getImage()) != null) {
                    sinValue = -Math.sin(Math.toRadians(offset - 90.0 - SECTION_START_ANGLE - SECTION_ANGLE_EXTEND * 0.5));
                    cosValue = -Math.cos(Math.toRadians(offset - 90.0 - SECTION_START_ANGLE - SECTION_ANGLE_EXTEND * 0.5));
                    Point2D iconPoint = new Point2D(center + this.size * 0.365 * sinValue, this.size * 0.5 + this.size * 0.365 * cosValue);
                    this.sectionsCtx.drawImage(icon, iconPoint.getX() - this.size * 0.06, iconPoint.getY() - this.size * 0.06, this.size * 0.12, this.size * 0.12);
                }
                this.sectionsCtx.restore();
            }
            ++i;
        }
    }

    private void resizeText() {
        double fontSize = this.size * 0.1;
        this.valueText.setFont(Fonts.robotoMedium(fontSize));
        double maxWidth = 0.395 * this.size;
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
        this.valueText.setTranslateX((this.size - this.valueText.getLayoutBounds().getWidth()) * 0.5);
        this.valueText.setTranslateY(this.size * 0.68);
        fontSize = this.size * 0.11;
        this.titleText.setFont(Fonts.robotoMedium(fontSize));
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        this.titleText.setTranslateX((this.size - this.titleText.getLayoutBounds().getWidth()) * 0.5);
        this.titleText.setTranslateY(this.size * 0.85);
    }

    @Override
    protected void resize() {
        double height;
        double width = this.gauge.getWidth() - this.gauge.getInsets().getLeft() - this.gauge.getInsets().getRight();
        double d = this.size = width < (height = this.gauge.getHeight() - this.gauge.getInsets().getTop() - this.gauge.getInsets().getBottom()) ? width : height;
        if (this.size > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((this.gauge.getWidth() - this.size) * 0.5, (this.gauge.getHeight() - this.size) * 0.5);
            this.ring.getElements().clear();
            this.ring.getElements().add((Object)new MoveTo(0.5 * this.size, 0.03 * this.size));
            this.ring.getElements().add((Object)new CubicCurveTo(0.76 * this.size, 0.03 * this.size, 0.97 * this.size, 0.24 * this.size, 0.97 * this.size, 0.5 * this.size));
            this.ring.getElements().add((Object)new CubicCurveTo(0.97 * this.size, 0.76 * this.size, 0.76 * this.size, 0.97 * this.size, 0.5 * this.size, 0.97 * this.size));
            this.ring.getElements().add((Object)new CubicCurveTo(0.24 * this.size, 0.97 * this.size, 0.03 * this.size, 0.76 * this.size, 0.03 * this.size, 0.5 * this.size));
            this.ring.getElements().add((Object)new CubicCurveTo(0.03 * this.size, 0.24 * this.size, 0.24 * this.size, 0.03 * this.size, 0.5 * this.size, 0.03 * this.size));
            this.ring.getElements().add((Object)new ClosePath());
            this.ring.getElements().add((Object)new MoveTo(0.5 * this.size, 0.2125 * this.size));
            this.ring.getElements().add((Object)new CubicCurveTo(0.6575 * this.size, 0.2125 * this.size, 0.7875 * this.size, 0.3425 * this.size, 0.7875 * this.size, 0.5 * this.size));
            this.ring.getElements().add((Object)new CubicCurveTo(0.7875 * this.size, 0.6575 * this.size, 0.6575 * this.size, 0.7875 * this.size, 0.5 * this.size, 0.7875 * this.size));
            this.ring.getElements().add((Object)new CubicCurveTo(0.3425 * this.size, 0.7875 * this.size, 0.2125 * this.size, 0.6575 * this.size, 0.2125 * this.size, 0.5 * this.size));
            this.ring.getElements().add((Object)new CubicCurveTo(0.2125 * this.size, 0.3425 * this.size, 0.3425 * this.size, 0.2125 * this.size, 0.5 * this.size, 0.2125 * this.size));
            this.ring.getElements().add((Object)new ClosePath());
            this.sectionsCanvas.setCache(false);
            this.sectionsCanvas.setWidth(this.size);
            this.sectionsCanvas.setHeight(this.size);
            this.drawSections();
            this.sectionsCanvas.setCache(true);
            this.sectionsCanvas.setCacheHint(CacheHint.QUALITY);
            this.mask.setCenterX(this.size * 0.5);
            this.mask.setCenterY(this.size * 0.5);
            this.mask.setRadius(this.size * 0.2855);
            this.knob.setCenterX(this.size * 0.5);
            this.knob.setCenterY(this.size * 0.5);
            this.knob.setRadius(this.size * 0.10375);
            this.needle.setCache(false);
            this.createNeedle();
            this.needle.setCache(true);
            this.needle.setCacheHint(CacheHint.ROTATE);
            this.needle.relocate((this.size - this.needle.getLayoutBounds().getWidth()) * 0.5, this.size * 0.5 - this.needle.getLayoutBounds().getHeight());
            this.needleRotate.setPivotX(this.needle.getLayoutBounds().getWidth() * 0.5);
            this.needleRotate.setPivotY(this.needle.getLayoutBounds().getMaxY());
            this.needleRotate.getAngle();
            this.gauge.getMinValue();
            this.valueText.setText(String.valueOf(Helper.formatNumber(this.gauge.getLocale(), this.gauge.getFormatString(), this.gauge.getDecimals(), this.gauge.getCurrentValue())) + this.gauge.getUnit());
            this.valueText.setVisible(this.gauge.isValueVisible());
            this.titleText.setText(this.gauge.getTitle());
            this.resizeText();
        }
    }

    @Override
    protected void redraw() {
        this.sectionsVisible = this.gauge.getSectionsVisible();
        this.drawSections();
        this.needle.setFill((Paint)new LinearGradient(this.needle.getLayoutBounds().getMinX(), 0.0, this.needle.getLayoutBounds().getMaxX(), 0.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.gauge.getNeedleColor().darker()), new Stop(0.5, this.gauge.getNeedleColor()), new Stop(1.0, this.gauge.getNeedleColor().darker())}));
        this.titleText.setFill((Paint)this.gauge.getTitleColor());
        this.valueText.setFill((Paint)this.gauge.getValueColor());
        this.mask.setFill(this.gauge.getBackgroundPaint());
        this.knob.setFill((Paint)this.gauge.getKnobColor());
        this.titleText.setText(this.gauge.getTitle());
        this.resizeText();
    }
}

