/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.tools;

import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.tools.ConicalGradient;
import eu.hansolo.medusa.tools.Helper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.geometry.Point2D;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;

public class AngleConicalGradient {
    private ConicalGradient gradient;

    public AngleConicalGradient(Map<Double, Color> ANGLE_STOP_MAP, Gauge.ScaleDirection DIRECTION) {
        this(0.0, 0.0, ANGLE_STOP_MAP, DIRECTION);
    }

    public AngleConicalGradient(double CENTER_X, double CENTER_Y, Map<Double, Color> ANGLE_STOP_MAP, Gauge.ScaleDirection DIRECTION) {
        this(CENTER_X, CENTER_Y, 0.0, ANGLE_STOP_MAP, DIRECTION);
    }

    public AngleConicalGradient(double CENTER_X, double CENTER_Y, double OFFSET_ANGLE, Map<Double, Color> ANGLE_STOP_MAP, Gauge.ScaleDirection DIRECTION) {
        double offset = Helper.clamp(0.0, 1.0, OFFSET_ANGLE % 360.0 * 0.002777777777777778);
        ArrayList<Stop> stops = new ArrayList<Stop>();
        for (double fraction : ANGLE_STOP_MAP.keySet()) {
            stops.add(new Stop(Helper.clamp(0.0, 1.0, fraction % 360.0 * 0.002777777777777778), ANGLE_STOP_MAP.get(fraction)));
        }
        this.gradient = new ConicalGradient(CENTER_X, CENTER_Y, offset, DIRECTION, stops);
    }

    public void recalculateWithAngle(double ANGLE) {
        this.gradient.recalculateWithAngle(ANGLE);
    }

    public List<Stop> getStops() {
        return this.gradient.getStops();
    }

    public double[] getCenter() {
        return this.gradient.getCenter();
    }

    public Point2D getCenterPoint() {
        return this.gradient.getCenterPoint();
    }

    public Image getImage(double WIDTH, double HEIGHT) {
        return this.gradient.getImage(WIDTH, HEIGHT);
    }

    public Image getRoundImage(double SIZE) {
        return this.gradient.getRoundImage(SIZE);
    }

    public ImagePattern apply(Shape SHAPE) {
        return this.gradient.apply(SHAPE);
    }

    public ImagePattern getImagePattern(Rectangle BOUNDS) {
        return this.gradient.getImagePattern(BOUNDS);
    }
}

