/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.tools;

import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.tools.Helper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeSet;
import javafx.animation.Interpolator;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.image.Image;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;

public class ConicalGradient {
    private static final double ANGLE_FACTOR = 0.002777777777777778;
    private double centerX;
    private double centerY;
    private List<Stop> sortedStops;
    private Gauge.ScaleDirection scaleDirection;
    private WritableImage rectRaster;
    private WritableImage roundRaster;

    public ConicalGradient() {
        this(0.0, 0.0, 0.0, Gauge.ScaleDirection.CLOCKWISE, Arrays.asList(new Stop[0]));
    }

    public ConicalGradient(Stop ... STOPS) {
        this(0.0, 0.0, 0.0, Gauge.ScaleDirection.CLOCKWISE, Arrays.asList(STOPS));
    }

    public ConicalGradient(List<Stop> STOPS) {
        this(0.0, 0.0, 0.0, Gauge.ScaleDirection.CLOCKWISE, STOPS);
    }

    public ConicalGradient(double CENTER_X, double CENTER_Y, Stop ... STOPS) {
        this(CENTER_X, CENTER_Y, Gauge.ScaleDirection.CLOCKWISE, STOPS);
    }

    public ConicalGradient(double CENTER_X, double CENTER_Y, Gauge.ScaleDirection DIRECTION, Stop ... STOPS) {
        this(CENTER_X, CENTER_Y, 0.0, DIRECTION, Arrays.asList(STOPS));
    }

    public ConicalGradient(double CENTER_X, double CENTER_Y, Gauge.ScaleDirection DIRECTION, List<Stop> STOPS) {
        this(CENTER_X, CENTER_Y, 0.0, DIRECTION, STOPS);
    }

    public ConicalGradient(double CENTER_X, double CENTER_Y, double OFFSET, Gauge.ScaleDirection DIRECTION, Stop ... STOPS) {
        this(CENTER_X, CENTER_Y, OFFSET, DIRECTION, Arrays.asList(STOPS));
    }

    public ConicalGradient(double CENTER_X, double CENTER_Y, double OFFSET, Gauge.ScaleDirection DIRECTION, List<Stop> STOPS) {
        this.centerX = CENTER_X;
        this.centerY = CENTER_Y;
        this.scaleDirection = DIRECTION;
        this.sortedStops = this.normalizeStops(OFFSET, STOPS);
    }

    public void recalculateWithAngle(double ANGLE) {
        double angle = ANGLE % 360.0;
        this.sortedStops = this.calculate(this.sortedStops, 0.002777777777777778 * angle);
        this.rectRaster = null;
        this.roundRaster = null;
    }

    public List<Stop> getStops() {
        return this.sortedStops;
    }

    public void setStops(Stop ... STOPS) {
        this.setStops(Arrays.asList(STOPS));
    }

    public void setStops(double OFFSET, Stop ... STOPS) {
        this.setStops(OFFSET, Arrays.asList(STOPS));
    }

    public void setStops(List<Stop> STOPS) {
        this.setStops(0.0, STOPS);
    }

    public void setStops(double OFFSET, List<Stop> STOPS) {
        this.sortedStops = this.normalizeStops(OFFSET, STOPS);
        this.rectRaster = null;
        this.roundRaster = null;
    }

    public double[] getCenter() {
        return new double[]{this.centerX, this.centerY};
    }

    public Point2D getCenterPoint() {
        return new Point2D(this.centerX, this.centerY);
    }

    public Image getImage(double WIDTH, double HEIGHT) {
        int height;
        int width = (int)WIDTH <= 0 ? 100 : (int)WIDTH;
        int n = height = (int)HEIGHT <= 0 ? 100 : (int)HEIGHT;
        if (this.rectRaster != null && (double)width == this.rectRaster.getWidth() && (double)height == this.rectRaster.getHeight()) {
            return this.rectRaster;
        }
        Color color = Color.TRANSPARENT;
        this.rectRaster = new WritableImage(width, height);
        PixelWriter PIXEL_WRITER = this.rectRaster.getPixelWriter();
        if (Double.compare(0.0, this.centerX) == 0) {
            this.centerX = (double)width * 0.5;
        }
        if (Double.compare(0.0, this.centerY) == 0) {
            this.centerY = (double)height * 0.5;
        }
        int calculatedStopsLength = this.sortedStops.size() - 1;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                double dx = (double)x - this.centerX;
                double dy = (double)y - this.centerY;
                double distance = Math.sqrt(dx * dx + dy * dy);
                distance = Double.compare(distance, 0.0) == 0 ? 1.0 : distance;
                double angle = this.adjustAngle(dx, dy, Math.abs(Math.toDegrees(Math.acos(dx / distance))));
                int i = 0;
                while (i < calculatedStopsLength) {
                    double offsetI = this.sortedStops.get(i).getOffset() * 360.0;
                    double offsetIPlus1 = this.sortedStops.get(i + 1).getOffset() * 360.0;
                    if (Double.compare(angle, offsetI) >= 0 && Double.compare(angle, offsetIPlus1) < 0) {
                        double fraction = (angle - offsetI) / (offsetIPlus1 - offsetI);
                        color = (Color)Interpolator.LINEAR.interpolate((Object)this.sortedStops.get(i).getColor(), (Object)this.sortedStops.get(i + 1).getColor(), fraction);
                    }
                    ++i;
                }
                PIXEL_WRITER.setColor(x, y, color);
                ++x;
            }
            ++y;
        }
        return this.rectRaster;
    }

    public Image getRoundImage(double SIZE) {
        int size;
        int n = size = (int)SIZE <= 0 ? 100 : (int)SIZE;
        if (this.roundRaster != null && (double)size == this.roundRaster.getWidth()) {
            return this.roundRaster;
        }
        Color color = Color.TRANSPARENT;
        this.roundRaster = new WritableImage(size, size);
        PixelWriter PIXEL_WRITER = this.roundRaster.getPixelWriter();
        if (Double.compare(0.0, this.centerX) == 0) {
            this.centerX = (double)size * 0.5;
        }
        if (Double.compare(0.0, this.centerY) == 0) {
            this.centerY = (double)size * 0.5;
        }
        double radius = (double)size * 0.5;
        int calculatedStopsLength = this.sortedStops.size() - 1;
        int y = 0;
        while (y < size) {
            int x = 0;
            while (x < size) {
                double dx = (double)x - this.centerX;
                double dy = (double)y - this.centerY;
                double distance = Math.sqrt(dx * dx + dy * dy);
                distance = Double.compare(distance, 0.0) == 0 ? 1.0 : distance;
                double angle = this.adjustAngle(dx, dy, Math.abs(Math.toDegrees(Math.acos(dx / distance))));
                double radiusMinus05 = radius - 0.25;
                double radiusMinus10 = radius - 0.5;
                double radiusMinus15 = radius - 1.0;
                double radiusMinus20 = radius - 1.5;
                if (distance > radius) {
                    color = Color.TRANSPARENT;
                } else {
                    int i = 0;
                    while (i < calculatedStopsLength) {
                        if (angle >= this.sortedStops.get(i).getOffset() * 360.0 && angle < this.sortedStops.get(i + 1).getOffset() * 360.0) {
                            double fraction = (angle - this.sortedStops.get(i).getOffset() * 360.0) / ((this.sortedStops.get(i + 1).getOffset() - this.sortedStops.get(i).getOffset()) * 360.0);
                            color = (Color)Interpolator.LINEAR.interpolate((Object)this.sortedStops.get(i).getColor(), (Object)this.sortedStops.get(i + 1).getColor(), fraction);
                            if (distance > radiusMinus05) {
                                color = color.deriveColor(0.0, 1.0, 1.0, 0.25);
                            } else if (distance > radiusMinus10) {
                                color = color.deriveColor(0.0, 1.0, 1.0, 0.45);
                            } else if (distance > radiusMinus15) {
                                color = color.deriveColor(0.0, 1.0, 1.0, 0.65);
                            } else if (distance > radiusMinus20) {
                                color = color.deriveColor(0.0, 1.0, 1.0, 0.85);
                            }
                        }
                        ++i;
                    }
                }
                PIXEL_WRITER.setColor(x, y, color);
                ++x;
            }
            ++y;
        }
        return this.roundRaster;
    }

    public ImagePattern apply(Shape SHAPE) {
        double x = SHAPE.getLayoutBounds().getMinX();
        double y = SHAPE.getLayoutBounds().getMinY();
        double width = SHAPE.getLayoutBounds().getWidth();
        double height = SHAPE.getLayoutBounds().getHeight();
        this.centerX = width * 0.5;
        this.centerY = height * 0.5;
        return new ImagePattern(this.getImage(width, height), x, y, width, height, false);
    }

    public ImagePattern getImagePattern(Bounds BOUNDS) {
        return this.getImagePattern(new Rectangle(BOUNDS.getMinX(), BOUNDS.getMinY(), BOUNDS.getWidth(), BOUNDS.getHeight()));
    }

    public ImagePattern getImagePattern(Rectangle BOUNDS) {
        double x = BOUNDS.getX();
        double y = BOUNDS.getY();
        double width = BOUNDS.getWidth();
        double height = BOUNDS.getHeight();
        this.centerX = width * 0.5;
        this.centerY = height * 0.5;
        return new ImagePattern(this.getImage(width, height), x, y, width, height, false);
    }

    private double adjustAngle(double DX, double DY, double angle) {
        if (Double.compare(DX, 0.0) >= 0 && Double.compare(DY, 0.0) <= 0) {
            angle = 90.0 - angle;
        } else if (Double.compare(DX, 0.0) >= 0 && Double.compare(DY, 0.0) >= 0) {
            angle += 90.0;
        } else if (Double.compare(DX, 0.0) <= 0 && Double.compare(DY, 0.0) >= 0) {
            angle += 90.0;
        } else if (Double.compare(DX, 0.0) <= 0 && Double.compare(DY, 0.0) <= 0) {
            angle = 450.0 - angle;
        }
        return angle;
    }

    private List<Stop> calculate(List<Stop> STOPS, double OFFSET) {
        ArrayList<Stop> stops = new ArrayList<Stop>(STOPS.size());
        BigDecimal STEP = new BigDecimal(Double.MIN_VALUE);
        for (Stop stop : STOPS) {
            double offset = stop.getOffset();
            Color color = stop.getColor();
            BigDecimal newOffsetBD = new BigDecimal(offset + OFFSET).remainder(BigDecimal.ONE);
            if (newOffsetBD.equals(BigDecimal.ZERO)) {
                newOffsetBD = BigDecimal.ONE;
                stops.add(new Stop(Double.MIN_VALUE, color));
            } else if (Double.compare(offset + OFFSET, 1.0) > 0) {
                newOffsetBD = newOffsetBD.subtract(STEP);
            }
            stops.add(new Stop(newOffsetBD.doubleValue(), color));
        }
        LinkedHashMap<Double, Color> stopMap = new LinkedHashMap<Double, Color>(stops.size());
        for (Stop stop : stops) {
            stopMap.put(stop.getOffset(), stop.getColor());
        }
        ArrayList<Stop> sortedStops = new ArrayList<Stop>(stops.size());
        TreeSet sortedFractions = new TreeSet(((HashMap)stopMap).keySet());
        if ((Double)sortedFractions.last() < 1.0) {
            stopMap.put(1.0, (Color)((HashMap)stopMap).get(sortedFractions.first()));
            sortedFractions.add(1.0);
        }
        if ((Double)sortedFractions.first() > 0.0) {
            stopMap.put(0.0, (Color)((HashMap)stopMap).get(sortedFractions.last()));
            sortedFractions.add(0.0);
        }
        Iterator iterator = sortedFractions.iterator();
        while (iterator.hasNext()) {
            double fraction = (Double)iterator.next();
            sortedStops.add(new Stop(fraction, (Color)((HashMap)stopMap).get(fraction)));
        }
        return sortedStops;
    }

    private List<Stop> normalizeStops(double OFFSET, List<Stop> STOPS) {
        ArrayList<Stop> stops;
        double offset = Helper.clamp(0.0, 1.0, OFFSET);
        if (STOPS == null || STOPS.isEmpty()) {
            stops = new ArrayList();
            stops.add(new Stop(0.0, Color.TRANSPARENT));
            stops.add(new Stop(1.0, Color.TRANSPARENT));
        } else {
            stops = STOPS;
        }
        List<Stop> sortedStops = this.calculate(stops, offset);
        if (Gauge.ScaleDirection.COUNTER_CLOCKWISE == this.scaleDirection) {
            ArrayList<Stop> sortedStops3 = new ArrayList<Stop>();
            Collections.reverse(sortedStops);
            for (Stop stop : sortedStops) {
                sortedStops3.add(new Stop(1.0 - stop.getOffset(), stop.getColor()));
            }
            sortedStops = sortedStops3;
        }
        return sortedStops;
    }
}

