/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox;

import eu.hansolo.toolbox.Constants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.NumberFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.WeekFields;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.stream.Collector;
import java.util.zip.CRC32;

public class Helper {
    private static final Matcher INT_MATCHER = Constants.INT_PATTERN.matcher("");
    private static final Matcher FLOAT_MATCHER = Constants.FLOAT_PATTERN.matcher("");
    private static final Matcher HEX_MATCHER = Constants.HEX_PATTERN.matcher("");
    private static final NavigableMap<Long, String> SUFFIXES = new TreeMap<Long, String>(Map.of(1000L, "k", 1000000L, "M", 1000000000L, "G", 1000000000000L, "T", 1000000000000000L, "P", 1000000000000000000L, "E"));

    private Helper() {
    }

    public static final <T extends Number> T clamp(T min, T max, T value) {
        if (value.doubleValue() < min.doubleValue()) {
            return min;
        }
        if (value.doubleValue() > max.doubleValue()) {
            return max;
        }
        return value;
    }

    public static final int clamp(int min, int max, int value) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static final long clamp(long min, long max, long value) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static final double clamp(double min, double max, double value) {
        if (Double.compare(value, min) < 0) {
            return min;
        }
        if (Double.compare(value, max) > 0) {
            return max;
        }
        return value;
    }

    public static final Instant clamp(Instant min, Instant max, Instant value) {
        if (value.isBefore(min)) {
            return min;
        }
        if (value.isAfter(max)) {
            return max;
        }
        return value;
    }

    public static final LocalDateTime clamp(LocalDateTime min, LocalDateTime max, LocalDateTime value) {
        if (value.isBefore(min)) {
            return min;
        }
        if (value.isAfter(max)) {
            return max;
        }
        return value;
    }

    public static final LocalDate clamp(LocalDate min, LocalDate max, LocalDate value) {
        if (value.isBefore(min)) {
            return min;
        }
        if (value.isAfter(max)) {
            return max;
        }
        return value;
    }

    public static final double clampMin(double min, double value) {
        if (value < min) {
            return min;
        }
        return value;
    }

    public static final double clampMax(double max, double value) {
        if (value > max) {
            return max;
        }
        return value;
    }

    public static final boolean almostEqual(double value1, double value2, double epsilon) {
        return Math.abs(value1 - value2) < epsilon;
    }

    public static final double round(double value, int precision) {
        int SCALE = (int)Math.pow(10.0, precision);
        return (double)Math.round(value * (double)SCALE) / (double)SCALE;
    }

    public static final double roundTo(double value, double target) {
        return target * (double)Math.round(value / target);
    }

    public static final double roundToHalf(double value) {
        return (double)Math.round(value * 2.0) / 2.0;
    }

    public static final int roundDoubleToInt(double value) {
        int i;
        double dAbs = Math.abs(value);
        double result = dAbs - (double)(i = (int)dAbs);
        if (result < 0.5) {
            return value < 0.0 ? -i : i;
        }
        return value < 0.0 ? -(i + 1) : i + 1;
    }

    public static final boolean equals(double a, double b) {
        return a == b || Math.abs(a - b) < 1.0E-6;
    }

    public static final boolean biggerThan(double a, double b) {
        return a - b > 1.0E-6;
    }

    public static final boolean lessThan(double a, double b) {
        return b - a > 1.0E-6;
    }

    public static final boolean isPositiveInteger(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        return Constants.POSITIVE_INTEGER_PATTERN.matcher(text).matches();
    }

    public static final String trimPrefix(String text, String prefix) {
        return text.replaceFirst(prefix, "");
    }

    public static final DateTimeFormatter getDateFormat(Locale locale) {
        if (Locale.US == locale) {
            return DateTimeFormatter.ofPattern("MM/dd/YYYY");
        }
        if (Locale.CHINA == locale) {
            return DateTimeFormatter.ofPattern("YYYY.MM.dd");
        }
        return DateTimeFormatter.ofPattern("dd.MM.YYYY");
    }

    public static final DateTimeFormatter getLocalizedDateFormat(Locale locale) {
        return DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT).withLocale(locale);
    }

    public static final String normalize(String text) {
        String normalized = text.replace("\u00fc", "ue").replace("\u00f6", "oe").replace("\u00e4", "ae").replace("\u00df", "ss");
        normalized = normalized.replace("\u00dc(?=[a-z\u00fc\u00f6\u00e4\u00df ])", "Ue").replace("\u00d6(?=[a-z\u00fc\u00f6\u00e4\u00df ])", "Oe").replace("\u00c4(?=[a-z\u00fc\u00f6\u00e4\u00df ])", "Ae");
        normalized = normalized.replace("\u00dc", "UE").replace("\u00d6", "OE").replace("\u00c4", "AE");
        return normalized;
    }

    public static final int getDegrees(double decDeg) {
        return (int)decDeg;
    }

    public static final int getMinutes(double decDeg) {
        return (int)((decDeg - (double)Helper.getDegrees(decDeg)) * 60.0);
    }

    public static final double getSeconds(double decDeg) {
        return ((decDeg - (double)Helper.getDegrees(decDeg)) * 60.0 - (double)Helper.getMinutes(decDeg)) * 60.0;
    }

    public static final double getDecimalDeg(int degrees, int minutes, double seconds) {
        return (seconds / 60.0 + (double)minutes) / 60.0 + (double)degrees;
    }

    public static final <T> Predicate<T> not(Predicate<T> predicate) {
        return predicate.negate();
    }

    public static <T> Collector<T, ?, List<T>> lastN(int n) {
        return Collector.of(ArrayDeque::new, (acc, t) -> {
            if (acc.size() == n) {
                acc.pollFirst();
            }
            acc.add(t);
        }, (acc1, acc2) -> {
            while (acc2.size() < n && !acc1.isEmpty()) {
                acc2.addFirst(acc1.pollLast());
            }
            return acc2;
        }, ArrayList::new, new Collector.Characteristics[0]);
    }

    public static final double getDoubleFromText(String text) {
        if (text == null || text.isEmpty()) {
            return 0.0;
        }
        FLOAT_MATCHER.reset(text);
        String result = "";
        double number = 0.0;
        try {
            while (FLOAT_MATCHER.find()) {
                result = FLOAT_MATCHER.group(0);
            }
            number = Double.parseDouble(result);
        }
        catch (IllegalStateException | NumberFormatException runtimeException) {
            return 0.0;
        }
        return number;
    }

    public static final int getIntFromText(String text) {
        INT_MATCHER.reset(text);
        String result = "";
        int number = 0;
        try {
            while (INT_MATCHER.find()) {
                result = INT_MATCHER.group(0);
            }
            number = Integer.parseInt(result);
        }
        catch (IllegalStateException | NumberFormatException runtimeException) {
            return 0;
        }
        return number;
    }

    public static final String getHexColorFromString(String text) {
        HEX_MATCHER.reset(text);
        String result = "";
        try {
            while (HEX_MATCHER.find()) {
                result = HEX_MATCHER.group(0);
            }
        }
        catch (IllegalStateException illegalStateException) {
            return "-";
        }
        return result;
    }

    public static final String readFromInputStream(InputStream inputStream) throws IOException {
        StringBuilder resultStringBuilder = new StringBuilder();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = br.readLine()) != null) {
                resultStringBuilder.append(line).append("\n");
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return resultStringBuilder.toString();
    }

    public static final String readTextFileToString(String filename) {
        if (filename == null || !new File(filename).exists()) {
            throw new IllegalArgumentException("File: " + filename + " not found or null");
        }
        try {
            Path fileObj = Path.of(filename, new String[0]);
            return Files.readString(fileObj);
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static final String readTextFileToString(File file) {
        if (file == null || !file.isFile()) {
            throw new IllegalArgumentException("Given file is either null or no file");
        }
        try {
            Path fileObj = file.toPath();
            return Files.readString(fileObj);
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static final void saveStringToTextFile(String filename, String text) {
        if (filename == null || filename.isEmpty()) {
            throw new IllegalArgumentException("filename cannot be null or empty");
        }
        if (text == null || text.isEmpty()) {
            throw new IllegalArgumentException("text cannot be null or empty");
        }
        try {
            Files.write(Paths.get("/" + filename, new String[0]), text.getBytes(), new OpenOption[0]);
        }
        catch (IOException iOException) {}
    }

    public static final LocalDate getFirstDayOfWeek(int year, int weekNumber, Locale locale) {
        return LocalDate.of(year, 2, 1).with(WeekFields.of(locale).getFirstDayOfWeek()).with(WeekFields.of(locale).weekOfWeekBasedYear(), weekNumber);
    }

    public static final long getEpochSecondsOfFirstDayOfWeek(int year, int weekNumber, Locale locale) {
        return Helper.getFirstDayOfWeek(year, weekNumber, locale).atStartOfDay().toEpochSecond(ZoneOffset.UTC);
    }

    public static final LocalDate getLastDayOfWeek(int year, int weekNumber, Locale locale) {
        return Helper.getFirstDayOfWeek(year, weekNumber, locale).plusDays(6L);
    }

    public static final long getEpochSecondsOfLastDayOfWeek(int year, int weekNumber, Locale locale) {
        return Helper.getLastDayOfWeek(year, weekNumber, locale).atStartOfDay().toEpochSecond(ZoneOffset.UTC);
    }

    public static final int getWeekOfYear(ZonedDateTime zonedDateTime) {
        return Helper.getWeekOfYear(zonedDateTime.toInstant(), zonedDateTime.getZone());
    }

    public static final int getWeekOfYeear(Instant instant) {
        return Helper.getWeekOfYear(instant, ZoneId.systemDefault());
    }

    public static final int getWeekOfYear(Instant instant, ZoneId zoneId) {
        return Helper.getWeekOfYear(LocalDate.ofInstant(instant, zoneId));
    }

    public static final int getWeekOfYear(LocalDateTime dateTime) {
        return Helper.getWeekOfYear(dateTime.toLocalDate());
    }

    public static final int getWeekOfYear(LocalDate date) {
        return date.get(ChronoField.ALIGNED_WEEK_OF_YEAR);
    }

    public static final int getWeekOfYear(long epochSeconds) {
        return Helper.getWeekOfYear(epochSeconds, ZoneId.systemDefault());
    }

    public static final int getWeekOfYear(long epochSeconds, ZoneId zoneId) {
        if (epochSeconds < 0L) {
            throw new IllegalArgumentException("Epochseconds cannot be smaller than 0");
        }
        return LocalDate.ofInstant(Instant.ofEpochSecond(epochSeconds), zoneId).get(ChronoField.ALIGNED_WEEK_OF_YEAR);
    }

    public static final String shortenNumber(long value) {
        return Helper.shortenNumber(value, Locale.US);
    }

    public static final String shortenNumber(long value, Locale locale) {
        if (value == Long.MIN_VALUE) {
            return Helper.shortenNumber(-9223372036854775807L, locale);
        }
        if (value < 0L) {
            return "-" + Helper.shortenNumber(-value, locale);
        }
        if (value < 1000L) {
            return Long.toString(value);
        }
        Map.Entry<Long, String> entry = SUFFIXES.floorEntry(value);
        Long divideBy = entry.getKey();
        String suffix = entry.getValue();
        long truncated = value / (divideBy / 10L);
        boolean hasDecimal = truncated < 100L && (double)truncated / 10.0 != (double)(truncated / 10L);
        NumberFormat formatter = NumberFormat.getNumberInstance(locale);
        formatter.setMinimumFractionDigits(1);
        formatter.setMaximumFractionDigits(1);
        return hasDecimal ? String.valueOf(formatter.format((double)truncated / 10.0)) + suffix : String.valueOf(truncated / 10L) + suffix;
    }

    public static final <K, V extends Comparable<V>> V getMaxValueInMap(Map<K, V> map) {
        Map.Entry maxEntry = Collections.max(map.entrySet(), Comparator.comparing(Map.Entry::getValue));
        return (V)((Comparable)maxEntry.getValue());
    }

    public static final <K, V extends Comparable<V>> K getKeyWithMaxValueInMap(Map<K, V> map) {
        Map.Entry maxEntry = Collections.max(map.entrySet(), Comparator.comparing(Map.Entry::getValue));
        return maxEntry.getKey();
    }

    public static final String secondsToHHMMString(long seconds) {
        long[] hhmmss = Helper.secondsToHHMMSS(seconds);
        return String.format("%02d:%02d:%02d", hhmmss[0], hhmmss[1], hhmmss[2]);
    }

    public static final long[] secondsToHHMMSS(long seconds) {
        long secs = seconds % 60L;
        long minutes = secs / 60L % 60L;
        long hours = secs / 3600L % 24L;
        return new long[]{hours, minutes, secs};
    }

    public static final long getCRC32Checksum(byte[] bytes) {
        CRC32 crc32 = new CRC32();
        crc32.update(bytes, 0, bytes.length);
        return crc32.getValue();
    }

    public static final String getMD5(String text) {
        return Helper.bytesToHex(Helper.getMD5Bytes(text.getBytes(StandardCharsets.UTF_8)));
    }

    public static final String getMD5(byte[] bytes) {
        return Helper.bytesToHex(Helper.getMD5Bytes(bytes));
    }

    public static final byte[] getMD5Bytes(byte[] bytes) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("Error getting MD5 algorithm. " + e.getMessage());
            return new byte[0];
        }
        return md.digest(bytes);
    }

    public static final String getMD5ForFile(File file) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        try (FileInputStream fis = new FileInputStream(file);){
            int n = 0;
            byte[] buffer = new byte[4096];
            while (n != -1) {
                n = ((InputStream)fis).read(buffer);
                if (n <= 0) continue;
                md.update(buffer, 0, n);
            }
        }
        byte[] byteData = md.digest();
        return Helper.getMD5(Helper.bytesToHex(byteData));
    }

    public static final String getSHA1(String text) {
        return Helper.bytesToHex(Helper.getSHA1Bytes(text.getBytes(StandardCharsets.UTF_8)));
    }

    public static final String getSHA1(byte[] bytes) {
        return Helper.bytesToHex(Helper.getSHA1Bytes(bytes));
    }

    public static final byte[] getSHA1Bytes(byte[] bytes) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("Error getting SHA-1 algorithm. " + e.getMessage());
            return new byte[0];
        }
        return md.digest(bytes);
    }

    public static final String getSHA1ForFile(File file) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        try (FileInputStream fis = new FileInputStream(file);){
            int n = 0;
            byte[] buffer = new byte[4096];
            while (n != -1) {
                n = ((InputStream)fis).read(buffer);
                if (n <= 0) continue;
                md.update(buffer, 0, n);
            }
        }
        byte[] byteData = md.digest();
        return Helper.getSHA1(Helper.bytesToHex(byteData));
    }

    public static final String getSHA256(String text) {
        return Helper.bytesToHex(Helper.getSHA256Bytes(text.getBytes(StandardCharsets.UTF_8)));
    }

    public static final String getSHA256(byte[] bytes) {
        return Helper.bytesToHex(Helper.getSHA256Bytes(bytes));
    }

    public static final byte[] getSHA256Bytes(byte[] bytes) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("Error getting SHA2-256 algorithm. " + e.getMessage());
            return new byte[0];
        }
        return md.digest(bytes);
    }

    public static final String getSHA256ForFile(File file) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        try (FileInputStream fis = new FileInputStream(file);){
            int n = 0;
            byte[] buffer = new byte[4096];
            while (n != -1) {
                n = ((InputStream)fis).read(buffer);
                if (n <= 0) continue;
                md.update(buffer, 0, n);
            }
        }
        byte[] byteData = md.digest();
        return Helper.getSHA256(Helper.bytesToHex(byteData));
    }

    public static final String getSHA3_256(String text) {
        return Helper.bytesToHex(Helper.getSHA3_256Bytes(text.getBytes(StandardCharsets.UTF_8)));
    }

    public static final String getSHA3_256(byte[] bytes) {
        return Helper.bytesToHex(Helper.getSHA3_256Bytes(bytes));
    }

    public static final byte[] getSHA3_256Bytes(byte[] bytes) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA3-256");
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("Error getting SHA3-256 algorithm. " + e.getMessage());
            return new byte[0];
        }
        return md.digest(bytes);
    }

    public static final String getSHA3_256ForFile(File file) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA3-256");
        try (FileInputStream fis = new FileInputStream(file);){
            int n = 0;
            byte[] buffer = new byte[4096];
            while (n != -1) {
                n = ((InputStream)fis).read(buffer);
                if (n <= 0) continue;
                md.update(buffer, 0, n);
            }
        }
        byte[] byteData = md.digest();
        return Helper.getSHA3_256(Helper.bytesToHex(byteData));
    }

    public static final String bytesToHex(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            builder.append(String.format("%02x", b));
            ++n2;
        }
        return builder.toString();
    }

    public static final Optional<String> nonEmpty(String text) {
        return text == null || text.length() == 0 ? Optional.empty() : Optional.ofNullable(text);
    }
}

