/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox.evt;

import eu.hansolo.toolbox.evt.Evt;
import java.util.Objects;

public final class EvtType<T extends Evt> {
    public static final EvtType<Evt> ROOT = new EvtType("EVENT", null);
    private final EvtType<? super T> superType;
    private final String name;

    public EvtType(EvtType<? super T> superType) {
        this(superType, null);
    }

    public EvtType(String name) {
        this(ROOT, name);
    }

    public EvtType(EvtType<? super T> superType, String name) {
        if (superType == null) {
            throw new NullPointerException("Event super type must not be null (EvtType.name: " + name + ")");
        }
        this.superType = superType;
        this.name = name;
    }

    EvtType(String name, EvtType<? super T> superType) {
        this.superType = superType;
        this.name = name;
    }

    public final EvtType<? super T> getSuperType() {
        return this.superType;
    }

    public final String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvtType evtType = (EvtType)o;
        return this.superType.equals(evtType.superType) && this.name.equals(evtType.name);
    }

    public int hashCode() {
        return Objects.hash(this.superType, this.name);
    }

    public String toString() {
        return this.name != null ? "{" + "\"" + "class" + "\"" + ":" + "\"" + this.getClass().getName() + "\"" + "," + "\"" + "name" + "\"" + ":" + "\"" + this.getName() + "\"" + "," + "\"" + "supertype" + "\"" + ":" + "\"" + this.getSuperType().name + "\"" + "}" : super.toString();
    }
}

