/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox.observables;

import eu.hansolo.toolbox.evt.EvtObserver;
import eu.hansolo.toolbox.evt.EvtType;
import eu.hansolo.toolbox.evt.type.MatrixChangeEvt;
import eu.hansolo.toolbox.evt.type.MatrixItemChangeEvt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ObservableMatrix<T> {
    private final Class<T> type;
    private Map<EvtType, List<EvtObserver<MatrixChangeEvt<T>>>> matrixObservers;
    private Map<EvtType, List<EvtObserver<MatrixItemChangeEvt<T>>>> itemObservers;
    private AtomicReference<T>[][] matrix;
    private volatile int cols;
    private volatile int rows;
    private boolean colsMirrored;
    private boolean rowsMirrored;
    private boolean resizeMatrixWhenInnerRowOrColIsRemoved;

    public ObservableMatrix(Class<T> type, int cols, int rows) {
        this(type, cols, rows, false);
    }

    public ObservableMatrix(Class<T> type, int cols, int rows, boolean resizeMatrixWhenInnerRowOrColIsRemoved) {
        this.type = type;
        this.matrixObservers = new ConcurrentHashMap<EvtType, List<EvtObserver<MatrixChangeEvt<T>>>>();
        this.itemObservers = new ConcurrentHashMap<EvtType, List<EvtObserver<MatrixItemChangeEvt<T>>>>();
        this.matrix = ObservableMatrix.createArray(type, cols, rows);
        this.cols = cols;
        this.rows = rows;
        this.colsMirrored = false;
        this.rowsMirrored = false;
        this.resizeMatrixWhenInnerRowOrColIsRemoved = resizeMatrixWhenInnerRowOrColIsRemoved;
    }

    public ObservableMatrix(ObservableMatrix<T> copyFromMatrix) {
        this.type = copyFromMatrix.getType();
        this.matrixObservers = new ConcurrentHashMap<EvtType, List<EvtObserver<MatrixChangeEvt<T>>>>();
        this.itemObservers = new ConcurrentHashMap<EvtType, List<EvtObserver<MatrixItemChangeEvt<T>>>>();
        this.matrix = ObservableMatrix.createArray(this.type, copyFromMatrix.cols, copyFromMatrix.rows);
        this.cols = copyFromMatrix.cols;
        this.rows = copyFromMatrix.rows;
        this.colsMirrored = copyFromMatrix.colsMirrored;
        this.rowsMirrored = copyFromMatrix.rowsMirrored;
        this.resizeMatrixWhenInnerRowOrColIsRemoved = copyFromMatrix.resizeMatrixWhenInnerRowOrColIsRemoved;
        int y = 0;
        while (y < this.rows) {
            int x = 0;
            while (x < this.cols) {
                this.setItemAt(x, y, copyFromMatrix.getItemAt(x, y));
                ++x;
            }
            ++y;
        }
    }

    public Class<T> getType() {
        return this.type;
    }

    public T getItemAt(int x, int y) {
        if (x < 0 || x > this.cols - 1 || y < 0 || y > this.rows - 1) {
            throw new IllegalArgumentException("cols/rows cannot be smaller than 0/0 or larger than " + (this.cols - 1) + "/" + (this.rows - 1));
        }
        return this.matrix[x][y].get();
    }

    public void setItemAt(int x, int y, T item) {
        this.setItemAt(x, y, item, true);
    }

    public void setItemAt(int x, int y, T item, boolean notify) {
        if (x < 0 || x > this.cols - 1 || y < 0 || y > this.rows - 1) {
            throw new IllegalArgumentException("cols/rows cannot be smaller than 0");
        }
        T oldItem = this.matrix[x][y].get();
        this.matrix[x][y].set(item);
        if (notify) {
            if (oldItem == null && item != null) {
                this.fireMatrixItemChangeEvt(new MatrixItemChangeEvt<T>(this, MatrixItemChangeEvt.ITEM_ADDED, x, y, oldItem, item));
            } else if (oldItem != null && item == null) {
                this.fireMatrixItemChangeEvt(new MatrixItemChangeEvt<T>(this, MatrixItemChangeEvt.ITEM_REMOVED, x, y, oldItem, item));
            } else if (oldItem != null && item != null) {
                this.fireMatrixItemChangeEvt(new MatrixItemChangeEvt<T>(this, MatrixItemChangeEvt.ITEM_CHANGED, x, y, oldItem, item));
            } else {
                return;
            }
        }
    }

    public void removeItemAt(int x, int y) {
        this.removeItemAt(x, y, true);
    }

    public void removeItemAt(int x, int y, boolean notify) {
        if (x < 0 || x > this.cols - 1 || y < 0 || y > this.rows - 1) {
            throw new IllegalArgumentException("cols/rows cannot be smaller than 0");
        }
        T oldItem = this.matrix[x][y].get();
        this.matrix[x][y].set(null);
        if (notify) {
            this.fireMatrixItemChangeEvt(new MatrixItemChangeEvt<Object>(this, MatrixItemChangeEvt.ITEM_REMOVED, x, y, oldItem, null));
        }
        this.checkForRemovedColumnsAndRows(x, y, notify);
    }

    public void removeItem(T item) {
        this.removeItem(item, true);
    }

    public void removeItem(T item, boolean notify) {
        int y = 0;
        while (y < this.rows) {
            int x = 0;
            while (x < this.cols) {
                T matrixItem = this.matrix[x][y].get();
                if (matrixItem != null && matrixItem.equals(item)) {
                    this.matrix[x][y] = null;
                    if (notify) {
                        this.fireMatrixItemChangeEvt(new MatrixItemChangeEvt<Object>(this, MatrixItemChangeEvt.ITEM_REMOVED, x, y, item, null));
                    }
                    this.checkForRemovedColumnsAndRows(x, y, notify);
                    return;
                }
                ++x;
            }
            ++y;
        }
    }

    public boolean contains(T item) {
        int y = 0;
        while (y < this.rows) {
            int x = 0;
            while (x < this.cols) {
                if (this.matrix[x][y] != null && this.matrix[x][y].equals(item)) {
                    return true;
                }
                ++x;
            }
            ++y;
        }
        return false;
    }

    public int[] getIndicesOf(T item) {
        int y = 0;
        while (y < this.rows) {
            int x = 0;
            while (x < this.cols) {
                if (this.matrix[x][y].equals(item)) {
                    return new int[]{x, y};
                }
                ++x;
            }
            ++y;
        }
        return new int[]{-1, -1};
    }

    public AtomicReference<T>[][] getMatrix() {
        return this.matrix;
    }

    public List<AtomicReference<T>> getAllItems() {
        return this.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Stream<AtomicReference<T>> stream() {
        return Arrays.stream(this.matrix).flatMap(t -> Arrays.stream(t));
    }

    public void reset() {
        if (this.rows == -1 || this.cols == -1) {
            throw new IllegalArgumentException("cols/rows cannot be smaller 0");
        }
        int y = 0;
        while (y < this.rows) {
            int x = 0;
            while (x < this.cols) {
                this.matrix[x][y] = null;
                ++x;
            }
            ++y;
        }
    }

    public List<T> getCol(int col) {
        if (this.rows == -1 || this.cols == -1 || col < 0 || col > this.cols) {
            throw new IllegalArgumentException("cols/rows cannot be smaller 0");
        }
        ArrayList<T> c = new ArrayList<T>();
        int y = 0;
        while (y < this.rows) {
            c.add(this.matrix[col][y].get());
            ++y;
        }
        return c;
    }

    public List<T> getRow(int row) {
        if (this.rows == -1 || this.cols == -1 || row < 0 || row > this.rows) {
            throw new IllegalArgumentException("cols/rows cannot be smaller 0");
        }
        ArrayList<T> r = new ArrayList<T>();
        int x = 0;
        while (x < this.cols) {
            r.add(this.matrix[x][row].get());
            ++x;
        }
        return r;
    }

    public boolean isColEmpty(int col) {
        List<T> c = this.getCol(col);
        long count = 0L;
        for (T item : c) {
            if (item == null) continue;
            ++count;
        }
        return 0L == count;
    }

    public boolean isRowEmpty(int row) {
        List<T> r = this.getRow(row);
        long count = 0L;
        for (T item : r) {
            if (item == null) continue;
            ++count;
        }
        return 0L == count;
    }

    public int getNoOfCols() {
        return this.cols;
    }

    public void setCols(int cols) {
        this.setCols(cols, true);
    }

    public void setCols(int cols, boolean notify) {
        if (this.rows == -1 || cols == -1 || this.cols == -1) {
            throw new IllegalArgumentException("cols/rows cannot be smaller 0");
        }
        AtomicReference[][] oldMatrix = new AtomicReference[cols][this.rows];
        int y = 0;
        while (y < this.rows) {
            int x = 0;
            while (x < this.cols) {
                oldMatrix[x][y].set(this.matrix[x][y].get());
                ++x;
            }
            ++y;
        }
        int oldCols = this.cols;
        this.cols = cols;
        this.matrix = ObservableMatrix.createArray(this.type, cols, this.rows);
        int r = this.rows;
        int c = cols > this.cols ? oldCols : (cols < this.cols ? cols : cols);
        int y2 = 0;
        while (y2 < r) {
            int x = 0;
            while (x < c) {
                this.matrix[x][y2].set(oldMatrix[x][y2].get());
                ++x;
            }
            ++y2;
        }
        if (notify) {
            this.fireMatrixChangeEvt(new MatrixChangeEvt(this, MatrixChangeEvt.NO_OF_COLUMNS_CHANGED, cols, -1));
        }
    }

    public void addCol(int at, Supplier<T> itemSupplier) {
        this.addCol(at, itemSupplier, true);
    }

    public void addCol(int at, Supplier<T> itemSupplier, boolean notify) {
        int x;
        if (at < 0 || at > this.cols) {
            throw new IllegalArgumentException("index cannot be smaller or larger than cols");
        }
        ++this.cols;
        AtomicReference<T>[][] newMatrix = ObservableMatrix.createArray(this.type, this.cols, this.rows);
        int y = 0;
        while (y < this.rows) {
            x = 0;
            while (x < at) {
                newMatrix[x][y].set(this.matrix[x][y].get());
                ++x;
            }
            ++y;
        }
        y = 0;
        while (y < this.rows) {
            newMatrix[at][y].set(itemSupplier.get());
            ++y;
        }
        y = 0;
        while (y < this.rows) {
            x = at + 1;
            while (x < this.cols) {
                newMatrix[x][y].set(this.matrix[x - 1][y].get());
                ++x;
            }
            ++y;
        }
        this.matrix = newMatrix;
        if (notify) {
            this.fireMatrixChangeEvt(new MatrixChangeEvt(this, MatrixChangeEvt.COLUMN_ADDED, at, -1));
        }
    }

    public void addCol(int at, List<T> items) {
        this.addCol(at, items, true);
    }

    public void addCol(int at, List<T> items, boolean notify) {
        int x;
        if (at < 0 || at > this.cols) {
            throw new IllegalArgumentException("index cannot be smaller or larger than cols");
        }
        if (items.size() != this.rows) {
            throw new IllegalArgumentException("no of items must be equal to number of rows");
        }
        ++this.cols;
        AtomicReference<T>[][] newMatrix = ObservableMatrix.createArray(this.type, this.cols, this.rows);
        int y = 0;
        while (y < this.rows) {
            x = 0;
            while (x < at) {
                newMatrix[x][y].set(this.matrix[x][y].get());
                ++x;
            }
            ++y;
        }
        y = 0;
        while (y < this.rows) {
            newMatrix[at][y].set(items.get(y));
            ++y;
        }
        y = 0;
        while (y < this.rows) {
            x = at + 1;
            while (x < this.cols) {
                newMatrix[x][y].set(this.matrix[x - 1][y].get());
                ++x;
            }
            ++y;
        }
        this.matrix = newMatrix;
        if (notify) {
            this.fireMatrixChangeEvt(new MatrixChangeEvt(this, MatrixChangeEvt.COLUMN_ADDED, at, -1));
        }
    }

    public void addNullCol(int at) {
        this.addNullCol(at, true);
    }

    public void addNullCol(int at, boolean notify) {
        int x;
        if (at < 0 || at > this.cols) {
            throw new IllegalArgumentException("index cannot be smaller or larger than cols");
        }
        ++this.cols;
        AtomicReference<T>[][] newMatrix = ObservableMatrix.createArray(this.type, this.cols, this.rows);
        int y = 0;
        while (y < this.rows) {
            x = 0;
            while (x < at) {
                newMatrix[x][y].set(this.matrix[x][y].get());
                ++x;
            }
            ++y;
        }
        y = 0;
        while (y < this.rows) {
            newMatrix[at][y].set(null);
            ++y;
        }
        y = 0;
        while (y < this.rows) {
            x = at + 1;
            while (x < this.cols) {
                newMatrix[x][y].set(this.matrix[x - 1][y].get());
                ++x;
            }
            ++y;
        }
        this.matrix = newMatrix;
        if (notify) {
            this.fireMatrixChangeEvt(new MatrixChangeEvt(this, MatrixChangeEvt.COLUMN_ADDED, at, -1));
        }
    }

    public void removeCol(int at) {
        this.removeCol(at, true);
    }

    public void removeCol(int at, boolean notify) {
        if (at < 0 || at > this.cols) {
            throw new IllegalArgumentException("index cannot be smaller or larger than cols");
        }
        if (this.cols <= 1) {
            throw new IllegalArgumentException("there is just one column in the matrix");
        }
        int y = 0;
        while (y < this.getNoOfRows()) {
            this.matrix[at][y] = null;
            ++y;
        }
        if (at == 0 || this.cols - 1 == at || this.resizeMatrixWhenInnerRowOrColIsRemoved) {
            --this.cols;
            AtomicReference<T>[][] newMatrix = ObservableMatrix.createArray(this.type, this.cols, this.rows);
            int y2 = 0;
            while (y2 < this.rows) {
                int x = 0;
                while (x <= this.cols) {
                    if (x < at) {
                        newMatrix[x][y2].set(this.matrix[x][y2].get());
                    } else if (x != at) {
                        newMatrix[x - 1][y2].set(this.matrix[x][y2].get());
                    }
                    ++x;
                }
                ++y2;
            }
            this.matrix = newMatrix;
        }
        if (notify) {
            this.fireMatrixChangeEvt(new MatrixChangeEvt(this, MatrixChangeEvt.COLUMN_REMOVED, at, -1));
        }
    }

    public void addRow(int at, Supplier<T> itemSupplier) {
        this.addRow(at, itemSupplier, true);
    }

    public void addRow(int at, Supplier<T> itemSupplier, boolean notify) {
        int x;
        if (at < 0 || at > this.rows) {
            throw new IllegalArgumentException("index cannot be smaller or larger than rows");
        }
        ++this.rows;
        AtomicReference<T>[][] newMatrix = ObservableMatrix.createArray(this.type, this.cols, this.rows);
        int y = 0;
        while (y < at) {
            x = 0;
            while (x < this.cols) {
                newMatrix[x][y].set(this.matrix[x][y].get());
                ++x;
            }
            ++y;
        }
        int x2 = 0;
        while (x2 < this.cols) {
            newMatrix[x2][at].set(itemSupplier.get());
            ++x2;
        }
        y = at + 1;
        while (y < this.rows) {
            x = 0;
            while (x < this.cols) {
                newMatrix[x][y].set(this.matrix[x][y - 1].get());
                ++x;
            }
            ++y;
        }
        this.matrix = newMatrix;
        if (notify) {
            this.fireMatrixChangeEvt(new MatrixChangeEvt(this, MatrixChangeEvt.ROW_ADDED, -1, at));
        }
    }

    public void addRow(int at, List<T> items) {
        this.addRow(at, items, true);
    }

    public void addRow(int at, List<T> items, boolean notify) {
        int x;
        if (at < 0 || at > this.rows) {
            throw new IllegalArgumentException("index cannot be smaller or larger than rows");
        }
        if (items.size() != this.cols) {
            throw new IllegalArgumentException("now of items must be equal to number of columns");
        }
        ++this.rows;
        AtomicReference<T>[][] newMatrix = ObservableMatrix.createArray(this.type, this.cols, this.rows);
        int y = 0;
        while (y < at) {
            x = 0;
            while (x < this.cols) {
                newMatrix[x][y].set(this.matrix[x][y].get());
                ++x;
            }
            ++y;
        }
        int x2 = 0;
        while (x2 < this.cols) {
            newMatrix[x2][at].set(items.get(x2));
            ++x2;
        }
        y = at + 1;
        while (y < this.rows) {
            x = 0;
            while (x < this.cols) {
                newMatrix[x][y].set(this.matrix[x][y - 1].get());
                ++x;
            }
            ++y;
        }
        this.matrix = newMatrix;
        if (notify) {
            this.fireMatrixChangeEvt(new MatrixChangeEvt(this, MatrixChangeEvt.ROW_ADDED, -1, at));
        }
    }

    public void addNullRow(int at) {
        this.addNullRow(at, true);
    }

    public void addNullRow(int at, boolean notify) {
        int x;
        if (at < 0 || at > this.rows) {
            throw new IllegalArgumentException("index cannot be smaller or larger than rows");
        }
        ++this.rows;
        AtomicReference<T>[][] newMatrix = ObservableMatrix.createArray(this.type, this.cols, this.rows);
        int y = 0;
        while (y < at) {
            x = 0;
            while (x < this.cols) {
                newMatrix[x][y].set(this.matrix[x][y].get());
                ++x;
            }
            ++y;
        }
        int x2 = 0;
        while (x2 < this.cols) {
            newMatrix[x2][at].set(null);
            ++x2;
        }
        y = at + 1;
        while (y < this.rows) {
            x = 0;
            while (x < this.cols) {
                newMatrix[x][y].set(this.matrix[x][y - 1].get());
                ++x;
            }
            ++y;
        }
        this.matrix = newMatrix;
        if (notify) {
            this.fireMatrixChangeEvt(new MatrixChangeEvt(this, MatrixChangeEvt.ROW_ADDED, -1, at));
        }
    }

    public void removeRow(int at) {
        this.removeRow(at, true);
    }

    public void removeRow(int at, boolean notify) {
        if (at < 0 || at > this.rows) {
            throw new IllegalArgumentException("index cannot be smaller or larger than rows");
        }
        if (this.rows <= 1) {
            throw new IllegalArgumentException("there is just one row in the matrix");
        }
        int x = 0;
        while (x < this.getNoOfCols()) {
            this.matrix[x][at] = null;
            ++x;
        }
        if (at == 0 || this.rows - 1 == at || this.resizeMatrixWhenInnerRowOrColIsRemoved) {
            --this.rows;
            AtomicReference<T>[][] newMatrix = ObservableMatrix.createArray(this.type, this.cols, this.rows);
            int y = 0;
            while (y <= this.rows) {
                if (y < at) {
                    x = 0;
                    while (x < this.cols) {
                        newMatrix[x][y].set(this.matrix[x][y].get());
                        ++x;
                    }
                } else if (y != at) {
                    x = 0;
                    while (x < this.cols) {
                        newMatrix[x][y - 1].set(this.matrix[x][y].get());
                        ++x;
                    }
                }
                ++y;
            }
            this.matrix = newMatrix;
        }
        if (notify) {
            this.fireMatrixChangeEvt(new MatrixChangeEvt(this, MatrixChangeEvt.ROW_REMOVED, -1, at));
        }
    }

    public int getNoOfRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.setRows(rows, true);
    }

    public void setRows(int rows, boolean notify) {
        if (rows == -1 || this.cols == -1 || this.rows == -1) {
            throw new IllegalArgumentException("cols/rows cannot be smaller 0");
        }
        AtomicReference[][] oldMatrix = (AtomicReference[][])new Object[this.cols][rows];
        int y = 0;
        while (y < this.rows) {
            int x = 0;
            while (x < this.cols) {
                oldMatrix[x][y].set(this.matrix[x][y].get());
                ++x;
            }
            ++y;
        }
        int oldRows = this.rows;
        this.rows = rows;
        this.matrix = ObservableMatrix.createArray(this.type, this.cols, rows);
        int c = this.cols;
        int r = rows > this.rows ? oldRows : (rows < this.rows ? rows : rows);
        int y2 = 0;
        while (y2 < r) {
            int x = 0;
            while (x < c) {
                this.matrix[x][y2].set(oldMatrix[x][y2].get());
                ++x;
            }
            ++y2;
        }
        if (notify) {
            this.fireMatrixChangeEvt(new MatrixChangeEvt(this, MatrixChangeEvt.NO_OF_ROWS_CHANGED, -1, rows));
        }
    }

    public List<List<T>> getAllColumns() {
        ArrayList<List<T>> columns = new ArrayList<List<T>>();
        int i = 0;
        while (i < this.getNoOfCols()) {
            columns.add(this.getCol(i));
            ++i;
        }
        return columns;
    }

    public List<Integer> getAllEmptyColumns() {
        ArrayList<Integer> emptyColumns = new ArrayList<Integer>();
        int x = 0;
        while (x < this.getNoOfCols()) {
            if (this.getCol(x).stream().filter(Objects::nonNull).count() == 0L) {
                emptyColumns.add(x);
            }
            ++x;
        }
        return emptyColumns;
    }

    public List<List<T>> getAllRows() {
        ArrayList<List<T>> rows = new ArrayList<List<T>>();
        int i = 0;
        while (i < this.getNoOfRows()) {
            rows.add(this.getRow(i));
            ++i;
        }
        return rows;
    }

    public List<Integer> getAllEmptyRows() {
        ArrayList<Integer> emptyRows = new ArrayList<Integer>();
        int y = 0;
        while (y < this.getNoOfRows()) {
            if (this.getRow(y).stream().filter(Objects::nonNull).count() == 0L) {
                emptyRows.add(y);
            }
            ++y;
        }
        return emptyRows;
    }

    public void mirrorColumns() {
        this.mirrorColumns(true);
    }

    public void mirrorColumns(boolean notify) {
        int i = 0;
        while (i < this.matrix.length / 2) {
            AtomicReference<T>[] temp = this.matrix[i];
            this.matrix[i] = this.matrix[this.matrix.length - i - 1];
            this.matrix[this.matrix.length - i - 1] = temp;
            ++i;
        }
        boolean bl = this.colsMirrored = !this.colsMirrored;
        if (notify) {
            this.fireMatrixChangeEvt(new MatrixChangeEvt(this, MatrixChangeEvt.COLUMNS_MIRRORED, this.cols, -1));
        }
    }

    public void mirrorRows() {
        this.mirrorRows(true);
    }

    public void mirrorRows(boolean notify) {
        int j = 0;
        while (j < this.matrix.length) {
            AtomicReference<T>[] row = this.matrix[j];
            int i = 0;
            while (i < row.length / 2) {
                T temp = row[i].get();
                row[i] = this.matrix[j][row.length - i - 1];
                row[row.length - i - 1].set(temp);
                ++i;
            }
            ++j;
        }
        boolean bl = this.rowsMirrored = !this.rowsMirrored;
        if (notify) {
            this.fireMatrixChangeEvt(new MatrixChangeEvt(this, MatrixChangeEvt.ROWS_MIRRORED, -1, this.rows));
        }
    }

    public boolean getColsMirrored() {
        return this.colsMirrored;
    }

    public boolean getRowsMirrored() {
        return this.rowsMirrored;
    }

    public boolean getResizeMatrixWhenInnerRowOrColIsRemoved() {
        return this.resizeMatrixWhenInnerRowOrColIsRemoved;
    }

    public void setResizeMatrixWhenInnerRowOrColIsRemoved(boolean resize) {
        this.resizeMatrixWhenInnerRowOrColIsRemoved = resize;
    }

    public boolean isEmpty() {
        return this.getAllEmptyColumns().size() == this.getNoOfCols() && this.getAllEmptyRows().size() == this.getNoOfRows();
    }

    private void shiftLeft() {
        int y = 0;
        while (y < this.rows) {
            int x = 1;
            while (x < this.cols) {
                this.matrix[x - 1][y] = this.matrix[x][y];
                ++x;
            }
            ++y;
        }
    }

    private void shiftUp() {
        int y = 1;
        while (y < this.rows) {
            int x = 0;
            while (x < this.cols) {
                this.matrix[x][y - 1] = this.matrix[x][y];
                ++x;
            }
            ++y;
        }
    }

    private static <T> AtomicReference<T>[][] createArray(Class type, int cols, int rows) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        if (cols < 1 || rows < 1) {
            throw new IllegalArgumentException("cols/rows cannot be smaller than 1");
        }
        AtomicReference[][] emptyMatrix = new AtomicReference[cols][rows];
        int y = 0;
        while (y < rows) {
            int x = 0;
            while (x < cols) {
                emptyMatrix[x][y] = new AtomicReference();
                ++x;
            }
            ++y;
        }
        return emptyMatrix;
    }

    private void checkForRemovedColumnsAndRows(int removedItemCol, int removedItemRow, boolean notify) {
        int nullItemCounter = 0;
        int r = 0;
        while (r < this.rows) {
            if (this.getItemAt(removedItemCol, r) == null) {
                ++nullItemCounter;
            }
            ++r;
        }
        if (nullItemCounter == this.rows) {
            this.removeCol(removedItemCol, notify);
            return;
        }
        nullItemCounter = 0;
        int c = 0;
        while (c < this.cols) {
            if (this.getItemAt(c, removedItemRow) == null) {
                ++nullItemCounter;
            }
            ++c;
        }
        if (nullItemCounter == this.cols) {
            this.removeRow(removedItemRow, notify);
            return;
        }
    }

    public void addMatrixChangeObserver(EvtType type, EvtObserver<MatrixChangeEvt<T>> observer) {
        if (!this.matrixObservers.containsKey(type)) {
            this.matrixObservers.put(type, new CopyOnWriteArrayList());
        }
        if (this.matrixObservers.get(type).contains(observer)) {
            return;
        }
        this.matrixObservers.get(type).add(observer);
    }

    public void removeMatrixChangeObserver(EvtType type, EvtObserver<MatrixChangeEvt<T>> observer) {
        if (this.matrixObservers.containsKey(type) && this.matrixObservers.get(type).contains(observer)) {
            this.matrixObservers.get(type).remove(observer);
        }
    }

    public void removeAllMatrixChangeObservers() {
        this.matrixObservers.clear();
    }

    public void fireMatrixChangeEvt(MatrixChangeEvt<T> evt) {
        EvtType<MatrixChangeEvt<T>> type = evt.getEvtType();
        this.matrixObservers.entrySet().stream().filter(entry -> ((EvtType)entry.getKey()).equals(MatrixChangeEvt.ANY)).forEach(entry -> ((List)entry.getValue()).forEach(observer -> observer.handle(evt)));
        if (this.matrixObservers.containsKey(type) && !type.equals(MatrixChangeEvt.ANY)) {
            this.matrixObservers.get(type).forEach(observer -> observer.handle(evt));
        }
    }

    public void addMatrixItemChangeObserver(EvtType type, EvtObserver<MatrixItemChangeEvt<T>> observer) {
        if (!this.itemObservers.containsKey(type)) {
            this.itemObservers.put(type, new CopyOnWriteArrayList());
        }
        if (this.itemObservers.get(type).contains(observer)) {
            return;
        }
        this.itemObservers.get(type).add(observer);
    }

    public void removeMatrixItemChangeObserver(EvtType type, EvtObserver<MatrixItemChangeEvt<T>> observer) {
        if (this.itemObservers.containsKey(type) && this.itemObservers.get(type).contains(observer)) {
            this.itemObservers.get(type).remove(observer);
        }
    }

    public void removeAllMatrixItemChangeObservers() {
        this.itemObservers.clear();
    }

    public void fireMatrixItemChangeEvt(MatrixItemChangeEvt<T> evt) {
        EvtType<MatrixItemChangeEvt<T>> type = evt.getEvtType();
        this.itemObservers.entrySet().stream().filter(entry -> ((EvtType)entry.getKey()).equals(MatrixItemChangeEvt.ANY)).forEach(entry -> ((List)entry.getValue()).forEach(observer -> observer.handle(evt)));
        if (this.itemObservers.containsKey(type) && !type.equals(MatrixItemChangeEvt.ANY)) {
            this.itemObservers.get(type).forEach(observer -> observer.handle(evt));
        }
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        int y = 0;
        while (y < this.rows) {
            int x = 0;
            while (x < this.cols) {
                output.append(this.matrix[x][y]).append(" ");
                ++x;
            }
            output.append("\n");
            ++y;
        }
        return output.toString();
    }
}

