/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox.properties;

import eu.hansolo.toolbox.evt.type.PropertyChangeEvt;
import eu.hansolo.toolbox.properties.ReadOnlyBooleanProperty;

public class BooleanProperty
extends ReadOnlyBooleanProperty {
    protected ReadOnlyBooleanProperty propertyBoundTo = null;
    protected boolean bound = false;

    public BooleanProperty() {
        this((Object)null, (String)null, false);
    }

    public BooleanProperty(boolean value) {
        this((Object)null, (String)null, value);
    }

    public BooleanProperty(String name, boolean value) {
        this((Object)null, name, value);
    }

    public BooleanProperty(Object bean, String name, boolean value) {
        super(bean, name, value);
    }

    public void setValue(Boolean value) {
        if (this.bound && !this.bidirectional) {
            throw new IllegalArgumentException("A bound value cannot be set.");
        }
        this.setValue(value, null);
    }

    public void set(boolean value) {
        this.setValue(value);
    }

    protected void setValue(Boolean value, BooleanProperty property) {
        this.willChange((Boolean)this.value, value);
        Boolean oldValue = (Boolean)this.value;
        this.value = value;
        if (property == null && this.propertyToUpdate != null) {
            this.propertyToUpdate.setValue(value, this);
        }
        this.fireEvent(new PropertyChangeEvt<Object>(this, PropertyChangeEvt.CHANGED, oldValue, this.value));
        this.didChange(oldValue, (Boolean)this.value);
        this.invalidated();
    }

    public void unset() {
        this.setValue((Boolean)this.getInitialValue());
    }

    public void setInitialValue(Boolean initialValue) {
        this.initialValue = initialValue;
    }

    public void bind(ReadOnlyBooleanProperty property) {
        this.propertyBoundTo = property;
        this.value = (Boolean)this.propertyBoundTo.getValue();
        this.propertyBoundTo.setPropertyToUpdate(this);
        this.propertyToUpdate = null;
        this.bound = true;
    }

    public boolean isBound() {
        return this.bound;
    }

    public void bindBidirectional(BooleanProperty property) {
        this.setPropertyToUpdate(property, true);
        property.setPropertyToUpdate(this, true);
        this.propertyBoundTo = property;
        this.bound = true;
    }

    public boolean isBoundBidirectional() {
        return this.bidirectional;
    }

    public void unbind() {
        if (this.propertyToUpdate != null) {
            this.propertyToUpdate.unsetPropertyToUpdate();
            this.propertyToUpdate.unbind();
            this.propertyToUpdate = null;
        }
        if (this.propertyBoundTo != null) {
            this.propertyBoundTo.unsetPropertyToUpdate();
            this.propertyBoundTo = null;
        }
        this.bound = false;
        this.bidirectional = false;
    }

    protected void setPropertyToUpdate(BooleanProperty property, boolean bidirectional) {
        this.propertyToUpdate = property;
        if (property == null) {
            this.bidirectional = false;
        } else {
            this.value = (Boolean)property.getValue();
            this.bidirectional = bidirectional;
        }
    }
}

