/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox.properties;

import eu.hansolo.toolbox.evt.type.PropertyChangeEvt;
import eu.hansolo.toolbox.properties.ReadOnlyByteProperty;

public class ByteProperty
extends ReadOnlyByteProperty {
    protected ReadOnlyByteProperty propertyBoundTo = null;
    protected boolean bound = false;

    public ByteProperty() {
        this((Object)null, (String)null, 0);
    }

    public ByteProperty(byte value) {
        this((Object)null, (String)null, value);
    }

    public ByteProperty(String name, byte value) {
        this((Object)null, name, value);
    }

    public ByteProperty(Object bean, String name, byte value) {
        super(bean, name, value);
    }

    public void setValue(Byte value) {
        if (this.bound && !this.bidirectional) {
            throw new IllegalArgumentException("A bound value cannot be set.");
        }
        this.setValue(value, null);
    }

    public void set(byte value) {
        this.setValue(value);
    }

    protected void setValue(Byte value, ByteProperty property) {
        this.willChange((Byte)this.value, value);
        Byte oldValue = (Byte)this.value;
        this.value = value;
        if (property == null && this.propertyToUpdate != null) {
            this.propertyToUpdate.setValue(value, this);
        }
        this.fireEvent(new PropertyChangeEvt<Object>(this, PropertyChangeEvt.CHANGED, oldValue, this.value));
        this.didChange(oldValue, (Byte)this.value);
        this.invalidated();
    }

    public void unset() {
        this.setValue((Byte)this.getInitialValue());
    }

    public void setInitialValue(Byte initialValue) {
        this.initialValue = initialValue;
    }

    public void bind(ReadOnlyByteProperty property) {
        this.propertyBoundTo = property;
        this.value = (Byte)this.propertyBoundTo.getValue();
        this.propertyBoundTo.setPropertyToUpdate(this);
        this.propertyToUpdate = null;
        this.bound = true;
    }

    public boolean isBound() {
        return this.bound;
    }

    public void bindBidirectional(ByteProperty property) {
        this.setPropertyToUpdate(property, true);
        property.setPropertyToUpdate(this, true);
        this.propertyBoundTo = property;
        this.bound = true;
    }

    public boolean isBoundBidirectional() {
        return this.bidirectional;
    }

    public void unbind() {
        if (this.propertyToUpdate != null) {
            this.propertyToUpdate.unsetPropertyToUpdate();
            this.propertyToUpdate.unbind();
            this.propertyToUpdate = null;
        }
        if (this.propertyBoundTo != null) {
            this.propertyBoundTo.unsetPropertyToUpdate();
            this.propertyBoundTo = null;
        }
        this.bound = false;
        this.bidirectional = false;
    }

    protected void setPropertyToUpdate(ByteProperty property, boolean bidirectional) {
        this.propertyToUpdate = property;
        if (property == null) {
            this.bidirectional = false;
        } else {
            this.value = (Byte)property.getValue();
            this.bidirectional = bidirectional;
        }
    }
}

