/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox.properties;

import eu.hansolo.toolbox.evt.type.PropertyChangeEvt;
import eu.hansolo.toolbox.properties.ReadOnlyLongProperty;

public class LongProperty
extends ReadOnlyLongProperty {
    protected ReadOnlyLongProperty propertyBoundTo = null;
    protected boolean bound = false;

    public LongProperty() {
        this((Object)null, (String)null, 0L);
    }

    public LongProperty(long value) {
        this((Object)null, (String)null, value);
    }

    public LongProperty(String name, long value) {
        this((Object)null, name, value);
    }

    public LongProperty(Object bean, String name, long value) {
        super(bean, name, value);
    }

    public void setValue(Long value) {
        if (this.bound && !this.bidirectional) {
            throw new IllegalArgumentException("A bound value cannot be set.");
        }
        this.setValue(value, null);
    }

    public void set(long value) {
        this.setValue(value);
    }

    protected void setValue(Long value, LongProperty property) {
        this.willChange((Long)this.value, value);
        Long oldValue = (Long)this.value;
        this.value = value;
        if (property == null && this.propertyToUpdate != null) {
            this.propertyToUpdate.setValue(value, this);
        }
        this.fireEvent(new PropertyChangeEvt<Object>(this, PropertyChangeEvt.CHANGED, oldValue, this.value));
        this.didChange(oldValue, (Long)this.value);
        this.invalidated();
    }

    public void unset() {
        this.setValue((Long)this.getInitialValue());
    }

    public void setInitialValue(Long initialValue) {
        this.initialValue = initialValue;
    }

    public void bind(ReadOnlyLongProperty property) {
        this.propertyBoundTo = property;
        this.value = (Long)this.propertyBoundTo.getValue();
        this.propertyBoundTo.setPropertyToUpdate(this);
        this.propertyToUpdate = null;
        this.bound = true;
    }

    public boolean isBound() {
        return this.bound;
    }

    public void bindBidirectional(LongProperty property) {
        this.setPropertyToUpdate(property, true);
        property.setPropertyToUpdate(this, true);
        this.propertyBoundTo = property;
        this.bound = true;
    }

    public boolean isBoundBidirectional() {
        return this.bidirectional;
    }

    public void unbind() {
        if (this.propertyToUpdate != null) {
            this.propertyToUpdate.unsetPropertyToUpdate();
            this.propertyToUpdate.unbind();
            this.propertyToUpdate = null;
        }
        if (this.propertyBoundTo != null) {
            this.propertyBoundTo.unsetPropertyToUpdate();
            this.propertyBoundTo = null;
        }
        this.bound = false;
        this.bidirectional = false;
    }

    protected void setPropertyToUpdate(LongProperty property, boolean bidirectional) {
        this.propertyToUpdate = property;
        if (property == null) {
            this.bidirectional = false;
        } else {
            this.value = (Long)property.getValue();
            this.bidirectional = bidirectional;
        }
    }
}

