/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox.properties;

import eu.hansolo.toolbox.evt.type.PropertyChangeEvt;
import eu.hansolo.toolbox.properties.ReadOnlyObjectProperty;

public class ObjectProperty<T>
extends ReadOnlyObjectProperty<T> {
    protected ReadOnlyObjectProperty<T> propertyBoundTo = null;
    protected boolean bound = false;

    public ObjectProperty() {
        this(null, null, null);
    }

    public ObjectProperty(T value) {
        this(null, null, value);
    }

    public ObjectProperty(String name, T value) {
        this(null, name, value);
    }

    public ObjectProperty(Object bean, String name, T value) {
        super(bean, name, value);
    }

    public void setValue(T value) {
        if (this.bound && !this.bidirectional) {
            throw new IllegalArgumentException("A bound value cannot be set.");
        }
        this.setValue(value, null);
    }

    public void set(T value) {
        this.setValue(value);
    }

    protected void setValue(T value, ObjectProperty<T> property) {
        this.willChange(this.value, value);
        Object oldValue = this.value;
        this.value = value;
        if (property == null && this.propertyToUpdate != null) {
            this.propertyToUpdate.setValue(value, this);
        }
        this.fireEvent(new PropertyChangeEvt<Object>(this, PropertyChangeEvt.CHANGED, oldValue, this.value));
        this.didChange(oldValue, this.value);
        this.invalidated();
    }

    public void unset() {
        this.setValue(this.getInitialValue());
    }

    public void setInitialValue(T initialValue) {
        this.initialValue = initialValue;
    }

    public void bind(ReadOnlyObjectProperty<T> property) {
        this.propertyBoundTo = property;
        this.value = this.propertyBoundTo.getValue();
        this.propertyBoundTo.setPropertyToUpdate(this);
        this.propertyToUpdate = null;
        this.bound = true;
    }

    public boolean isBound() {
        return this.bound;
    }

    public void bindBidirectional(ObjectProperty<T> property) {
        this.setPropertyToUpdate(property, true);
        property.setPropertyToUpdate(this, true);
        this.propertyBoundTo = property;
        this.bound = true;
    }

    public boolean isBoundBidirectional() {
        return this.bidirectional;
    }

    public void unbind() {
        if (this.propertyToUpdate != null) {
            this.propertyToUpdate.unsetPropertyToUpdate();
            this.propertyToUpdate.unbind();
            this.propertyToUpdate = null;
        }
        if (this.propertyBoundTo != null) {
            this.propertyBoundTo.unsetPropertyToUpdate();
            this.propertyBoundTo = null;
        }
        this.bound = false;
        this.bidirectional = false;
    }

    protected void setPropertyToUpdate(ObjectProperty<T> property, boolean bidirectional) {
        this.propertyToUpdate = property;
        if (property == null) {
            this.bidirectional = false;
        } else {
            this.value = property.getValue();
            this.bidirectional = bidirectional;
        }
    }
}

