/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolboxfx.geom;

import eu.hansolo.toolbox.Helper;
import eu.hansolo.toolbox.evt.Evt;
import eu.hansolo.toolbox.evt.EvtObserver;
import eu.hansolo.toolbox.evt.EvtType;
import eu.hansolo.toolboxfx.HelperFX;
import eu.hansolo.toolboxfx.evt.type.LocationChangeEvt;
import eu.hansolo.toolboxfx.geom.CardinalDirection;
import eu.hansolo.toolboxfx.geom.Point;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;

public class Location {
    private final String id = UUID.randomUUID().toString();
    private Instant timestamp;
    private double latitude;
    private double longitude;
    private double altitude;
    private double accuracy;
    private String name;
    private String info;
    private Color _fill;
    private ObjectProperty<Color> fill;
    private Color _stroke;
    private ObjectProperty<Color> stroke;
    private int zoomLevel;
    private Location oldLocation;
    private EventHandler<MouseEvent> mouseEnterHandler;
    private EventHandler<MouseEvent> mousePressHandler;
    private EventHandler<MouseEvent> mouseReleaseHandler;
    private EventHandler<MouseEvent> mouseExitHandler;
    private Map<EvtType, List<EvtObserver<LocationChangeEvt>>> observers;

    public Location() {
        this(Instant.now(), 0.0, 0.0, 0.0, 1.0, "", "", Color.BLUE, Color.TRANSPARENT);
    }

    public Location(double latitude, double longitude) {
        this(Instant.now(), latitude, longitude, 0.0, 1.0, "", "", Color.BLUE, Color.TRANSPARENT);
    }

    public Location(Instant timestamp, double latitude, double longitude, double altitude, double accuracy, String name, String info, Color fill, Color stroke) {
        this.timestamp = timestamp;
        this.latitude = latitude;
        this.longitude = longitude;
        this.altitude = altitude;
        this.accuracy = accuracy;
        this.name = name;
        this.info = info;
        this.zoomLevel = 15;
        this._fill = fill;
        this._stroke = stroke;
        this.oldLocation = null;
        this.observers = new ConcurrentHashMap<EvtType, List<EvtObserver<LocationChangeEvt>>>();
    }

    public String getId() {
        return this.id;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public long getTimestampInSeconds() {
        return this.timestamp.getEpochSecond();
    }

    public void setTimestamp(Instant timestamp) {
        this.oldLocation = this.getCopy();
        this.timestamp = timestamp;
        this.fireLocationEvent(new LocationChangeEvt(this, LocationChangeEvt.TIMESTAMP_CHANGED, this.oldLocation, this));
    }

    public LocalDateTime getLocaleDateTime() {
        return this.getLocalDateTime(ZoneId.systemDefault());
    }

    public LocalDateTime getLocalDateTime(ZoneId zoneId) {
        return LocalDateTime.ofInstant(this.timestamp, zoneId);
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.oldLocation = this.getCopy();
        this.latitude = latitude;
        this.fireLocationEvent(new LocationChangeEvt(this, LocationChangeEvt.LOCATION_CHANGED, this.oldLocation, this));
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        Location oldLocation = this.getCopy();
        this.longitude = longitude;
        this.fireLocationEvent(new LocationChangeEvt(this, LocationChangeEvt.LOCATION_CHANGED, oldLocation, this));
    }

    public double getAltitude() {
        return this.altitude;
    }

    public void setAltitude(double altitude) {
        this.oldLocation = this.getCopy();
        this.altitude = altitude;
        this.fireLocationEvent(new LocationChangeEvt(this, LocationChangeEvt.LOCATION_CHANGED, this.oldLocation, this));
    }

    public double getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(double accuracy) {
        this.oldLocation = this.getCopy();
        this.accuracy = accuracy;
        this.fireLocationEvent(new LocationChangeEvt(this, LocationChangeEvt.ACCURACY_CHANGED, this.oldLocation, this));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.oldLocation = this.getCopy();
        this.name = name;
        this.fireLocationEvent(new LocationChangeEvt(this, LocationChangeEvt.NAME_CHANGED, this.oldLocation, this));
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.oldLocation = this.getCopy();
        this.info = info;
        this.fireLocationEvent(new LocationChangeEvt(this, LocationChangeEvt.INFO_CHANGED, this.oldLocation, this));
    }

    public Color getFill() {
        return this.fill == null ? this._fill : (Color)this.fill.get();
    }

    public void setFill(Color fill) {
        this.oldLocation = this.getCopy();
        if (this.fill == null) {
            this._fill = fill;
            this.fireLocationEvent(new LocationChangeEvt(this, LocationChangeEvt.FILL_CHANGED, this.oldLocation, this));
        } else {
            this.fill.set((Object)fill);
        }
    }

    public ObjectProperty<Color> fillProperty() {
        if (this.fill == null) {
            this.fill = new ObjectPropertyBase<Color>(this._fill){

                protected void invalidated() {
                    Location.this.fireLocationEvent(new LocationChangeEvt(Location.this, LocationChangeEvt.FILL_CHANGED, Location.this.oldLocation, Location.this));
                }

                public void set(Color color) {
                    Location.this.oldLocation = Location.this.getCopy();
                    super.set((Object)color);
                }

                public Object getBean() {
                    return Location.this;
                }

                public String getName() {
                    return "fill";
                }
            };
            this._fill = null;
        }
        return this.fill;
    }

    public Color getStroke() {
        return this.stroke == null ? this._stroke : (Color)this.stroke.get();
    }

    public void setStroke(Color stroke) {
        this.oldLocation = this.getCopy();
        if (this.stroke == null) {
            this._stroke = stroke;
            this.fireLocationEvent(new LocationChangeEvt(this, LocationChangeEvt.STROKE_CHANGED, this.oldLocation, this));
        } else {
            this.stroke.set((Object)stroke);
        }
    }

    public ObjectProperty<Color> strokeProperty() {
        if (this.stroke == null) {
            this.stroke = new ObjectPropertyBase<Color>(this._stroke){

                protected void invalidated() {
                    Location.this.fireLocationEvent(new LocationChangeEvt(Location.this, LocationChangeEvt.STROKE_CHANGED, Location.this.oldLocation, Location.this));
                }

                public void set(Color color) {
                    Location.this.oldLocation = Location.this.getCopy();
                    super.set((Object)color);
                }

                public Object getBean() {
                    return Location.this;
                }

                public String getName() {
                    return "stroke";
                }
            };
            this._stroke = null;
        }
        return this.stroke;
    }

    public int getZoomLevel() {
        return this.zoomLevel;
    }

    public void setZoomLevel(int level) {
        this.oldLocation = this.getCopy();
        this.zoomLevel = Helper.clamp((int)0, (int)17, (int)level);
        this.fireLocationEvent(new LocationChangeEvt(this, LocationChangeEvt.ZOOM_LEVEL_CHANGED, this.oldLocation, this));
    }

    public Point getAsPoint() {
        return new Point(this.longitude, this.latitude);
    }

    public void set(double latitude, double longitude) {
        Location oldLocation = this.getCopy();
        this.latitude = latitude;
        this.longitude = longitude;
        this.timestamp = Instant.now();
        this.fireLocationEvent(new LocationChangeEvt(this, LocationChangeEvt.LOCATION_CHANGED, oldLocation, this));
    }

    public void set(double latitude, double longitude, double altitude, Instant timestamp) {
        Location oldLocation = this.getCopy();
        this.latitude = latitude;
        this.longitude = longitude;
        this.altitude = altitude;
        this.timestamp = timestamp;
        this.fireLocationEvent(new LocationChangeEvt(this, LocationChangeEvt.LOCATION_CHANGED, oldLocation, this));
    }

    public void set(double latitude, double longitude, double altitude, Instant timestamp, double accuracy, String info) {
        Location oldLocation = this.getCopy();
        this.latitude = latitude;
        this.longitude = longitude;
        this.altitude = altitude;
        this.timestamp = timestamp;
        this.accuracy = accuracy;
        this.info = info;
        this.fireLocationEvent(new LocationChangeEvt(this, LocationChangeEvt.LOCATION_CHANGED, oldLocation, this));
    }

    public void set(Location location) {
        Location oldLocation = this.getCopy();
        this.latitude = location.getLatitude();
        this.longitude = location.getLongitude();
        this.altitude = location.getAltitude();
        this.timestamp = location.getTimestamp();
        this.accuracy = location.getAccuracy();
        this.name = location.getName();
        this.info = location.getInfo();
        this.fireLocationEvent(new LocationChangeEvt(this, LocationChangeEvt.LOCATION_CHANGED, oldLocation, this));
    }

    public double getDistanceTo(Location location) {
        return Location.calcDistanceInMeter(this, location);
    }

    public boolean isWithinRangeOf(Location location, double meters) {
        return this.getDistanceTo(location) < meters;
    }

    public static double calcDistanceInMeter(Location p1, Location p2) {
        return Location.calcDistanceInMeter(p1.getLatitude(), p1.getLongitude(), p2.getLatitude(), p2.getLongitude());
    }

    public static double calcDistanceInKilometer(Location p1, Location p2) {
        return Location.calcDistanceInMeter(p1, p2) / 1000.0;
    }

    public static double calcDistanceInMeter(double lat1, double lon1, double lat2, double lon2) {
        double lat1Radians = Math.toRadians(lat1);
        double lat2Radians = Math.toRadians(lat2);
        double deltaLatRadians = Math.toRadians(lat2 - lat1);
        double deltaLonRadians = Math.toRadians(lon2 - lon1);
        double a = Math.sin(deltaLatRadians * 0.5) * Math.sin(deltaLatRadians * 0.5) + Math.cos(lat1Radians) * Math.cos(lat2Radians) * Math.sin(deltaLonRadians * 0.5) * Math.sin(deltaLonRadians * 0.5);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        double distance = 6371000.0 * c;
        return distance;
    }

    public double getAltitudeDifferenceInMeter(Location location) {
        return this.altitude - location.getAltitude();
    }

    public double getBearingTo(Location location) {
        return this.calcBearingInDegree(this.getLatitude(), this.getLongitude(), location.getLatitude(), location.getLongitude());
    }

    public double getBearingTo(double latitude, double longitude) {
        return this.calcBearingInDegree(this.getLatitude(), this.getLongitude(), latitude, longitude);
    }

    public boolean isZero() {
        return Double.compare(this.latitude, 0.0) == 0 && Double.compare(this.longitude, 0.0) == 0;
    }

    public double calcBearingInDegree(double lt1, double ln1, double lt2, double ln2) {
        double lat1 = Math.toRadians(lt1);
        double lon1 = Math.toRadians(ln1);
        double lat2 = Math.toRadians(lt2);
        double lon2 = Math.toRadians(ln2);
        double deltaLon = lon2 - lon1;
        double deltaPhi = Math.log(Math.tan(lat2 * 0.5 + 0.7853981633974483) / Math.tan(lat1 * 0.5 + 0.7853981633974483));
        if (Math.abs(deltaLon) > Math.PI) {
            deltaLon = deltaLon > 0.0 ? -(Math.PI * 2 - deltaLon) : (deltaLon += Math.PI * 2);
        }
        double bearing = (Math.toDegrees(Math.atan2(deltaLon, deltaPhi)) + 360.0) % 360.0;
        return bearing;
    }

    public String getCardinalDirectionFromBearing(double brng) {
        double bearing = brng % 360.0;
        CardinalDirection[] cardinalDirectionArray = CardinalDirection.values();
        int n = cardinalDirectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            CardinalDirection cardinalDirection = cardinalDirectionArray[n2];
            if (Double.compare(bearing, cardinalDirection.from) >= 0 && Double.compare(bearing, cardinalDirection.to) < 0) {
                return cardinalDirection.direction;
            }
            ++n2;
        }
        return "";
    }

    public Location getCopy() {
        return new Location(Instant.ofEpochSecond(this.timestamp.getEpochSecond()), this.latitude, this.longitude, this.altitude, this.accuracy, this.name, this.info, this.getFill(), this.getStroke());
    }

    public void dispose() {
        this.removeAllObservers();
    }

    public void addLocationObserver(EvtType<? extends Evt> type, EvtObserver<LocationChangeEvt> observer) {
        if (!this.observers.containsKey(type)) {
            this.observers.put(type, new CopyOnWriteArrayList());
        }
        if (this.observers.get(type).contains(observer)) {
            return;
        }
        this.observers.get(type).add(observer);
    }

    public void removeLocationObserver(EvtType<? extends Evt> type, EvtObserver<LocationChangeEvt> observer) {
        if (this.observers.containsKey(type) && this.observers.get(type).contains(observer)) {
            this.observers.get(type).remove(observer);
        }
    }

    public void removeAllObservers() {
        this.observers.clear();
    }

    public void fireLocationEvent(LocationChangeEvt evt) {
        EvtType<? extends LocationChangeEvt> type = evt.getEvtType();
        this.observers.entrySet().stream().filter(entry -> ((EvtType)entry.getKey()).equals(LocationChangeEvt.ANY)).forEach(entry -> ((List)entry.getValue()).forEach(observer -> observer.handle((Evt)evt)));
        if (this.observers.containsKey(type)) {
            this.observers.get(type).forEach(observer -> observer.handle((Evt)evt));
        }
    }

    public EventHandler<MouseEvent> getMouseEnterHandler() {
        return this.mouseEnterHandler;
    }

    public void setMouseEnterHandler(EventHandler<MouseEvent> handler) {
        this.mouseEnterHandler = handler;
    }

    public EventHandler<MouseEvent> getMousePressHandler() {
        return this.mousePressHandler;
    }

    public void setMousePressHandler(EventHandler<MouseEvent> handler) {
        this.mousePressHandler = handler;
    }

    public EventHandler<MouseEvent> getMouseReleaseHandler() {
        return this.mouseReleaseHandler;
    }

    public void setMouseReleaseHandler(EventHandler<MouseEvent> handler) {
        this.mouseReleaseHandler = handler;
    }

    public EventHandler<MouseEvent> getMouseExitHandler() {
        return this.mouseExitHandler;
    }

    public void setMouseExitHandler(EventHandler<MouseEvent> handler) {
        this.mouseExitHandler = handler;
    }

    public boolean equals(Object other) {
        if (other instanceof Location) {
            Location location = (Location)other;
            return this.id.equals(location.getId());
        }
        return false;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        long temp = Double.doubleToLongBits(this.latitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.longitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.altitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "{" + "\"" + "id" + "\"" + ":" + this.id + "\"" + "," + "\"" + "timestamp" + "\"" + ":" + this.timestamp.getEpochSecond() + "," + "\"" + "latitude" + "\"" + ":" + this.latitude + "," + "\"" + "longitude" + "\"" + ":" + this.longitude + "," + "\"" + "altitude" + "\"" + ":" + this.altitude + "," + "\"" + "accuracy" + "\"" + ":" + this.accuracy + "," + "\"" + "name" + "\"" + ":" + "\"" + this.name + "\"" + "," + "\"" + "info" + "\"" + ":" + "\"" + this.info + "\"" + "," + "\"" + "fill" + "\"" + ":" + "\"" + HelperFX.colorToWeb(this.getFill()) + "\"" + "," + "\"" + "stroke" + "\"" + ":" + "\"" + HelperFX.colorToWeb(this.getStroke()) + "\"" + "," + "\"" + "zoom_level" + "\"" + ":" + this.zoomLevel + "}";
    }
}

