/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.smtp;

import com.sun.mail.auth.OAuth2SaslClientFactory;
import com.sun.mail.smtp.SMTPTransport;
import com.sun.mail.smtp.SaslAuthenticator;
import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.BASE64DecoderStream;
import com.sun.mail.util.BASE64EncoderStream;
import com.sun.mail.util.MailLogger;
import java.util.Properties;
import java.util.logging.Level;
import javax.mail.MessagingException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;

public class SMTPSaslAuthenticator
implements SaslAuthenticator {
    private SMTPTransport pr;
    private String name;
    private Properties props;
    private MailLogger logger;
    private String host;

    static {
        try {
            OAuth2SaslClientFactory.init();
        }
        catch (Throwable throwable) {}
    }

    public SMTPSaslAuthenticator(SMTPTransport pr, String name, Properties props, MailLogger logger, String host) {
        this.pr = pr;
        this.name = name;
        this.props = props;
        this.logger = logger;
        this.host = host;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean authenticate(String[] mechs, final String realm, String authzid, final String u, final String p) throws MessagingException {
        block25: {
            done = false;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("SASL Mechanisms:");
                i = 0;
                while (i < mechs.length) {
                    this.logger.fine(" " + mechs[i]);
                    ++i;
                }
                this.logger.fine("");
            }
            cbh = new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) {
                    if (SMTPSaslAuthenticator.this.logger.isLoggable(Level.FINE)) {
                        SMTPSaslAuthenticator.this.logger.fine("SASL callback length: " + callbacks.length);
                    }
                    int i = 0;
                    while (i < callbacks.length) {
                        if (SMTPSaslAuthenticator.this.logger.isLoggable(Level.FINE)) {
                            SMTPSaslAuthenticator.this.logger.fine("SASL callback " + i + ": " + callbacks[i]);
                        }
                        if (callbacks[i] instanceof NameCallback) {
                            NameCallback ncb = (NameCallback)callbacks[i];
                            ncb.setName(u);
                        } else if (callbacks[i] instanceof PasswordCallback) {
                            PasswordCallback pcb = (PasswordCallback)callbacks[i];
                            pcb.setPassword(p.toCharArray());
                        } else if (callbacks[i] instanceof RealmCallback) {
                            rcb = (RealmCallback)callbacks[i];
                            ((TextInputCallback)rcb).setText(realm != null ? realm : ((TextInputCallback)rcb).getDefaultText());
                        } else if (callbacks[i] instanceof RealmChoiceCallback) {
                            rcb = (RealmChoiceCallback)callbacks[i];
                            if (realm == null) {
                                ((ChoiceCallback)rcb).setSelectedIndex(((ChoiceCallback)rcb).getDefaultChoice());
                            } else {
                                String[] choices = ((ChoiceCallback)rcb).getChoices();
                                int k = 0;
                                while (k < choices.length) {
                                    if (choices[k].equals(realm)) {
                                        ((ChoiceCallback)rcb).setSelectedIndex(k);
                                        break;
                                    }
                                    ++k;
                                }
                            }
                        }
                        ++i;
                    }
                }
            };
            try {
                propsMap = this.props;
                sc = Sasl.createSaslClient(mechs, authzid, this.name, this.host, propsMap, cbh);
            }
            catch (SaslException sex) {
                this.logger.log(Level.FINE, "Failed to create SASL client", sex);
                throw new UnsupportedOperationException(sex.getMessage(), sex);
            }
            if (sc == null) {
                this.logger.fine("No SASL support");
                throw new UnsupportedOperationException("No SASL support");
            }
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("SASL client " + sc.getMechanismName());
            }
            try {
                mech = sc.getMechanismName();
                ir = null;
                if (sc.hasInitialResponse()) {
                    ba = sc.evaluateChallenge(new byte[0]);
                    if (ba.length > 0) {
                        ba = BASE64EncoderStream.encode(ba);
                        ir = ASCIIUtility.toString(ba, 0, ba.length);
                    } else {
                        ir = "=";
                    }
                }
                if ((resp = ir != null ? this.pr.simpleCommand("AUTH " + mech + " " + ir) : this.pr.simpleCommand("AUTH " + mech)) == 530) {
                    this.pr.startTLS();
                    resp = ir != null ? this.pr.simpleCommand("AUTH " + mech + " " + ir) : this.pr.simpleCommand("AUTH " + mech);
                }
                if (resp != 235) break block25;
                return true;
            }
            catch (Exception ex) {
                this.logger.log(Level.FINE, "SASL AUTHENTICATE Exception", ex);
                return false;
            }
        }
        if (resp != 334) {
            return false;
        }
        ** GOTO lbl70
lbl-1000:
        // 1 sources

        {
            try {
                if (resp == 334) {
                    ba = null;
                    if (!sc.isComplete()) {
                        ba = ASCIIUtility.getBytes(SMTPSaslAuthenticator.responseText(this.pr));
                        if (ba.length > 0) {
                            ba = BASE64DecoderStream.decode(ba);
                        }
                        if (this.logger.isLoggable(Level.FINE)) {
                            this.logger.fine("SASL challenge: " + ASCIIUtility.toString(ba, 0, ba.length) + " :");
                        }
                        ba = sc.evaluateChallenge(ba);
                    }
                    if (ba == null) {
                        this.logger.fine("SASL: no response");
                        resp = this.pr.simpleCommand("");
                        continue;
                    }
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("SASL response: " + ASCIIUtility.toString(ba, 0, ba.length) + " :");
                    }
                    ba = BASE64EncoderStream.encode(ba);
                    resp = this.pr.simpleCommand(ba);
                    continue;
                }
                done = true;
                continue;
            }
            catch (Exception ioex) {
                this.logger.log(Level.FINE, "SASL Exception", ioex);
                done = true;
            }
lbl70:
            // 5 sources

            ** while (!done)
        }
lbl71:
        // 1 sources

        if (resp != 235) {
            return false;
        }
        if (sc.isComplete() && (qop = (String)sc.getNegotiatedProperty("javax.security.sasl.qop")) != null && (qop.equalsIgnoreCase("auth-int") || qop.equalsIgnoreCase("auth-conf"))) {
            this.logger.fine("SASL Mechanism requires integrity or confidentiality");
            return false;
        }
        return true;
    }

    private static final String responseText(SMTPTransport pr) {
        String resp = pr.getLastServerResponse().trim();
        if (resp.length() > 4) {
            return resp.substring(4);
        }
        return "";
    }
}

