/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.util.Arrays;
import javax.security.jacc.URLPattern;

class URLPatternSpec
extends URLPattern {
    private static String EMPTY_STRING = "";
    private transient int hashCodeValue = 0;
    private String canonicalSpec = null;
    private final String urlPatternList;
    private URLPattern[] urlPatternArray = null;

    public URLPatternSpec(String urlPatternSpec) {
        super(URLPatternSpec.getFirstPattern(urlPatternSpec));
        int colon = urlPatternSpec.indexOf(":");
        if (colon >= 0) {
            this.urlPatternList = urlPatternSpec.substring(colon + 1);
            this.setURLPatternArray();
        } else {
            this.urlPatternList = null;
        }
    }

    public String getURLPattern() {
        return super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof URLPatternSpec)) {
            return false;
        }
        URLPatternSpec that = (URLPatternSpec)o;
        return this.toString().equals(that.toString());
    }

    public int hashCode() {
        if (this.hashCodeValue == 0) {
            this.hashCodeValue = this.toString().hashCode();
        }
        return this.hashCodeValue;
    }

    public boolean implies(URLPatternSpec that) {
        if (that == null) {
            return false;
        }
        if (!super.implies(that)) {
            return false;
        }
        int i = 0;
        while (this.urlPatternArray != null && i < this.urlPatternArray.length) {
            if (this.urlPatternArray[i] != null && this.urlPatternArray[i].implies(that)) {
                return false;
            }
            ++i;
        }
        if (this.urlPatternArray != null && that.implies((URLPattern)this)) {
            if (that.urlPatternArray == null) {
                return false;
            }
            boolean[] flags = new boolean[this.urlPatternArray.length];
            int i2 = 0;
            while (i2 < flags.length) {
                flags[i2] = false;
                ++i2;
            }
            int count = 0;
            int j = 0;
            while (j < that.urlPatternArray.length) {
                int i3 = 0;
                while (i3 < flags.length) {
                    if (!flags[i3] && (this.urlPatternArray[i3] == null || that.urlPatternArray[j] != null && that.urlPatternArray[j].implies(this.urlPatternArray[i3]))) {
                        flags[i3] = true;
                        if (++count == flags.length) {
                            return true;
                        }
                    }
                    ++i3;
                }
                ++j;
            }
            return count == flags.length;
        }
        return true;
    }

    @Override
    public String toString() {
        if (this.canonicalSpec == null) {
            if (this.urlPatternList == null) {
                this.canonicalSpec = super.toString();
            } else {
                StringBuffer s = null;
                int i = 0;
                while (i < this.urlPatternArray.length) {
                    if (this.urlPatternArray[i] != null) {
                        if (s == null) {
                            s = new StringBuffer(this.urlPatternArray[i].toString());
                        } else {
                            s.append(":" + this.urlPatternArray[i].toString());
                        }
                    }
                    ++i;
                }
                this.canonicalSpec = s == null ? super.toString() : String.valueOf(super.toString()) + ":" + s.toString();
            }
        }
        return this.canonicalSpec;
    }

    private static String getFirstPattern(String urlPatternSpec) {
        if (urlPatternSpec == null) {
            throw new IllegalArgumentException("Invalid URLPatternSpec");
        }
        int colon = urlPatternSpec.indexOf(":");
        if (colon < 0) {
            return urlPatternSpec;
        }
        if (colon > 0) {
            return urlPatternSpec.substring(0, colon);
        }
        if (colon == 0) {
            return EMPTY_STRING;
        }
        throw new IllegalArgumentException("Invalid URLPatternSpec");
    }

    private void setURLPatternArray() {
        if (this.urlPatternArray == null && this.urlPatternList != null) {
            String[] tokens = this.urlPatternList.split(":", -1);
            int count = tokens.length;
            if (count == 0) {
                throw new IllegalArgumentException("colon followed by empty URLPatternList");
            }
            this.urlPatternArray = new URLPattern[count];
            int firstType = this.patternType();
            int i = 0;
            while (i < count) {
                this.urlPatternArray[i] = new URLPattern(tokens[i]);
                if (this.urlPatternArray[i].implies(this)) {
                    throw new IllegalArgumentException("pattern in URLPatternList implies first pattern");
                }
                switch (firstType) {
                    case 1: 
                    case 2: {
                        switch (this.urlPatternArray[i].patternType()) {
                            case 2: {
                                if (firstType != 2 || !super.equals(this.urlPatternArray[i]) && super.implies(this.urlPatternArray[i])) break;
                                throw new IllegalArgumentException("Invalid prefix pattern in URLPatternList");
                            }
                            case 3: {
                                if (super.implies(this.urlPatternArray[i])) break;
                                throw new IllegalArgumentException("Invalid exact pattern in URLPatternList");
                            }
                            default: {
                                throw new IllegalArgumentException("Invalid pattern type in URLPatternList");
                            }
                        }
                    }
                    case 0: {
                        if (!super.equals(this.urlPatternArray[i])) break;
                        throw new IllegalArgumentException("Invalid default pattern in URLPatternList");
                    }
                    case 3: {
                        throw new IllegalArgumentException("invalid URLPatternSpec");
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid pattern type in URLPatternList");
                    }
                }
                ++i;
            }
            Arrays.sort(this.urlPatternArray);
            i = 0;
            while (i < this.urlPatternArray.length) {
                if (this.urlPatternArray[i] != null) {
                    switch (this.urlPatternArray[i].patternType()) {
                        case 2: {
                            int j = i + 1;
                            while (j < this.urlPatternArray.length) {
                                if (this.urlPatternArray[i].implies(this.urlPatternArray[j])) {
                                    this.urlPatternArray[j] = null;
                                }
                                ++j;
                            }
                            break;
                        }
                    }
                }
                ++i;
            }
        }
    }
}

