/*
 * Decompiled with CFR 0.152.
 */
package javax.usb;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.usb.UsbException;
import javax.usb.UsbServices;

public final class UsbHostManager {
    public static final String JAVAX_USB_PROPERTIES_FILE = "javax.usb.properties";
    public static final String JAVAX_USB_USBSERVICES_PROPERTY = "javax.usb.services";
    private static final String PROPERTIES_FILE_NOT_FOUND = "Properties file javax.usb.properties not found.";
    private static final String PROPERTIES_FILE_IOEXCEPTION_READING = "IOException while reading properties file javax.usb.properties";
    private static final String PROPERTIES_FILE_IOEXCEPTION_CLOSING = "IOException while closing properties file javax.usb.properties";
    private static boolean propertiesLoaded = false;
    private static Properties properties = new Properties();
    private static Object propertiesLock = new Object();
    private static UsbServices usbServices = null;
    private static Object servicesLock = new Object();

    private UsbHostManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UsbServices getUsbServices() throws UsbException, SecurityException {
        Object object = servicesLock;
        synchronized (object) {
            if (usbServices == null) {
                usbServices = UsbHostManager.createUsbServices();
            }
        }
        return usbServices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties() throws UsbException, SecurityException {
        Object object = propertiesLock;
        synchronized (object) {
            if (!propertiesLoaded) {
                UsbHostManager.setupProperties();
            }
        }
        return (Properties)properties.clone();
    }

    private static UsbServices createUsbServices() throws UsbException, SecurityException {
        String className = UsbHostManager.getProperties().getProperty(JAVAX_USB_USBSERVICES_PROPERTY);
        if (className == null) {
            throw new UsbException(UsbHostManager.USBSERVICES_PROPERTY_NOT_DEFINED());
        }
        try {
            return (UsbServices)Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException cnfE) {
            throw new UsbException(String.valueOf(UsbHostManager.USBSERVICES_CLASSNOTFOUNDEXCEPTION(className)) + " : " + cnfE.getMessage());
        }
        catch (ExceptionInInitializerError eiiE) {
            throw new UsbException(String.valueOf(UsbHostManager.USBSERVICES_EXCEPTIONININITIALIZERERROR(className)) + " : " + eiiE.getMessage());
        }
        catch (InstantiationException iE) {
            throw new UsbException(String.valueOf(UsbHostManager.USBSERVICES_INSTANTIATIONEXCEPTION(className)) + " : " + iE.getMessage());
        }
        catch (IllegalAccessException iaE) {
            throw new UsbException(String.valueOf(UsbHostManager.USBSERVICES_ILLEGALACCESSEXCEPTION(className)) + " : " + iaE.getMessage());
        }
        catch (ClassCastException ccE) {
            throw new UsbException(String.valueOf(UsbHostManager.USBSERVICES_CLASSCASTEXCEPTION(className)) + " : " + ccE.getMessage());
        }
    }

    private static void setupProperties() throws UsbException, SecurityException {
        InputStream i = null;
        String h = System.getProperty("java.home");
        String s = System.getProperty("file.separator");
        if (h != null && s != null) {
            try {
                i = new FileInputStream(String.valueOf(h) + s + "lib" + s + JAVAX_USB_PROPERTIES_FILE);
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        if (i == null) {
            i = UsbHostManager.class.getClassLoader().getResourceAsStream(JAVAX_USB_PROPERTIES_FILE);
        }
        if (i == null) {
            throw new UsbException(PROPERTIES_FILE_NOT_FOUND);
        }
        try {
            properties.load(i);
        }
        catch (IOException ioE) {
            throw new UsbException("IOException while reading properties file javax.usb.properties : " + ioE.getMessage());
        }
        propertiesLoaded = true;
        try {
            i.close();
        }
        catch (IOException ioE) {
            System.err.println("IOException while closing properties file javax.usb.properties : " + ioE.getMessage());
        }
    }

    private static final String USBSERVICES_PROPERTY_NOT_DEFINED() {
        return "The property javax.usb.services is not defined as the implementation class of UsbServices";
    }

    private static final String USBSERVICES_CLASSNOTFOUNDEXCEPTION(String c) {
        return "The UsbServices implementation class " + c + " was not found";
    }

    private static final String USBSERVICES_EXCEPTIONININITIALIZERERROR(String c) {
        return "an Exception occurred during initialization of the UsbServices Class " + c;
    }

    private static final String USBSERVICES_INSTANTIATIONEXCEPTION(String c) {
        return "An Exception occurred during instantiation of the UsbServices implementation " + c;
    }

    private static final String USBSERVICES_ILLEGALACCESSEXCEPTION(String c) {
        return "An IllegalAccessException occurred while creating the UsbServices implementation " + c;
    }

    private static final String USBSERVICES_CLASSCASTEXCEPTION(String c) {
        return "The class " + c + " does not implement UsbServices";
    }
}

