/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind;

public abstract class WhiteSpaceProcessor {
    public static String replace(String text) {
        return WhiteSpaceProcessor.replace((CharSequence)text).toString();
    }

    public static CharSequence replace(CharSequence text) {
        int i = text.length() - 1;
        while (i >= 0 && !WhiteSpaceProcessor.isWhiteSpaceExceptSpace(text.charAt(i))) {
            --i;
        }
        if (i < 0) {
            return text;
        }
        StringBuilder buf = new StringBuilder(text);
        buf.setCharAt(i--, ' ');
        while (i >= 0) {
            if (WhiteSpaceProcessor.isWhiteSpaceExceptSpace(buf.charAt(i))) {
                buf.setCharAt(i, ' ');
            }
            --i;
        }
        return new String(buf);
    }

    public static CharSequence trim(CharSequence text) {
        int len = text.length();
        int start = 0;
        while (start < len && WhiteSpaceProcessor.isWhiteSpace(text.charAt(start))) {
            ++start;
        }
        int end = len - 1;
        while (end > start && WhiteSpaceProcessor.isWhiteSpace(text.charAt(end))) {
            --end;
        }
        if (start == 0 && end == len - 1) {
            return text;
        }
        return text.subSequence(start, end + 1);
    }

    public static String collapse(String text) {
        return WhiteSpaceProcessor.collapse((CharSequence)text).toString();
    }

    public static CharSequence collapse(CharSequence text) {
        int len = text.length();
        int s = 0;
        while (s < len) {
            if (WhiteSpaceProcessor.isWhiteSpace(text.charAt(s))) break;
            ++s;
        }
        if (s == len) {
            return text;
        }
        StringBuilder result = new StringBuilder(len);
        if (s != 0) {
            int i = 0;
            while (i < s) {
                result.append(text.charAt(i));
                ++i;
            }
            result.append(' ');
        }
        boolean inStripMode = true;
        int i = s + 1;
        while (i < len) {
            char ch = text.charAt(i);
            boolean b = WhiteSpaceProcessor.isWhiteSpace(ch);
            if (!inStripMode || !b) {
                inStripMode = b;
                if (inStripMode) {
                    result.append(' ');
                } else {
                    result.append(ch);
                }
            }
            ++i;
        }
        len = result.length();
        if (len > 0 && result.charAt(len - 1) == ' ') {
            result.setLength(len - 1);
        }
        return result;
    }

    public static boolean isWhiteSpace(CharSequence s) {
        int i = s.length() - 1;
        while (i >= 0) {
            if (!WhiteSpaceProcessor.isWhiteSpace(s.charAt(i))) {
                return false;
            }
            --i;
        }
        return true;
    }

    public static boolean isWhiteSpace(char ch) {
        if (ch > ' ') {
            return false;
        }
        return ch == '\t' || ch == '\n' || ch == '\r' || ch == ' ';
    }

    protected static boolean isWhiteSpaceExceptSpace(char ch) {
        if (ch >= ' ') {
            return false;
        }
        return ch == '\t' || ch == '\n' || ch == '\r';
    }
}

