/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset.algorithm;

import com.sun.xml.fastinfoset.CommonResourceBundle;
import com.sun.xml.fastinfoset.algorithm.BuiltInEncodingAlgorithm;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jvnet.fastinfoset.EncodingAlgorithmException;

public class BASE64EncodingAlgorithm
extends BuiltInEncodingAlgorithm {
    static final char[] encodeBase64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    static final int[] decodeBase64;

    static {
        int[] nArray = new int[80];
        nArray[0] = 62;
        nArray[1] = -1;
        nArray[2] = -1;
        nArray[3] = -1;
        nArray[4] = 63;
        nArray[5] = 52;
        nArray[6] = 53;
        nArray[7] = 54;
        nArray[8] = 55;
        nArray[9] = 56;
        nArray[10] = 57;
        nArray[11] = 58;
        nArray[12] = 59;
        nArray[13] = 60;
        nArray[14] = 61;
        nArray[15] = -1;
        nArray[16] = -1;
        nArray[17] = -1;
        nArray[18] = -1;
        nArray[19] = -1;
        nArray[20] = -1;
        nArray[21] = -1;
        nArray[23] = 1;
        nArray[24] = 2;
        nArray[25] = 3;
        nArray[26] = 4;
        nArray[27] = 5;
        nArray[28] = 6;
        nArray[29] = 7;
        nArray[30] = 8;
        nArray[31] = 9;
        nArray[32] = 10;
        nArray[33] = 11;
        nArray[34] = 12;
        nArray[35] = 13;
        nArray[36] = 14;
        nArray[37] = 15;
        nArray[38] = 16;
        nArray[39] = 17;
        nArray[40] = 18;
        nArray[41] = 19;
        nArray[42] = 20;
        nArray[43] = 21;
        nArray[44] = 22;
        nArray[45] = 23;
        nArray[46] = 24;
        nArray[47] = 25;
        nArray[48] = -1;
        nArray[49] = -1;
        nArray[50] = -1;
        nArray[51] = -1;
        nArray[52] = -1;
        nArray[53] = -1;
        nArray[54] = 26;
        nArray[55] = 27;
        nArray[56] = 28;
        nArray[57] = 29;
        nArray[58] = 30;
        nArray[59] = 31;
        nArray[60] = 32;
        nArray[61] = 33;
        nArray[62] = 34;
        nArray[63] = 35;
        nArray[64] = 36;
        nArray[65] = 37;
        nArray[66] = 38;
        nArray[67] = 39;
        nArray[68] = 40;
        nArray[69] = 41;
        nArray[70] = 42;
        nArray[71] = 43;
        nArray[72] = 44;
        nArray[73] = 45;
        nArray[74] = 46;
        nArray[75] = 47;
        nArray[76] = 48;
        nArray[77] = 49;
        nArray[78] = 50;
        nArray[79] = 51;
        decodeBase64 = nArray;
    }

    @Override
    public final Object decodeFromBytes(byte[] b, int start, int length) throws EncodingAlgorithmException {
        byte[] data = new byte[length];
        System.arraycopy(b, start, data, 0, length);
        return data;
    }

    @Override
    public final Object decodeFromInputStream(InputStream s) throws IOException {
        throw new UnsupportedOperationException(CommonResourceBundle.getInstance().getString("message.notImplemented"));
    }

    @Override
    public void encodeToOutputStream(Object data, OutputStream s) throws IOException {
        if (!(data instanceof byte[])) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.dataNotByteArray"));
        }
        s.write((byte[])data);
    }

    @Override
    public final Object convertFromCharacters(char[] ch, int start, int length) {
        if (length == 0) {
            return new byte[0];
        }
        StringBuilder encodedValue = this.removeWhitespace(ch, start, length);
        int encodedLength = encodedValue.length();
        if (encodedLength == 0) {
            return new byte[0];
        }
        int blockCount = encodedLength / 4;
        int partialBlockLength = 3;
        if (encodedValue.charAt(encodedLength - 1) == '=') {
            --partialBlockLength;
            if (encodedValue.charAt(encodedLength - 2) == '=') {
                --partialBlockLength;
            }
        }
        int valueLength = (blockCount - 1) * 3 + partialBlockLength;
        byte[] value = new byte[valueLength];
        int idx = 0;
        int encodedIdx = 0;
        int i = 0;
        while (i < blockCount) {
            int x1 = decodeBase64[encodedValue.charAt(encodedIdx++) - 43];
            int x2 = decodeBase64[encodedValue.charAt(encodedIdx++) - 43];
            int x3 = decodeBase64[encodedValue.charAt(encodedIdx++) - 43];
            int x4 = decodeBase64[encodedValue.charAt(encodedIdx++) - 43];
            value[idx++] = (byte)(x1 << 2 | x2 >> 4);
            if (idx < valueLength) {
                value[idx++] = (byte)((x2 & 0xF) << 4 | x3 >> 2);
            }
            if (idx < valueLength) {
                value[idx++] = (byte)((x3 & 3) << 6 | x4);
            }
            ++i;
        }
        return value;
    }

    @Override
    public final void convertToCharacters(Object data, StringBuffer s) {
        if (data == null) {
            return;
        }
        byte[] value = (byte[])data;
        this.convertToCharacters(value, 0, value.length, s);
    }

    @Override
    public final int getPrimtiveLengthFromOctetLength(int octetLength) throws EncodingAlgorithmException {
        return octetLength;
    }

    @Override
    public int getOctetLengthFromPrimitiveLength(int primitiveLength) {
        return primitiveLength;
    }

    @Override
    public final void encodeToBytes(Object array, int astart, int alength, byte[] b, int start) {
        System.arraycopy((byte[])array, astart, b, start, alength);
    }

    public final void convertToCharacters(byte[] data, int offset, int length, StringBuffer s) {
        if (data == null) {
            return;
        }
        byte[] value = data;
        if (length == 0) {
            return;
        }
        int partialBlockLength = length % 3;
        int blockCount = partialBlockLength != 0 ? length / 3 + 1 : length / 3;
        int encodedLength = blockCount * 4;
        int originalBufferSize = s.length();
        s.ensureCapacity(encodedLength + originalBufferSize);
        int idx = offset;
        int lastIdx = offset + length;
        int i = 0;
        while (i < blockCount) {
            int b1 = value[idx++] & 0xFF;
            int b2 = idx < lastIdx ? value[idx++] & 0xFF : 0;
            int b3 = idx < lastIdx ? value[idx++] & 0xFF : 0;
            s.append(encodeBase64[b1 >> 2]);
            s.append(encodeBase64[(b1 & 3) << 4 | b2 >> 4]);
            s.append(encodeBase64[(b2 & 0xF) << 2 | b3 >> 6]);
            s.append(encodeBase64[b3 & 0x3F]);
            ++i;
        }
        switch (partialBlockLength) {
            case 1: {
                s.setCharAt(originalBufferSize + encodedLength - 1, '=');
                s.setCharAt(originalBufferSize + encodedLength - 2, '=');
                break;
            }
            case 2: {
                s.setCharAt(originalBufferSize + encodedLength - 1, '=');
            }
        }
    }
}

