/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset.stax.factory;

import com.sun.xml.fastinfoset.CommonResourceBundle;
import com.sun.xml.fastinfoset.stax.StAXDocumentSerializer;
import com.sun.xml.fastinfoset.stax.StAXManager;
import com.sun.xml.fastinfoset.stax.events.StAXEventWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;

public class StAXOutputFactory
extends XMLOutputFactory {
    private StAXManager _manager = new StAXManager(2);

    @Override
    public XMLEventWriter createXMLEventWriter(Result result) throws XMLStreamException {
        return new StAXEventWriter(this.createXMLStreamWriter(result));
    }

    @Override
    public XMLEventWriter createXMLEventWriter(Writer writer) throws XMLStreamException {
        return new StAXEventWriter(this.createXMLStreamWriter(writer));
    }

    @Override
    public XMLEventWriter createXMLEventWriter(OutputStream outputStream) throws XMLStreamException {
        return new StAXEventWriter(this.createXMLStreamWriter(outputStream));
    }

    @Override
    public XMLEventWriter createXMLEventWriter(OutputStream outputStream, String encoding) throws XMLStreamException {
        return new StAXEventWriter(this.createXMLStreamWriter(outputStream, encoding));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public XMLStreamWriter createXMLStreamWriter(Result result) throws XMLStreamException {
        XMLStreamWriter xMLStreamWriter;
        if (result instanceof StreamResult) {
            XMLStreamWriter xMLStreamWriter2;
            StreamResult streamResult = (StreamResult)result;
            if (streamResult.getWriter() != null) {
                return this.createXMLStreamWriter(streamResult.getWriter());
            }
            if (streamResult.getOutputStream() != null) {
                return this.createXMLStreamWriter(streamResult.getOutputStream());
            }
            if (streamResult.getSystemId() == null) throw new UnsupportedOperationException();
            FileWriter writer = null;
            boolean isError = true;
            try {
                writer = new FileWriter(new File(streamResult.getSystemId()));
                XMLStreamWriter streamWriter = this.createXMLStreamWriter(writer);
                isError = false;
                xMLStreamWriter2 = streamWriter;
                if (!isError) return xMLStreamWriter2;
                if (writer == null) return xMLStreamWriter2;
            }
            catch (IOException ie) {
                try {
                    throw new XMLStreamException(ie);
                }
                catch (Throwable throwable) {
                    if (!isError) throw throwable;
                    if (writer == null) throw throwable;
                    try {
                        writer.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                writer.close();
                return xMLStreamWriter2;
            }
            catch (IOException iOException) {}
            return xMLStreamWriter2;
        }
        FileWriter writer = null;
        boolean isError = true;
        try {
            writer = new FileWriter(new File(result.getSystemId()));
            XMLStreamWriter streamWriter = this.createXMLStreamWriter(writer);
            isError = false;
            xMLStreamWriter = streamWriter;
            if (!isError) return xMLStreamWriter;
            if (writer == null) return xMLStreamWriter;
        }
        catch (IOException ie) {
            try {
                throw new XMLStreamException(ie);
            }
            catch (Throwable throwable) {
                if (!isError) throw throwable;
                if (writer == null) throw throwable;
                try {
                    writer.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            writer.close();
            return xMLStreamWriter;
        }
        catch (IOException iOException) {}
        return xMLStreamWriter;
    }

    @Override
    public XMLStreamWriter createXMLStreamWriter(Writer writer) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public XMLStreamWriter createXMLStreamWriter(OutputStream outputStream) throws XMLStreamException {
        return new StAXDocumentSerializer(outputStream, new StAXManager(this._manager));
    }

    @Override
    public XMLStreamWriter createXMLStreamWriter(OutputStream outputStream, String encoding) throws XMLStreamException {
        StAXDocumentSerializer serializer = new StAXDocumentSerializer(outputStream, new StAXManager(this._manager));
        serializer.setEncoding(encoding);
        return serializer;
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.propertyNotSupported", new Object[1]));
        }
        if (this._manager.containsProperty(name)) {
            return this._manager.getProperty(name);
        }
        throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.propertyNotSupported", new Object[]{name}));
    }

    @Override
    public boolean isPropertySupported(String name) {
        if (name == null) {
            return false;
        }
        return this._manager.containsProperty(name);
    }

    @Override
    public void setProperty(String name, Object value) throws IllegalArgumentException {
        this._manager.setProperty(name, value);
    }
}

