/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy;

import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.utility.RandomString;

public interface NamingStrategy {
    public String subclass(TypeDescription.Generic var1);

    public String redefine(TypeDescription var1);

    public String rebase(TypeDescription var1);

    public static abstract class AbstractBase
    implements NamingStrategy {
        @Override
        public String subclass(TypeDescription.Generic superClass) {
            return this.name(superClass.asErasure());
        }

        protected abstract String name(TypeDescription var1);

        @Override
        public String redefine(TypeDescription typeDescription) {
            return typeDescription.getName();
        }

        @Override
        public String rebase(TypeDescription typeDescription) {
            return typeDescription.getName();
        }
    }

    @HashCodeAndEqualsPlugin.Enhance
    public static class PrefixingRandom
    extends AbstractBase {
        private final String prefix;
        @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.IGNORE)
        private final RandomString randomString;

        public PrefixingRandom(String prefix) {
            this.prefix = prefix;
            this.randomString = new RandomString();
        }

        @Override
        protected String name(TypeDescription superClass) {
            return String.valueOf(this.prefix) + "." + superClass.getName() + "$" + this.randomString.nextString();
        }
    }

    @HashCodeAndEqualsPlugin.Enhance
    public static class SuffixingRandom
    extends AbstractBase {
        public static final String BYTE_BUDDY_RENAME_PACKAGE = "net.bytebuddy.renamed";
        public static final String NO_PREFIX = "";
        private static final String JAVA_PACKAGE = "java.";
        private final String suffix;
        private final String javaLangPackagePrefix;
        @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.IGNORE)
        private final RandomString randomString;
        private final BaseNameResolver baseNameResolver;

        public SuffixingRandom(String suffix) {
            this(suffix, BaseNameResolver.ForUnnamedType.INSTANCE);
        }

        public SuffixingRandom(String suffix, String javaLangPackagePrefix) {
            this(suffix, BaseNameResolver.ForUnnamedType.INSTANCE, javaLangPackagePrefix);
        }

        public SuffixingRandom(String suffix, BaseNameResolver baseNameResolver) {
            this(suffix, baseNameResolver, BYTE_BUDDY_RENAME_PACKAGE);
        }

        public SuffixingRandom(String suffix, BaseNameResolver baseNameResolver, String javaLangPackagePrefix) {
            this.suffix = suffix;
            this.baseNameResolver = baseNameResolver;
            this.javaLangPackagePrefix = javaLangPackagePrefix;
            this.randomString = new RandomString();
        }

        @Override
        protected String name(TypeDescription superClass) {
            String baseName = this.baseNameResolver.resolve(superClass);
            if (baseName.startsWith(JAVA_PACKAGE) && !this.javaLangPackagePrefix.equals(NO_PREFIX)) {
                baseName = String.valueOf(this.javaLangPackagePrefix) + "." + baseName;
            }
            return String.valueOf(baseName) + "$" + this.suffix + "$" + this.randomString.nextString();
        }

        public static interface BaseNameResolver {
            public String resolve(TypeDescription var1);

            @HashCodeAndEqualsPlugin.Enhance
            public static class ForFixedValue
            implements BaseNameResolver {
                private final String name;

                public ForFixedValue(String name) {
                    this.name = name;
                }

                @Override
                public String resolve(TypeDescription typeDescription) {
                    return this.name;
                }
            }

            @HashCodeAndEqualsPlugin.Enhance
            public static class ForGivenType
            implements BaseNameResolver {
                private final TypeDescription typeDescription;

                public ForGivenType(TypeDescription typeDescription) {
                    this.typeDescription = typeDescription;
                }

                @Override
                public String resolve(TypeDescription typeDescription) {
                    return this.typeDescription.getName();
                }
            }

            public static enum ForUnnamedType implements BaseNameResolver
            {
                INSTANCE;


                @Override
                public String resolve(TypeDescription typeDescription) {
                    return typeDescription.getName();
                }
            }
        }
    }
}

