/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.asm;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.jar.asm.AnnotationVisitor;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.ConstantDynamic;
import net.bytebuddy.jar.asm.FieldVisitor;
import net.bytebuddy.jar.asm.Handle;
import net.bytebuddy.jar.asm.Label;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.RecordComponentVisitor;
import net.bytebuddy.jar.asm.Type;
import net.bytebuddy.jar.asm.TypePath;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.OpenedClassReader;

@HashCodeAndEqualsPlugin.Enhance
public class TypeReferenceAdjustment
extends AsmVisitorWrapper.AbstractBase {
    private final boolean strict;
    private final ElementMatcher.Junction<? super TypeDescription> filter;

    protected TypeReferenceAdjustment(boolean strict, ElementMatcher.Junction<? super TypeDescription> filter) {
        this.strict = strict;
        this.filter = filter;
    }

    public static TypeReferenceAdjustment strict() {
        return new TypeReferenceAdjustment(true, ElementMatchers.none());
    }

    public static TypeReferenceAdjustment relaxed() {
        return new TypeReferenceAdjustment(false, ElementMatchers.none());
    }

    public TypeReferenceAdjustment filter(ElementMatcher<? super TypeDescription> filter) {
        return new TypeReferenceAdjustment(this.strict, this.filter.or(filter));
    }

    @Override
    public ClassVisitor wrap(TypeDescription instrumentedType, ClassVisitor classVisitor, Implementation.Context implementationContext, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int writerFlags, int readerFlags) {
        return new TypeReferenceClassVisitor(classVisitor, this.strict, this.filter, typePool);
    }

    protected static class TypeReferenceClassVisitor
    extends ClassVisitor {
        private static final AnnotationVisitor IGNORE_ANNOTATION = null;
        private static final FieldVisitor IGNORE_FIELD = null;
        private static final MethodVisitor IGNORE_METHOD = null;
        private final boolean strict;
        private final ElementMatcher<? super TypeDescription> filter;
        private final TypePool typePool;
        private final Set<String> observedTypes;
        private final Set<String> visitedInnerTypes;

        protected TypeReferenceClassVisitor(ClassVisitor classVisitor, boolean strict, ElementMatcher<? super TypeDescription> filter, TypePool typePool) {
            super(OpenedClassReader.ASM_API, classVisitor);
            this.typePool = typePool;
            this.strict = strict;
            this.filter = filter;
            this.observedTypes = new HashSet<String>();
            this.visitedInnerTypes = new HashSet<String>();
        }

        @Override
        public void visit(int version, int modifiers, String internalName, String genericSignature, String superClassInternalName, String[] interfaceInternalName) {
            if (superClassInternalName != null) {
                this.observedTypes.add(superClassInternalName);
            }
            if (interfaceInternalName != null) {
                this.observedTypes.addAll(Arrays.asList(interfaceInternalName));
            }
            super.visit(version, modifiers, internalName, genericSignature, superClassInternalName, interfaceInternalName);
        }

        @Override
        public void visitNestHost(String nestHost) {
            this.observedTypes.add(nestHost);
            super.visitNestHost(nestHost);
        }

        @Override
        public void visitOuterClass(String ownerTypeInternalName, String methodName, String methodDescriptor) {
            this.observedTypes.add(ownerTypeInternalName);
            super.visitOuterClass(ownerTypeInternalName, methodName, methodDescriptor);
        }

        @Override
        public void visitNestMember(String nestMember) {
            this.observedTypes.add(nestMember);
            super.visitNestMember(nestMember);
        }

        @Override
        public void visitInnerClass(String internalName, String outerName, String innerName, int modifiers) {
            this.visitedInnerTypes.add(internalName);
            super.visitInnerClass(internalName, outerName, innerName, modifiers);
        }

        @Override
        public RecordComponentVisitor visitRecordComponent(String name, String descriptor, String signature) {
            this.observedTypes.add(Type.getType(descriptor).getInternalName());
            return super.visitRecordComponent(name, descriptor, signature);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            this.observedTypes.add(Type.getType(descriptor).getInternalName());
            AnnotationVisitor annotationVisitor = super.visitAnnotation(descriptor, visible);
            if (annotationVisitor != null) {
                return new TypeReferenceAnnotationVisitor(annotationVisitor);
            }
            return IGNORE_ANNOTATION;
        }

        @Override
        public AnnotationVisitor visitTypeAnnotation(int typeReference, TypePath typePath, String descriptor, boolean visible) {
            this.observedTypes.add(Type.getType(descriptor).getInternalName());
            AnnotationVisitor annotationVisitor = super.visitTypeAnnotation(typeReference, typePath, descriptor, visible);
            if (annotationVisitor != null) {
                return new TypeReferenceAnnotationVisitor(annotationVisitor);
            }
            return IGNORE_ANNOTATION;
        }

        @Override
        public FieldVisitor visitField(int modifiers, String name, String descriptor, String signature, Object defaultValue) {
            FieldVisitor fieldVisitor = super.visitField(modifiers, name, descriptor, signature, defaultValue);
            if (fieldVisitor != null) {
                this.resolve(Type.getType(descriptor));
                return new TypeReferenceFieldVisitor(fieldVisitor);
            }
            return IGNORE_FIELD;
        }

        @Override
        public MethodVisitor visitMethod(int modifiers, String internalName, String descriptor, String signature, String[] exceptionInternalName) {
            MethodVisitor methodVisitor = super.visitMethod(modifiers, internalName, descriptor, signature, exceptionInternalName);
            if (methodVisitor != null) {
                this.resolve(Type.getType(descriptor));
                if (exceptionInternalName != null) {
                    this.observedTypes.addAll(Arrays.asList(exceptionInternalName));
                }
                return new TypeReferenceMethodVisitor(methodVisitor);
            }
            return IGNORE_METHOD;
        }

        @Override
        public void visitEnd() {
            block2: for (String observedType : this.observedTypes) {
                if (!this.visitedInnerTypes.add(observedType)) continue;
                TypePool.Resolution resolution = this.typePool.describe(observedType.replace('/', '.'));
                if (resolution.isResolved()) {
                    TypeDescription typeDescription = resolution.resolve();
                    if (this.filter.matches(typeDescription)) continue;
                    while (typeDescription != null && typeDescription.isNestedClass()) {
                        super.visitInnerClass(typeDescription.getInternalName(), typeDescription.isMemberType() ? typeDescription.getDeclaringType().getInternalName() : null, typeDescription.isAnonymousType() ? null : typeDescription.getSimpleName(), typeDescription.getModifiers());
                        try {
                            while ((typeDescription = typeDescription.getEnclosingType()) != null && !this.visitedInnerTypes.add(typeDescription.getInternalName())) {
                            }
                        }
                        catch (RuntimeException exception) {
                            if (!this.strict) continue block2;
                            throw exception;
                        }
                    }
                    continue;
                }
                if (!this.strict) continue;
                throw new IllegalStateException("Could not locate type for: " + observedType.replace('/', '.'));
            }
            super.visitEnd();
        }

        /*
         * Unable to fully structure code
         */
        protected void resolve(Type type) {
            block3: {
                if (type.getSort() != 11) ** GOTO lbl13
                this.resolve(type.getReturnType());
                var5_2 = type.getArgumentTypes();
                var4_3 = var5_2.length;
                var3_4 = 0;
                while (var3_4 < var4_3) {
                    argumentType = var5_2[var3_4];
                    this.resolve(argumentType);
                    ++var3_4;
                }
                break block3;
lbl-1000:
                // 1 sources

                {
                    type = type.getElementType();
lbl13:
                    // 2 sources

                    ** while (type.getSort() == 9)
                }
lbl14:
                // 1 sources

                if (type.getSort() == 10) {
                    this.observedTypes.add(type.getInternalName());
                }
            }
        }

        protected void resolve(Handle handle) {
            this.observedTypes.add(handle.getOwner());
            Type methodType = Type.getType(handle.getDesc());
            this.resolve(methodType.getReturnType());
            Type[] typeArray = methodType.getArgumentTypes();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type type = typeArray[n2];
                this.resolve(type);
                ++n2;
            }
        }

        protected void resolve(ConstantDynamic constant) {
            Type methodType = Type.getType(constant.getDescriptor());
            this.resolve(methodType.getReturnType());
            Type[] typeArray = methodType.getArgumentTypes();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type type = typeArray[n2];
                this.resolve(type);
                ++n2;
            }
            this.resolve(constant.getBootstrapMethod());
            int index = 0;
            while (index < constant.getBootstrapMethodArgumentCount()) {
                this.resolve(constant.getBootstrapMethodArgument(index));
                ++index;
            }
        }

        protected void resolveInternalName(String internalName) {
            while (internalName.startsWith("[")) {
                internalName = internalName.substring(1);
            }
            this.observedTypes.add(internalName);
        }

        protected void resolve(Object value) {
            if (value instanceof Type) {
                this.resolve((Type)value);
            } else if (value instanceof Handle) {
                this.resolve((Handle)value);
            } else if (value instanceof ConstantDynamic) {
                this.resolve((ConstantDynamic)value);
            }
        }

        protected class TypeReferenceAnnotationVisitor
        extends AnnotationVisitor {
            protected TypeReferenceAnnotationVisitor(AnnotationVisitor annotationVisitor) {
                super(OpenedClassReader.ASM_API, annotationVisitor);
            }

            @Override
            public void visit(String name, Object value) {
                TypeReferenceClassVisitor.this.resolve(value);
                super.visit(name, value);
            }

            @Override
            public void visitEnum(String name, String descriptor, String value) {
                TypeReferenceClassVisitor.this.observedTypes.add(Type.getType(descriptor).getInternalName());
                super.visitEnum(name, descriptor, value);
            }

            @Override
            public AnnotationVisitor visitAnnotation(String name, String descriptor) {
                TypeReferenceClassVisitor.this.observedTypes.add(Type.getType(descriptor).getInternalName());
                AnnotationVisitor annotationVisitor = super.visitAnnotation(name, descriptor);
                if (annotationVisitor != null) {
                    return new TypeReferenceAnnotationVisitor(annotationVisitor);
                }
                return IGNORE_ANNOTATION;
            }

            @Override
            public AnnotationVisitor visitArray(String name) {
                AnnotationVisitor annotationVisitor = super.visitArray(name);
                if (annotationVisitor != null) {
                    return new TypeReferenceAnnotationVisitor(annotationVisitor);
                }
                return IGNORE_ANNOTATION;
            }
        }

        protected class TypeReferenceFieldVisitor
        extends FieldVisitor {
            protected TypeReferenceFieldVisitor(FieldVisitor fieldVisitor) {
                super(OpenedClassReader.ASM_API, fieldVisitor);
            }

            @Override
            public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                TypeReferenceClassVisitor.this.observedTypes.add(Type.getType(descriptor).getInternalName());
                AnnotationVisitor annotationVisitor = super.visitAnnotation(descriptor, visible);
                if (annotationVisitor != null) {
                    return new TypeReferenceAnnotationVisitor(annotationVisitor);
                }
                return IGNORE_ANNOTATION;
            }
        }

        protected class TypeReferenceMethodVisitor
        extends MethodVisitor {
            protected TypeReferenceMethodVisitor(MethodVisitor methodVisitor) {
                super(OpenedClassReader.ASM_API, methodVisitor);
            }

            @Override
            public AnnotationVisitor visitAnnotationDefault() {
                AnnotationVisitor annotationVisitor = super.visitAnnotationDefault();
                if (annotationVisitor != null) {
                    return new TypeReferenceAnnotationVisitor(annotationVisitor);
                }
                return IGNORE_ANNOTATION;
            }

            @Override
            public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                TypeReferenceClassVisitor.this.observedTypes.add(Type.getType(descriptor).getInternalName());
                AnnotationVisitor annotationVisitor = super.visitAnnotation(descriptor, visible);
                if (annotationVisitor != null) {
                    return new TypeReferenceAnnotationVisitor(annotationVisitor);
                }
                return IGNORE_ANNOTATION;
            }

            @Override
            public AnnotationVisitor visitTypeAnnotation(int typeReference, TypePath typePath, String descriptor, boolean visible) {
                TypeReferenceClassVisitor.this.observedTypes.add(Type.getType(descriptor).getInternalName());
                AnnotationVisitor annotationVisitor = super.visitTypeAnnotation(typeReference, typePath, descriptor, visible);
                if (annotationVisitor != null) {
                    return new TypeReferenceAnnotationVisitor(annotationVisitor);
                }
                return IGNORE_ANNOTATION;
            }

            @Override
            public AnnotationVisitor visitParameterAnnotation(int index, String descriptor, boolean visible) {
                TypeReferenceClassVisitor.this.observedTypes.add(Type.getType(descriptor).getInternalName());
                AnnotationVisitor annotationVisitor = super.visitParameterAnnotation(index, descriptor, visible);
                if (annotationVisitor != null) {
                    return new TypeReferenceAnnotationVisitor(annotationVisitor);
                }
                return IGNORE_ANNOTATION;
            }

            @Override
            public AnnotationVisitor visitInsnAnnotation(int typeReference, TypePath typePath, String descriptor, boolean visible) {
                TypeReferenceClassVisitor.this.observedTypes.add(Type.getType(descriptor).getInternalName());
                AnnotationVisitor annotationVisitor = super.visitInsnAnnotation(typeReference, typePath, descriptor, visible);
                if (annotationVisitor != null) {
                    return new TypeReferenceAnnotationVisitor(annotationVisitor);
                }
                return IGNORE_ANNOTATION;
            }

            @Override
            public AnnotationVisitor visitTryCatchAnnotation(int typeReference, TypePath typePath, String descriptor, boolean visible) {
                TypeReferenceClassVisitor.this.observedTypes.add(Type.getType(descriptor).getInternalName());
                AnnotationVisitor annotationVisitor = super.visitTryCatchAnnotation(typeReference, typePath, descriptor, visible);
                if (annotationVisitor != null) {
                    return new TypeReferenceAnnotationVisitor(annotationVisitor);
                }
                return IGNORE_ANNOTATION;
            }

            @Override
            public AnnotationVisitor visitLocalVariableAnnotation(int typeReference, TypePath typePath, Label[] start, Label[] end, int[] index, String descriptor, boolean visible) {
                TypeReferenceClassVisitor.this.observedTypes.add(Type.getType(descriptor).getInternalName());
                AnnotationVisitor annotationVisitor = super.visitLocalVariableAnnotation(typeReference, typePath, start, end, index, descriptor, visible);
                if (annotationVisitor != null) {
                    return new TypeReferenceAnnotationVisitor(annotationVisitor);
                }
                return IGNORE_ANNOTATION;
            }

            @Override
            public void visitTypeInsn(int opcode, String internalName) {
                TypeReferenceClassVisitor.this.resolveInternalName(internalName);
                super.visitTypeInsn(opcode, internalName);
            }

            @Override
            public void visitFieldInsn(int opcode, String ownerInternalName, String name, String descriptor) {
                TypeReferenceClassVisitor.this.resolveInternalName(ownerInternalName);
                TypeReferenceClassVisitor.this.resolve(Type.getType(descriptor));
                super.visitFieldInsn(opcode, ownerInternalName, name, descriptor);
            }

            @Override
            public void visitMethodInsn(int opcode, String ownerInternalName, String name, String descriptor, boolean isInterface) {
                TypeReferenceClassVisitor.this.resolveInternalName(ownerInternalName);
                TypeReferenceClassVisitor.this.resolve(Type.getType(descriptor));
                super.visitMethodInsn(opcode, ownerInternalName, name, descriptor, isInterface);
            }

            @Override
            public void visitInvokeDynamicInsn(String name, String descriptor, Handle handle, Object[] argument) {
                TypeReferenceClassVisitor.this.resolve(Type.getType(descriptor));
                TypeReferenceClassVisitor.this.resolve(handle);
                Object[] objectArray = argument;
                int n = argument.length;
                int n2 = 0;
                while (n2 < n) {
                    Object anArgument = objectArray[n2];
                    TypeReferenceClassVisitor.this.resolve(anArgument);
                    ++n2;
                }
                super.visitInvokeDynamicInsn(name, descriptor, handle, argument);
            }

            @Override
            public void visitLdcInsn(Object value) {
                TypeReferenceClassVisitor.this.resolve(value);
                super.visitLdcInsn(value);
            }

            @Override
            public void visitMultiANewArrayInsn(String descriptor, int dimension) {
                TypeReferenceClassVisitor.this.resolve(Type.getType(descriptor));
                super.visitMultiANewArrayInsn(descriptor, dimension);
            }

            @Override
            public void visitTryCatchBlock(Label start, Label end, Label handler, String typeInternalName) {
                if (typeInternalName != null) {
                    TypeReferenceClassVisitor.this.observedTypes.add(typeInternalName);
                }
                super.visitTryCatchBlock(start, end, handler, typeInternalName);
            }
        }
    }
}

