/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.loading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;

@HashCodeAndEqualsPlugin.Enhance
public class ClassReloadingStrategy
implements ClassLoadingStrategy<ClassLoader> {
    private static final String INSTALLER_TYPE = "net.bytebuddy.agent.Installer";
    private static final String INSTRUMENTATION_GETTER = "getInstrumentation";
    private static final Object STATIC_MEMBER = null;
    protected static final Dispatcher DISPATCHER = AccessController.doPrivileged(Dispatcher.CreationAction.INSTANCE);
    private final Instrumentation instrumentation;
    private final Strategy strategy;
    private final BootstrapInjection bootstrapInjection;
    private final Map<String, Class<?>> preregisteredTypes;

    public ClassReloadingStrategy(Instrumentation instrumentation, Strategy strategy) {
        this(instrumentation, strategy, BootstrapInjection.Disabled.INSTANCE, Collections.emptyMap());
    }

    protected ClassReloadingStrategy(Instrumentation instrumentation, Strategy strategy, BootstrapInjection bootstrapInjection, Map<String, Class<?>> preregisteredTypes) {
        this.instrumentation = instrumentation;
        this.strategy = strategy.validate(instrumentation);
        this.bootstrapInjection = bootstrapInjection;
        this.preregisteredTypes = preregisteredTypes;
    }

    public static ClassReloadingStrategy of(Instrumentation instrumentation) {
        if (DISPATCHER.isRetransformClassesSupported(instrumentation)) {
            return new ClassReloadingStrategy(instrumentation, Strategy.RETRANSFORMATION);
        }
        if (instrumentation.isRedefineClassesSupported()) {
            return new ClassReloadingStrategy(instrumentation, Strategy.REDEFINITION);
        }
        throw new IllegalArgumentException("Instrumentation does not support reloading of classes: " + instrumentation);
    }

    public static ClassReloadingStrategy fromInstalledAgent() {
        try {
            return ClassReloadingStrategy.of((Instrumentation)ClassLoader.getSystemClassLoader().loadClass(INSTALLER_TYPE).getMethod(INSTRUMENTATION_GETTER, new Class[0]).invoke(STATIC_MEMBER, new Object[0]));
        }
        catch (RuntimeException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new IllegalStateException("The Byte Buddy agent is not installed or not accessible", exception);
        }
    }

    public static ClassReloadingStrategy fromInstalledAgent(Strategy strategy) {
        try {
            return new ClassReloadingStrategy((Instrumentation)ClassLoader.getSystemClassLoader().loadClass(INSTALLER_TYPE).getMethod(INSTRUMENTATION_GETTER, new Class[0]).invoke(STATIC_MEMBER, new Object[0]), strategy);
        }
        catch (RuntimeException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new IllegalStateException("The Byte Buddy agent is not installed or not accessible", exception);
        }
    }

    @Override
    public Map<TypeDescription, Class<?>> load(ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
        HashMap availableTypes = new HashMap(this.preregisteredTypes);
        Class[] classArray = this.instrumentation.getInitiatedClasses(classLoader);
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class type = classArray[n2];
            availableTypes.put(TypeDescription.ForLoadedType.getName(type), type);
            ++n2;
        }
        ConcurrentHashMap classDefinitions = new ConcurrentHashMap();
        HashMap loadedClasses = new HashMap();
        LinkedHashMap<TypeDescription, byte[]> unloadedClasses = new LinkedHashMap<TypeDescription, byte[]>();
        for (Map.Entry<TypeDescription, byte[]> entry : types.entrySet()) {
            Class type = (Class)availableTypes.get(entry.getKey().getName());
            if (type != null) {
                classDefinitions.put(type, new ClassDefinition(type, entry.getValue()));
                loadedClasses.put(entry.getKey(), type);
                continue;
            }
            unloadedClasses.put(entry.getKey(), entry.getValue());
        }
        try {
            this.strategy.apply(this.instrumentation, classDefinitions);
            if (!unloadedClasses.isEmpty()) {
                loadedClasses.putAll((classLoader == null ? this.bootstrapInjection.make(this.instrumentation) : new ClassInjector.UsingReflection(classLoader)).inject(unloadedClasses));
            }
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalArgumentException("Could not locate classes for redefinition", exception);
        }
        catch (UnmodifiableClassException exception) {
            throw new IllegalStateException("Cannot redefine specified class", exception);
        }
        return loadedClasses;
    }

    public ClassReloadingStrategy reset(Class<?> ... type) throws IOException {
        return type.length == 0 ? this : this.reset(ClassFileLocator.ForClassLoader.of(type[0].getClassLoader()), type);
    }

    public ClassReloadingStrategy reset(ClassFileLocator classFileLocator, Class<?> ... type) throws IOException {
        if (type.length > 0) {
            try {
                this.strategy.reset(this.instrumentation, classFileLocator, Arrays.asList(type));
            }
            catch (ClassNotFoundException exception) {
                throw new IllegalArgumentException("Cannot locate types " + Arrays.toString(type), exception);
            }
            catch (UnmodifiableClassException exception) {
                throw new IllegalStateException("Cannot reset types " + Arrays.toString(type), exception);
            }
        }
        return this;
    }

    public ClassReloadingStrategy enableBootstrapInjection(File folder) {
        return new ClassReloadingStrategy(this.instrumentation, this.strategy, new BootstrapInjection.Enabled(folder), this.preregisteredTypes);
    }

    public ClassReloadingStrategy preregistered(Class<?> ... type) {
        HashMap preregisteredTypes = new HashMap(this.preregisteredTypes);
        Class<?>[] classArray = type;
        int n = type.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> aType = classArray[n2];
            preregisteredTypes.put(TypeDescription.ForLoadedType.getName(aType), aType);
            ++n2;
        }
        return new ClassReloadingStrategy(this.instrumentation, this.strategy, this.bootstrapInjection, preregisteredTypes);
    }

    protected static interface BootstrapInjection {
        public ClassInjector make(Instrumentation var1);

        public static enum Disabled implements BootstrapInjection
        {
            INSTANCE;


            @Override
            public ClassInjector make(Instrumentation instrumentation) {
                throw new IllegalStateException("Bootstrap injection is not enabled");
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class Enabled
        implements BootstrapInjection {
            private final File folder;

            protected Enabled(File folder) {
                this.folder = folder;
            }

            @Override
            public ClassInjector make(Instrumentation instrumentation) {
                return ClassInjector.UsingInstrumentation.of(this.folder, ClassInjector.UsingInstrumentation.Target.BOOTSTRAP, instrumentation);
            }
        }
    }

    protected static interface Dispatcher {
        public boolean isModifiableClass(Instrumentation var1, Class<?> var2);

        public boolean isRetransformClassesSupported(Instrumentation var1);

        public void addTransformer(Instrumentation var1, ClassFileTransformer var2, boolean var3);

        public void retransformClasses(Instrumentation var1, Class<?>[] var2) throws UnmodifiableClassException;

        public static enum CreationAction implements PrivilegedAction<Dispatcher>
        {
            INSTANCE;


            @Override
            public Dispatcher run() {
                try {
                    Class<?> instrumentation = Class.forName("java.lang.instrument.Instrumentation");
                    return new ForJava6CapableVm(instrumentation.getMethod("isModifiableClass", Class.class), instrumentation.getMethod("isRetransformClassesSupported", new Class[0]), instrumentation.getMethod("addTransformer", ClassFileTransformer.class, Boolean.TYPE), instrumentation.getMethod("retransformClasses", Class[].class));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return ForLegacyVm.INSTANCE;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return ForLegacyVm.INSTANCE;
                }
            }
        }

        public static class ForJava6CapableVm
        implements Dispatcher {
            private final Method isModifiableClass;
            private final Method isRetransformClassesSupported;
            private final Method addTransformer;
            private final Method retransformClasses;

            protected ForJava6CapableVm(Method isModifiableClass, Method isRetransformClassesSupported, Method addTransformer, Method retransformClasses) {
                this.isModifiableClass = isModifiableClass;
                this.isRetransformClassesSupported = isRetransformClassesSupported;
                this.addTransformer = addTransformer;
                this.retransformClasses = retransformClasses;
            }

            @Override
            public boolean isModifiableClass(Instrumentation instrumentation, Class<?> type) {
                try {
                    return (Boolean)this.isModifiableClass.invoke((Object)instrumentation, type);
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot access java.lang.instrument.Instrumentation#isModifiableClass", exception);
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Error invoking java.lang.instrument.Instrumentation#isModifiableClass", exception.getCause());
                }
            }

            @Override
            public boolean isRetransformClassesSupported(Instrumentation instrumentation) {
                try {
                    return (Boolean)this.isRetransformClassesSupported.invoke((Object)instrumentation, new Object[0]);
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot access java.lang.instrument.Instrumentation#isModifiableClass", exception);
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Error invoking java.lang.instrument.Instrumentation#isModifiableClass", exception.getCause());
                }
            }

            @Override
            public void addTransformer(Instrumentation instrumentation, ClassFileTransformer classFileTransformer, boolean canRetransform) {
                try {
                    this.addTransformer.invoke((Object)instrumentation, classFileTransformer, canRetransform);
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot access java.lang.instrument.Instrumentation#addTransformer", exception);
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Error invoking java.lang.instrument.Instrumentation#addTransformer", exception.getCause());
                }
            }

            @Override
            public void retransformClasses(Instrumentation instrumentation, Class<?>[] type) throws UnmodifiableClassException {
                try {
                    this.retransformClasses.invoke((Object)instrumentation, new Object[]{type});
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot access java.lang.instrument.Instrumentation#retransformClasses", exception);
                }
                catch (InvocationTargetException exception) {
                    Throwable cause = exception.getCause();
                    if (cause instanceof UnmodifiableClassException) {
                        throw (UnmodifiableClassException)cause;
                    }
                    throw new IllegalStateException("Error invoking java.lang.instrument.Instrumentation#retransformClasses", cause);
                }
            }
        }

        public static enum ForLegacyVm implements Dispatcher
        {
            INSTANCE;


            @Override
            public boolean isModifiableClass(Instrumentation instrumentation, Class<?> type) {
                return !type.isArray() && !type.isPrimitive();
            }

            @Override
            public boolean isRetransformClassesSupported(Instrumentation instrumentation) {
                return false;
            }

            @Override
            public void addTransformer(Instrumentation instrumentation, ClassFileTransformer classFileTransformer, boolean canRetransform) {
                if (canRetransform) {
                    throw new UnsupportedOperationException("Cannot apply retransformation on legacy VM");
                }
                instrumentation.addTransformer(classFileTransformer);
            }

            @Override
            public void retransformClasses(Instrumentation instrumentation, Class<?>[] type) {
                throw new IllegalStateException();
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Strategy {
        REDEFINITION(true){

            @Override
            protected void apply(Instrumentation instrumentation, Map<Class<?>, ClassDefinition> classDefinitions) throws UnmodifiableClassException, ClassNotFoundException {
                instrumentation.redefineClasses(classDefinitions.values().toArray(new ClassDefinition[0]));
            }

            @Override
            protected Strategy validate(Instrumentation instrumentation) {
                if (!instrumentation.isRedefineClassesSupported()) {
                    throw new IllegalArgumentException("Does not support redefinition: " + instrumentation);
                }
                return this;
            }

            @Override
            public void reset(Instrumentation instrumentation, ClassFileLocator classFileLocator, List<Class<?>> types) throws IOException, UnmodifiableClassException, ClassNotFoundException {
                HashMap classDefinitions = new HashMap(types.size());
                for (Class<?> type : types) {
                    classDefinitions.put(type, new ClassDefinition(type, classFileLocator.locate(TypeDescription.ForLoadedType.getName(type)).resolve()));
                }
                this.apply(instrumentation, classDefinitions);
            }
        }
        ,
        RETRANSFORMATION(false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void apply(Instrumentation instrumentation, Map<Class<?>, ClassDefinition> classDefinitions) throws UnmodifiableClassException {
                ClassRedefinitionTransformer classRedefinitionTransformer = new ClassRedefinitionTransformer(classDefinitions);
                2 var4_4 = this;
                synchronized (var4_4) {
                    DISPATCHER.addTransformer(instrumentation, classRedefinitionTransformer, true);
                    try {
                        DISPATCHER.retransformClasses(instrumentation, classDefinitions.keySet().toArray(new Class[0]));
                    }
                    finally {
                        instrumentation.removeTransformer(classRedefinitionTransformer);
                    }
                }
                classRedefinitionTransformer.assertTransformation();
            }

            @Override
            protected Strategy validate(Instrumentation instrumentation) {
                if (!DISPATCHER.isRetransformClassesSupported(instrumentation)) {
                    throw new IllegalArgumentException("Does not support retransformation: " + instrumentation);
                }
                return this;
            }

            @Override
            public void reset(Instrumentation instrumentation, ClassFileLocator classFileLocator, List<Class<?>> types) throws UnmodifiableClassException, ClassNotFoundException {
                for (Class<?> type : types) {
                    if (DISPATCHER.isModifiableClass(instrumentation, type)) continue;
                    throw new IllegalArgumentException("Cannot modify type: " + type);
                }
                DISPATCHER.addTransformer(instrumentation, ClassResettingTransformer.INSTANCE, true);
                try {
                    DISPATCHER.retransformClasses(instrumentation, types.toArray(new Class[0]));
                }
                finally {
                    instrumentation.removeTransformer(ClassResettingTransformer.INSTANCE);
                }
            }
        };

        private static final byte[] NO_REDEFINITION;
        private static final boolean REDEFINE_CLASSES = true;
        private final boolean redefinition;

        static {
            NO_REDEFINITION = null;
        }

        private Strategy(boolean redefinition) {
            this.redefinition = redefinition;
        }

        protected abstract void apply(Instrumentation var1, Map<Class<?>, ClassDefinition> var2) throws UnmodifiableClassException, ClassNotFoundException;

        protected abstract Strategy validate(Instrumentation var1);

        public boolean isRedefinition() {
            return this.redefinition;
        }

        public abstract void reset(Instrumentation var1, ClassFileLocator var2, List<Class<?>> var3) throws IOException, UnmodifiableClassException, ClassNotFoundException;

        protected static class ClassRedefinitionTransformer
        implements ClassFileTransformer {
            private final Map<Class<?>, ClassDefinition> redefinedClasses;

            protected ClassRedefinitionTransformer(Map<Class<?>, ClassDefinition> redefinedClasses) {
                this.redefinedClasses = redefinedClasses;
            }

            @Override
            @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Value is always null")
            public @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Value is always null") byte[] transform(ClassLoader classLoader, String internalTypeName, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
                if (internalTypeName == null) {
                    return NO_REDEFINITION;
                }
                ClassDefinition redefinedClass = this.redefinedClasses.remove(classBeingRedefined);
                return redefinedClass == null ? NO_REDEFINITION : redefinedClass.getDefinitionClassFile();
            }

            public void assertTransformation() {
                if (!this.redefinedClasses.isEmpty()) {
                    throw new IllegalStateException("Could not transform: " + this.redefinedClasses.keySet());
                }
            }
        }

        protected static enum ClassResettingTransformer implements ClassFileTransformer
        {
            INSTANCE;


            @Override
            public byte[] transform(ClassLoader classLoader, String internalTypeName, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
                return NO_REDEFINITION;
            }
        }
    }
}

