/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.loading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;

public interface PackageDefinitionStrategy {
    public Definition define(ClassLoader var1, String var2, String var3);

    public static interface Definition {
        public boolean isDefined();

        public String getSpecificationTitle();

        public String getSpecificationVersion();

        public String getSpecificationVendor();

        public String getImplementationTitle();

        public String getImplementationVersion();

        public String getImplementationVendor();

        public URL getSealBase();

        public boolean isCompatibleTo(Package var1);

        public static class Simple
        implements Definition {
            protected final URL sealBase;
            private final String specificationTitle;
            private final String specificationVersion;
            private final String specificationVendor;
            private final String implementationTitle;
            private final String implementationVersion;
            private final String implementationVendor;

            public Simple(String specificationTitle, String specificationVersion, String specificationVendor, String implementationTitle, String implementationVersion, String implementationVendor, URL sealBase) {
                this.specificationTitle = specificationTitle;
                this.specificationVersion = specificationVersion;
                this.specificationVendor = specificationVendor;
                this.implementationTitle = implementationTitle;
                this.implementationVersion = implementationVersion;
                this.implementationVendor = implementationVendor;
                this.sealBase = sealBase;
            }

            @Override
            public boolean isDefined() {
                return true;
            }

            @Override
            public String getSpecificationTitle() {
                return this.specificationTitle;
            }

            @Override
            public String getSpecificationVersion() {
                return this.specificationVersion;
            }

            @Override
            public String getSpecificationVendor() {
                return this.specificationVendor;
            }

            @Override
            public String getImplementationTitle() {
                return this.implementationTitle;
            }

            @Override
            public String getImplementationVersion() {
                return this.implementationVersion;
            }

            @Override
            public String getImplementationVendor() {
                return this.implementationVendor;
            }

            @Override
            public URL getSealBase() {
                return this.sealBase;
            }

            @Override
            public boolean isCompatibleTo(Package definedPackage) {
                if (this.sealBase == null) {
                    return !definedPackage.isSealed();
                }
                return definedPackage.isSealed(this.sealBase);
            }

            @SuppressFBWarnings(value={"DMI_BLOCKING_METHODS_ON_URL"}, justification="Package sealing relies on URL equality")
            public @SuppressFBWarnings(value={"DMI_BLOCKING_METHODS_ON_URL"}, justification="Package sealing relies on URL equality") int hashCode() {
                int result = this.specificationTitle != null ? this.specificationTitle.hashCode() : 0;
                result = 31 * result + (this.specificationVersion != null ? this.specificationVersion.hashCode() : 0);
                result = 31 * result + (this.specificationVendor != null ? this.specificationVendor.hashCode() : 0);
                result = 31 * result + (this.implementationTitle != null ? this.implementationTitle.hashCode() : 0);
                result = 31 * result + (this.implementationVersion != null ? this.implementationVersion.hashCode() : 0);
                result = 31 * result + (this.implementationVendor != null ? this.implementationVendor.hashCode() : 0);
                result = 31 * result + (this.sealBase != null ? this.sealBase.hashCode() : 0);
                return result;
            }

            @SuppressFBWarnings(value={"DMI_BLOCKING_METHODS_ON_URL"}, justification="Package sealing relies on URL equality")
            public @SuppressFBWarnings(value={"DMI_BLOCKING_METHODS_ON_URL"}, justification="Package sealing relies on URL equality") boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Simple simple = (Simple)other;
                return (this.specificationTitle != null ? this.specificationTitle.equals(simple.specificationTitle) : simple.specificationTitle == null) && (this.specificationVersion != null ? this.specificationVersion.equals(simple.specificationVersion) : simple.specificationVersion == null) && (this.specificationVendor != null ? this.specificationVendor.equals(simple.specificationVendor) : simple.specificationVendor == null) && (this.implementationTitle != null ? this.implementationTitle.equals(simple.implementationTitle) : simple.implementationTitle == null) && (this.implementationVersion != null ? this.implementationVersion.equals(simple.implementationVersion) : simple.implementationVersion == null) && (this.implementationVendor != null ? this.implementationVendor.equals(simple.implementationVendor) : simple.implementationVendor == null) && (this.sealBase != null ? this.sealBase.equals(simple.sealBase) : simple.sealBase == null);
            }
        }

        public static enum Trivial implements Definition
        {
            INSTANCE;

            private static final String NO_VALUE;
            private static final URL NOT_SEALED;

            static {
                NO_VALUE = null;
                NOT_SEALED = null;
            }

            @Override
            public boolean isDefined() {
                return true;
            }

            @Override
            public String getSpecificationTitle() {
                return NO_VALUE;
            }

            @Override
            public String getSpecificationVersion() {
                return NO_VALUE;
            }

            @Override
            public String getSpecificationVendor() {
                return NO_VALUE;
            }

            @Override
            public String getImplementationTitle() {
                return NO_VALUE;
            }

            @Override
            public String getImplementationVersion() {
                return NO_VALUE;
            }

            @Override
            public String getImplementationVendor() {
                return NO_VALUE;
            }

            @Override
            public URL getSealBase() {
                return NOT_SEALED;
            }

            @Override
            public boolean isCompatibleTo(Package definedPackage) {
                return true;
            }
        }

        public static enum Undefined implements Definition
        {
            INSTANCE;


            @Override
            public boolean isDefined() {
                return false;
            }

            @Override
            public String getSpecificationTitle() {
                throw new IllegalStateException("Cannot read property of undefined package");
            }

            @Override
            public String getSpecificationVersion() {
                throw new IllegalStateException("Cannot read property of undefined package");
            }

            @Override
            public String getSpecificationVendor() {
                throw new IllegalStateException("Cannot read property of undefined package");
            }

            @Override
            public String getImplementationTitle() {
                throw new IllegalStateException("Cannot read property of undefined package");
            }

            @Override
            public String getImplementationVersion() {
                throw new IllegalStateException("Cannot read property of undefined package");
            }

            @Override
            public String getImplementationVendor() {
                throw new IllegalStateException("Cannot read property of undefined package");
            }

            @Override
            public URL getSealBase() {
                throw new IllegalStateException("Cannot read property of undefined package");
            }

            @Override
            public boolean isCompatibleTo(Package definedPackage) {
                throw new IllegalStateException("Cannot check compatibility to undefined package");
            }
        }
    }

    @HashCodeAndEqualsPlugin.Enhance
    public static class ManifestReading
    implements PackageDefinitionStrategy {
        private static final URL NOT_SEALED = null;
        private static final Attributes.Name[] ATTRIBUTE_NAMES = new Attributes.Name[]{Attributes.Name.SPECIFICATION_TITLE, Attributes.Name.SPECIFICATION_VERSION, Attributes.Name.SPECIFICATION_VENDOR, Attributes.Name.IMPLEMENTATION_TITLE, Attributes.Name.IMPLEMENTATION_VERSION, Attributes.Name.IMPLEMENTATION_VENDOR, Attributes.Name.SEALED};
        private final SealBaseLocator sealBaseLocator;

        public ManifestReading() {
            this(new SealBaseLocator.ForTypeResourceUrl());
        }

        public ManifestReading(SealBaseLocator sealBaseLocator) {
            this.sealBaseLocator = sealBaseLocator;
        }

        @Override
        public Definition define(ClassLoader classLoader, String packageName, String typeName) {
            InputStream inputStream = classLoader.getResourceAsStream("META-INF/MANIFEST.MF");
            if (inputStream != null) {
                Definition.Simple simple;
                try {
                    Attributes attributes;
                    int n;
                    Manifest manifest = new Manifest(inputStream);
                    HashMap<Attributes.Name, String> values = new HashMap<Attributes.Name, String>();
                    Attributes mainAttributes = manifest.getMainAttributes();
                    if (mainAttributes != null) {
                        Attributes.Name[] nameArray = ATTRIBUTE_NAMES;
                        n = ATTRIBUTE_NAMES.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Attributes.Name attributeName = nameArray[n2];
                            values.put(attributeName, mainAttributes.getValue(attributeName));
                            ++n2;
                        }
                    }
                    if ((attributes = manifest.getAttributes(packageName.replace('.', '/').concat("/"))) != null) {
                        Attributes.Name[] nameArray = ATTRIBUTE_NAMES;
                        int n3 = ATTRIBUTE_NAMES.length;
                        n = 0;
                        while (n < n3) {
                            Attributes.Name attributeName = nameArray[n];
                            String value = attributes.getValue(attributeName);
                            if (value != null) {
                                values.put(attributeName, value);
                            }
                            ++n;
                        }
                    }
                    simple = new Definition.Simple((String)values.get(Attributes.Name.SPECIFICATION_TITLE), (String)values.get(Attributes.Name.SPECIFICATION_VERSION), (String)values.get(Attributes.Name.SPECIFICATION_VENDOR), (String)values.get(Attributes.Name.IMPLEMENTATION_TITLE), (String)values.get(Attributes.Name.IMPLEMENTATION_VERSION), (String)values.get(Attributes.Name.IMPLEMENTATION_VENDOR), Boolean.parseBoolean((String)values.get(Attributes.Name.SEALED)) ? this.sealBaseLocator.findSealBase(classLoader, typeName) : NOT_SEALED);
                }
                catch (Throwable throwable) {
                    try {
                        inputStream.close();
                        throw throwable;
                    }
                    catch (IOException exception) {
                        throw new IllegalStateException("Error while reading manifest file", exception);
                    }
                }
                inputStream.close();
                return simple;
            }
            return Definition.Trivial.INSTANCE;
        }

        public static interface SealBaseLocator {
            public URL findSealBase(ClassLoader var1, String var2);

            public static class ForFixedValue
            implements SealBaseLocator {
                private final URL sealBase;

                public ForFixedValue(URL sealBase) {
                    this.sealBase = sealBase;
                }

                @Override
                public URL findSealBase(ClassLoader classLoader, String typeName) {
                    return this.sealBase;
                }

                @SuppressFBWarnings(value={"DMI_BLOCKING_METHODS_ON_URL"}, justification="Package sealing relies on URL equality")
                public @SuppressFBWarnings(value={"DMI_BLOCKING_METHODS_ON_URL"}, justification="Package sealing relies on URL equality") int hashCode() {
                    return this.sealBase.hashCode();
                }

                @SuppressFBWarnings(value={"DMI_BLOCKING_METHODS_ON_URL"}, justification="Package sealing relies on URL equality")
                public @SuppressFBWarnings(value={"DMI_BLOCKING_METHODS_ON_URL"}, justification="Package sealing relies on URL equality") boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    ForFixedValue forFixedValue = (ForFixedValue)other;
                    return this.sealBase.equals(forFixedValue.sealBase);
                }
            }

            @HashCodeAndEqualsPlugin.Enhance
            public static class ForTypeResourceUrl
            implements SealBaseLocator {
                private static final int EXCLUDE_INITIAL_SLASH = 1;
                private static final String CLASS_FILE_EXTENSION = ".class";
                private static final String JAR_FILE = "jar";
                private static final String FILE_SYSTEM = "file";
                private static final String RUNTIME_IMAGE = "jrt";
                private final SealBaseLocator fallback;

                public ForTypeResourceUrl() {
                    this(NonSealing.INSTANCE);
                }

                public ForTypeResourceUrl(SealBaseLocator fallback) {
                    this.fallback = fallback;
                }

                @Override
                public URL findSealBase(ClassLoader classLoader, String typeName) {
                    URL url = classLoader.getResource(String.valueOf(typeName.replace('.', '/')) + CLASS_FILE_EXTENSION);
                    if (url != null) {
                        try {
                            if (url.getProtocol().equals(JAR_FILE)) {
                                return new URL(url.getPath().substring(0, url.getPath().indexOf(33)));
                            }
                            if (url.getProtocol().equals(FILE_SYSTEM)) {
                                return url;
                            }
                            if (url.getProtocol().equals(RUNTIME_IMAGE)) {
                                String path = url.getPath();
                                int modulePathIndex = path.indexOf(47, 1);
                                return modulePathIndex == -1 ? url : new URL("jrt:" + path.substring(0, modulePathIndex));
                            }
                        }
                        catch (MalformedURLException exception) {
                            throw new IllegalStateException("Unexpected URL: " + url, exception);
                        }
                    }
                    return this.fallback.findSealBase(classLoader, typeName);
                }
            }

            public static enum NonSealing implements SealBaseLocator
            {
                INSTANCE;


                @Override
                public URL findSealBase(ClassLoader classLoader, String typeName) {
                    return NOT_SEALED;
                }
            }
        }
    }

    public static enum NoOp implements PackageDefinitionStrategy
    {
        INSTANCE;


        @Override
        public Definition define(ClassLoader classLoader, String packageName, String typeName) {
            return Definition.Undefined.INSTANCE;
        }
    }

    public static enum Trivial implements PackageDefinitionStrategy
    {
        INSTANCE;


        @Override
        public Definition define(ClassLoader classLoader, String packageName, String typeName) {
            return Definition.Trivial.INSTANCE;
        }
    }
}

