/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.scaffold.inline;

import java.util.ArrayList;
import java.util.Map;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.dynamic.scaffold.MethodGraph;
import net.bytebuddy.dynamic.scaffold.inline.MethodRebaseResolver;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.constant.DefaultValue;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.utility.CompoundList;

@HashCodeAndEqualsPlugin.Enhance
public class RebaseImplementationTarget
extends Implementation.Target.AbstractBase {
    private final Map<MethodDescription.SignatureToken, MethodRebaseResolver.Resolution> rebaseableMethods;

    protected RebaseImplementationTarget(TypeDescription instrumentedType, MethodGraph.Linked methodGraph, Implementation.Target.AbstractBase.DefaultMethodInvocation defaultMethodInvocation, Map<MethodDescription.SignatureToken, MethodRebaseResolver.Resolution> rebaseableMethods) {
        super(instrumentedType, methodGraph, defaultMethodInvocation);
        this.rebaseableMethods = rebaseableMethods;
    }

    protected static Implementation.Target of(TypeDescription instrumentedType, MethodGraph.Linked methodGraph, ClassFileVersion classFileVersion, MethodRebaseResolver methodRebaseResolver) {
        return new RebaseImplementationTarget(instrumentedType, methodGraph, Implementation.Target.AbstractBase.DefaultMethodInvocation.of(classFileVersion), methodRebaseResolver.asTokenMap());
    }

    @Override
    public Implementation.SpecialMethodInvocation invokeSuper(MethodDescription.SignatureToken token) {
        MethodRebaseResolver.Resolution resolution = this.rebaseableMethods.get(token);
        return resolution == null ? this.invokeSuper(this.methodGraph.getSuperClassGraph().locate(token)) : this.invokeSuper(resolution);
    }

    private Implementation.SpecialMethodInvocation invokeSuper(MethodGraph.Node node) {
        return node.getSort().isResolved() ? Implementation.SpecialMethodInvocation.Simple.of(node.getRepresentative(), this.instrumentedType.getSuperClass().asErasure()) : Implementation.SpecialMethodInvocation.Illegal.INSTANCE;
    }

    private Implementation.SpecialMethodInvocation invokeSuper(MethodRebaseResolver.Resolution resolution) {
        return resolution.isRebased() ? RebasedMethodInvocation.of(resolution.getResolvedMethod(), this.instrumentedType, resolution.getPrependedParameters()) : Implementation.SpecialMethodInvocation.Simple.of(resolution.getResolvedMethod(), this.instrumentedType);
    }

    @Override
    public TypeDescription getOriginType() {
        return this.instrumentedType;
    }

    @HashCodeAndEqualsPlugin.Enhance
    public static class Factory
    implements Implementation.Target.Factory {
        private final MethodRebaseResolver methodRebaseResolver;

        public Factory(MethodRebaseResolver methodRebaseResolver) {
            this.methodRebaseResolver = methodRebaseResolver;
        }

        @Override
        public Implementation.Target make(TypeDescription instrumentedType, MethodGraph.Linked methodGraph, ClassFileVersion classFileVersion) {
            return RebaseImplementationTarget.of(instrumentedType, methodGraph, classFileVersion, this.methodRebaseResolver);
        }
    }

    protected static class RebasedMethodInvocation
    extends Implementation.SpecialMethodInvocation.AbstractBase {
        private final MethodDescription methodDescription;
        private final TypeDescription instrumentedType;
        private final StackManipulation stackManipulation;
        private final TypeList prependedParameters;

        protected RebasedMethodInvocation(MethodDescription methodDescription, TypeDescription instrumentedType, StackManipulation stackManipulation, TypeList prependedParameters) {
            this.methodDescription = methodDescription;
            this.instrumentedType = instrumentedType;
            this.stackManipulation = stackManipulation;
            this.prependedParameters = prependedParameters;
        }

        protected static Implementation.SpecialMethodInvocation of(MethodDescription resolvedMethod, TypeDescription instrumentedType, TypeList prependedParameters) {
            MethodInvocation.WithImplicitInvocationTargetType stackManipulation;
            StackManipulation stackManipulation2 = stackManipulation = resolvedMethod.isStatic() ? MethodInvocation.invoke(resolvedMethod) : MethodInvocation.invoke(resolvedMethod).special(instrumentedType);
            if (stackManipulation.isValid()) {
                ArrayList<StackManipulation> stackManipulations = new ArrayList<StackManipulation>(prependedParameters.size() + 1);
                for (TypeDescription prependedParameter : prependedParameters) {
                    stackManipulations.add(DefaultValue.of(prependedParameter));
                }
                stackManipulations.add(stackManipulation);
                return new RebasedMethodInvocation(resolvedMethod, instrumentedType, new StackManipulation.Compound(stackManipulations), prependedParameters);
            }
            return Implementation.SpecialMethodInvocation.Illegal.INSTANCE;
        }

        @Override
        public MethodDescription getMethodDescription() {
            return this.methodDescription;
        }

        @Override
        public TypeDescription getTypeDescription() {
            return this.instrumentedType;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            return this.stackManipulation.apply(methodVisitor, implementationContext);
        }

        @Override
        public Implementation.SpecialMethodInvocation withCheckedCompatibilityTo(MethodDescription.TypeToken token) {
            if (this.methodDescription.asTypeToken().equals(new MethodDescription.TypeToken(token.getReturnType(), CompoundList.of(token.getParameterTypes(), this.prependedParameters)))) {
                return this;
            }
            return Implementation.SpecialMethodInvocation.Illegal.INSTANCE;
        }
    }
}

