/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.enumeration.EnumerationDescription;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.method.ParameterList;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.scaffold.FieldLocator;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.dynamic.scaffold.MethodGraph;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.LoadedTypeInitializer;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.Duplication;
import net.bytebuddy.implementation.bytecode.Removal;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.TypeCreation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.collection.ArrayAccess;
import net.bytebuddy.implementation.bytecode.collection.ArrayFactory;
import net.bytebuddy.implementation.bytecode.constant.ClassConstant;
import net.bytebuddy.implementation.bytecode.constant.DoubleConstant;
import net.bytebuddy.implementation.bytecode.constant.FloatConstant;
import net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import net.bytebuddy.implementation.bytecode.constant.JavaConstantValue;
import net.bytebuddy.implementation.bytecode.constant.LongConstant;
import net.bytebuddy.implementation.bytecode.constant.NullConstant;
import net.bytebuddy.implementation.bytecode.constant.TextConstant;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.CompoundList;
import net.bytebuddy.utility.JavaConstant;
import net.bytebuddy.utility.JavaType;
import net.bytebuddy.utility.RandomString;

@HashCodeAndEqualsPlugin.Enhance
public class MethodCall
implements Implementation.Composable {
    protected final MethodLocator.Factory methodLocator;
    protected final TargetHandler.Factory targetHandler;
    protected final List<ArgumentLoader.Factory> argumentLoaders;
    protected final MethodInvoker.Factory methodInvoker;
    protected final TerminationHandler.Factory terminationHandler;
    protected final Assigner assigner;
    protected final Assigner.Typing typing;

    protected MethodCall(MethodLocator.Factory methodLocator, TargetHandler.Factory targetHandler, List<ArgumentLoader.Factory> argumentLoaders, MethodInvoker.Factory methodInvoker, TerminationHandler.Factory terminationHandler, Assigner assigner, Assigner.Typing typing) {
        this.methodLocator = methodLocator;
        this.targetHandler = targetHandler;
        this.argumentLoaders = argumentLoaders;
        this.methodInvoker = methodInvoker;
        this.terminationHandler = terminationHandler;
        this.assigner = assigner;
        this.typing = typing;
    }

    public static WithoutSpecifiedTarget invoke(Method method) {
        return MethodCall.invoke(new MethodDescription.ForLoadedMethod(method));
    }

    public static WithoutSpecifiedTarget invoke(Constructor<?> constructor) {
        return MethodCall.invoke(new MethodDescription.ForLoadedConstructor(constructor));
    }

    public static WithoutSpecifiedTarget invoke(MethodDescription methodDescription) {
        return MethodCall.invoke(new MethodLocator.ForExplicitMethod(methodDescription));
    }

    public static WithoutSpecifiedTarget invoke(ElementMatcher<? super MethodDescription> matcher) {
        return MethodCall.invoke(matcher, MethodGraph.Compiler.DEFAULT);
    }

    public static WithoutSpecifiedTarget invoke(ElementMatcher<? super MethodDescription> matcher, MethodGraph.Compiler methodGraphCompiler) {
        return MethodCall.invoke(new MethodLocator.ForElementMatcher.Factory(matcher, methodGraphCompiler));
    }

    public static WithoutSpecifiedTarget invoke(MethodLocator.Factory methodLocator) {
        return new WithoutSpecifiedTarget(methodLocator);
    }

    public static WithoutSpecifiedTarget invokeSelf() {
        return new WithoutSpecifiedTarget(MethodLocator.ForInstrumentedMethod.INSTANCE);
    }

    public static MethodCall invokeSuper() {
        return MethodCall.invokeSelf().onSuper();
    }

    public static Implementation.Composable call(Callable<?> callable) {
        try {
            return MethodCall.invoke(Callable.class.getMethod("call", new Class[0])).on(callable, Callable.class).withAssigner(Assigner.DEFAULT, Assigner.Typing.DYNAMIC);
        }
        catch (NoSuchMethodException exception) {
            throw new IllegalStateException("Could not locate Callable::call method", exception);
        }
    }

    public static Implementation.Composable run(Runnable runnable) {
        try {
            return MethodCall.invoke(Runnable.class.getMethod("run", new Class[0])).on(runnable, Runnable.class).withAssigner(Assigner.DEFAULT, Assigner.Typing.DYNAMIC);
        }
        catch (NoSuchMethodException exception) {
            throw new IllegalStateException("Could not locate Runnable::run method", exception);
        }
    }

    public static MethodCall construct(Constructor<?> constructor) {
        return MethodCall.construct(new MethodDescription.ForLoadedConstructor(constructor));
    }

    public static MethodCall construct(MethodDescription methodDescription) {
        if (!methodDescription.isConstructor()) {
            throw new IllegalArgumentException("Not a constructor: " + methodDescription);
        }
        return new MethodCall(new MethodLocator.ForExplicitMethod(methodDescription), TargetHandler.ForConstructingInvocation.Factory.INSTANCE, Collections.emptyList(), MethodInvoker.ForContextualInvocation.Factory.INSTANCE, TerminationHandler.Simple.RETURNING, Assigner.DEFAULT, Assigner.Typing.STATIC);
    }

    public MethodCall with(Object ... argument) {
        ArrayList<ArgumentLoader.Factory> argumentLoaders = new ArrayList<ArgumentLoader.Factory>(argument.length);
        Object[] objectArray = argument;
        int n = argument.length;
        int n2 = 0;
        while (n2 < n) {
            Object anArgument = objectArray[n2];
            argumentLoaders.add(ArgumentLoader.ForStackManipulation.of(anArgument));
            ++n2;
        }
        return this.with(argumentLoaders);
    }

    public MethodCall with(TypeDescription ... typeDescription) {
        ArrayList<ArgumentLoader.ForStackManipulation> argumentLoaders = new ArrayList<ArgumentLoader.ForStackManipulation>(typeDescription.length);
        TypeDescription[] typeDescriptionArray = typeDescription;
        int n = typeDescription.length;
        int n2 = 0;
        while (n2 < n) {
            TypeDescription aTypeDescription = typeDescriptionArray[n2];
            argumentLoaders.add(new ArgumentLoader.ForStackManipulation(ClassConstant.of(aTypeDescription), (Type)((Object)Class.class)));
            ++n2;
        }
        return this.with(argumentLoaders);
    }

    public MethodCall with(EnumerationDescription ... enumerationDescription) {
        ArrayList<ArgumentLoader.ForStackManipulation> argumentLoaders = new ArrayList<ArgumentLoader.ForStackManipulation>(enumerationDescription.length);
        EnumerationDescription[] enumerationDescriptionArray = enumerationDescription;
        int n = enumerationDescription.length;
        int n2 = 0;
        while (n2 < n) {
            EnumerationDescription anEnumerationDescription = enumerationDescriptionArray[n2];
            argumentLoaders.add(new ArgumentLoader.ForStackManipulation(FieldAccess.forEnumeration(anEnumerationDescription), anEnumerationDescription.getEnumerationType()));
            ++n2;
        }
        return this.with(argumentLoaders);
    }

    public MethodCall with(JavaConstant ... javaConstant) {
        ArrayList<ArgumentLoader.ForStackManipulation> argumentLoaders = new ArrayList<ArgumentLoader.ForStackManipulation>(javaConstant.length);
        JavaConstant[] javaConstantArray = javaConstant;
        int n = javaConstant.length;
        int n2 = 0;
        while (n2 < n) {
            JavaConstant aJavaConstant = javaConstantArray[n2];
            argumentLoaders.add(new ArgumentLoader.ForStackManipulation((StackManipulation)new JavaConstantValue(aJavaConstant), aJavaConstant.getType()));
            ++n2;
        }
        return this.with(argumentLoaders);
    }

    public MethodCall withReference(Object ... argument) {
        ArrayList<ArgumentLoader.ForNullConstant> argumentLoaders = new ArrayList<ArgumentLoader.ForNullConstant>(argument.length);
        Object[] objectArray = argument;
        int n = argument.length;
        int n2 = 0;
        while (n2 < n) {
            Object anArgument = objectArray[n2];
            argumentLoaders.add((ArgumentLoader.ForNullConstant)(anArgument == null ? ArgumentLoader.ForNullConstant.INSTANCE : new ArgumentLoader.ForInstance.Factory(anArgument)));
            ++n2;
        }
        return this.with(argumentLoaders);
    }

    public MethodCall withArgument(int ... index) {
        ArrayList<ArgumentLoader.ForMethodParameter.Factory> argumentLoaders = new ArrayList<ArgumentLoader.ForMethodParameter.Factory>(index.length);
        int[] nArray = index;
        int n = index.length;
        int n2 = 0;
        while (n2 < n) {
            int anIndex = nArray[n2];
            if (anIndex < 0) {
                throw new IllegalArgumentException("Negative index: " + anIndex);
            }
            argumentLoaders.add(new ArgumentLoader.ForMethodParameter.Factory(anIndex));
            ++n2;
        }
        return this.with(argumentLoaders);
    }

    public MethodCall withAllArguments() {
        return this.with(ArgumentLoader.ForMethodParameter.OfInstrumentedMethod.INSTANCE);
    }

    public MethodCall withArgumentArray() {
        return this.with(ArgumentLoader.ForMethodParameterArray.ForInstrumentedMethod.INSTANCE);
    }

    public MethodCall withArgumentArrayElements(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("A parameter index cannot be negative: " + index);
        }
        return this.with(new ArgumentLoader.ForMethodParameterArrayElement.OfInvokedMethod(index));
    }

    public MethodCall withArgumentArrayElements(int index, int size) {
        return this.withArgumentArrayElements(index, 0, size);
    }

    public MethodCall withArgumentArrayElements(int index, int start, int size) {
        if (index < 0) {
            throw new IllegalArgumentException("A parameter index cannot be negative: " + index);
        }
        if (start < 0) {
            throw new IllegalArgumentException("An array index cannot be negative: " + start);
        }
        if (size == 0) {
            return this;
        }
        if (size < 0) {
            throw new IllegalArgumentException("Size cannot be negative: " + size);
        }
        ArrayList<ArgumentLoader.ForMethodParameterArrayElement.OfParameter> argumentLoaders = new ArrayList<ArgumentLoader.ForMethodParameterArrayElement.OfParameter>(size);
        int position = 0;
        while (position < size) {
            argumentLoaders.add(new ArgumentLoader.ForMethodParameterArrayElement.OfParameter(index, start + position));
            ++position;
        }
        return this.with(argumentLoaders);
    }

    public MethodCall withThis() {
        return this.with(ArgumentLoader.ForThisReference.Factory.INSTANCE);
    }

    public MethodCall withOwnType() {
        return this.with(ArgumentLoader.ForInstrumentedType.Factory.INSTANCE);
    }

    public MethodCall withField(String ... name) {
        return this.withField(FieldLocator.ForClassHierarchy.Factory.INSTANCE, name);
    }

    public MethodCall withField(FieldLocator.Factory fieldLocatorFactory, String ... name) {
        ArrayList<ArgumentLoader.ForField.Factory> argumentLoaders = new ArrayList<ArgumentLoader.ForField.Factory>(name.length);
        String[] stringArray = name;
        int n = name.length;
        int n2 = 0;
        while (n2 < n) {
            String aName = stringArray[n2];
            argumentLoaders.add(new ArgumentLoader.ForField.Factory(aName, fieldLocatorFactory));
            ++n2;
        }
        return this.with(argumentLoaders);
    }

    public MethodCall withMethodCall(MethodCall methodCall) {
        return this.with(new ArgumentLoader.ForMethodCall.Factory(methodCall));
    }

    public MethodCall with(StackManipulation stackManipulation, Type type) {
        return this.with(stackManipulation, TypeDefinition.Sort.describe(type));
    }

    public MethodCall with(StackManipulation stackManipulation, TypeDefinition typeDefinition) {
        return this.with(new ArgumentLoader.ForStackManipulation(stackManipulation, typeDefinition));
    }

    public MethodCall with(ArgumentLoader.Factory ... argumentLoader) {
        return this.with(Arrays.asList(argumentLoader));
    }

    public MethodCall with(List<? extends ArgumentLoader.Factory> argumentLoaders) {
        return new MethodCall(this.methodLocator, this.targetHandler, CompoundList.of(this.argumentLoaders, argumentLoaders), this.methodInvoker, this.terminationHandler, this.assigner, this.typing);
    }

    public FieldSetting setsField(Field field) {
        return this.setsField(new FieldDescription.ForLoadedField(field));
    }

    public FieldSetting setsField(FieldDescription fieldDescription) {
        return new FieldSetting(new MethodCall(this.methodLocator, this.targetHandler, this.argumentLoaders, this.methodInvoker, new TerminationHandler.FieldSetting.Explicit(fieldDescription), this.assigner, this.typing));
    }

    public FieldSetting setsField(ElementMatcher<? super FieldDescription> matcher) {
        return new FieldSetting(new MethodCall(this.methodLocator, this.targetHandler, this.argumentLoaders, this.methodInvoker, new TerminationHandler.FieldSetting.Implicit(matcher), this.assigner, this.typing));
    }

    public Implementation.Composable withAssigner(Assigner assigner, Assigner.Typing typing) {
        return new MethodCall(this.methodLocator, this.targetHandler, this.argumentLoaders, this.methodInvoker, this.terminationHandler, assigner, typing);
    }

    @Override
    public Implementation andThen(Implementation implementation) {
        return new Implementation.Compound(new MethodCall(this.methodLocator, this.targetHandler, this.argumentLoaders, this.methodInvoker, TerminationHandler.Simple.DROPPING, this.assigner, this.typing), implementation);
    }

    @Override
    public Implementation.Composable andThen(Implementation.Composable implementation) {
        return new Implementation.Compound.Composable(new MethodCall(this.methodLocator, this.targetHandler, this.argumentLoaders, this.methodInvoker, TerminationHandler.Simple.DROPPING, this.assigner, this.typing), implementation);
    }

    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        for (InstrumentedType.Prepareable prepareable : this.argumentLoaders) {
            instrumentedType = prepareable.prepare(instrumentedType);
        }
        return this.targetHandler.prepare(instrumentedType);
    }

    @Override
    public ByteCodeAppender appender(Implementation.Target implementationTarget) {
        return new Appender(implementationTarget, this.terminationHandler.make(implementationTarget.getInstrumentedType()));
    }

    @HashCodeAndEqualsPlugin.Enhance(includeSyntheticFields=true)
    protected class Appender
    implements ByteCodeAppender {
        private final Implementation.Target implementationTarget;
        private final MethodLocator methodLocator;
        private final List<ArgumentLoader.ArgumentProvider> argumentProviders;
        private final MethodInvoker methodInvoker;
        private final TargetHandler targetHandler;
        private final TerminationHandler terminationHandler;

        protected Appender(Implementation.Target implementationTarget, TerminationHandler terminationHandler) {
            this.implementationTarget = implementationTarget;
            this.methodLocator = MethodCall.this.methodLocator.make(implementationTarget.getInstrumentedType());
            this.argumentProviders = new ArrayList<ArgumentLoader.ArgumentProvider>(MethodCall.this.argumentLoaders.size());
            for (ArgumentLoader.Factory factory : MethodCall.this.argumentLoaders) {
                this.argumentProviders.add(factory.make(implementationTarget));
            }
            this.methodInvoker = MethodCall.this.methodInvoker.make(implementationTarget.getInstrumentedType());
            this.targetHandler = MethodCall.this.targetHandler.make(implementationTarget);
            this.terminationHandler = terminationHandler;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            TargetHandler.Resolved targetHandler = this.targetHandler.resolve(instrumentedMethod);
            return new ByteCodeAppender.Size(new StackManipulation.Compound(this.terminationHandler.prepare(), this.toStackManipulation(instrumentedMethod, this.toInvokedMethod(instrumentedMethod, targetHandler), targetHandler)).apply(methodVisitor, implementationContext).getMaximalSize(), instrumentedMethod.getStackSize());
        }

        protected MethodDescription toInvokedMethod(MethodDescription instrumentedMethod, TargetHandler.Resolved targetHandler) {
            return this.methodLocator.resolve(targetHandler.getTypeDescription(), instrumentedMethod);
        }

        protected StackManipulation toStackManipulation(MethodDescription instrumentedMethod, MethodDescription invokedMethod, TargetHandler.Resolved targetHandler) {
            ArrayList<ArgumentLoader> argumentLoaders = new ArrayList<ArgumentLoader>();
            for (ArgumentLoader.ArgumentProvider argumentProvider : this.argumentProviders) {
                argumentLoaders.addAll(argumentProvider.resolve(instrumentedMethod, invokedMethod));
            }
            ParameterList<?> parameters = invokedMethod.getParameters();
            if (parameters.size() != argumentLoaders.size()) {
                throw new IllegalStateException(invokedMethod + " does not accept " + argumentLoaders.size() + " arguments");
            }
            Iterator parameterIterator = parameters.iterator();
            ArrayList<StackManipulation> argumentInstructions = new ArrayList<StackManipulation>(argumentLoaders.size());
            for (ArgumentLoader argumentLoader : argumentLoaders) {
                argumentInstructions.add(argumentLoader.toStackManipulation((ParameterDescription)parameterIterator.next(), MethodCall.this.assigner, MethodCall.this.typing));
            }
            return new StackManipulation.Compound(targetHandler.toStackManipulation(invokedMethod, MethodCall.this.assigner, MethodCall.this.typing), new StackManipulation.Compound(argumentInstructions), this.methodInvoker.toStackManipulation(invokedMethod, this.implementationTarget), this.terminationHandler.toStackManipulation(invokedMethod, instrumentedMethod, MethodCall.this.assigner, MethodCall.this.typing));
        }
    }

    public static interface ArgumentLoader {
        public StackManipulation toStackManipulation(ParameterDescription var1, Assigner var2, Assigner.Typing var3);

        public static interface ArgumentProvider {
            public List<ArgumentLoader> resolve(MethodDescription var1, MethodDescription var2);
        }

        public static interface Factory
        extends InstrumentedType.Prepareable {
            public ArgumentProvider make(Implementation.Target var1);
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForField
        implements ArgumentLoader {
            private final FieldDescription fieldDescription;
            private final MethodDescription instrumentedMethod;

            public ForField(FieldDescription fieldDescription, MethodDescription instrumentedMethod) {
                this.fieldDescription = fieldDescription;
                this.instrumentedMethod = instrumentedMethod;
            }

            @Override
            public StackManipulation toStackManipulation(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                if (!this.fieldDescription.isStatic() && this.instrumentedMethod.isStatic()) {
                    throw new IllegalStateException("Cannot access non-static " + this.fieldDescription + " from " + this.instrumentedMethod);
                }
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(this.fieldDescription.isStatic() ? StackManipulation.Trivial.INSTANCE : MethodVariableAccess.loadThis(), FieldAccess.forField(this.fieldDescription).read(), assigner.assign(this.fieldDescription.getType(), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.fieldDescription + " to " + target);
                }
                return stackManipulation;
            }

            @HashCodeAndEqualsPlugin.Enhance
            protected static class ArgumentProvider
            implements net.bytebuddy.implementation.MethodCall$ArgumentLoader$ArgumentProvider {
                private final FieldDescription fieldDescription;

                protected ArgumentProvider(FieldDescription fieldDescription) {
                    this.fieldDescription = fieldDescription;
                }

                @Override
                public List<ArgumentLoader> resolve(MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                    return Collections.singletonList(new ForField(this.fieldDescription, instrumentedMethod));
                }
            }

            @HashCodeAndEqualsPlugin.Enhance
            protected static class Factory
            implements net.bytebuddy.implementation.MethodCall$ArgumentLoader$Factory {
                private final String name;
                private final FieldLocator.Factory fieldLocatorFactory;

                public Factory(String name, FieldLocator.Factory fieldLocatorFactory) {
                    this.name = name;
                    this.fieldLocatorFactory = fieldLocatorFactory;
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public net.bytebuddy.implementation.MethodCall$ArgumentLoader$ArgumentProvider make(Implementation.Target implementationTarget) {
                    FieldLocator.Resolution resolution = this.fieldLocatorFactory.make(implementationTarget.getInstrumentedType()).locate(this.name);
                    if (!resolution.isResolved()) {
                        throw new IllegalStateException("Could not locate field '" + this.name + "' on " + implementationTarget.getInstrumentedType());
                    }
                    return new ArgumentProvider(resolution.getField());
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForInstance
        implements ArgumentLoader,
        ArgumentProvider {
            private final FieldDescription fieldDescription;

            public ForInstance(FieldDescription fieldDescription) {
                this.fieldDescription = fieldDescription;
            }

            @Override
            public List<ArgumentLoader> resolve(MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                return Collections.singletonList(this);
            }

            @Override
            public StackManipulation toStackManipulation(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(FieldAccess.forField(this.fieldDescription).read(), assigner.assign(this.fieldDescription.getType(), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.fieldDescription.getType() + " to " + target);
                }
                return stackManipulation;
            }

            @HashCodeAndEqualsPlugin.Enhance
            protected static class Factory
            implements net.bytebuddy.implementation.MethodCall$ArgumentLoader$Factory {
                private static final String FIELD_PREFIX = "methodCall";
                private final Object value;
                @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.IGNORE)
                private final String name;

                public Factory(Object value) {
                    this.value = value;
                    this.name = "methodCall$" + RandomString.make();
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType.withField(new FieldDescription.Token(this.name, 4105, TypeDescription.Generic.OfNonGenericType.ForLoadedType.of(this.value.getClass()))).withInitializer(new LoadedTypeInitializer.ForStaticField(this.name, this.value));
                }

                @Override
                public ArgumentProvider make(Implementation.Target implementationTarget) {
                    return new ForInstance((FieldDescription)((FieldList)implementationTarget.getInstrumentedType().getDeclaredFields().filter(ElementMatchers.named(this.name))).getOnly());
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForInstrumentedType
        implements ArgumentLoader,
        ArgumentProvider {
            private final TypeDescription instrumentedType;

            public ForInstrumentedType(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public List<ArgumentLoader> resolve(MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                return Collections.singletonList(this);
            }

            @Override
            public StackManipulation toStackManipulation(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(ClassConstant.of(this.instrumentedType), assigner.assign(TypeDescription.Generic.OfNonGenericType.ForLoadedType.CLASS, target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign Class value to " + target);
                }
                return stackManipulation;
            }

            public static enum Factory implements net.bytebuddy.implementation.MethodCall$ArgumentLoader$Factory
            {
                INSTANCE;


                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public ArgumentProvider make(Implementation.Target implementationTarget) {
                    return new ForInstrumentedType(implementationTarget.getInstrumentedType());
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForMethodCall
        implements ArgumentLoader {
            private final Appender appender;
            private final MethodDescription methodDescription;
            private final MethodDescription instrumentedMethod;
            private final TargetHandler.Resolved targetHandler;

            public ForMethodCall(Appender appender, MethodDescription methodDescription, MethodDescription instrumentedMethod, TargetHandler.Resolved targetHandler) {
                this.appender = appender;
                this.methodDescription = methodDescription;
                this.instrumentedMethod = instrumentedMethod;
                this.targetHandler = targetHandler;
            }

            @Override
            public StackManipulation toStackManipulation(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(this.appender.toStackManipulation(this.instrumentedMethod, this.methodDescription, this.targetHandler), assigner.assign(this.methodDescription.isConstructor() ? this.methodDescription.getDeclaringType().asGenericType() : this.methodDescription.getReturnType(), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign return type of " + this.methodDescription + " to " + target);
                }
                return stackManipulation;
            }

            @HashCodeAndEqualsPlugin.Enhance
            protected static class ArgumentProvider
            implements net.bytebuddy.implementation.MethodCall$ArgumentLoader$ArgumentProvider {
                private final Appender appender;

                protected ArgumentProvider(Appender appender) {
                    this.appender = appender;
                }

                @Override
                public List<ArgumentLoader> resolve(MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                    TargetHandler.Resolved targetHandler = this.appender.targetHandler.resolve(instrumentedMethod);
                    return Collections.singletonList(new ForMethodCall(this.appender, this.appender.toInvokedMethod(instrumentedMethod, targetHandler), instrumentedMethod, targetHandler));
                }
            }

            @HashCodeAndEqualsPlugin.Enhance
            protected static class Factory
            implements net.bytebuddy.implementation.MethodCall$ArgumentLoader$Factory {
                private final MethodCall methodCall;

                public Factory(MethodCall methodCall) {
                    this.methodCall = methodCall;
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return this.methodCall.prepare(instrumentedType);
                }

                @Override
                public net.bytebuddy.implementation.MethodCall$ArgumentLoader$ArgumentProvider make(Implementation.Target implementationTarget) {
                    MethodCall methodCall = this.methodCall;
                    methodCall.getClass();
                    return new ArgumentProvider(methodCall.new Appender(implementationTarget, TerminationHandler.Simple.IGNORING));
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForMethodParameter
        implements ArgumentLoader {
            private final int index;
            private final MethodDescription instrumentedMethod;

            public ForMethodParameter(int index, MethodDescription instrumentedMethod) {
                this.index = index;
                this.instrumentedMethod = instrumentedMethod;
            }

            @Override
            public StackManipulation toStackManipulation(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                ParameterDescription parameterDescription = (ParameterDescription)this.instrumentedMethod.getParameters().get(this.index);
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(MethodVariableAccess.load(parameterDescription), assigner.assign(parameterDescription.getType(), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign " + parameterDescription + " to " + target + " for " + this.instrumentedMethod);
                }
                return stackManipulation;
            }

            @HashCodeAndEqualsPlugin.Enhance
            protected static class Factory
            implements net.bytebuddy.implementation.MethodCall$ArgumentLoader$Factory,
            ArgumentProvider {
                private final int index;

                public Factory(int index) {
                    this.index = index;
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public ArgumentProvider make(Implementation.Target implementationTarget) {
                    return this;
                }

                @Override
                public List<ArgumentLoader> resolve(MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                    if (this.index >= instrumentedMethod.getParameters().size()) {
                        throw new IllegalStateException(instrumentedMethod + " does not have a parameter with index " + this.index);
                    }
                    return Collections.singletonList(new ForMethodParameter(this.index, instrumentedMethod));
                }
            }

            protected static enum OfInstrumentedMethod implements net.bytebuddy.implementation.MethodCall$ArgumentLoader$Factory,
            ArgumentProvider
            {
                INSTANCE;


                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public ArgumentProvider make(Implementation.Target implementationTarget) {
                    return this;
                }

                @Override
                public List<ArgumentLoader> resolve(MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                    ArrayList<ArgumentLoader> argumentLoaders = new ArrayList<ArgumentLoader>(instrumentedMethod.getParameters().size());
                    for (ParameterDescription parameterDescription : instrumentedMethod.getParameters()) {
                        argumentLoaders.add(new ForMethodParameter(parameterDescription.getIndex(), instrumentedMethod));
                    }
                    return argumentLoaders;
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForMethodParameterArray
        implements ArgumentLoader {
            private final ParameterList<?> parameters;

            public ForMethodParameterArray(ParameterList<?> parameters) {
                this.parameters = parameters;
            }

            @Override
            public StackManipulation toStackManipulation(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                TypeDescription.Generic componentType;
                if (target.getType().represents((Type)((Object)Object.class))) {
                    componentType = TypeDescription.Generic.OBJECT;
                } else if (target.getType().isArray()) {
                    componentType = target.getType().getComponentType();
                } else {
                    throw new IllegalStateException("Cannot set method parameter array for non-array type: " + target);
                }
                ArrayList<StackManipulation.Compound> stackManipulations = new ArrayList<StackManipulation.Compound>(this.parameters.size());
                for (ParameterDescription parameter : this.parameters) {
                    StackManipulation.Compound stackManipulation = new StackManipulation.Compound(MethodVariableAccess.load(parameter), assigner.assign(parameter.getType(), componentType, typing));
                    if (stackManipulation.isValid()) {
                        stackManipulations.add(stackManipulation);
                        continue;
                    }
                    throw new IllegalStateException("Cannot assign " + parameter + " to " + componentType);
                }
                return new StackManipulation.Compound(ArrayFactory.forType(componentType).withValues(stackManipulations));
            }

            public static enum ForInstrumentedMethod implements Factory,
            ArgumentProvider
            {
                INSTANCE;


                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public ArgumentProvider make(Implementation.Target implementationTarget) {
                    return this;
                }

                @Override
                public List<ArgumentLoader> resolve(MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                    return Collections.singletonList(new ForMethodParameterArray(instrumentedMethod.getParameters()));
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForMethodParameterArrayElement
        implements ArgumentLoader {
            private final ParameterDescription parameterDescription;
            private final int index;

            public ForMethodParameterArrayElement(ParameterDescription parameterDescription, int index) {
                this.parameterDescription = parameterDescription;
                this.index = index;
            }

            @Override
            public StackManipulation toStackManipulation(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(MethodVariableAccess.load(this.parameterDescription), IntegerConstant.forValue(this.index), ArrayAccess.of(this.parameterDescription.getType().getComponentType()).load(), assigner.assign(this.parameterDescription.getType().getComponentType(), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.parameterDescription.getType().getComponentType() + " to " + target);
                }
                return stackManipulation;
            }

            @HashCodeAndEqualsPlugin.Enhance
            public static class OfInvokedMethod
            implements Factory,
            ArgumentProvider {
                private final int index;

                public OfInvokedMethod(int index) {
                    this.index = index;
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public ArgumentProvider make(Implementation.Target implementationTarget) {
                    return this;
                }

                @Override
                public List<ArgumentLoader> resolve(MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                    if (instrumentedMethod.getParameters().size() <= this.index) {
                        throw new IllegalStateException(instrumentedMethod + " does not declare a parameter with index " + this.index);
                    }
                    if (!((ParameterDescription)instrumentedMethod.getParameters().get(this.index)).getType().isArray()) {
                        throw new IllegalStateException("Cannot access an item from non-array parameter " + instrumentedMethod.getParameters().get(this.index));
                    }
                    ArrayList<ArgumentLoader> argumentLoaders = new ArrayList<ArgumentLoader>(instrumentedMethod.getParameters().size());
                    int index = 0;
                    while (index < invokedMethod.getParameters().size()) {
                        argumentLoaders.add(new ForMethodParameterArrayElement((ParameterDescription)instrumentedMethod.getParameters().get(this.index), index++));
                        ++index;
                    }
                    return argumentLoaders;
                }
            }

            @HashCodeAndEqualsPlugin.Enhance
            public static class OfParameter
            implements Factory,
            ArgumentProvider {
                private final int index;
                private final int arrayIndex;

                public OfParameter(int index, int arrayIndex) {
                    this.index = index;
                    this.arrayIndex = arrayIndex;
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public ArgumentProvider make(Implementation.Target implementationTarget) {
                    return this;
                }

                @Override
                public List<ArgumentLoader> resolve(MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                    if (instrumentedMethod.getParameters().size() <= this.index) {
                        throw new IllegalStateException(instrumentedMethod + " does not declare a parameter with index " + this.index);
                    }
                    if (!((ParameterDescription)instrumentedMethod.getParameters().get(this.index)).getType().isArray()) {
                        throw new IllegalStateException("Cannot access an item from non-array parameter " + instrumentedMethod.getParameters().get(this.index));
                    }
                    return Collections.singletonList(new ForMethodParameterArrayElement((ParameterDescription)instrumentedMethod.getParameters().get(this.index), this.arrayIndex));
                }
            }
        }

        public static enum ForNullConstant implements ArgumentLoader,
        ArgumentProvider,
        Factory
        {
            INSTANCE;


            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public ArgumentProvider make(Implementation.Target implementationTarget) {
                return this;
            }

            @Override
            public List<ArgumentLoader> resolve(MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                return Collections.singletonList(this);
            }

            @Override
            public StackManipulation toStackManipulation(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                if (target.getType().isPrimitive()) {
                    throw new IllegalStateException("Cannot assign null to " + target);
                }
                return NullConstant.INSTANCE;
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForStackManipulation
        implements ArgumentLoader,
        ArgumentProvider,
        Factory {
            private final StackManipulation stackManipulation;
            private final TypeDefinition typeDefinition;

            public ForStackManipulation(StackManipulation stackManipulation, Type type) {
                this(stackManipulation, TypeDefinition.Sort.describe(type));
            }

            public ForStackManipulation(StackManipulation stackManipulation, TypeDefinition typeDefinition) {
                this.stackManipulation = stackManipulation;
                this.typeDefinition = typeDefinition;
            }

            public static Factory of(Object value) {
                if (value == null) {
                    return ForNullConstant.INSTANCE;
                }
                if (value instanceof String) {
                    return new ForStackManipulation((StackManipulation)new TextConstant((String)value), (Type)((Object)String.class));
                }
                if (value instanceof Boolean) {
                    return new ForStackManipulation(IntegerConstant.forValue((Boolean)value), Boolean.TYPE);
                }
                if (value instanceof Byte) {
                    return new ForStackManipulation(IntegerConstant.forValue(((Byte)value).byteValue()), Byte.TYPE);
                }
                if (value instanceof Short) {
                    return new ForStackManipulation(IntegerConstant.forValue(((Short)value).shortValue()), Short.TYPE);
                }
                if (value instanceof Character) {
                    return new ForStackManipulation(IntegerConstant.forValue(((Character)value).charValue()), Character.TYPE);
                }
                if (value instanceof Integer) {
                    return new ForStackManipulation(IntegerConstant.forValue((Integer)value), Integer.TYPE);
                }
                if (value instanceof Long) {
                    return new ForStackManipulation(LongConstant.forValue((Long)value), Long.TYPE);
                }
                if (value instanceof Float) {
                    return new ForStackManipulation(FloatConstant.forValue(((Float)value).floatValue()), Float.TYPE);
                }
                if (value instanceof Double) {
                    return new ForStackManipulation(DoubleConstant.forValue((Double)value), Double.TYPE);
                }
                if (value instanceof Class) {
                    return new ForStackManipulation(ClassConstant.of(TypeDescription.ForLoadedType.of((Class)value)), (Type)((Object)Class.class));
                }
                if (JavaType.METHOD_HANDLE.isInstance(value)) {
                    return new ForStackManipulation((StackManipulation)new JavaConstantValue(JavaConstant.MethodHandle.ofLoaded(value)), JavaType.METHOD_HANDLE.getTypeStub());
                }
                if (JavaType.METHOD_TYPE.isInstance(value)) {
                    return new ForStackManipulation((StackManipulation)new JavaConstantValue(JavaConstant.MethodType.ofLoaded(value)), JavaType.METHOD_TYPE.getTypeStub());
                }
                if (value instanceof Enum) {
                    EnumerationDescription.ForLoadedEnumeration enumerationDescription = new EnumerationDescription.ForLoadedEnumeration((Enum)value);
                    return new ForStackManipulation(FieldAccess.forEnumeration(enumerationDescription), enumerationDescription.getEnumerationType());
                }
                return new ForInstance.Factory(value);
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public ArgumentProvider make(Implementation.Target implementationTarget) {
                return this;
            }

            @Override
            public List<ArgumentLoader> resolve(MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                return Collections.singletonList(this);
            }

            @Override
            public StackManipulation toStackManipulation(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation assignment = assigner.assign(this.typeDefinition.asGenericType(), target.getType(), typing);
                if (!assignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + target + " to " + this.typeDefinition);
                }
                return new StackManipulation.Compound(this.stackManipulation, assignment);
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForThisReference
        implements ArgumentLoader,
        ArgumentProvider {
            private final TypeDescription instrumentedType;

            public ForThisReference(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public List<ArgumentLoader> resolve(MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                if (instrumentedMethod.isStatic()) {
                    throw new IllegalStateException(instrumentedMethod + " is static and cannot supply an invoker instance");
                }
                return Collections.singletonList(this);
            }

            @Override
            public StackManipulation toStackManipulation(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(MethodVariableAccess.loadThis(), assigner.assign(this.instrumentedType.asGenericType(), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.instrumentedType + " to " + target);
                }
                return stackManipulation;
            }

            public static enum Factory implements net.bytebuddy.implementation.MethodCall$ArgumentLoader$Factory
            {
                INSTANCE;


                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public ArgumentProvider make(Implementation.Target implementationTarget) {
                    return new ForThisReference(implementationTarget.getInstrumentedType());
                }
            }
        }
    }

    @HashCodeAndEqualsPlugin.Enhance
    public static class FieldSetting
    implements Implementation.Composable {
        private final MethodCall methodCall;

        protected FieldSetting(MethodCall methodCall) {
            this.methodCall = methodCall;
        }

        public Implementation.Composable withAssigner(Assigner assigner, Assigner.Typing typing) {
            return new FieldSetting((MethodCall)this.methodCall.withAssigner(assigner, typing));
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return this.methodCall.prepare(instrumentedType);
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new ByteCodeAppender.Compound(this.methodCall.appender(implementationTarget), Appender.INSTANCE);
        }

        @Override
        public Implementation andThen(Implementation implementation) {
            return new Implementation.Compound(this.methodCall, implementation);
        }

        @Override
        public Implementation.Composable andThen(Implementation.Composable implementation) {
            return new Implementation.Compound.Composable(this.methodCall, implementation);
        }

        protected static enum Appender implements ByteCodeAppender
        {
            INSTANCE;


            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                if (!instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                    throw new IllegalStateException("Instrumented method " + instrumentedMethod + " does not return void for field setting method call");
                }
                return new ByteCodeAppender.Size(MethodReturn.VOID.apply(methodVisitor, implementationContext).getMaximalSize(), instrumentedMethod.getStackSize());
            }
        }
    }

    protected static interface MethodInvoker {
        public StackManipulation toStackManipulation(MethodDescription var1, Implementation.Target var2);

        public static interface Factory {
            public MethodInvoker make(TypeDescription var1);
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForContextualInvocation
        implements MethodInvoker {
            private final TypeDescription instrumentedType;

            protected ForContextualInvocation(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public StackManipulation toStackManipulation(MethodDescription invokedMethod, Implementation.Target implementationTarget) {
                if (invokedMethod.isVirtual() && !invokedMethod.isInvokableOn(this.instrumentedType)) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " on " + this.instrumentedType);
                }
                return invokedMethod.isVirtual() ? MethodInvocation.invoke(invokedMethod).virtual(this.instrumentedType) : MethodInvocation.invoke(invokedMethod);
            }

            static enum Factory implements net.bytebuddy.implementation.MethodCall$MethodInvoker$Factory
            {
                INSTANCE;


                @Override
                public MethodInvoker make(TypeDescription instrumentedType) {
                    return new ForContextualInvocation(instrumentedType);
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForDefaultMethodInvocation
        implements MethodInvoker {
            private final TypeDescription instrumentedType;

            protected ForDefaultMethodInvocation(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public StackManipulation toStackManipulation(MethodDescription invokedMethod, Implementation.Target implementationTarget) {
                if (!invokedMethod.isInvokableOn(this.instrumentedType)) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " as default method of " + this.instrumentedType);
                }
                Implementation.SpecialMethodInvocation stackManipulation = implementationTarget.invokeDefault(invokedMethod.asSignatureToken(), invokedMethod.getDeclaringType().asErasure()).withCheckedCompatibilityTo(invokedMethod.asTypeToken());
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " on " + this.instrumentedType);
                }
                return stackManipulation;
            }

            static enum Factory implements net.bytebuddy.implementation.MethodCall$MethodInvoker$Factory
            {
                INSTANCE;


                @Override
                public MethodInvoker make(TypeDescription instrumentedType) {
                    return new ForDefaultMethodInvocation(instrumentedType);
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForSuperMethodInvocation
        implements MethodInvoker {
            private final TypeDescription instrumentedType;

            protected ForSuperMethodInvocation(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public StackManipulation toStackManipulation(MethodDescription invokedMethod, Implementation.Target implementationTarget) {
                if (!invokedMethod.isInvokableOn(implementationTarget.getOriginType().asErasure())) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " as super method of " + this.instrumentedType);
                }
                Implementation.SpecialMethodInvocation stackManipulation = implementationTarget.invokeDominant(invokedMethod.asSignatureToken()).withCheckedCompatibilityTo(invokedMethod.asTypeToken());
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " as a super method");
                }
                return stackManipulation;
            }

            static enum Factory implements net.bytebuddy.implementation.MethodCall$MethodInvoker$Factory
            {
                INSTANCE;


                @Override
                public MethodInvoker make(TypeDescription instrumentedType) {
                    if (instrumentedType.getSuperClass() == null) {
                        throw new IllegalStateException("Cannot invoke super method for " + instrumentedType);
                    }
                    return new ForSuperMethodInvocation(instrumentedType);
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForVirtualInvocation
        implements MethodInvoker {
            private final TypeDescription typeDescription;

            protected ForVirtualInvocation(TypeDescription typeDescription) {
                this.typeDescription = typeDescription;
            }

            @Override
            public StackManipulation toStackManipulation(MethodDescription invokedMethod, Implementation.Target implementationTarget) {
                if (!invokedMethod.isInvokableOn(this.typeDescription)) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " on " + this.typeDescription);
                }
                return MethodInvocation.invoke(invokedMethod).virtual(this.typeDescription);
            }

            @HashCodeAndEqualsPlugin.Enhance
            protected static class Factory
            implements net.bytebuddy.implementation.MethodCall$MethodInvoker$Factory {
                private final TypeDescription typeDescription;

                protected Factory(TypeDescription typeDescription) {
                    this.typeDescription = typeDescription;
                }

                @Override
                public MethodInvoker make(TypeDescription instrumentedType) {
                    if (!this.typeDescription.asErasure().isAccessibleTo(instrumentedType)) {
                        throw new IllegalStateException(this.typeDescription + " is not accessible to " + instrumentedType);
                    }
                    return new ForVirtualInvocation(this.typeDescription);
                }
            }

            protected static enum WithImplicitType implements MethodInvoker,
            net.bytebuddy.implementation.MethodCall$MethodInvoker$Factory
            {
                INSTANCE;


                @Override
                public MethodInvoker make(TypeDescription instrumentedType) {
                    return this;
                }

                @Override
                public StackManipulation toStackManipulation(MethodDescription invokedMethod, Implementation.Target implementationTarget) {
                    if (!invokedMethod.isAccessibleTo(implementationTarget.getInstrumentedType()) || !invokedMethod.isVirtual()) {
                        throw new IllegalStateException("Cannot invoke " + invokedMethod + " virtually");
                    }
                    return MethodInvocation.invoke(invokedMethod);
                }
            }
        }
    }

    public static interface MethodLocator {
        public MethodDescription resolve(TypeDescription var1, MethodDescription var2);

        public static interface Factory {
            public MethodLocator make(TypeDescription var1);
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForElementMatcher
        implements MethodLocator {
            private final TypeDescription instrumentedType;
            private final ElementMatcher<? super MethodDescription> matcher;
            private final MethodGraph.Compiler methodGraphCompiler;

            protected ForElementMatcher(TypeDescription instrumentedType, ElementMatcher<? super MethodDescription> matcher, MethodGraph.Compiler methodGraphCompiler) {
                this.instrumentedType = instrumentedType;
                this.matcher = matcher;
                this.methodGraphCompiler = methodGraphCompiler;
            }

            @Override
            public MethodDescription resolve(TypeDescription targetType, MethodDescription instrumentedMethod) {
                List candidates = CompoundList.of(this.instrumentedType.getSuperClass().getDeclaredMethods().filter(ElementMatchers.isConstructor().and(this.matcher)), this.methodGraphCompiler.compile(targetType, this.instrumentedType).listNodes().asMethodList().filter(this.matcher));
                if (candidates.size() == 1) {
                    return (MethodDescription)candidates.get(0);
                }
                throw new IllegalStateException(this.instrumentedType + " does not define exactly one virtual method or constructor for " + this.matcher);
            }

            @HashCodeAndEqualsPlugin.Enhance
            public static class Factory
            implements net.bytebuddy.implementation.MethodCall$MethodLocator$Factory {
                private final ElementMatcher<? super MethodDescription> matcher;
                private final MethodGraph.Compiler methodGraphCompiler;

                public Factory(ElementMatcher<? super MethodDescription> matcher, MethodGraph.Compiler methodGraphCompiler) {
                    this.matcher = matcher;
                    this.methodGraphCompiler = methodGraphCompiler;
                }

                @Override
                public MethodLocator make(TypeDescription instrumentedType) {
                    return new ForElementMatcher(instrumentedType, this.matcher, this.methodGraphCompiler);
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForExplicitMethod
        implements MethodLocator,
        Factory {
            private final MethodDescription methodDescription;

            protected ForExplicitMethod(MethodDescription methodDescription) {
                this.methodDescription = methodDescription;
            }

            @Override
            public MethodLocator make(TypeDescription instrumentedType) {
                return this;
            }

            @Override
            public MethodDescription resolve(TypeDescription targetType, MethodDescription instrumentedMethod) {
                return this.methodDescription;
            }
        }

        public static enum ForInstrumentedMethod implements MethodLocator,
        Factory
        {
            INSTANCE;


            @Override
            public MethodLocator make(TypeDescription instrumentedType) {
                return this;
            }

            @Override
            public MethodDescription resolve(TypeDescription targetType, MethodDescription instrumentedMethod) {
                return instrumentedMethod;
            }
        }
    }

    protected static interface TargetHandler {
        public Resolved resolve(MethodDescription var1);

        public static interface Factory
        extends InstrumentedType.Prepareable {
            public TargetHandler make(Implementation.Target var1);
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForConstructingInvocation
        implements TargetHandler,
        Resolved {
            private final TypeDescription instrumentedType;

            protected ForConstructingInvocation(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public Resolved resolve(MethodDescription instrumentedMethod) {
                return this;
            }

            @Override
            public TypeDescription getTypeDescription() {
                return this.instrumentedType;
            }

            @Override
            public StackManipulation toStackManipulation(MethodDescription invokedMethod, Assigner assigner, Assigner.Typing typing) {
                return new StackManipulation.Compound(TypeCreation.of(invokedMethod.getDeclaringType().asErasure()), Duplication.SINGLE);
            }

            static enum Factory implements net.bytebuddy.implementation.MethodCall$TargetHandler$Factory
            {
                INSTANCE;


                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public TargetHandler make(Implementation.Target implementationTarget) {
                    return new ForConstructingInvocation(implementationTarget.getInstrumentedType());
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForField
        implements TargetHandler,
        Resolved {
            private final FieldDescription fieldDescription;

            protected ForField(FieldDescription fieldDescription) {
                this.fieldDescription = fieldDescription;
            }

            @Override
            public Resolved resolve(MethodDescription instrumentedMethod) {
                return this;
            }

            @Override
            public TypeDescription getTypeDescription() {
                return this.fieldDescription.getType().asErasure();
            }

            @Override
            public StackManipulation toStackManipulation(MethodDescription invokedMethod, Assigner assigner, Assigner.Typing typing) {
                if (!(invokedMethod.isMethod() && invokedMethod.isVirtual() && invokedMethod.isVisibleTo(this.fieldDescription.getType().asErasure()))) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " on " + this.fieldDescription);
                }
                StackManipulation stackManipulation = assigner.assign(this.fieldDescription.getType(), invokedMethod.getDeclaringType().asGenericType(), typing);
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " on " + this.fieldDescription);
                }
                return new StackManipulation.Compound(invokedMethod.isStatic() || this.fieldDescription.isStatic() ? StackManipulation.Trivial.INSTANCE : MethodVariableAccess.loadThis(), FieldAccess.forField(this.fieldDescription).read(), stackManipulation);
            }

            @HashCodeAndEqualsPlugin.Enhance
            protected static class Factory
            implements net.bytebuddy.implementation.MethodCall$TargetHandler$Factory {
                private final Location location;

                protected Factory(Location location) {
                    this.location = location;
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public TargetHandler make(Implementation.Target implementationTarget) {
                    FieldDescription fieldDescription = this.location.resolve(implementationTarget.getInstrumentedType());
                    if (!fieldDescription.isStatic() && !implementationTarget.getInstrumentedType().isAssignableTo(fieldDescription.getDeclaringType().asErasure())) {
                        throw new IllegalStateException("Cannot access " + fieldDescription + " from " + implementationTarget.getInstrumentedType());
                    }
                    return new ForField(fieldDescription);
                }
            }

            protected static interface Location {
                public FieldDescription resolve(TypeDescription var1);

                @HashCodeAndEqualsPlugin.Enhance
                public static class ForExplicitField
                implements Location {
                    private final FieldDescription fieldDescription;

                    protected ForExplicitField(FieldDescription fieldDescription) {
                        this.fieldDescription = fieldDescription;
                    }

                    @Override
                    public FieldDescription resolve(TypeDescription instrumentedType) {
                        return this.fieldDescription;
                    }
                }

                @HashCodeAndEqualsPlugin.Enhance
                public static class ForImplicitField
                implements Location {
                    private final String name;
                    private final FieldLocator.Factory fieldLocatorFactory;

                    protected ForImplicitField(String name, FieldLocator.Factory fieldLocatorFactory) {
                        this.name = name;
                        this.fieldLocatorFactory = fieldLocatorFactory;
                    }

                    @Override
                    public FieldDescription resolve(TypeDescription instrumentedType) {
                        FieldLocator.Resolution resolution = this.fieldLocatorFactory.make(instrumentedType).locate(this.name);
                        if (!resolution.isResolved()) {
                            throw new IllegalStateException("Could not locate field name " + this.name + " on " + instrumentedType);
                        }
                        return resolution.getField();
                    }
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForMethodCall
        implements TargetHandler {
            private final Appender appender;

            protected ForMethodCall(Appender appender) {
                this.appender = appender;
            }

            @Override
            public net.bytebuddy.implementation.MethodCall$TargetHandler$Resolved resolve(MethodDescription instrumentedMethod) {
                net.bytebuddy.implementation.MethodCall$TargetHandler$Resolved targetHandler = this.appender.targetHandler.resolve(instrumentedMethod);
                return new Resolved(this.appender, this.appender.toInvokedMethod(instrumentedMethod, targetHandler), instrumentedMethod, targetHandler);
            }

            @HashCodeAndEqualsPlugin.Enhance
            protected static class Factory
            implements net.bytebuddy.implementation.MethodCall$TargetHandler$Factory {
                private final MethodCall methodCall;

                public Factory(MethodCall methodCall) {
                    this.methodCall = methodCall;
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return this.methodCall.prepare(instrumentedType);
                }

                @Override
                public TargetHandler make(Implementation.Target implementationTarget) {
                    MethodCall methodCall = this.methodCall;
                    methodCall.getClass();
                    return new ForMethodCall(methodCall.new Appender(implementationTarget, TerminationHandler.Simple.IGNORING));
                }
            }

            @HashCodeAndEqualsPlugin.Enhance
            protected static class Resolved
            implements net.bytebuddy.implementation.MethodCall$TargetHandler$Resolved {
                private final Appender appender;
                private final MethodDescription methodDescription;
                private final MethodDescription instrumentedMethod;
                private final net.bytebuddy.implementation.MethodCall$TargetHandler$Resolved targetHandler;

                protected Resolved(Appender appender, MethodDescription methodDescription, MethodDescription instrumentedMethod, net.bytebuddy.implementation.MethodCall$TargetHandler$Resolved targetHandler) {
                    this.appender = appender;
                    this.methodDescription = methodDescription;
                    this.instrumentedMethod = instrumentedMethod;
                    this.targetHandler = targetHandler;
                }

                @Override
                public TypeDescription getTypeDescription() {
                    return this.methodDescription.getReturnType().asErasure();
                }

                @Override
                public StackManipulation toStackManipulation(MethodDescription invokedMethod, Assigner assigner, Assigner.Typing typing) {
                    StackManipulation stackManipulation = assigner.assign(this.methodDescription.getReturnType(), invokedMethod.getDeclaringType().asGenericType(), typing);
                    if (!stackManipulation.isValid()) {
                        throw new IllegalStateException("Cannot invoke " + invokedMethod + " on " + this.methodDescription.getReturnType());
                    }
                    return new StackManipulation.Compound(this.appender.toStackManipulation(this.instrumentedMethod, this.methodDescription, this.targetHandler), stackManipulation);
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForMethodParameter
        implements TargetHandler,
        Factory {
            private final int index;

            protected ForMethodParameter(int index) {
                this.index = index;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public TargetHandler make(Implementation.Target implementationTarget) {
                return this;
            }

            @Override
            public net.bytebuddy.implementation.MethodCall$TargetHandler$Resolved resolve(MethodDescription instrumentedMethod) {
                if (instrumentedMethod.getParameters().size() < this.index) {
                    throw new IllegalArgumentException(instrumentedMethod + " does not have a parameter with index " + this.index);
                }
                return new Resolved((ParameterDescription)instrumentedMethod.getParameters().get(this.index));
            }

            @HashCodeAndEqualsPlugin.Enhance
            protected static class Resolved
            implements net.bytebuddy.implementation.MethodCall$TargetHandler$Resolved {
                private final ParameterDescription parameterDescription;

                protected Resolved(ParameterDescription parameterDescription) {
                    this.parameterDescription = parameterDescription;
                }

                @Override
                public TypeDescription getTypeDescription() {
                    return this.parameterDescription.getType().asErasure();
                }

                @Override
                public StackManipulation toStackManipulation(MethodDescription invokedMethod, Assigner assigner, Assigner.Typing typing) {
                    StackManipulation stackManipulation = assigner.assign(this.parameterDescription.getType(), invokedMethod.getDeclaringType().asGenericType(), typing);
                    if (!stackManipulation.isValid()) {
                        throw new IllegalStateException("Cannot invoke " + invokedMethod + " on " + this.parameterDescription.getType());
                    }
                    return new StackManipulation.Compound(MethodVariableAccess.load(this.parameterDescription), stackManipulation);
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForSelfOrStaticInvocation
        implements TargetHandler {
            private final TypeDescription instrumentedType;

            protected ForSelfOrStaticInvocation(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public net.bytebuddy.implementation.MethodCall$TargetHandler$Resolved resolve(MethodDescription instrumentedMethod) {
                return new Resolved(this.instrumentedType, instrumentedMethod);
            }

            protected static enum Factory implements net.bytebuddy.implementation.MethodCall$TargetHandler$Factory
            {
                INSTANCE;


                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public TargetHandler make(Implementation.Target implementationTarget) {
                    return new ForSelfOrStaticInvocation(implementationTarget.getInstrumentedType());
                }
            }

            @HashCodeAndEqualsPlugin.Enhance
            protected static class Resolved
            implements net.bytebuddy.implementation.MethodCall$TargetHandler$Resolved {
                private final TypeDescription instrumentedType;
                private final MethodDescription instrumentedMethod;

                protected Resolved(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                    this.instrumentedType = instrumentedType;
                    this.instrumentedMethod = instrumentedMethod;
                }

                @Override
                public TypeDescription getTypeDescription() {
                    return this.instrumentedType;
                }

                @Override
                public StackManipulation toStackManipulation(MethodDescription invokedMethod, Assigner assigner, Assigner.Typing typing) {
                    if (this.instrumentedMethod.isStatic() && !invokedMethod.isStatic() && !invokedMethod.isConstructor()) {
                        throw new IllegalStateException("Cannot invoke " + invokedMethod + " from " + this.instrumentedMethod);
                    }
                    if (invokedMethod.isConstructor() && (!this.instrumentedMethod.isConstructor() || !this.instrumentedType.equals(invokedMethod.getDeclaringType().asErasure()) && !this.instrumentedType.getSuperClass().asErasure().equals(invokedMethod.getDeclaringType().asErasure()))) {
                        throw new IllegalStateException("Cannot invoke " + invokedMethod + " from " + this.instrumentedMethod + " in " + this.instrumentedType);
                    }
                    return new StackManipulation.Compound(new StackManipulation[]{invokedMethod.isStatic() ? StackManipulation.Trivial.INSTANCE : MethodVariableAccess.loadThis(), invokedMethod.isConstructor() ? Duplication.SINGLE : StackManipulation.Trivial.INSTANCE});
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForValue
        implements TargetHandler,
        Resolved {
            private final FieldDescription.InDefinedShape fieldDescription;

            protected ForValue(FieldDescription.InDefinedShape fieldDescription) {
                this.fieldDescription = fieldDescription;
            }

            @Override
            public Resolved resolve(MethodDescription instrumentedMethod) {
                return this;
            }

            @Override
            public TypeDescription getTypeDescription() {
                return this.fieldDescription.getType().asErasure();
            }

            @Override
            public StackManipulation toStackManipulation(MethodDescription invokedMethod, Assigner assigner, Assigner.Typing typing) {
                StackManipulation stackManipulation = assigner.assign(this.fieldDescription.getType(), invokedMethod.getDeclaringType().asGenericType(), typing);
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " on " + this.fieldDescription);
                }
                return new StackManipulation.Compound(FieldAccess.forField(this.fieldDescription).read(), stackManipulation);
            }

            @HashCodeAndEqualsPlugin.Enhance
            protected static class Factory
            implements net.bytebuddy.implementation.MethodCall$TargetHandler$Factory {
                private static final String FIELD_PREFIX = "invocationTarget";
                private final Object target;
                private final TypeDescription.Generic fieldType;
                @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.IGNORE)
                private final String name;

                protected Factory(Object target, TypeDescription.Generic fieldType) {
                    this.target = target;
                    this.fieldType = fieldType;
                    this.name = "invocationTarget$" + RandomString.make();
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType.withField(new FieldDescription.Token(this.name, 4169, this.fieldType)).withInitializer(new LoadedTypeInitializer.ForStaticField(this.name, this.target));
                }

                @Override
                public TargetHandler make(Implementation.Target implementationTarget) {
                    return new ForValue((FieldDescription.InDefinedShape)((FieldList)implementationTarget.getInstrumentedType().getDeclaredFields().filter(ElementMatchers.named(this.name))).getOnly());
                }
            }
        }

        public static interface Resolved {
            public TypeDescription getTypeDescription();

            public StackManipulation toStackManipulation(MethodDescription var1, Assigner var2, Assigner.Typing var3);
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class Simple
        implements TargetHandler,
        Factory,
        Resolved {
            private final TypeDescription typeDescription;
            private final StackManipulation stackManipulation;

            protected Simple(TypeDescription typeDescription, StackManipulation stackManipulation) {
                this.typeDescription = typeDescription;
                this.stackManipulation = stackManipulation;
            }

            @Override
            public TargetHandler make(Implementation.Target implementationTarget) {
                return this;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public Resolved resolve(MethodDescription instrumentedMethod) {
                return this;
            }

            @Override
            public TypeDescription getTypeDescription() {
                return this.typeDescription;
            }

            @Override
            public StackManipulation toStackManipulation(MethodDescription invokedMethod, Assigner assigner, Assigner.Typing typing) {
                return this.stackManipulation;
            }
        }
    }

    protected static interface TerminationHandler {
        public StackManipulation prepare();

        public StackManipulation toStackManipulation(MethodDescription var1, MethodDescription var2, Assigner var3, Assigner.Typing var4);

        public static interface Factory {
            public TerminationHandler make(TypeDescription var1);
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class FieldSetting
        implements TerminationHandler {
            private final FieldDescription fieldDescription;

            protected FieldSetting(FieldDescription fieldDescription) {
                this.fieldDescription = fieldDescription;
            }

            @Override
            public StackManipulation prepare() {
                return this.fieldDescription.isStatic() ? StackManipulation.Trivial.INSTANCE : MethodVariableAccess.loadThis();
            }

            @Override
            public StackManipulation toStackManipulation(MethodDescription invokedMethod, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                StackManipulation stackManipulation = assigner.assign(invokedMethod.getReturnType(), this.fieldDescription.getType(), typing);
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign result of " + invokedMethod + " to " + this.fieldDescription);
                }
                return new StackManipulation.Compound(stackManipulation, FieldAccess.forField(this.fieldDescription).write());
            }

            @HashCodeAndEqualsPlugin.Enhance
            protected static class Explicit
            implements Factory {
                private final FieldDescription fieldDescription;

                protected Explicit(FieldDescription fieldDescription) {
                    this.fieldDescription = fieldDescription;
                }

                @Override
                public TerminationHandler make(TypeDescription instrumentedType) {
                    if (!this.fieldDescription.isStatic() && !instrumentedType.isAssignableTo(this.fieldDescription.getDeclaringType().asErasure())) {
                        throw new IllegalStateException("Cannot set " + this.fieldDescription + " from " + instrumentedType);
                    }
                    if (!this.fieldDescription.isAccessibleTo(instrumentedType)) {
                        throw new IllegalStateException("Cannot access " + this.fieldDescription + " from " + instrumentedType);
                    }
                    return new FieldSetting(this.fieldDescription);
                }
            }

            @HashCodeAndEqualsPlugin.Enhance
            protected static class Implicit
            implements Factory {
                private final ElementMatcher<? super FieldDescription> matcher;

                protected Implicit(ElementMatcher<? super FieldDescription> matcher) {
                    this.matcher = matcher;
                }

                @Override
                public TerminationHandler make(TypeDescription instrumentedType) {
                    TypeDefinition current = instrumentedType;
                    do {
                        FieldList candidates;
                        if ((candidates = (FieldList)current.getDeclaredFields().filter(ElementMatchers.isAccessibleTo(instrumentedType).and(this.matcher))).size() == 1) {
                            return new FieldSetting((FieldDescription)candidates.getOnly());
                        }
                        if (candidates.size() != 2) continue;
                        throw new IllegalStateException(this.matcher + " is ambigous and resolved: " + candidates);
                    } while ((current = current.getSuperClass()) != null);
                    throw new IllegalStateException(this.matcher + " does not locate any accessible fields for " + instrumentedType);
                }
            }
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        public static enum Simple implements TerminationHandler,
        Factory
        {
            RETURNING{

                @Override
                public StackManipulation toStackManipulation(MethodDescription invokedMethod, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    StackManipulation stackManipulation = assigner.assign(invokedMethod.isConstructor() ? invokedMethod.getDeclaringType().asGenericType() : invokedMethod.getReturnType(), instrumentedMethod.getReturnType(), typing);
                    if (!stackManipulation.isValid()) {
                        throw new IllegalStateException("Cannot return " + invokedMethod.getReturnType() + " from " + instrumentedMethod);
                    }
                    return new StackManipulation.Compound(stackManipulation, MethodReturn.of(instrumentedMethod.getReturnType()));
                }
            }
            ,
            DROPPING{

                @Override
                public StackManipulation toStackManipulation(MethodDescription invokedMethod, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    return Removal.of(invokedMethod.isConstructor() ? invokedMethod.getDeclaringType() : invokedMethod.getReturnType());
                }
            }
            ,
            IGNORING{

                @Override
                public StackManipulation toStackManipulation(MethodDescription invokedMethod, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                    return StackManipulation.Trivial.INSTANCE;
                }
            };


            @Override
            public TerminationHandler make(TypeDescription instrumentedType) {
                return this;
            }

            @Override
            public StackManipulation prepare() {
                return StackManipulation.Trivial.INSTANCE;
            }
        }
    }

    public static class WithoutSpecifiedTarget
    extends MethodCall {
        protected WithoutSpecifiedTarget(MethodLocator.Factory methodLocator) {
            super(methodLocator, TargetHandler.ForSelfOrStaticInvocation.Factory.INSTANCE, Collections.emptyList(), MethodInvoker.ForContextualInvocation.Factory.INSTANCE, TerminationHandler.Simple.RETURNING, Assigner.DEFAULT, Assigner.Typing.STATIC);
        }

        public MethodCall on(Object target) {
            return this.on(target, target.getClass());
        }

        public <T> MethodCall on(T target, Class<? super T> type) {
            return new MethodCall(this.methodLocator, new TargetHandler.ForValue.Factory(target, TypeDescription.Generic.OfNonGenericType.ForLoadedType.of(type)), this.argumentLoaders, new MethodInvoker.ForVirtualInvocation.Factory(TypeDescription.ForLoadedType.of(type)), this.terminationHandler, this.assigner, this.typing);
        }

        public MethodCall on(StackManipulation stackManipulation, Class<?> type) {
            return this.on(stackManipulation, TypeDescription.ForLoadedType.of(type));
        }

        public MethodCall on(StackManipulation stackManipulation, TypeDescription typeDescription) {
            return new MethodCall(this.methodLocator, new TargetHandler.Simple(typeDescription, stackManipulation), this.argumentLoaders, new MethodInvoker.ForVirtualInvocation.Factory(typeDescription), this.terminationHandler, this.assigner, this.typing);
        }

        public MethodCall onArgument(int index) {
            if (index < 0) {
                throw new IllegalArgumentException("An argument index cannot be negative: " + index);
            }
            return new MethodCall(this.methodLocator, new TargetHandler.ForMethodParameter(index), this.argumentLoaders, MethodInvoker.ForVirtualInvocation.WithImplicitType.INSTANCE, this.terminationHandler, this.assigner, this.typing);
        }

        public MethodCall onField(String name) {
            return this.onField(name, FieldLocator.ForClassHierarchy.Factory.INSTANCE);
        }

        public MethodCall onField(String name, FieldLocator.Factory fieldLocatorFactory) {
            return new MethodCall(this.methodLocator, new TargetHandler.ForField.Factory(new TargetHandler.ForField.Location.ForImplicitField(name, fieldLocatorFactory)), this.argumentLoaders, MethodInvoker.ForVirtualInvocation.WithImplicitType.INSTANCE, this.terminationHandler, this.assigner, this.typing);
        }

        public MethodCall onField(Field field) {
            return this.onField(new FieldDescription.ForLoadedField(field));
        }

        public MethodCall onField(FieldDescription fieldDescription) {
            return new MethodCall(this.methodLocator, new TargetHandler.ForField.Factory(new TargetHandler.ForField.Location.ForExplicitField(fieldDescription)), this.argumentLoaders, MethodInvoker.ForVirtualInvocation.WithImplicitType.INSTANCE, this.terminationHandler, this.assigner, this.typing);
        }

        public MethodCall onMethodCall(MethodCall methodCall) {
            return new MethodCall(this.methodLocator, new TargetHandler.ForMethodCall.Factory(methodCall), this.argumentLoaders, MethodInvoker.ForVirtualInvocation.WithImplicitType.INSTANCE, this.terminationHandler, this.assigner, this.typing);
        }

        public MethodCall onSuper() {
            return new MethodCall(this.methodLocator, TargetHandler.ForSelfOrStaticInvocation.Factory.INSTANCE, this.argumentLoaders, MethodInvoker.ForSuperMethodInvocation.Factory.INSTANCE, this.terminationHandler, this.assigner, this.typing);
        }

        public MethodCall onDefault() {
            return new MethodCall(this.methodLocator, TargetHandler.ForSelfOrStaticInvocation.Factory.INSTANCE, this.argumentLoaders, MethodInvoker.ForDefaultMethodInvocation.Factory.INSTANCE, this.terminationHandler, this.assigner, this.typing);
        }
    }
}

