/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.matcher;

import net.bytebuddy.build.HashCodeAndEqualsPlugin;

public interface ElementMatcher<T> {
    public boolean matches(T var1);

    public static interface Junction<S>
    extends ElementMatcher<S> {
        public <U extends S> Junction<U> and(ElementMatcher<? super U> var1);

        public <U extends S> Junction<U> or(ElementMatcher<? super U> var1);

        public static abstract class AbstractBase<V>
        implements Junction<V> {
            @Override
            public <U extends V> Junction<U> and(ElementMatcher<? super U> other) {
                return new Conjunction<U>(this, other);
            }

            @Override
            public <U extends V> Junction<U> or(ElementMatcher<? super U> other) {
                return new Disjunction<U>(this, other);
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class Conjunction<W>
        extends AbstractBase<W> {
            private final ElementMatcher<? super W> left;
            private final ElementMatcher<? super W> right;

            public Conjunction(ElementMatcher<? super W> left, ElementMatcher<? super W> right) {
                this.left = left;
                this.right = right;
            }

            @Override
            public boolean matches(W target) {
                return this.left.matches(target) && this.right.matches(target);
            }

            public String toString() {
                return "(" + this.left + " and " + this.right + ')';
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class Disjunction<W>
        extends AbstractBase<W> {
            private final ElementMatcher<? super W> left;
            private final ElementMatcher<? super W> right;

            public Disjunction(ElementMatcher<? super W> left, ElementMatcher<? super W> right) {
                this.left = left;
                this.right = right;
            }

            @Override
            public boolean matches(W target) {
                return this.left.matches(target) || this.right.matches(target);
            }

            public String toString() {
                return "(" + this.left + " or " + this.right + ')';
            }
        }
    }
}

