/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.matcher;

import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.matcher.ElementMatcher;

@HashCodeAndEqualsPlugin.Enhance
public class MethodSortMatcher<T extends MethodDescription>
extends ElementMatcher.Junction.AbstractBase<T> {
    private final Sort sort;

    public MethodSortMatcher(Sort sort) {
        this.sort = sort;
    }

    @Override
    public boolean matches(T target) {
        return this.sort.isSort((MethodDescription)target);
    }

    public String toString() {
        return this.sort.getDescription();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Sort {
        METHOD("isMethod()"){

            @Override
            protected boolean isSort(MethodDescription target) {
                return target.isMethod();
            }
        }
        ,
        CONSTRUCTOR("isConstructor()"){

            @Override
            protected boolean isSort(MethodDescription target) {
                return target.isConstructor();
            }
        }
        ,
        TYPE_INITIALIZER("isTypeInitializer()"){

            @Override
            protected boolean isSort(MethodDescription target) {
                return target.isTypeInitializer();
            }
        }
        ,
        VIRTUAL("isVirtual()"){

            @Override
            protected boolean isSort(MethodDescription target) {
                return target.isVirtual();
            }
        }
        ,
        DEFAULT_METHOD("isDefaultMethod()"){

            @Override
            protected boolean isSort(MethodDescription target) {
                return target.isDefaultMethod();
            }
        };

        private final String description;

        private Sort(String description) {
            this.description = description;
        }

        protected abstract boolean isSort(MethodDescription var1);

        protected String getDescription() {
            return this.description;
        }
    }
}

