/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.matcher;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.matcher.ElementMatcher;

@HashCodeAndEqualsPlugin.Enhance
public class StringMatcher
extends ElementMatcher.Junction.AbstractBase<String> {
    private final String value;
    private final Mode mode;

    public StringMatcher(String value, Mode mode) {
        this.value = value;
        this.mode = mode;
    }

    @Override
    public boolean matches(String target) {
        return this.mode.matches(this.value, target);
    }

    public String toString() {
        return String.valueOf(this.mode.getDescription()) + '(' + this.value + ')';
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Mode {
        EQUALS_FULLY("equals"){

            @Override
            protected boolean matches(String expected, String actual) {
                return actual.equals(expected);
            }
        }
        ,
        EQUALS_FULLY_IGNORE_CASE("equalsIgnoreCase"){

            @Override
            protected boolean matches(String expected, String actual) {
                return actual.equalsIgnoreCase(expected);
            }
        }
        ,
        STARTS_WITH("startsWith"){

            @Override
            protected boolean matches(String expected, String actual) {
                return actual.startsWith(expected);
            }
        }
        ,
        STARTS_WITH_IGNORE_CASE("startsWithIgnoreCase"){

            @Override
            @SuppressFBWarnings(value={"DM_CONVERT_CASE"}, justification="Both strings are transformed by the default locale")
            protected @SuppressFBWarnings(value={"DM_CONVERT_CASE"}, justification="Both strings are transformed by the default locale") boolean matches(String expected, String actual) {
                return actual.toLowerCase().startsWith(expected.toLowerCase());
            }
        }
        ,
        ENDS_WITH("endsWith"){

            @Override
            protected boolean matches(String expected, String actual) {
                return actual.endsWith(expected);
            }
        }
        ,
        ENDS_WITH_IGNORE_CASE("endsWithIgnoreCase"){

            @Override
            @SuppressFBWarnings(value={"DM_CONVERT_CASE"}, justification="Both strings are transformed by the default locale")
            protected @SuppressFBWarnings(value={"DM_CONVERT_CASE"}, justification="Both strings are transformed by the default locale") boolean matches(String expected, String actual) {
                return actual.toLowerCase().endsWith(expected.toLowerCase());
            }
        }
        ,
        CONTAINS("contains"){

            @Override
            protected boolean matches(String expected, String actual) {
                return actual.contains(expected);
            }
        }
        ,
        CONTAINS_IGNORE_CASE("containsIgnoreCase"){

            @Override
            @SuppressFBWarnings(value={"DM_CONVERT_CASE"}, justification="Both strings are transformed by the default locale")
            protected @SuppressFBWarnings(value={"DM_CONVERT_CASE"}, justification="Both strings are transformed by the default locale") boolean matches(String expected, String actual) {
                return actual.toLowerCase().contains(expected.toLowerCase());
            }
        }
        ,
        MATCHES("matches"){

            @Override
            protected boolean matches(String expected, String actual) {
                return actual.matches(expected);
            }
        };

        private final String description;

        private Mode(String description) {
            this.description = description;
        }

        protected String getDescription() {
            return this.description;
        }

        protected abstract boolean matches(String var1, String var2);
    }
}

