/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.utility;

import java.util.Random;

public class RandomString {
    public static final int DEFAULT_LENGTH = 8;
    private static final char[] SYMBOL;
    private static final int KEY_BITS;
    private final Random random;
    private final int length;

    static {
        StringBuilder symbol = new StringBuilder();
        char character = '0';
        while (character <= '9') {
            symbol.append(character);
            character = (char)(character + '\u0001');
        }
        character = 'a';
        while (character <= 'z') {
            symbol.append(character);
            character = (char)(character + '\u0001');
        }
        character = 'A';
        while (character <= 'Z') {
            symbol.append(character);
            character = (char)(character + '\u0001');
        }
        SYMBOL = symbol.toString().toCharArray();
        int bits = 32 - Integer.numberOfLeadingZeros(SYMBOL.length);
        KEY_BITS = bits - (Integer.bitCount(SYMBOL.length) == bits ? 0 : 1);
    }

    public RandomString() {
        this(8);
    }

    public RandomString(int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("A random string's length cannot be zero or negative");
        }
        this.length = length;
        this.random = new Random();
    }

    public static String make() {
        return RandomString.make(8);
    }

    public static String make(int length) {
        return new RandomString(length).nextString();
    }

    public static String hashOf(int value) {
        char[] buffer = new char[32 / KEY_BITS + (32 % KEY_BITS == 0 ? 0 : 1)];
        int index = 0;
        while (index < buffer.length) {
            buffer[index] = SYMBOL[value >>> index * KEY_BITS & -1 >>> 32 - KEY_BITS];
            ++index;
        }
        return new String(buffer);
    }

    public String nextString() {
        char[] buffer = new char[this.length];
        int index = 0;
        while (index < this.length) {
            buffer[index] = SYMBOL[this.random.nextInt(SYMBOL.length)];
            ++index;
        }
        return new String(buffer);
    }
}

