/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.crypto.engine;

import net.lingala.zip4j.exception.ZipException;

public class AESEngine {
    private int rounds;
    private int[][] workingKey = null;
    private int C0;
    private int C1;
    private int C2;
    private int C3;
    private static final byte[] S;
    private static final int[] rcon;
    private static final int[] T0;

    static {
        byte[] byArray = new byte[256];
        byArray[0] = 99;
        byArray[1] = 124;
        byArray[2] = 119;
        byArray[3] = 123;
        byArray[4] = -14;
        byArray[5] = 107;
        byArray[6] = 111;
        byArray[7] = -59;
        byArray[8] = 48;
        byArray[9] = 1;
        byArray[10] = 103;
        byArray[11] = 43;
        byArray[12] = -2;
        byArray[13] = -41;
        byArray[14] = -85;
        byArray[15] = 118;
        byArray[16] = -54;
        byArray[17] = -126;
        byArray[18] = -55;
        byArray[19] = 125;
        byArray[20] = -6;
        byArray[21] = 89;
        byArray[22] = 71;
        byArray[23] = -16;
        byArray[24] = -83;
        byArray[25] = -44;
        byArray[26] = -94;
        byArray[27] = -81;
        byArray[28] = -100;
        byArray[29] = -92;
        byArray[30] = 114;
        byArray[31] = -64;
        byArray[32] = -73;
        byArray[33] = -3;
        byArray[34] = -109;
        byArray[35] = 38;
        byArray[36] = 54;
        byArray[37] = 63;
        byArray[38] = -9;
        byArray[39] = -52;
        byArray[40] = 52;
        byArray[41] = -91;
        byArray[42] = -27;
        byArray[43] = -15;
        byArray[44] = 113;
        byArray[45] = -40;
        byArray[46] = 49;
        byArray[47] = 21;
        byArray[48] = 4;
        byArray[49] = -57;
        byArray[50] = 35;
        byArray[51] = -61;
        byArray[52] = 24;
        byArray[53] = -106;
        byArray[54] = 5;
        byArray[55] = -102;
        byArray[56] = 7;
        byArray[57] = 18;
        byArray[58] = -128;
        byArray[59] = -30;
        byArray[60] = -21;
        byArray[61] = 39;
        byArray[62] = -78;
        byArray[63] = 117;
        byArray[64] = 9;
        byArray[65] = -125;
        byArray[66] = 44;
        byArray[67] = 26;
        byArray[68] = 27;
        byArray[69] = 110;
        byArray[70] = 90;
        byArray[71] = -96;
        byArray[72] = 82;
        byArray[73] = 59;
        byArray[74] = -42;
        byArray[75] = -77;
        byArray[76] = 41;
        byArray[77] = -29;
        byArray[78] = 47;
        byArray[79] = -124;
        byArray[80] = 83;
        byArray[81] = -47;
        byArray[83] = -19;
        byArray[84] = 32;
        byArray[85] = -4;
        byArray[86] = -79;
        byArray[87] = 91;
        byArray[88] = 106;
        byArray[89] = -53;
        byArray[90] = -66;
        byArray[91] = 57;
        byArray[92] = 74;
        byArray[93] = 76;
        byArray[94] = 88;
        byArray[95] = -49;
        byArray[96] = -48;
        byArray[97] = -17;
        byArray[98] = -86;
        byArray[99] = -5;
        byArray[100] = 67;
        byArray[101] = 77;
        byArray[102] = 51;
        byArray[103] = -123;
        byArray[104] = 69;
        byArray[105] = -7;
        byArray[106] = 2;
        byArray[107] = 127;
        byArray[108] = 80;
        byArray[109] = 60;
        byArray[110] = -97;
        byArray[111] = -88;
        byArray[112] = 81;
        byArray[113] = -93;
        byArray[114] = 64;
        byArray[115] = -113;
        byArray[116] = -110;
        byArray[117] = -99;
        byArray[118] = 56;
        byArray[119] = -11;
        byArray[120] = -68;
        byArray[121] = -74;
        byArray[122] = -38;
        byArray[123] = 33;
        byArray[124] = 16;
        byArray[125] = -1;
        byArray[126] = -13;
        byArray[127] = -46;
        byArray[128] = -51;
        byArray[129] = 12;
        byArray[130] = 19;
        byArray[131] = -20;
        byArray[132] = 95;
        byArray[133] = -105;
        byArray[134] = 68;
        byArray[135] = 23;
        byArray[136] = -60;
        byArray[137] = -89;
        byArray[138] = 126;
        byArray[139] = 61;
        byArray[140] = 100;
        byArray[141] = 93;
        byArray[142] = 25;
        byArray[143] = 115;
        byArray[144] = 96;
        byArray[145] = -127;
        byArray[146] = 79;
        byArray[147] = -36;
        byArray[148] = 34;
        byArray[149] = 42;
        byArray[150] = -112;
        byArray[151] = -120;
        byArray[152] = 70;
        byArray[153] = -18;
        byArray[154] = -72;
        byArray[155] = 20;
        byArray[156] = -34;
        byArray[157] = 94;
        byArray[158] = 11;
        byArray[159] = -37;
        byArray[160] = -32;
        byArray[161] = 50;
        byArray[162] = 58;
        byArray[163] = 10;
        byArray[164] = 73;
        byArray[165] = 6;
        byArray[166] = 36;
        byArray[167] = 92;
        byArray[168] = -62;
        byArray[169] = -45;
        byArray[170] = -84;
        byArray[171] = 98;
        byArray[172] = -111;
        byArray[173] = -107;
        byArray[174] = -28;
        byArray[175] = 121;
        byArray[176] = -25;
        byArray[177] = -56;
        byArray[178] = 55;
        byArray[179] = 109;
        byArray[180] = -115;
        byArray[181] = -43;
        byArray[182] = 78;
        byArray[183] = -87;
        byArray[184] = 108;
        byArray[185] = 86;
        byArray[186] = -12;
        byArray[187] = -22;
        byArray[188] = 101;
        byArray[189] = 122;
        byArray[190] = -82;
        byArray[191] = 8;
        byArray[192] = -70;
        byArray[193] = 120;
        byArray[194] = 37;
        byArray[195] = 46;
        byArray[196] = 28;
        byArray[197] = -90;
        byArray[198] = -76;
        byArray[199] = -58;
        byArray[200] = -24;
        byArray[201] = -35;
        byArray[202] = 116;
        byArray[203] = 31;
        byArray[204] = 75;
        byArray[205] = -67;
        byArray[206] = -117;
        byArray[207] = -118;
        byArray[208] = 112;
        byArray[209] = 62;
        byArray[210] = -75;
        byArray[211] = 102;
        byArray[212] = 72;
        byArray[213] = 3;
        byArray[214] = -10;
        byArray[215] = 14;
        byArray[216] = 97;
        byArray[217] = 53;
        byArray[218] = 87;
        byArray[219] = -71;
        byArray[220] = -122;
        byArray[221] = -63;
        byArray[222] = 29;
        byArray[223] = -98;
        byArray[224] = -31;
        byArray[225] = -8;
        byArray[226] = -104;
        byArray[227] = 17;
        byArray[228] = 105;
        byArray[229] = -39;
        byArray[230] = -114;
        byArray[231] = -108;
        byArray[232] = -101;
        byArray[233] = 30;
        byArray[234] = -121;
        byArray[235] = -23;
        byArray[236] = -50;
        byArray[237] = 85;
        byArray[238] = 40;
        byArray[239] = -33;
        byArray[240] = -116;
        byArray[241] = -95;
        byArray[242] = -119;
        byArray[243] = 13;
        byArray[244] = -65;
        byArray[245] = -26;
        byArray[246] = 66;
        byArray[247] = 104;
        byArray[248] = 65;
        byArray[249] = -103;
        byArray[250] = 45;
        byArray[251] = 15;
        byArray[252] = -80;
        byArray[253] = 84;
        byArray[254] = -69;
        byArray[255] = 22;
        S = byArray;
        rcon = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212, 179, 125, 250, 239, 197, 145};
        int[] nArray = new int[256];
        nArray[0] = -1520213050;
        nArray[1] = -2072216328;
        nArray[2] = -1720223762;
        nArray[3] = -1921287178;
        nArray[4] = 0xDF2F2FF;
        nArray[5] = -1117033514;
        nArray[6] = -1318096930;
        nArray[7] = 1422247313;
        nArray[8] = 1345335392;
        nArray[9] = 50397442;
        nArray[10] = -1452841010;
        nArray[11] = 2099981142;
        nArray[12] = 436141799;
        nArray[13] = 1658312629;
        nArray[14] = -424957107;
        nArray[15] = -1703512340;
        nArray[16] = 1170918031;
        nArray[17] = -1652391393;
        nArray[18] = 1086966153;
        nArray[19] = -2021818886;
        nArray[20] = 368769775;
        nArray[21] = -346465870;
        nArray[22] = -918075506;
        nArray[23] = 0xBF0F0FB;
        nArray[24] = -324162239;
        nArray[25] = 1742001331;
        nArray[26] = -39673249;
        nArray[27] = -357585083;
        nArray[28] = -1080255453;
        nArray[29] = -140204973;
        nArray[30] = -1770884380;
        nArray[31] = 1539358875;
        nArray[32] = -1028147339;
        nArray[33] = 486407649;
        nArray[34] = -1366060227;
        nArray[35] = 1780885068;
        nArray[36] = 1513502316;
        nArray[37] = 1094664062;
        nArray[38] = 49805301;
        nArray[39] = 1338821763;
        nArray[40] = 1546925160;
        nArray[41] = -190470831;
        nArray[42] = 887481809;
        nArray[43] = 150073849;
        nArray[44] = -1821281822;
        nArray[45] = 1943591083;
        nArray[46] = 1395732834;
        nArray[47] = 1058346282;
        nArray[48] = 201589768;
        nArray[49] = 1388824469;
        nArray[50] = 1696801606;
        nArray[51] = 1589887901;
        nArray[52] = 672667696;
        nArray[53] = -1583966665;
        nArray[54] = 251987210;
        nArray[55] = -1248159185;
        nArray[56] = 151455502;
        nArray[57] = 907153956;
        nArray[58] = -1686077413;
        nArray[59] = 1038279391;
        nArray[60] = 652995533;
        nArray[61] = 1764173646;
        nArray[62] = -843926913;
        nArray[63] = -1619692054;
        nArray[64] = 453576978;
        nArray[65] = -1635548387;
        nArray[66] = 1949051992;
        nArray[67] = 773462580;
        nArray[68] = 756751158;
        nArray[69] = -1301385508;
        nArray[70] = -296068428;
        nArray[71] = -73359269;
        nArray[72] = -162377052;
        nArray[73] = 1295727478;
        nArray[74] = 1641469623;
        nArray[75] = -827083907;
        nArray[76] = 2066295122;
        nArray[77] = 0x3EE3E3DD;
        nArray[78] = 1898917726;
        nArray[79] = -1752923117;
        nArray[80] = -179088474;
        nArray[81] = 1758581177;
        nArray[83] = 753790401;
        nArray[84] = 1612718144;
        nArray[85] = 536673507;
        nArray[86] = -927878791;
        nArray[87] = -312779850;
        nArray[88] = -1100322092;
        nArray[89] = 1187761037;
        nArray[90] = -641810841;
        nArray[91] = 1262041458;
        nArray[92] = -565556588;
        nArray[93] = -733197160;
        nArray[94] = -396863312;
        nArray[95] = 1255133061;
        nArray[96] = 1808847035;
        nArray[97] = 720367557;
        nArray[98] = -441800113;
        nArray[99] = 385612781;
        nArray[100] = -985447546;
        nArray[101] = -682799718;
        nArray[102] = 0x55333366;
        nArray[103] = -1803188975;
        nArray[104] = -817543798;
        nArray[105] = 284817897;
        nArray[106] = 100794884;
        nArray[107] = -2122350594;
        nArray[108] = -263171936;
        nArray[109] = 1144798328;
        nArray[110] = -1163944155;
        nArray[111] = -475486133;
        nArray[112] = -212774494;
        nArray[113] = -22830243;
        nArray[114] = -1069531008;
        nArray[115] = -1970303227;
        nArray[116] = -1382903233;
        nArray[117] = -1130521311;
        nArray[118] = 1211644016;
        nArray[119] = 83228145;
        nArray[120] = -541279133;
        nArray[121] = -1044990345;
        nArray[122] = 1977277103;
        nArray[123] = 1663115586;
        nArray[124] = 806359072;
        nArray[125] = 452984805;
        nArray[126] = 250868733;
        nArray[127] = 1842533055;
        nArray[128] = 1288555905;
        nArray[129] = 336333848;
        nArray[130] = 890442534;
        nArray[131] = 804056259;
        nArray[132] = -513843266;
        nArray[133] = -1567123659;
        nArray[134] = -867941240;
        nArray[135] = 957814574;
        nArray[136] = 1472513171;
        nArray[137] = -223893675;
        nArray[138] = -2105639172;
        nArray[139] = 1195195770;
        nArray[140] = -1402706744;
        nArray[141] = -413311558;
        nArray[142] = 723065138;
        nArray[143] = -1787595802;
        nArray[144] = -1604296512;
        nArray[145] = -1736343271;
        nArray[146] = -783331426;
        nArray[147] = 2145180835;
        nArray[148] = 0x66222244;
        nArray[149] = 2116692564;
        nArray[150] = -1416589253;
        nArray[151] = -2088204277;
        nArray[152] = -901364084;
        nArray[153] = 703524551;
        nArray[154] = -742868885;
        nArray[155] = 1007948840;
        nArray[156] = 2044649127;
        nArray[157] = -497131844;
        nArray[158] = 487262998;
        nArray[159] = 1994120109;
        nArray[160] = 1004593371;
        nArray[161] = 1446130276;
        nArray[162] = 1312438900;
        nArray[163] = 503974420;
        nArray[164] = -615954030;
        nArray[165] = 168166924;
        nArray[166] = 1814307912;
        nArray[167] = -463709000;
        nArray[168] = 1573044895;
        nArray[169] = 1859376061;
        nArray[170] = -273896381;
        nArray[171] = -1503501628;
        nArray[172] = -1466855111;
        nArray[173] = -1533700815;
        nArray[174] = 937747667;
        nArray[175] = -1954973198;
        nArray[176] = 854058965;
        nArray[177] = 1137232011;
        nArray[178] = 1496790894;
        nArray[179] = -1217565222;
        nArray[180] = -1936880383;
        nArray[181] = 1691735473;
        nArray[182] = -766620004;
        nArray[183] = -525751991;
        nArray[184] = -1267962664;
        nArray[185] = -95005012;
        nArray[186] = 133494003;
        nArray[187] = 636152527;
        nArray[188] = -1352309302;
        nArray[189] = -1904575756;
        nArray[190] = -374428089;
        nArray[191] = 0x18080810;
        nArray[192] = -709182865;
        nArray[193] = -2005370640;
        nArray[194] = 1864705354;
        nArray[195] = 1915629148;
        nArray[196] = 605822008;
        nArray[197] = -240736681;
        nArray[198] = -944458637;
        nArray[199] = 1371981463;
        nArray[200] = 602466507;
        nArray[201] = 2094914977;
        nArray[202] = -1670089496;
        nArray[203] = 555687742;
        nArray[204] = -582268010;
        nArray[205] = -591544991;
        nArray[206] = -2037675251;
        nArray[207] = -2054518257;
        nArray[208] = -1871679264;
        nArray[209] = 1111375484;
        nArray[210] = -994724495;
        nArray[211] = -1436129588;
        nArray[212] = -666351472;
        nArray[213] = 84083462;
        nArray[214] = 32962295;
        nArray[215] = 302911004;
        nArray[216] = -1553899070;
        nArray[217] = 1597322602;
        nArray[218] = -111716434;
        nArray[219] = -793134743;
        nArray[220] = -1853454825;
        nArray[221] = 1489093017;
        nArray[222] = 656219450;
        nArray[223] = -1180787161;
        nArray[224] = 954327513;
        nArray[225] = 335083755;
        nArray[226] = -1281845205;
        nArray[227] = 0x33111122;
        nArray[228] = -1150719534;
        nArray[229] = 1893325225;
        nArray[230] = -1987146233;
        nArray[231] = -1483434957;
        nArray[232] = -1231316179;
        nArray[233] = 572399164;
        nArray[234] = -1836611819;
        nArray[235] = 552200649;
        nArray[236] = 1238290055;
        nArray[237] = -11184726;
        nArray[238] = 2015897680;
        nArray[239] = 2061492133;
        nArray[240] = -1886614525;
        nArray[241] = -123625127;
        nArray[242] = -2138470135;
        nArray[243] = 386731290;
        nArray[244] = -624967835;
        nArray[245] = 837215959;
        nArray[246] = -968736124;
        nArray[247] = -1201116976;
        nArray[248] = -1019133566;
        nArray[249] = -1332111063;
        nArray[250] = 1999449434;
        nArray[251] = 286199582;
        nArray[252] = -877612933;
        nArray[253] = -61582168;
        nArray[254] = -692339859;
        nArray[255] = 974525996;
        T0 = nArray;
    }

    public AESEngine(byte[] key) throws ZipException {
        this.init(key);
    }

    private void init(byte[] key) throws ZipException {
        this.workingKey = this.generateWorkingKey(key);
    }

    private int[][] generateWorkingKey(byte[] key) throws ZipException {
        int kc = key.length / 4;
        if (kc != 4 && kc != 6 && kc != 8 || kc * 4 != key.length) {
            throw new ZipException("invalid key length (not 128/192/256)");
        }
        this.rounds = kc + 6;
        int[][] W = new int[this.rounds + 1][4];
        int t = 0;
        int i = 0;
        while (i < key.length) {
            W[t >> 2][t & 3] = key[i] & 0xFF | (key[i + 1] & 0xFF) << 8 | (key[i + 2] & 0xFF) << 16 | key[i + 3] << 24;
            i += 4;
            ++t;
        }
        int k = this.rounds + 1 << 2;
        i = kc;
        while (i < k) {
            int temp = W[i - 1 >> 2][i - 1 & 3];
            if (i % kc == 0) {
                temp = this.subWord(this.shift(temp, 8)) ^ rcon[i / kc - 1];
            } else if (kc > 6 && i % kc == 4) {
                temp = this.subWord(temp);
            }
            W[i >> 2][i & 3] = W[i - kc >> 2][i - kc & 3] ^ temp;
            ++i;
        }
        return W;
    }

    public int processBlock(byte[] in, byte[] out) throws ZipException {
        return this.processBlock(in, 0, out, 0);
    }

    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws ZipException {
        if (this.workingKey == null) {
            throw new ZipException("AES engine not initialised");
        }
        if (inOff + 16 > in.length) {
            throw new ZipException("input buffer too short");
        }
        if (outOff + 16 > out.length) {
            throw new ZipException("output buffer too short");
        }
        this.stateIn(in, inOff);
        this.encryptBlock(this.workingKey);
        this.stateOut(out, outOff);
        return 16;
    }

    private void stateIn(byte[] bytes, int off) {
        int index = off;
        this.C0 = bytes[index++] & 0xFF;
        this.C0 |= (bytes[index++] & 0xFF) << 8;
        this.C0 |= (bytes[index++] & 0xFF) << 16;
        this.C0 |= bytes[index++] << 24;
        this.C1 = bytes[index++] & 0xFF;
        this.C1 |= (bytes[index++] & 0xFF) << 8;
        this.C1 |= (bytes[index++] & 0xFF) << 16;
        this.C1 |= bytes[index++] << 24;
        this.C2 = bytes[index++] & 0xFF;
        this.C2 |= (bytes[index++] & 0xFF) << 8;
        this.C2 |= (bytes[index++] & 0xFF) << 16;
        this.C2 |= bytes[index++] << 24;
        this.C3 = bytes[index++] & 0xFF;
        this.C3 |= (bytes[index++] & 0xFF) << 8;
        this.C3 |= (bytes[index++] & 0xFF) << 16;
        this.C3 |= bytes[index++] << 24;
    }

    private void stateOut(byte[] bytes, int off) {
        int index = off;
        bytes[index++] = (byte)this.C0;
        bytes[index++] = (byte)(this.C0 >> 8);
        bytes[index++] = (byte)(this.C0 >> 16);
        bytes[index++] = (byte)(this.C0 >> 24);
        bytes[index++] = (byte)this.C1;
        bytes[index++] = (byte)(this.C1 >> 8);
        bytes[index++] = (byte)(this.C1 >> 16);
        bytes[index++] = (byte)(this.C1 >> 24);
        bytes[index++] = (byte)this.C2;
        bytes[index++] = (byte)(this.C2 >> 8);
        bytes[index++] = (byte)(this.C2 >> 16);
        bytes[index++] = (byte)(this.C2 >> 24);
        bytes[index++] = (byte)this.C3;
        bytes[index++] = (byte)(this.C3 >> 8);
        bytes[index++] = (byte)(this.C3 >> 16);
        bytes[index++] = (byte)(this.C3 >> 24);
    }

    private void encryptBlock(int[][] KW) {
        int r3;
        int r2;
        int r1;
        int r0;
        this.C0 ^= KW[0][0];
        this.C1 ^= KW[0][1];
        this.C2 ^= KW[0][2];
        this.C3 ^= KW[0][3];
        int r = 1;
        while (r < this.rounds - 1) {
            r0 = T0[this.C0 & 0xFF] ^ this.shift(T0[this.C1 >> 8 & 0xFF], 24) ^ this.shift(T0[this.C2 >> 16 & 0xFF], 16) ^ this.shift(T0[this.C3 >> 24 & 0xFF], 8) ^ KW[r][0];
            r1 = T0[this.C1 & 0xFF] ^ this.shift(T0[this.C2 >> 8 & 0xFF], 24) ^ this.shift(T0[this.C3 >> 16 & 0xFF], 16) ^ this.shift(T0[this.C0 >> 24 & 0xFF], 8) ^ KW[r][1];
            r2 = T0[this.C2 & 0xFF] ^ this.shift(T0[this.C3 >> 8 & 0xFF], 24) ^ this.shift(T0[this.C0 >> 16 & 0xFF], 16) ^ this.shift(T0[this.C1 >> 24 & 0xFF], 8) ^ KW[r][2];
            r3 = T0[this.C3 & 0xFF] ^ this.shift(T0[this.C0 >> 8 & 0xFF], 24) ^ this.shift(T0[this.C1 >> 16 & 0xFF], 16) ^ this.shift(T0[this.C2 >> 24 & 0xFF], 8) ^ KW[r++][3];
            this.C0 = T0[r0 & 0xFF] ^ this.shift(T0[r1 >> 8 & 0xFF], 24) ^ this.shift(T0[r2 >> 16 & 0xFF], 16) ^ this.shift(T0[r3 >> 24 & 0xFF], 8) ^ KW[r][0];
            this.C1 = T0[r1 & 0xFF] ^ this.shift(T0[r2 >> 8 & 0xFF], 24) ^ this.shift(T0[r3 >> 16 & 0xFF], 16) ^ this.shift(T0[r0 >> 24 & 0xFF], 8) ^ KW[r][1];
            this.C2 = T0[r2 & 0xFF] ^ this.shift(T0[r3 >> 8 & 0xFF], 24) ^ this.shift(T0[r0 >> 16 & 0xFF], 16) ^ this.shift(T0[r1 >> 24 & 0xFF], 8) ^ KW[r][2];
            this.C3 = T0[r3 & 0xFF] ^ this.shift(T0[r0 >> 8 & 0xFF], 24) ^ this.shift(T0[r1 >> 16 & 0xFF], 16) ^ this.shift(T0[r2 >> 24 & 0xFF], 8) ^ KW[r++][3];
        }
        r0 = T0[this.C0 & 0xFF] ^ this.shift(T0[this.C1 >> 8 & 0xFF], 24) ^ this.shift(T0[this.C2 >> 16 & 0xFF], 16) ^ this.shift(T0[this.C3 >> 24 & 0xFF], 8) ^ KW[r][0];
        r1 = T0[this.C1 & 0xFF] ^ this.shift(T0[this.C2 >> 8 & 0xFF], 24) ^ this.shift(T0[this.C3 >> 16 & 0xFF], 16) ^ this.shift(T0[this.C0 >> 24 & 0xFF], 8) ^ KW[r][1];
        r2 = T0[this.C2 & 0xFF] ^ this.shift(T0[this.C3 >> 8 & 0xFF], 24) ^ this.shift(T0[this.C0 >> 16 & 0xFF], 16) ^ this.shift(T0[this.C1 >> 24 & 0xFF], 8) ^ KW[r][2];
        r3 = T0[this.C3 & 0xFF] ^ this.shift(T0[this.C0 >> 8 & 0xFF], 24) ^ this.shift(T0[this.C1 >> 16 & 0xFF], 16) ^ this.shift(T0[this.C2 >> 24 & 0xFF], 8) ^ KW[r++][3];
        this.C0 = S[r0 & 0xFF] & 0xFF ^ (S[r1 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[r2 >> 16 & 0xFF] & 0xFF) << 16 ^ S[r3 >> 24 & 0xFF] << 24 ^ KW[r][0];
        this.C1 = S[r1 & 0xFF] & 0xFF ^ (S[r2 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[r3 >> 16 & 0xFF] & 0xFF) << 16 ^ S[r0 >> 24 & 0xFF] << 24 ^ KW[r][1];
        this.C2 = S[r2 & 0xFF] & 0xFF ^ (S[r3 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[r0 >> 16 & 0xFF] & 0xFF) << 16 ^ S[r1 >> 24 & 0xFF] << 24 ^ KW[r][2];
        this.C3 = S[r3 & 0xFF] & 0xFF ^ (S[r0 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[r1 >> 16 & 0xFF] & 0xFF) << 16 ^ S[r2 >> 24 & 0xFF] << 24 ^ KW[r][3];
    }

    private int shift(int r, int shift) {
        return r >>> shift | r << -shift;
    }

    private int subWord(int x) {
        return S[x & 0xFF] & 0xFF | (S[x >> 8 & 0xFF] & 0xFF) << 8 | (S[x >> 16 & 0xFF] & 0xFF) << 16 | S[x >> 24 & 0xFF] << 24;
    }
}

