/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io.inputstream;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import net.lingala.zip4j.io.inputstream.SplitInputStream;

public class ZipStandardSplitInputStream
extends SplitInputStream {
    private int lastSplitZipFileNumber;

    public ZipStandardSplitInputStream(File zipFile, boolean isSplitZipArchive, int lastSplitZipFileNumber) throws FileNotFoundException {
        super(zipFile, isSplitZipArchive, lastSplitZipFileNumber);
        this.lastSplitZipFileNumber = lastSplitZipFileNumber;
    }

    @Override
    protected File getNextSplitFile(int zipFileIndex) throws IOException {
        if (zipFileIndex == this.lastSplitZipFileNumber) {
            return this.zipFile;
        }
        String currZipFileNameWithPath = this.zipFile.getCanonicalPath();
        String extensionSubString = ".z0";
        if (zipFileIndex >= 9) {
            extensionSubString = ".z";
        }
        return new File(String.valueOf(currZipFileNameWithPath.substring(0, currZipFileNameWithPath.lastIndexOf("."))) + extensionSubString + (zipFileIndex + 1));
    }
}

