/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.progress.ProgressMonitor;

public class CrcUtil {
    private static final int BUF_SIZE = 16384;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long computeFileCrc(File inputFile, ProgressMonitor progressMonitor) throws IOException {
        if (inputFile == null) throw new ZipException("input file is null or does not exist or cannot read. Cannot calculate CRC for the file");
        if (!inputFile.exists()) throw new ZipException("input file is null or does not exist or cannot read. Cannot calculate CRC for the file");
        if (!inputFile.canRead()) {
            throw new ZipException("input file is null or does not exist or cannot read. Cannot calculate CRC for the file");
        }
        byte[] buff = new byte[16384];
        CRC32 crc32 = new CRC32();
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileInputStream inputStream = new FileInputStream(inputFile);){
            while (true) {
                int readLen;
                if ((readLen = ((InputStream)inputStream).read(buff)) == -1) {
                    return crc32.getValue();
                }
                crc32.update(buff, 0, readLen);
                if (progressMonitor == null) continue;
                progressMonitor.updateWorkCompleted(readLen);
                if (progressMonitor.isCancelAllTasks()) break;
            }
            progressMonitor.setResult(ProgressMonitor.Result.CANCELLED);
            progressMonitor.setState(ProgressMonitor.State.READY);
            return 0L;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }
}

