/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.misc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.antlr.v4.runtime.misc.IntegerList;
import org.antlr.v4.runtime.misc.IntervalSet;

public class Utils {
    public static <T> String join(Iterator<T> iter, String separator) {
        StringBuilder buf = new StringBuilder();
        while (iter.hasNext()) {
            buf.append(iter.next());
            if (!iter.hasNext()) continue;
            buf.append(separator);
        }
        return buf.toString();
    }

    public static <T> String join(T[] array, String separator) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < array.length) {
            builder.append(array[i]);
            if (i < array.length - 1) {
                builder.append(separator);
            }
            ++i;
        }
        return builder.toString();
    }

    public static int numNonnull(Object[] data) {
        int n = 0;
        if (data == null) {
            return n;
        }
        Object[] objectArray = data;
        int n2 = data.length;
        int n3 = 0;
        while (n3 < n2) {
            Object o = objectArray[n3];
            if (o != null) {
                ++n;
            }
            ++n3;
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    public static <T> void removeAllElements(Collection<T> data, T value) {
        if (data != null) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            data.remove(value);
lbl5:
            // 2 sources

            ** while (data.contains(value))
        }
lbl6:
        // 1 sources

    }

    public static String escapeWhitespace(String s, boolean escapeSpaces) {
        StringBuilder buf = new StringBuilder();
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == ' ' && escapeSpaces) {
                buf.append('\u00b7');
            } else if (c == '\t') {
                buf.append("\\t");
            } else if (c == '\n') {
                buf.append("\\n");
            } else if (c == '\r') {
                buf.append("\\r");
            } else {
                buf.append(c);
            }
            ++n2;
        }
        return buf.toString();
    }

    public static void writeFile(String fileName, String content) throws IOException {
        Utils.writeFile(fileName, content, null);
    }

    public static void writeFile(String fileName, String content, String encoding) throws IOException {
        File f = new File(fileName);
        FileOutputStream fos = new FileOutputStream(f);
        try (OutputStreamWriter osw = encoding != null ? new OutputStreamWriter((OutputStream)fos, encoding) : new OutputStreamWriter(fos);){
            osw.write(content);
        }
    }

    public static char[] readFile(String fileName) throws IOException {
        return Utils.readFile(fileName, null);
    }

    public static char[] readFile(String fileName, String encoding) throws IOException {
        File f = new File(fileName);
        int size = (int)f.length();
        FileInputStream fis = new FileInputStream(fileName);
        char[] data = null;
        try (InputStreamReader isr = encoding != null ? new InputStreamReader((InputStream)fis, encoding) : new InputStreamReader(fis);){
            data = new char[size];
            int n = isr.read(data);
            if (n < data.length) {
                data = Arrays.copyOf(data, n);
            }
        }
        return data;
    }

    public static Map<String, Integer> toMap(String[] keys) {
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        int i = 0;
        while (i < keys.length) {
            m.put(keys[i], i);
            ++i;
        }
        return m;
    }

    public static char[] toCharArray(IntegerList data) {
        if (data == null) {
            return null;
        }
        return data.toCharArray();
    }

    public static IntervalSet toSet(BitSet bits) {
        IntervalSet s = new IntervalSet(new int[0]);
        int i = bits.nextSetBit(0);
        while (i >= 0) {
            s.add(i);
            i = bits.nextSetBit(i + 1);
        }
        return s;
    }

    public static String expandTabs(String s, int tabSize) {
        if (s == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        int col = 0;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '\n': {
                    col = 0;
                    buf.append(c);
                    break;
                }
                case '\t': {
                    int n = tabSize - col % tabSize;
                    col += n;
                    buf.append(Utils.spaces(n));
                    break;
                }
                default: {
                    ++col;
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static String spaces(int n) {
        return Utils.sequence(n, " ");
    }

    public static String newlines(int n) {
        return Utils.sequence(n, "\n");
    }

    public static String sequence(int n, String s) {
        StringBuilder buf = new StringBuilder();
        int sp = 1;
        while (sp <= n) {
            buf.append(s);
            ++sp;
        }
        return buf.toString();
    }

    public static int count(String s, char x) {
        int n = 0;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == x) {
                ++n;
            }
            ++i;
        }
        return n;
    }
}

