/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.MethodUtils;

class BeanIntrospectionData {
    private final PropertyDescriptor[] descriptors;
    private final Map<String, String> writeMethodNames;

    public BeanIntrospectionData(PropertyDescriptor[] descs) {
        this(descs, BeanIntrospectionData.setUpWriteMethodNames(descs));
    }

    BeanIntrospectionData(PropertyDescriptor[] descs, Map<String, String> writeMethNames) {
        this.descriptors = descs;
        this.writeMethodNames = writeMethNames;
    }

    public PropertyDescriptor[] getDescriptors() {
        return this.descriptors;
    }

    public PropertyDescriptor getDescriptor(String name) {
        PropertyDescriptor[] propertyDescriptorArray = this.getDescriptors();
        int n = propertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor pd = propertyDescriptorArray[n2];
            if (name.equals(pd.getName())) {
                return pd;
            }
            ++n2;
        }
        return null;
    }

    public Method getWriteMethod(Class<?> beanCls, PropertyDescriptor desc) {
        String methodName;
        Method method = desc.getWriteMethod();
        if (method == null && (methodName = this.writeMethodNames.get(desc.getName())) != null && (method = MethodUtils.getAccessibleMethod(beanCls, methodName, desc.getPropertyType())) != null) {
            try {
                desc.setWriteMethod(method);
            }
            catch (IntrospectionException introspectionException) {}
        }
        return method;
    }

    private static Map<String, String> setUpWriteMethodNames(PropertyDescriptor[] descs) {
        HashMap<String, String> methods = new HashMap<String, String>();
        PropertyDescriptor[] propertyDescriptorArray = descs;
        int n = descs.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor pd = propertyDescriptorArray[n2];
            Method method = pd.getWriteMethod();
            if (method != null) {
                methods.put(pd.getName(), method.getName());
            }
            ++n2;
        }
        return methods;
    }
}

