/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import org.apache.commons.beanutils.converters.AbstractConverter;

public final class BooleanConverter
extends AbstractConverter {
    @Deprecated
    public static final Object NO_DEFAULT = new Object();
    private String[] trueStrings = new String[]{"true", "yes", "y", "on", "1"};
    private String[] falseStrings = new String[]{"false", "no", "n", "off", "0"};

    public BooleanConverter() {
    }

    public BooleanConverter(Object defaultValue) {
        if (defaultValue != NO_DEFAULT) {
            this.setDefaultValue(defaultValue);
        }
    }

    public BooleanConverter(String[] trueStrings, String[] falseStrings) {
        this.trueStrings = BooleanConverter.copyStrings(trueStrings);
        this.falseStrings = BooleanConverter.copyStrings(falseStrings);
    }

    public BooleanConverter(String[] trueStrings, String[] falseStrings, Object defaultValue) {
        this.trueStrings = BooleanConverter.copyStrings(trueStrings);
        this.falseStrings = BooleanConverter.copyStrings(falseStrings);
        if (defaultValue != NO_DEFAULT) {
            this.setDefaultValue(defaultValue);
        }
    }

    protected Class<Boolean> getDefaultType() {
        return Boolean.class;
    }

    @Override
    protected <T> T convertToType(Class<T> type, Object value) throws Throwable {
        if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
            String stringValue = value.toString().toLowerCase();
            String[] stringArray = this.trueStrings;
            int n = this.trueStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String trueString = stringArray[n2];
                if (trueString.equals(stringValue)) {
                    return type.cast(Boolean.TRUE);
                }
                ++n2;
            }
            stringArray = this.falseStrings;
            n = this.falseStrings.length;
            n2 = 0;
            while (n2 < n) {
                String falseString = stringArray[n2];
                if (falseString.equals(stringValue)) {
                    return type.cast(Boolean.FALSE);
                }
                ++n2;
            }
        }
        throw this.conversionException(type, value);
    }

    private static String[] copyStrings(String[] src) {
        String[] dst = new String[src.length];
        int i = 0;
        while (i < src.length) {
            dst[i] = src[i].toLowerCase();
            ++i;
        }
        return dst;
    }
}

