/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.AbstractMultivariateRealDistribution;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.NonPositiveDefiniteMatrixException;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;

public class MultivariateNormalDistribution
extends AbstractMultivariateRealDistribution {
    private final double[] means;
    private final RealMatrix covarianceMatrix;
    private final RealMatrix covarianceMatrixInverse;
    private final double covarianceMatrixDeterminant;
    private final RealMatrix samplingMatrix;

    public MultivariateNormalDistribution(double[] means, double[][] covariances) throws SingularMatrixException, DimensionMismatchException, NonPositiveDefiniteMatrixException {
        this(new Well19937c(), means, covariances);
    }

    public MultivariateNormalDistribution(RandomGenerator rng, double[] means, double[][] covariances) throws SingularMatrixException, DimensionMismatchException, NonPositiveDefiniteMatrixException {
        super(rng, means.length);
        int dim = means.length;
        if (covariances.length != dim) {
            throw new DimensionMismatchException(covariances.length, dim);
        }
        int i = 0;
        while (i < dim) {
            if (dim != covariances[i].length) {
                throw new DimensionMismatchException(covariances[i].length, dim);
            }
            ++i;
        }
        this.means = MathArrays.copyOf(means);
        this.covarianceMatrix = new Array2DRowRealMatrix(covariances);
        EigenDecomposition covMatDec = new EigenDecomposition(this.covarianceMatrix);
        this.covarianceMatrixInverse = covMatDec.getSolver().getInverse();
        this.covarianceMatrixDeterminant = covMatDec.getDeterminant();
        double[] covMatEigenvalues = covMatDec.getRealEigenvalues();
        int i2 = 0;
        while (i2 < covMatEigenvalues.length) {
            if (covMatEigenvalues[i2] < 0.0) {
                throw new NonPositiveDefiniteMatrixException(covMatEigenvalues[i2], i2, 0.0);
            }
            ++i2;
        }
        Array2DRowRealMatrix covMatEigenvectors = new Array2DRowRealMatrix(dim, dim);
        int v = 0;
        while (v < dim) {
            double[] evec = covMatDec.getEigenvector(v).toArray();
            covMatEigenvectors.setColumn(v, evec);
            ++v;
        }
        RealMatrix tmpMatrix = covMatEigenvectors.transpose();
        int row = 0;
        while (row < dim) {
            double factor = FastMath.sqrt(covMatEigenvalues[row]);
            int col = 0;
            while (col < dim) {
                tmpMatrix.multiplyEntry(row, col, factor);
                ++col;
            }
            ++row;
        }
        this.samplingMatrix = covMatEigenvectors.multiply(tmpMatrix);
    }

    public double[] getMeans() {
        return MathArrays.copyOf(this.means);
    }

    public RealMatrix getCovariances() {
        return this.covarianceMatrix.copy();
    }

    @Override
    public double density(double[] vals) throws DimensionMismatchException {
        int dim = this.getDimension();
        if (vals.length != dim) {
            throw new DimensionMismatchException(vals.length, dim);
        }
        return FastMath.pow(Math.PI * 2, -0.5 * (double)dim) * FastMath.pow(this.covarianceMatrixDeterminant, -0.5) * this.getExponentTerm(vals);
    }

    public double[] getStandardDeviations() {
        int dim = this.getDimension();
        double[] std = new double[dim];
        double[][] s = this.covarianceMatrix.getData();
        int i = 0;
        while (i < dim) {
            std[i] = FastMath.sqrt(s[i][i]);
            ++i;
        }
        return std;
    }

    @Override
    public double[] sample() {
        int dim = this.getDimension();
        double[] normalVals = new double[dim];
        int i = 0;
        while (i < dim) {
            normalVals[i] = this.random.nextGaussian();
            ++i;
        }
        double[] vals = this.samplingMatrix.operate(normalVals);
        int i2 = 0;
        while (i2 < dim) {
            int n = i2;
            vals[n] = vals[n] + this.means[i2];
            ++i2;
        }
        return vals;
    }

    private double getExponentTerm(double[] values) {
        double[] centered = new double[values.length];
        int i = 0;
        while (i < centered.length) {
            centered[i] = values[i] - this.getMeans()[i];
            ++i;
        }
        double[] preMultiplied = this.covarianceMatrixInverse.preMultiply(centered);
        double sum = 0.0;
        int i2 = 0;
        while (i2 < preMultiplied.length) {
            sum += preMultiplied[i2] * centered[i2];
            ++i2;
        }
        return FastMath.exp(-0.5 * sum);
    }
}

