/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.util.FastMath;

class BiDiagonalTransformer {
    private final double[][] householderVectors;
    private final double[] main;
    private final double[] secondary;
    private RealMatrix cachedU;
    private RealMatrix cachedB;
    private RealMatrix cachedV;

    BiDiagonalTransformer(RealMatrix matrix) {
        int m = matrix.getRowDimension();
        int n = matrix.getColumnDimension();
        int p = FastMath.min(m, n);
        this.householderVectors = matrix.getData();
        this.main = new double[p];
        this.secondary = new double[p - 1];
        this.cachedU = null;
        this.cachedB = null;
        this.cachedV = null;
        if (m >= n) {
            this.transformToUpperBiDiagonal();
        } else {
            this.transformToLowerBiDiagonal();
        }
    }

    public RealMatrix getU() {
        if (this.cachedU == null) {
            int m = this.householderVectors.length;
            int n = this.householderVectors[0].length;
            int p = this.main.length;
            int diagOffset = m >= n ? 0 : 1;
            double[] diagonal = m >= n ? this.main : this.secondary;
            double[][] ua = new double[m][m];
            int k = m - 1;
            while (k >= p) {
                ua[k][k] = 1.0;
                --k;
            }
            k = p - 1;
            while (k >= diagOffset) {
                double[] hK = this.householderVectors[k];
                ua[k][k] = 1.0;
                if (hK[k - diagOffset] != 0.0) {
                    int j = k;
                    while (j < m) {
                        double alpha = 0.0;
                        int i = k;
                        while (i < m) {
                            alpha -= ua[i][j] * this.householderVectors[i][k - diagOffset];
                            ++i;
                        }
                        alpha /= diagonal[k - diagOffset] * hK[k - diagOffset];
                        i = k;
                        while (i < m) {
                            double[] dArray = ua[i];
                            int n2 = j;
                            dArray[n2] = dArray[n2] + -alpha * this.householderVectors[i][k - diagOffset];
                            ++i;
                        }
                        ++j;
                    }
                }
                --k;
            }
            if (diagOffset > 0) {
                ua[0][0] = 1.0;
            }
            this.cachedU = MatrixUtils.createRealMatrix(ua);
        }
        return this.cachedU;
    }

    public RealMatrix getB() {
        if (this.cachedB == null) {
            int m = this.householderVectors.length;
            int n = this.householderVectors[0].length;
            double[][] ba = new double[m][n];
            int i = 0;
            while (i < this.main.length) {
                ba[i][i] = this.main[i];
                if (m < n) {
                    if (i > 0) {
                        ba[i][i - 1] = this.secondary[i - 1];
                    }
                } else if (i < this.main.length - 1) {
                    ba[i][i + 1] = this.secondary[i];
                }
                ++i;
            }
            this.cachedB = MatrixUtils.createRealMatrix(ba);
        }
        return this.cachedB;
    }

    public RealMatrix getV() {
        if (this.cachedV == null) {
            int m = this.householderVectors.length;
            int n = this.householderVectors[0].length;
            int p = this.main.length;
            int diagOffset = m >= n ? 1 : 0;
            double[] diagonal = m >= n ? this.secondary : this.main;
            double[][] va = new double[n][n];
            int k = n - 1;
            while (k >= p) {
                va[k][k] = 1.0;
                --k;
            }
            k = p - 1;
            while (k >= diagOffset) {
                double[] hK = this.householderVectors[k - diagOffset];
                va[k][k] = 1.0;
                if (hK[k] != 0.0) {
                    int j = k;
                    while (j < n) {
                        double beta = 0.0;
                        int i = k;
                        while (i < n) {
                            beta -= va[i][j] * hK[i];
                            ++i;
                        }
                        beta /= diagonal[k - diagOffset] * hK[k];
                        i = k;
                        while (i < n) {
                            double[] dArray = va[i];
                            int n2 = j;
                            dArray[n2] = dArray[n2] + -beta * hK[i];
                            ++i;
                        }
                        ++j;
                    }
                }
                --k;
            }
            if (diagOffset > 0) {
                va[0][0] = 1.0;
            }
            this.cachedV = MatrixUtils.createRealMatrix(va);
        }
        return this.cachedV;
    }

    double[][] getHouseholderVectorsRef() {
        return this.householderVectors;
    }

    double[] getMainDiagonalRef() {
        return this.main;
    }

    double[] getSecondaryDiagonalRef() {
        return this.secondary;
    }

    boolean isUpperBiDiagonal() {
        return this.householderVectors.length >= this.householderVectors[0].length;
    }

    private void transformToUpperBiDiagonal() {
        int m = this.householderVectors.length;
        int n = this.householderVectors[0].length;
        int k = 0;
        while (k < n) {
            int j;
            double a;
            double xNormSqr = 0.0;
            int i = k;
            while (i < m) {
                double c = this.householderVectors[i][k];
                xNormSqr += c * c;
                ++i;
            }
            double[] hK = this.householderVectors[k];
            this.main[k] = a = hK[k] > 0.0 ? -FastMath.sqrt(xNormSqr) : FastMath.sqrt(xNormSqr);
            if (a != 0.0) {
                int n2 = k;
                hK[n2] = hK[n2] - a;
                j = k + 1;
                while (j < n) {
                    double[] hI;
                    double alpha = 0.0;
                    int i2 = k;
                    while (i2 < m) {
                        hI = this.householderVectors[i2];
                        alpha -= hI[j] * hI[k];
                        ++i2;
                    }
                    alpha /= a * this.householderVectors[k][k];
                    i2 = k;
                    while (i2 < m) {
                        hI = this.householderVectors[i2];
                        int n3 = j;
                        hI[n3] = hI[n3] - alpha * hI[k];
                        ++i2;
                    }
                    ++j;
                }
            }
            if (k < n - 1) {
                double b;
                xNormSqr = 0.0;
                j = k + 1;
                while (j < n) {
                    double c = hK[j];
                    xNormSqr += c * c;
                    ++j;
                }
                this.secondary[k] = b = hK[k + 1] > 0.0 ? -FastMath.sqrt(xNormSqr) : FastMath.sqrt(xNormSqr);
                if (b != 0.0) {
                    int n4 = k + 1;
                    hK[n4] = hK[n4] - b;
                    int i3 = k + 1;
                    while (i3 < m) {
                        double[] hI = this.householderVectors[i3];
                        double beta = 0.0;
                        int j2 = k + 1;
                        while (j2 < n) {
                            beta -= hI[j2] * hK[j2];
                            ++j2;
                        }
                        beta /= b * hK[k + 1];
                        j2 = k + 1;
                        while (j2 < n) {
                            int n5 = j2;
                            hI[n5] = hI[n5] - beta * hK[j2];
                            ++j2;
                        }
                        ++i3;
                    }
                }
            }
            ++k;
        }
    }

    private void transformToLowerBiDiagonal() {
        int m = this.householderVectors.length;
        int n = this.householderVectors[0].length;
        int k = 0;
        while (k < m) {
            double a;
            double[] hK = this.householderVectors[k];
            double xNormSqr = 0.0;
            int j = k;
            while (j < n) {
                double c = hK[j];
                xNormSqr += c * c;
                ++j;
            }
            this.main[k] = a = hK[k] > 0.0 ? -FastMath.sqrt(xNormSqr) : FastMath.sqrt(xNormSqr);
            if (a != 0.0) {
                int n2 = k;
                hK[n2] = hK[n2] - a;
                int i = k + 1;
                while (i < m) {
                    double[] hI = this.householderVectors[i];
                    double alpha = 0.0;
                    int j2 = k;
                    while (j2 < n) {
                        alpha -= hI[j2] * hK[j2];
                        ++j2;
                    }
                    alpha /= a * this.householderVectors[k][k];
                    j2 = k;
                    while (j2 < n) {
                        int n3 = j2;
                        hI[n3] = hI[n3] - alpha * hK[j2];
                        ++j2;
                    }
                    ++i;
                }
            }
            if (k < m - 1) {
                double b;
                double[] hKp1 = this.householderVectors[k + 1];
                xNormSqr = 0.0;
                int i = k + 1;
                while (i < m) {
                    double c = this.householderVectors[i][k];
                    xNormSqr += c * c;
                    ++i;
                }
                this.secondary[k] = b = hKp1[k] > 0.0 ? -FastMath.sqrt(xNormSqr) : FastMath.sqrt(xNormSqr);
                if (b != 0.0) {
                    int n4 = k;
                    hKp1[n4] = hKp1[n4] - b;
                    int j3 = k + 1;
                    while (j3 < n) {
                        double[] hI;
                        double beta = 0.0;
                        int i2 = k + 1;
                        while (i2 < m) {
                            hI = this.householderVectors[i2];
                            beta -= hI[j3] * hI[k];
                            ++i2;
                        }
                        beta /= b * hKp1[k];
                        i2 = k + 1;
                        while (i2 < m) {
                            hI = this.householderVectors[i2];
                            int n5 = j3;
                            hI[n5] = hI[n5] - beta * hI[k];
                            ++i2;
                        }
                        ++j3;
                    }
                }
            }
            ++k;
        }
    }
}

