/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.MathUnsupportedOperationException;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SchurTransformer;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.apache.commons.math3.linear.TriDiagonalTransformer;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;

public class EigenDecomposition {
    private static final double EPSILON = 1.0E-12;
    private byte maxIter = (byte)30;
    private double[] main;
    private double[] secondary;
    private TriDiagonalTransformer transformer;
    private double[] realEigenvalues;
    private double[] imagEigenvalues;
    private ArrayRealVector[] eigenvectors;
    private RealMatrix cachedV;
    private RealMatrix cachedD;
    private RealMatrix cachedVt;
    private final boolean isSymmetric;

    public EigenDecomposition(RealMatrix matrix) throws MathArithmeticException {
        double symTol = (double)(10 * matrix.getRowDimension() * matrix.getColumnDimension()) * Precision.EPSILON;
        this.isSymmetric = MatrixUtils.isSymmetric(matrix, symTol);
        if (this.isSymmetric) {
            this.transformToTridiagonal(matrix);
            this.findEigenVectors(this.transformer.getQ().getData());
        } else {
            SchurTransformer t = this.transformToSchur(matrix);
            this.findEigenVectorsFromSchur(t);
        }
    }

    @Deprecated
    public EigenDecomposition(RealMatrix matrix, double splitTolerance) throws MathArithmeticException {
        this(matrix);
    }

    public EigenDecomposition(double[] main, double[] secondary) {
        this.isSymmetric = true;
        this.main = (double[])main.clone();
        this.secondary = (double[])secondary.clone();
        this.transformer = null;
        int size = main.length;
        double[][] z = new double[size][size];
        int i = 0;
        while (i < size) {
            z[i][i] = 1.0;
            ++i;
        }
        this.findEigenVectors(z);
    }

    @Deprecated
    public EigenDecomposition(double[] main, double[] secondary, double splitTolerance) {
        this(main, secondary);
    }

    public RealMatrix getV() {
        if (this.cachedV == null) {
            int m = this.eigenvectors.length;
            this.cachedV = MatrixUtils.createRealMatrix(m, m);
            int k = 0;
            while (k < m) {
                this.cachedV.setColumnVector(k, this.eigenvectors[k]);
                ++k;
            }
        }
        return this.cachedV;
    }

    public RealMatrix getD() {
        if (this.cachedD == null) {
            this.cachedD = MatrixUtils.createRealDiagonalMatrix(this.realEigenvalues);
            int i = 0;
            while (i < this.imagEigenvalues.length) {
                if (Precision.compareTo(this.imagEigenvalues[i], 0.0, 1.0E-12) > 0) {
                    this.cachedD.setEntry(i, i + 1, this.imagEigenvalues[i]);
                } else if (Precision.compareTo(this.imagEigenvalues[i], 0.0, 1.0E-12) < 0) {
                    this.cachedD.setEntry(i, i - 1, this.imagEigenvalues[i]);
                }
                ++i;
            }
        }
        return this.cachedD;
    }

    public RealMatrix getVT() {
        if (this.cachedVt == null) {
            int m = this.eigenvectors.length;
            this.cachedVt = MatrixUtils.createRealMatrix(m, m);
            int k = 0;
            while (k < m) {
                this.cachedVt.setRowVector(k, this.eigenvectors[k]);
                ++k;
            }
        }
        return this.cachedVt;
    }

    public boolean hasComplexEigenvalues() {
        int i = 0;
        while (i < this.imagEigenvalues.length) {
            if (!Precision.equals(this.imagEigenvalues[i], 0.0, 1.0E-12)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public double[] getRealEigenvalues() {
        return (double[])this.realEigenvalues.clone();
    }

    public double getRealEigenvalue(int i) {
        return this.realEigenvalues[i];
    }

    public double[] getImagEigenvalues() {
        return (double[])this.imagEigenvalues.clone();
    }

    public double getImagEigenvalue(int i) {
        return this.imagEigenvalues[i];
    }

    public RealVector getEigenvector(int i) {
        return this.eigenvectors[i].copy();
    }

    public double getDeterminant() {
        double determinant = 1.0;
        double[] dArray = this.realEigenvalues;
        int n = this.realEigenvalues.length;
        int n2 = 0;
        while (n2 < n) {
            double lambda = dArray[n2];
            determinant *= lambda;
            ++n2;
        }
        return determinant;
    }

    public RealMatrix getSquareRoot() {
        if (!this.isSymmetric) {
            throw new MathUnsupportedOperationException();
        }
        double[] sqrtEigenValues = new double[this.realEigenvalues.length];
        int i = 0;
        while (i < this.realEigenvalues.length) {
            double eigen = this.realEigenvalues[i];
            if (eigen <= 0.0) {
                throw new MathUnsupportedOperationException();
            }
            sqrtEigenValues[i] = FastMath.sqrt(eigen);
            ++i;
        }
        RealMatrix sqrtEigen = MatrixUtils.createRealDiagonalMatrix(sqrtEigenValues);
        RealMatrix v = this.getV();
        RealMatrix vT = this.getVT();
        return v.multiply(sqrtEigen).multiply(vT);
    }

    public DecompositionSolver getSolver() {
        if (this.hasComplexEigenvalues()) {
            throw new MathUnsupportedOperationException();
        }
        return new Solver(this.realEigenvalues, this.imagEigenvalues, this.eigenvectors);
    }

    private void transformToTridiagonal(RealMatrix matrix) {
        this.transformer = new TriDiagonalTransformer(matrix);
        this.main = this.transformer.getMainDiagonalRef();
        this.secondary = this.transformer.getSecondaryDiagonalRef();
    }

    private void findEigenVectors(double[][] householderMatrix) {
        double[][] z = (double[][])householderMatrix.clone();
        int n = this.main.length;
        this.realEigenvalues = new double[n];
        this.imagEigenvalues = new double[n];
        double[] e = new double[n];
        int i = 0;
        while (i < n - 1) {
            this.realEigenvalues[i] = this.main[i];
            e[i] = this.secondary[i];
            ++i;
        }
        this.realEigenvalues[n - 1] = this.main[n - 1];
        e[n - 1] = 0.0;
        double maxAbsoluteValue = 0.0;
        int i2 = 0;
        while (i2 < n) {
            if (FastMath.abs(this.realEigenvalues[i2]) > maxAbsoluteValue) {
                maxAbsoluteValue = FastMath.abs(this.realEigenvalues[i2]);
            }
            if (FastMath.abs(e[i2]) > maxAbsoluteValue) {
                maxAbsoluteValue = FastMath.abs(e[i2]);
            }
            ++i2;
        }
        if (maxAbsoluteValue != 0.0) {
            i2 = 0;
            while (i2 < n) {
                if (FastMath.abs(this.realEigenvalues[i2]) <= Precision.EPSILON * maxAbsoluteValue) {
                    this.realEigenvalues[i2] = 0.0;
                }
                if (FastMath.abs(e[i2]) <= Precision.EPSILON * maxAbsoluteValue) {
                    e[i2] = 0.0;
                }
                ++i2;
            }
        }
        int j = 0;
        while (j < n) {
            int m;
            int its = 0;
            do {
                m = j;
                while (m < n - 1) {
                    double delta = FastMath.abs(this.realEigenvalues[m]) + FastMath.abs(this.realEigenvalues[m + 1]);
                    if (FastMath.abs(e[m]) + delta == delta) break;
                    ++m;
                }
                if (m == j) continue;
                if (its == this.maxIter) {
                    throw new MaxCountExceededException((Localizable)LocalizedFormats.CONVERGENCE_FAILED, this.maxIter, new Object[0]);
                }
                ++its;
                double q = (this.realEigenvalues[j + 1] - this.realEigenvalues[j]) / (2.0 * e[j]);
                double t = FastMath.sqrt(1.0 + q * q);
                q = q < 0.0 ? this.realEigenvalues[m] - this.realEigenvalues[j] + e[j] / (q - t) : this.realEigenvalues[m] - this.realEigenvalues[j] + e[j] / (q + t);
                double u = 0.0;
                double s = 1.0;
                double c = 1.0;
                int i3 = m - 1;
                while (i3 >= j) {
                    double p = s * e[i3];
                    double h = c * e[i3];
                    if (FastMath.abs(p) >= FastMath.abs(q)) {
                        c = q / p;
                        t = FastMath.sqrt(c * c + 1.0);
                        e[i3 + 1] = p * t;
                        s = 1.0 / t;
                        c *= s;
                    } else {
                        s = p / q;
                        t = FastMath.sqrt(s * s + 1.0);
                        e[i3 + 1] = q * t;
                        c = 1.0 / t;
                        s *= c;
                    }
                    if (e[i3 + 1] == 0.0) {
                        int n2 = i3 + 1;
                        this.realEigenvalues[n2] = this.realEigenvalues[n2] - u;
                        e[m] = 0.0;
                        break;
                    }
                    q = this.realEigenvalues[i3 + 1] - u;
                    t = (this.realEigenvalues[i3] - q) * s + 2.0 * c * h;
                    u = s * t;
                    this.realEigenvalues[i3 + 1] = q + u;
                    q = c * t - h;
                    int ia = 0;
                    while (ia < n) {
                        p = z[ia][i3 + 1];
                        z[ia][i3 + 1] = s * z[ia][i3] + c * p;
                        z[ia][i3] = c * z[ia][i3] - s * p;
                        ++ia;
                    }
                    --i3;
                }
                if (t == 0.0 && i3 >= j) continue;
                int n3 = j;
                this.realEigenvalues[n3] = this.realEigenvalues[n3] - u;
                e[j] = q;
                e[m] = 0.0;
            } while (m != j);
            ++j;
        }
        i2 = 0;
        while (i2 < n) {
            int k = i2;
            double p = this.realEigenvalues[i2];
            int j2 = i2 + 1;
            while (j2 < n) {
                if (this.realEigenvalues[j2] > p) {
                    k = j2;
                    p = this.realEigenvalues[j2];
                }
                ++j2;
            }
            if (k != i2) {
                this.realEigenvalues[k] = this.realEigenvalues[i2];
                this.realEigenvalues[i2] = p;
                j2 = 0;
                while (j2 < n) {
                    p = z[j2][i2];
                    z[j2][i2] = z[j2][k];
                    z[j2][k] = p;
                    ++j2;
                }
            }
            ++i2;
        }
        maxAbsoluteValue = 0.0;
        i2 = 0;
        while (i2 < n) {
            if (FastMath.abs(this.realEigenvalues[i2]) > maxAbsoluteValue) {
                maxAbsoluteValue = FastMath.abs(this.realEigenvalues[i2]);
            }
            ++i2;
        }
        if (maxAbsoluteValue != 0.0) {
            i2 = 0;
            while (i2 < n) {
                if (FastMath.abs(this.realEigenvalues[i2]) < Precision.EPSILON * maxAbsoluteValue) {
                    this.realEigenvalues[i2] = 0.0;
                }
                ++i2;
            }
        }
        this.eigenvectors = new ArrayRealVector[n];
        double[] tmp = new double[n];
        int i4 = 0;
        while (i4 < n) {
            int j3 = 0;
            while (j3 < n) {
                tmp[j3] = z[j3][i4];
                ++j3;
            }
            this.eigenvectors[i4] = new ArrayRealVector(tmp);
            ++i4;
        }
    }

    private SchurTransformer transformToSchur(RealMatrix matrix) {
        SchurTransformer schurTransform = new SchurTransformer(matrix);
        double[][] matT = schurTransform.getT().getData();
        this.realEigenvalues = new double[matT.length];
        this.imagEigenvalues = new double[matT.length];
        int i = 0;
        while (i < this.realEigenvalues.length) {
            if (i == this.realEigenvalues.length - 1 || Precision.equals(matT[i + 1][i], 0.0, 1.0E-12)) {
                this.realEigenvalues[i] = matT[i][i];
            } else {
                double x = matT[i + 1][i + 1];
                double p = 0.5 * (matT[i][i] - x);
                double z = FastMath.sqrt(FastMath.abs(p * p + matT[i + 1][i] * matT[i][i + 1]));
                this.realEigenvalues[i] = x + p;
                this.imagEigenvalues[i] = z;
                this.realEigenvalues[i + 1] = x + p;
                this.imagEigenvalues[i + 1] = -z;
                ++i;
            }
            ++i;
        }
        return schurTransform;
    }

    private Complex cdiv(double xr, double xi, double yr, double yi) {
        return new Complex(xr, xi).divide(new Complex(yr, yi));
    }

    private void findEigenVectorsFromSchur(SchurTransformer schur) throws MathArithmeticException {
        double[][] matrixT = schur.getT().getData();
        double[][] matrixP = schur.getP().getData();
        int n = matrixT.length;
        double norm = 0.0;
        int i = 0;
        while (i < n) {
            int j = FastMath.max(i - 1, 0);
            while (j < n) {
                norm += FastMath.abs(matrixT[i][j]);
                ++j;
            }
            ++i;
        }
        if (Precision.equals(norm, 0.0, 1.0E-12)) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_NORM, new Object[0]);
        }
        double r = 0.0;
        double s = 0.0;
        double z = 0.0;
        int idx = n - 1;
        while (idx >= 0) {
            double p = this.realEigenvalues[idx];
            double q = this.imagEigenvalues[idx];
            if (Precision.equals(q, 0.0)) {
                l = idx;
                matrixT[idx][idx] = 1.0;
                i = idx - 1;
                while (i >= 0) {
                    double w = matrixT[i][i] - p;
                    r = 0.0;
                    int j = l;
                    while (j <= idx) {
                        r += matrixT[i][j] * matrixT[j][idx];
                        ++j;
                    }
                    if (Precision.compareTo(this.imagEigenvalues[i], 0.0, 1.0E-12) < 0) {
                        z = w;
                        s = r;
                    } else {
                        l = i;
                        if (Precision.equals(this.imagEigenvalues[i], 0.0)) {
                            matrixT[i][idx] = w != 0.0 ? -r / w : -r / (Precision.EPSILON * norm);
                        } else {
                            double x = matrixT[i][i + 1];
                            double y = matrixT[i + 1][i];
                            q = (this.realEigenvalues[i] - p) * (this.realEigenvalues[i] - p) + this.imagEigenvalues[i] * this.imagEigenvalues[i];
                            matrixT[i][idx] = t = (x * s - z * r) / q;
                            matrixT[i + 1][idx] = FastMath.abs(x) > FastMath.abs(z) ? (-r - w * t) / x : (-s - y * t) / z;
                        }
                        double t = FastMath.abs(matrixT[i][idx]);
                        if (Precision.EPSILON * t * t > 1.0) {
                            int j2 = i;
                            while (j2 <= idx) {
                                double[] dArray = matrixT[j2];
                                int n2 = idx;
                                dArray[n2] = dArray[n2] / t;
                                ++j2;
                            }
                        }
                    }
                    --i;
                }
            } else if (q < 0.0) {
                l = idx - 1;
                if (FastMath.abs(matrixT[idx][idx - 1]) > FastMath.abs(matrixT[idx - 1][idx])) {
                    matrixT[idx - 1][idx - 1] = q / matrixT[idx][idx - 1];
                    matrixT[idx - 1][idx] = -(matrixT[idx][idx] - p) / matrixT[idx][idx - 1];
                } else {
                    Complex result = this.cdiv(0.0, -matrixT[idx - 1][idx], matrixT[idx - 1][idx - 1] - p, q);
                    matrixT[idx - 1][idx - 1] = result.getReal();
                    matrixT[idx - 1][idx] = result.getImaginary();
                }
                matrixT[idx][idx - 1] = 0.0;
                matrixT[idx][idx] = 1.0;
                i = idx - 2;
                while (i >= 0) {
                    double ra = 0.0;
                    double sa = 0.0;
                    int j = l;
                    while (j <= idx) {
                        ra += matrixT[i][j] * matrixT[j][idx - 1];
                        sa += matrixT[i][j] * matrixT[j][idx];
                        ++j;
                    }
                    double w = matrixT[i][i] - p;
                    if (Precision.compareTo(this.imagEigenvalues[i], 0.0, 1.0E-12) < 0) {
                        z = w;
                        r = ra;
                        s = sa;
                    } else {
                        l = i;
                        if (Precision.equals(this.imagEigenvalues[i], 0.0)) {
                            Complex c = this.cdiv(-ra, -sa, w, q);
                            matrixT[i][idx - 1] = c.getReal();
                            matrixT[i][idx] = c.getImaginary();
                        } else {
                            double x = matrixT[i][i + 1];
                            double y = matrixT[i + 1][i];
                            double vr = (this.realEigenvalues[i] - p) * (this.realEigenvalues[i] - p) + this.imagEigenvalues[i] * this.imagEigenvalues[i] - q * q;
                            double vi = (this.realEigenvalues[i] - p) * 2.0 * q;
                            if (Precision.equals(vr, 0.0) && Precision.equals(vi, 0.0)) {
                                vr = Precision.EPSILON * norm * (FastMath.abs(w) + FastMath.abs(q) + FastMath.abs(x) + FastMath.abs(y) + FastMath.abs(z));
                            }
                            Complex c = this.cdiv(x * r - z * ra + q * sa, x * s - z * sa - q * ra, vr, vi);
                            matrixT[i][idx - 1] = c.getReal();
                            matrixT[i][idx] = c.getImaginary();
                            if (FastMath.abs(x) > FastMath.abs(z) + FastMath.abs(q)) {
                                matrixT[i + 1][idx - 1] = (-ra - w * matrixT[i][idx - 1] + q * matrixT[i][idx]) / x;
                                matrixT[i + 1][idx] = (-sa - w * matrixT[i][idx] - q * matrixT[i][idx - 1]) / x;
                            } else {
                                Complex c2 = this.cdiv(-r - y * matrixT[i][idx - 1], -s - y * matrixT[i][idx], z, q);
                                matrixT[i + 1][idx - 1] = c2.getReal();
                                matrixT[i + 1][idx] = c2.getImaginary();
                            }
                        }
                        t = FastMath.max(FastMath.abs(matrixT[i][idx - 1]), FastMath.abs(matrixT[i][idx]));
                        if (Precision.EPSILON * t * t > 1.0) {
                            int j3 = i;
                            while (j3 <= idx) {
                                double[] dArray = matrixT[j3];
                                int n3 = idx - 1;
                                dArray[n3] = dArray[n3] / t;
                                double[] dArray2 = matrixT[j3];
                                int n4 = idx;
                                dArray2[n4] = dArray2[n4] / t;
                                ++j3;
                            }
                        }
                    }
                    --i;
                }
            }
            --idx;
        }
        int j = n - 1;
        while (j >= 0) {
            int i2 = 0;
            while (i2 <= n - 1) {
                z = 0.0;
                int k = 0;
                while (k <= FastMath.min(j, n - 1)) {
                    z += matrixP[i2][k] * matrixT[k][j];
                    ++k;
                }
                matrixP[i2][j] = z;
                ++i2;
            }
            --j;
        }
        this.eigenvectors = new ArrayRealVector[n];
        double[] tmp = new double[n];
        int i3 = 0;
        while (i3 < n) {
            int j4 = 0;
            while (j4 < n) {
                tmp[j4] = matrixP[j4][i3];
                ++j4;
            }
            this.eigenvectors[i3] = new ArrayRealVector(tmp);
            ++i3;
        }
    }

    private static class Solver
    implements DecompositionSolver {
        private double[] realEigenvalues;
        private double[] imagEigenvalues;
        private final ArrayRealVector[] eigenvectors;

        private Solver(double[] realEigenvalues, double[] imagEigenvalues, ArrayRealVector[] eigenvectors) {
            this.realEigenvalues = realEigenvalues;
            this.imagEigenvalues = imagEigenvalues;
            this.eigenvectors = eigenvectors;
        }

        @Override
        public RealVector solve(RealVector b) {
            if (!this.isNonSingular()) {
                throw new SingularMatrixException();
            }
            int m = this.realEigenvalues.length;
            if (b.getDimension() != m) {
                throw new DimensionMismatchException(b.getDimension(), m);
            }
            double[] bp = new double[m];
            int i = 0;
            while (i < m) {
                ArrayRealVector v = this.eigenvectors[i];
                double[] vData = v.getDataRef();
                double s = v.dotProduct(b) / this.realEigenvalues[i];
                int j = 0;
                while (j < m) {
                    int n = j;
                    bp[n] = bp[n] + s * vData[j];
                    ++j;
                }
                ++i;
            }
            return new ArrayRealVector(bp, false);
        }

        @Override
        public RealMatrix solve(RealMatrix b) {
            if (!this.isNonSingular()) {
                throw new SingularMatrixException();
            }
            int m = this.realEigenvalues.length;
            if (b.getRowDimension() != m) {
                throw new DimensionMismatchException(b.getRowDimension(), m);
            }
            int nColB = b.getColumnDimension();
            double[][] bp = new double[m][nColB];
            double[] tmpCol = new double[m];
            int k = 0;
            while (k < nColB) {
                int i = 0;
                while (i < m) {
                    tmpCol[i] = b.getEntry(i, k);
                    bp[i][k] = 0.0;
                    ++i;
                }
                i = 0;
                while (i < m) {
                    ArrayRealVector v = this.eigenvectors[i];
                    double[] vData = v.getDataRef();
                    double s = 0.0;
                    int j = 0;
                    while (j < m) {
                        s += v.getEntry(j) * tmpCol[j];
                        ++j;
                    }
                    s /= this.realEigenvalues[i];
                    j = 0;
                    while (j < m) {
                        double[] dArray = bp[j];
                        int n = k;
                        dArray[n] = dArray[n] + s * vData[j];
                        ++j;
                    }
                    ++i;
                }
                ++k;
            }
            return new Array2DRowRealMatrix(bp, false);
        }

        @Override
        public boolean isNonSingular() {
            double largestEigenvalueNorm = 0.0;
            int i = 0;
            while (i < this.realEigenvalues.length) {
                largestEigenvalueNorm = FastMath.max(largestEigenvalueNorm, this.eigenvalueNorm(i));
                ++i;
            }
            if (largestEigenvalueNorm == 0.0) {
                return false;
            }
            i = 0;
            while (i < this.realEigenvalues.length) {
                if (Precision.equals(this.eigenvalueNorm(i) / largestEigenvalueNorm, 0.0, 1.0E-12)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private double eigenvalueNorm(int i) {
            double re = this.realEigenvalues[i];
            double im = this.imagEigenvalues[i];
            return FastMath.sqrt(re * re + im * im);
        }

        @Override
        public RealMatrix getInverse() {
            if (!this.isNonSingular()) {
                throw new SingularMatrixException();
            }
            int m = this.realEigenvalues.length;
            double[][] invData = new double[m][m];
            int i = 0;
            while (i < m) {
                double[] invI = invData[i];
                int j = 0;
                while (j < m) {
                    double invIJ = 0.0;
                    int k = 0;
                    while (k < m) {
                        double[] vK = this.eigenvectors[k].getDataRef();
                        invIJ += vK[i] * vK[j] / this.realEigenvalues[k];
                        ++k;
                    }
                    invI[j] = invIJ;
                    ++j;
                }
                ++i;
            }
            return MatrixUtils.createRealMatrix(invData);
        }
    }
}

