/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.Field;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.linear.Array2DRowFieldMatrix;
import org.apache.commons.math3.linear.ArrayFieldVector;
import org.apache.commons.math3.linear.FieldDecompositionSolver;
import org.apache.commons.math3.linear.FieldLUDecomposition;
import org.apache.commons.math3.linear.FieldMatrix;
import org.apache.commons.math3.util.MathArrays;

public class AdamsNordsieckFieldTransformer<T extends RealFieldElement<T>> {
    private static final Map<Integer, Map<Field<? extends RealFieldElement<?>>, AdamsNordsieckFieldTransformer<? extends RealFieldElement<?>>>> CACHE = new HashMap();
    private final Field<T> field;
    private final Array2DRowFieldMatrix<T> update;
    private final T[] c1;

    private AdamsNordsieckFieldTransformer(Field<T> field, int n) {
        this.field = field;
        int rows = n - 1;
        FieldMatrix<T> bigP = this.buildP(rows);
        FieldDecompositionSolver<T> pSolver = new FieldLUDecomposition<T>(bigP).getSolver();
        Object[] u = (RealFieldElement[])MathArrays.buildArray(field, rows);
        Arrays.fill(u, field.getOne());
        this.c1 = (RealFieldElement[])pSolver.solve(new ArrayFieldVector((FieldElement[])u, false)).toArray();
        FieldElement[][] shiftedP = (RealFieldElement[][])bigP.getData();
        int i = shiftedP.length - 1;
        while (i > 0) {
            shiftedP[i] = shiftedP[i - 1];
            --i;
        }
        shiftedP[0] = (RealFieldElement[])MathArrays.buildArray(field, rows);
        Arrays.fill(shiftedP[0], field.getZero());
        this.update = new Array2DRowFieldMatrix((FieldElement[][])((RealFieldElement[][])pSolver.solve(new Array2DRowFieldMatrix(shiftedP, false)).getData()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends RealFieldElement<T>> AdamsNordsieckFieldTransformer<T> getInstance(Field<T> field, int nSteps) {
        Map<Integer, Map<Field<? extends RealFieldElement<?>>, AdamsNordsieckFieldTransformer<? extends RealFieldElement<?>>>> map = CACHE;
        synchronized (map) {
            AdamsNordsieckFieldTransformer<RealFieldElement<Object>> t;
            Map<Field<RealFieldElement<?>>, AdamsNordsieckFieldTransformer<RealFieldElement<?>>> map2 = CACHE.get(nSteps);
            if (map2 == null) {
                map2 = new HashMap();
                CACHE.put(nSteps, map2);
            }
            if ((t = map2.get(field)) == null) {
                t = new AdamsNordsieckFieldTransformer<T>(field, nSteps);
                map2.put(field, t);
            }
            return t;
        }
    }

    private FieldMatrix<T> buildP(int rows) {
        FieldElement[][] pData = (RealFieldElement[][])MathArrays.buildArray(this.field, rows, rows);
        int i = 1;
        while (i <= pData.length) {
            FieldElement[] pI = pData[i - 1];
            int factor = -i;
            RealFieldElement aj = (RealFieldElement)((RealFieldElement)this.field.getZero()).add(factor);
            int j = 1;
            while (j <= pI.length) {
                pI[j - 1] = (RealFieldElement)aj.multiply(j + 1);
                aj = (RealFieldElement)aj.multiply(factor);
                ++j;
            }
            ++i;
        }
        return new Array2DRowFieldMatrix(pData, false);
    }

    public Array2DRowFieldMatrix<T> initializeHighOrderDerivatives(T h, T[] t, T[][] y, T[][] yDot) {
        FieldElement[][] a = (RealFieldElement[][])MathArrays.buildArray(this.field, this.c1.length + 1, this.c1.length + 1);
        FieldElement[][] b = (RealFieldElement[][])MathArrays.buildArray(this.field, this.c1.length + 1, y[0].length);
        T[] y0 = y[0];
        T[] yDot0 = yDot[0];
        int i = 1;
        while (i < y.length) {
            RealFieldElement di = (RealFieldElement)t[i].subtract(t[0]);
            RealFieldElement ratio = (RealFieldElement)di.divide(h);
            RealFieldElement dikM1Ohk = (RealFieldElement)h.reciprocal();
            FieldElement[] aI = a[2 * i - 2];
            FieldElement[] aDotI = 2 * i - 1 < a.length ? a[2 * i - 1] : null;
            int j = 0;
            while (j < aI.length) {
                dikM1Ohk = dikM1Ohk.multiply(ratio);
                aI[j] = di.multiply(dikM1Ohk);
                if (aDotI != null) {
                    aDotI[j] = (RealFieldElement)dikM1Ohk.multiply(j + 2);
                }
                ++j;
            }
            T[] yI = y[i];
            T[] yDotI = yDot[i];
            FieldElement[] bI = b[2 * i - 2];
            FieldElement[] bDotI = 2 * i - 1 < b.length ? b[2 * i - 1] : null;
            int j2 = 0;
            while (j2 < yI.length) {
                bI[j2] = ((RealFieldElement)yI[j2].subtract(y0[j2])).subtract((RealFieldElement)di.multiply(yDot0[j2]));
                if (bDotI != null) {
                    bDotI[j2] = (RealFieldElement)yDotI[j2].subtract(yDot0[j2]);
                }
                ++j2;
            }
            ++i;
        }
        FieldLUDecomposition decomposition = new FieldLUDecomposition(new Array2DRowFieldMatrix(a, false));
        FieldMatrix x = decomposition.getSolver().solve(new Array2DRowFieldMatrix(b, false));
        Array2DRowFieldMatrix<RealFieldElement> truncatedX = new Array2DRowFieldMatrix<RealFieldElement>(this.field, x.getRowDimension() - 1, x.getColumnDimension());
        int i2 = 0;
        while (i2 < truncatedX.getRowDimension()) {
            int j = 0;
            while (j < truncatedX.getColumnDimension()) {
                truncatedX.setEntry(i2, j, (RealFieldElement)x.getEntry(i2, j));
                ++j;
            }
            ++i2;
        }
        return truncatedX;
    }

    public Array2DRowFieldMatrix<T> updateHighOrderDerivativesPhase1(Array2DRowFieldMatrix<T> highOrder) {
        return this.update.multiply(highOrder);
    }

    public void updateHighOrderDerivativesPhase2(T[] start, T[] end, Array2DRowFieldMatrix<T> highOrder) {
        RealFieldElement[][] data = (RealFieldElement[][])highOrder.getDataRef();
        int i = 0;
        while (i < data.length) {
            RealFieldElement[] dataI = data[i];
            RealFieldElement c1I = this.c1[i];
            int j = 0;
            while (j < dataI.length) {
                dataI[j] = dataI[j].add(c1I.multiply((RealFieldElement)((RealFieldElement)start[j].subtract(end[j]))));
                ++j;
            }
            ++i;
        }
    }
}

