/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.transaction.locking;

import java.util.Map;
import org.apache.commons.transaction.locking.GenericLock;
import org.apache.commons.transaction.locking.GenericLockManager;
import org.apache.commons.transaction.locking.LockException;
import org.apache.commons.transaction.locking.ReadWriteLock;
import org.apache.commons.transaction.util.LoggerFacade;

public class ReadWriteLockManager
extends GenericLockManager {
    public ReadWriteLockManager(LoggerFacade logger, long timeoutMSecs) {
        super(2, logger, timeoutMSecs);
    }

    protected ReadWriteLockManager(int maxLockLevel, LoggerFacade logger, long timeoutMSecs) throws IllegalArgumentException {
        super(maxLockLevel, logger, timeoutMSecs);
    }

    public boolean tryReadLock(Object ownerId, Object resourceId) {
        return this.tryLock(ownerId, resourceId, 1, true);
    }

    public boolean tryWriteLock(Object ownerId, Object resourceId) {
        return this.tryLock(ownerId, resourceId, 2, true);
    }

    public boolean checkReadLock(Object ownerId, Object resourceId) {
        return this.checkLock(ownerId, resourceId, 1, true);
    }

    public boolean hasWriteLock(Object ownerId, Object resourceId) {
        return this.hasLock(ownerId, resourceId, 2);
    }

    public boolean hasReadLock(Object ownerId, Object resourceId) {
        return this.hasLock(ownerId, resourceId, 1);
    }

    public boolean checkWriteLock(Object ownerId, Object resourceId) {
        return this.checkLock(ownerId, resourceId, 2, true);
    }

    public void readLock(Object ownerId, Object resourceId) throws LockException {
        this.lock(ownerId, resourceId, 1, 1, false, this.globalTimeoutMSecs);
    }

    public void writeLock(Object ownerId, Object resourceId) throws LockException {
        this.lock(ownerId, resourceId, 2, 1, true, this.globalTimeoutMSecs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected GenericLock createLock(Object resourceId) {
        Map map = this.globalLocks;
        synchronized (map) {
            ReadWriteLock lock = new ReadWriteLock(resourceId, this.logger);
            this.globalLocks.put(resourceId, lock);
            return lock;
        }
    }
}

