/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.transaction.util;

import java.io.PrintWriter;
import org.apache.commons.transaction.util.LoggerFacade;

public class PrintWriterLogger
implements LoggerFacade {
    protected PrintWriter printWriter;
    protected String name;
    protected boolean debug;

    public PrintWriterLogger(PrintWriter printWriter, String name, boolean debug) {
        this.printWriter = printWriter;
        this.name = name;
        this.debug = debug;
    }

    @Override
    public LoggerFacade createLogger(String newName) {
        return new PrintWriterLogger(this.printWriter, newName, this.debug);
    }

    @Override
    public void logInfo(String message) {
        this.log("INFO", message);
    }

    @Override
    public void logFine(String message) {
        if (this.debug) {
            this.log("FINE", message);
        }
    }

    @Override
    public boolean isFineEnabled() {
        return this.debug;
    }

    @Override
    public void logFiner(String message) {
        if (this.debug) {
            this.log("FINER", message);
        }
    }

    @Override
    public boolean isFinerEnabled() {
        return this.debug;
    }

    @Override
    public void logFinest(String message) {
        if (this.debug) {
            this.log("FINEST", message);
        }
    }

    @Override
    public boolean isFinestEnabled() {
        return this.debug;
    }

    @Override
    public void logWarning(String message) {
        this.log("WARNING", message);
    }

    @Override
    public void logWarning(String message, Throwable t) {
        this.log("WARNING", message);
        t.printStackTrace(this.printWriter);
    }

    @Override
    public void logSevere(String message) {
        this.log("SEVERE", message);
    }

    @Override
    public void logSevere(String message, Throwable t) {
        this.log("SEVERE", message);
        t.printStackTrace(this.printWriter);
    }

    protected void log(String level, String message) {
        this.printWriter.write(String.valueOf(this.name) + "(" + level + ":" + message);
        this.printWriter.flush();
    }
}

