/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexValidator
implements Serializable {
    private static final long serialVersionUID = -8832409930574867162L;
    private final Pattern[] patterns;

    public RegexValidator(String regex) {
        this(regex, true);
    }

    public RegexValidator(String regex, boolean caseSensitive) {
        this(new String[]{regex}, caseSensitive);
    }

    public RegexValidator(String[] regexs) {
        this(regexs, true);
    }

    public RegexValidator(String[] regexs, boolean caseSensitive) {
        if (regexs == null || regexs.length == 0) {
            throw new IllegalArgumentException("Regular expressions are missing");
        }
        this.patterns = new Pattern[regexs.length];
        int flags = caseSensitive ? 0 : 2;
        int i = 0;
        while (i < regexs.length) {
            if (regexs[i] == null || regexs[i].length() == 0) {
                throw new IllegalArgumentException("Regular expression[" + i + "] is missing");
            }
            this.patterns[i] = Pattern.compile(regexs[i], flags);
            ++i;
        }
    }

    public boolean isValid(String value) {
        if (value == null) {
            return false;
        }
        int i = 0;
        while (i < this.patterns.length) {
            if (this.patterns[i].matcher(value).matches()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String[] match(String value) {
        if (value == null) {
            return null;
        }
        int i = 0;
        while (i < this.patterns.length) {
            Matcher matcher = this.patterns[i].matcher(value);
            if (matcher.matches()) {
                int count = matcher.groupCount();
                String[] groups = new String[count];
                int j = 0;
                while (j < count) {
                    groups[j] = matcher.group(j + 1);
                    ++j;
                }
                return groups;
            }
            ++i;
        }
        return null;
    }

    public String validate(String value) {
        if (value == null) {
            return null;
        }
        int i = 0;
        while (i < this.patterns.length) {
            Matcher matcher = this.patterns[i].matcher(value);
            if (matcher.matches()) {
                int count = matcher.groupCount();
                if (count == 1) {
                    return matcher.group(1);
                }
                StringBuilder buffer = new StringBuilder();
                int j = 0;
                while (j < count) {
                    String component = matcher.group(j + 1);
                    if (component != null) {
                        buffer.append(component);
                    }
                    ++j;
                }
                return buffer.toString();
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("RegexValidator{");
        int i = 0;
        while (i < this.patterns.length) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(this.patterns[i].pattern());
            ++i;
        }
        buffer.append("}");
        return buffer.toString();
    }
}

